/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.simple;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.calrissian.mango.types.encoders.AbstractURIEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;

public class UriEncoder
extends AbstractURIEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(URI value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return value.toString();
    }

    @Override
    public URI decode(String value) throws TypeDecodingException {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new TypeDecodingException(e);
        }
    }
}

