/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.index;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.locationtech.geomesa.cassandra.index.AttributeColumnMapper$;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper$;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper$class;
import org.locationtech.geomesa.cassandra.package;
import org.locationtech.geomesa.cassandra.package$NamedColumn$;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mt!B\u0001\u0003\u0011\u0003i\u0011!F!uiJL'-\u001e;f\u0007>dW/\u001c8NCB\u0004XM\u001d\u0006\u0003\u0007\u0011\tQ!\u001b8eKbT!!\u0002\u0004\u0002\u0013\r\f7o]1oIJ\f'BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011Q#\u0011;ue&\u0014W\u000f^3D_2,XN\\'baB,'o\u0005\u0002\u0010%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!G\b\u0005\u0002i\ta\u0001P5oSRtD#A\u0007\t\u000fqy!\u0019!C\u0005;\u0005)1-Y2iKV\ta\u0004\u0005\u0003 S-\u001aT\"\u0001\u0011\u000b\u0005q\t#B\u0001\u0012$\u0003!\u0019\u0017M\u001a4fS:,'B\u0001\u0013&\u0003!\u0011WM\\7b]\u0016\u001c(B\u0001\u0014(\u0003\u00199\u0017\u000e\u001e5vE*\t\u0001&A\u0002d_6L!A\u000b\u0011\u0003\u00191{\u0017\rZ5oO\u000e\u000b7\r[3\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00027b]\u001eT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\t9\u0011J\u001c;fO\u0016\u0014\bC\u0001\b5\r\u0011\u0001\"\u0001A\u001b\u0014\u0007Q\u0012b\u0007\u0005\u0002\u000fo%\u0011\u0001H\u0001\u0002\u0016\u0007\u0006\u001c8/\u00198ee\u0006\u001cu\u000e\\;n]6\u000b\u0007\u000f]3s\u0011!QDG!A!\u0002\u0013Y\u0014AB:iCJ$7\u000fE\u0002=\t\u001es!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u0001c\u0011A\u0002\u001fs_>$h(C\u0001\u0016\u0013\t\u0019E#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%aA*fc*\u00111\t\u0006\t\u0003\u0011Js!!S)\u000f\u0005)\u0003fBA&P\u001d\taeJ\u0004\u0002?\u001b&\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0011\u0003\n\u0005M#&\u0001D\"pYVlgnU3mK\u000e$(BA\"\u0005\u0011\u0015IB\u0007\"\u0001W)\t\u0019t\u000bC\u0003;+\u0002\u00071\bC\u0004Zi\t\u0007I\u0011\u0002.\u0002\u000bMC\u0017M\u001d3\u0016\u0003m\u0003\"\u0001\u0013/\n\u0005u#&a\u0003(b[\u0016$7i\u001c7v[:Daa\u0018\u001b!\u0002\u0013Y\u0016AB*iCJ$\u0007\u0005C\u0004bi\t\u0007I\u0011\u0002.\u0002\u000bY\u000bG.^3\t\r\r$\u0004\u0015!\u0003\\\u0003\u00191\u0016\r\\;fA!9Q\r\u000eb\u0001\n\u0013Q\u0016!C*fG>tG-\u0019:z\u0011\u00199G\u0007)A\u00057\u0006Q1+Z2p]\u0012\f'/\u001f\u0011\t\u000f%$$\u0019!C\u00055\u0006Ia)Z1ukJ,\u0017\n\u001a\u0005\u0007WR\u0002\u000b\u0011B.\u0002\u0015\u0019+\u0017\r^;sK&#\u0007\u0005C\u0004ni\t\u0007I\u0011\u0002.\u0002\u000f\u0019+\u0017\r^;sK\"1q\u000e\u000eQ\u0001\nm\u000b\u0001BR3biV\u0014X\r\t\u0005\bcR\u0012\r\u0011\"\u0011s\u0003\u001d\u0019w\u000e\\;n]N,\u0012a\u001d\t\u0004y\u0011[\u0006BB;5A\u0003%1/\u0001\u0005d_2,XN\\:!\u0011\u00159H\u0007\"\u0011y\u0003\u0011\u0011\u0017N\u001c3\u0015\u0005eT\bc\u0001\u001fE%!)1P\u001ea\u0001y\u0006)a/\u00197vKB\u001aQ0!\u0007\u0011\u000by\fy!!\u0006\u000f\u0007}\fYA\u0004\u0003\u0002\u0002\u0005\u0015ab\u0001&\u0002\u0004%\u00111AB\u0005\u0005\u0003\u000f\tI!A\u0002ba&T!a\u0001\u0004\n\u0007\r\u000biA\u0003\u0003\u0002\b\u0005%\u0011\u0002BA\t\u0003'\u0011\u0011cU5oO2,'k\\<LKf4\u0016\r\\;f\u0015\r\u0019\u0015Q\u0002\t\u0005\u0003/\tI\u0002\u0004\u0001\u0005\u0017\u0005m!0!A\u0001\u0002\u000b\u0005\u0011Q\u0004\u0002\u0004?\u0012\n\u0014\u0003BA\u0010\u0003K\u00012aEA\u0011\u0013\r\t\u0019\u0003\u0006\u0002\b\u001d>$\b.\u001b8h!\r\u0019\u0012qE\u0005\u0004\u0003S!\"aA!os\"9\u0011Q\u0006\u001b\u0005B\u0005=\u0012A\u00032j]\u0012$U\r\\3uKR\u0019\u00110!\r\t\u000fm\fY\u00031\u0001\u00024A\"\u0011QGA\u001d!\u0015q\u0018qBA\u001c!\u0011\t9\"!\u000f\u0005\u0019\u0005m\u0012\u0011GA\u0001\u0002\u0003\u0015\t!!\b\u0003\u0007}##\u0007C\u0004\u0002@Q\"\t%!\u0011\u0002\rM,G.Z2u)\u0019\t\u0019%a\u0013\u0002^A!A\bRA#!\rA\u0015qI\u0005\u0004\u0003\u0013\"&!\u0003*poN+G.Z2u\u0011!\ti%!\u0010A\u0002\u0005=\u0013!\u0002:b]\u001e,\u0007\u0007BA)\u00033\u0002RA`A*\u0003/JA!!\u0016\u0002\u0014\tI1kY1o%\u0006tw-\u001a\t\u0005\u0003/\tI\u0006\u0002\u0007\u0002\\\u0005-\u0013\u0011!A\u0001\u0006\u0003\tiBA\u0002`IMB\u0001\"a\u0018\u0002>\u0001\u0007\u0011\u0011M\u0001\u0010i&,'/\u001a3LKf\u0014\u0016M\\4fgB!A\bRA2!\rq\u0018QM\u0005\u0005\u0003O\n\u0019BA\u0005CsR,'+\u00198hK\"9\u00111N\b!\u0002\u0013q\u0012AB2bG\",\u0007\u0005C\u0004\u0002p=!\t!!\u001d\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007M\n\u0019\bC\u0004;\u0003[\u0002\r!!\u001e\u0011\u0007M\t9(C\u0002\u0002zQ\u00111!\u00138u\u0001")
public class AttributeColumnMapper
implements CassandraColumnMapper {
    private final Seq<package.ColumnSelect> shards;
    private final package.NamedColumn Shard;
    private final package.NamedColumn Value;
    private final package.NamedColumn Secondary;
    private final package.NamedColumn FeatureId;
    private final package.NamedColumn Feature;
    private final Seq<package.NamedColumn> columns;

    public static AttributeColumnMapper apply(int n) {
        return AttributeColumnMapper$.MODULE$.apply(n);
    }

    @Override
    public PreparedStatement insert(Session session, String table) {
        return CassandraColumnMapper$class.insert(this, session, table);
    }

    @Override
    public PreparedStatement delete(Session session, String table) {
        return CassandraColumnMapper$class.delete(this, session, table);
    }

    private package.NamedColumn Shard() {
        return this.Shard;
    }

    private package.NamedColumn Value() {
        return this.Value;
    }

    private package.NamedColumn Secondary() {
        return this.Secondary;
    }

    private package.NamedColumn FeatureId() {
        return this.FeatureId;
    }

    private package.NamedColumn Feature() {
        return this.Feature;
    }

    @Override
    public Seq<package.NamedColumn> columns() {
        return this.columns;
    }

    @Override
    public Seq<Object> bind(package.SingleRowKeyValue<?> value) {
        Byte shard = BoxesRunTime.boxToByte((byte)(Predef$.MODULE$.byteArrayOps(value.shard()).isEmpty() ? (byte)0 : BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(value.shard()).head())));
        Object object = value.key();
        if (object instanceof AttributeIndexKey) {
            String v;
            String string;
            AttributeIndexKey attributeIndexKey = (AttributeIndexKey)object;
            String v2 = string = (v = attributeIndexKey.value());
            ByteBuffer secondary = ByteBuffer.wrap(value.tier());
            String fid = new String(value.id(), StandardCharsets.UTF_8);
            Seq seq = (Seq)value.values().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ByteBuffer apply(package.KeyValue v) {
                    return ByteBuffer.wrap(v.value());
                }
            }, Seq$.MODULE$.canBuildFrom());
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                ByteBuffer feature;
                ByteBuffer byteBuffer;
                ByteBuffer feature2 = byteBuffer = (feature = (ByteBuffer)((SeqLike)some.get()).apply(0));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{shard, v2, secondary, fid, feature2}));
            }
            throw new MatchError((Object)seq);
        }
        throw new MatchError(object);
    }

    @Override
    public Seq<Object> bindDelete(package.SingleRowKeyValue<?> value) {
        Byte shard = BoxesRunTime.boxToByte((byte)(Predef$.MODULE$.byteArrayOps(value.shard()).isEmpty() ? (byte)0 : BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(value.shard()).head())));
        Object object = value.key();
        if (object instanceof AttributeIndexKey) {
            String v;
            String string;
            AttributeIndexKey attributeIndexKey = (AttributeIndexKey)object;
            String v2 = string = (v = attributeIndexKey.value());
            ByteBuffer secondary = ByteBuffer.wrap(value.tier());
            String fid = new String(value.id(), StandardCharsets.UTF_8);
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{shard, v2, secondary, fid}));
        }
        throw new MatchError(object);
    }

    @Override
    public Seq<package.RowSelect> select(package.ScanRange<?> range, Seq<package.ByteRange> tieredKeyRanges) {
        block11: {
            Seq seq;
            Seq seq2;
            block6: {
                package.ScanRange<?> scanRange;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    scanRange = range;
                                    if (!(scanRange instanceof package.SingleRowRange)) break block5;
                                    package.SingleRowRange singleRowRange = (package.SingleRowRange)scanRange;
                                    AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                                    seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{new package.ColumnSelect(this.Value(), row.value(), row.value(), true, true)}));
                                    break block6;
                                }
                                if (!(scanRange instanceof package.BoundedRange)) break block7;
                                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                                AttributeIndexKey lo = (AttributeIndexKey)boundedRange.lower();
                                AttributeIndexKey hi = (AttributeIndexKey)boundedRange.upper();
                                seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{new package.ColumnSelect(this.Value(), lo.value(), hi.value(), lo.inclusive(), hi.inclusive())}));
                                break block6;
                            }
                            if (!(scanRange instanceof package.LowerBoundedRange)) break block8;
                            package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                            AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                            seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{new package.ColumnSelect(this.Value(), lo.value(), null, lo.inclusive(), false)}));
                            break block6;
                        }
                        if (!(scanRange instanceof package.UpperBoundedRange)) break block9;
                        package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                        AttributeIndexKey hi = (AttributeIndexKey)upperBoundedRange.upper();
                        seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{new package.ColumnSelect(this.Value(), null, hi.value(), false, hi.inclusive())}));
                        break block6;
                    }
                    if (!(scanRange instanceof package.PrefixRange)) break block10;
                    package.PrefixRange prefixRange = (package.PrefixRange)scanRange;
                    AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                    seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{new package.ColumnSelect(this.Value(), prefix.value(), new StringBuilder().append((Object)prefix.value()).append((Object)"zzzz").toString(), prefix.inclusive(), false)}));
                    break block6;
                }
                if (!(scanRange instanceof package.UnboundedRange)) break block11;
                seq2 = (Seq)Seq$.MODULE$.empty();
            }
            Seq primary = seq2;
            if (tieredKeyRanges.isEmpty()) {
                seq = primary;
            } else {
                byte[] minTier = package.ByteRange$.MODULE$.min(tieredKeyRanges);
                byte[] maxTier = package.ByteRange$.MODULE$.max(tieredKeyRanges);
                seq = (Seq)primary.$colon$plus((Object)new package.ColumnSelect(this.Secondary(), ByteBuffer.wrap(minTier), ByteBuffer.wrap(maxTier), true, true), Seq$.MODULE$.canBuildFrom());
            }
            Seq clause = seq;
            return clause.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.RowSelect[]{new package.RowSelect((Seq<package.ColumnSelect>)clause)})) : (Seq)this.shards.map((Function1)new Serializable(this, clause){
                public static final long serialVersionUID = 0L;
                private final Seq clause$1;

                public final package.RowSelect apply(package.ColumnSelect s) {
                    return new package.RowSelect((Seq<package.ColumnSelect>)((Seq)this.clause$1.$plus$colon((Object)s, Seq$.MODULE$.canBuildFrom())));
                }
                {
                    this.clause$1 = clause$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{range})));
    }

    public AttributeColumnMapper(Seq<package.ColumnSelect> shards) {
        this.shards = shards;
        CassandraColumnMapper$class.$init$(this);
        this.Shard = CassandraColumnMapper$.MODULE$.ShardColumn();
        this.Value = new package.NamedColumn("attrVal", 1, "text", String.class, package$NamedColumn$.MODULE$.apply$default$5());
        this.Secondary = new package.NamedColumn("secondary", 2, "blob", ByteBuffer.class, package$NamedColumn$.MODULE$.apply$default$5());
        this.FeatureId = CassandraColumnMapper$.MODULE$.featureIdColumn(3);
        this.Feature = CassandraColumnMapper$.MODULE$.featureColumn(4);
        this.columns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.NamedColumn[]{this.Shard(), this.Value(), this.Secondary(), this.FeatureId(), this.Feature()}));
    }
}

