/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.interop;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import org.opengis.feature.simple.SimpleFeatureType;

public class ConfigurationUtils {
    private static ConfigRenderOptions renderOptions = ConfigRenderOptions.concise().setFormatted(true);

    public static void setEncoding(SimpleFeatureType sft, String encoding) {
        sft.getUserData().put("geomesa.fs.encoding", encoding);
    }

    public static void setLeafStorage(SimpleFeatureType sft, boolean leafStorage) {
        sft.getUserData().put("geomesa.fs.leaf-storage", String.valueOf(leafStorage));
    }

    public static void setScheme(SimpleFeatureType sft, String scheme, Map<String, String> options) {
        sft.getUserData().put("geomesa.fs.scheme", ConfigurationUtils.serialize(scheme, options));
    }

    public static void setMetadata(SimpleFeatureType sft, String name, Map<String, String> options) {
        sft.getUserData().put("geomesa.fs.metadata", ConfigurationUtils.serialize(name, options));
    }

    private static String serialize(String name, Map<String, String> options) {
        return ConfigFactory.empty().withValue("name", ConfigValueFactory.fromAnyRef((Object)name)).withValue("options", (ConfigValue)ConfigValueFactory.fromMap(options)).root().render(renderOptions);
    }
}

