/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.json.JsonConverter$;
import org.locationtech.geomesa.convert2.transforms.CollectionFunctionFactory;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u00015\u00111CS:p]\u001a+hn\u0019;j_:4\u0015m\u0019;pefT!a\u0001\u0003\u0002\t)\u001cxN\u001c\u0006\u0003\u000b\u0019\tqaY8om\u0016\u0014HO\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)q\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003)!(/\u00198tM>\u0014Xn\u001d\u0006\u00033\u0019\t\u0001bY8om\u0016\u0014HOM\u0005\u00037Y\u0011!\u0004\u0016:b]N4wN]7fe\u001a+hn\u0019;j_:4\u0015m\u0019;pef\u0004\"!H\u0017\u000f\u0005yYcBA\u0010+\u001d\t\u0001\u0013F\u0004\u0002\"Q9\u0011!e\n\b\u0003G\u0019j\u0011\u0001\n\u0006\u0003K1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\tIb!\u0003\u0002\u00181%\u0011AFF\u0001\u001a\u0007>dG.Z2uS>tg)\u001e8di&|gNR1di>\u0014\u00180\u0003\u0002/_\t\t2i\u001c7mK\u000e$\u0018n\u001c8QCJ\u001c\u0018N\\4\u000b\u000512\u0002\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\bF\u00014!\t!\u0004!D\u0001\u0003\u0011\u00151\u0004\u0001\"\u00118\u0003%1WO\\2uS>t7/F\u00019!\rId(\u0011\b\u0003uqr!aI\u001e\n\u0003EI!!\u0010\t\u0002\u000fA\f7m[1hK&\u0011q\b\u0011\u0002\u0004'\u0016\f(BA\u001f\u0011!\t)\")\u0003\u0002D-\t\u0019BK]1og\u001a|'/\\3s\rVt7\r^5p]\"9Q\t\u0001b\u0001\n\u00131\u0015\u0001\u00046t_:$vn\u0015;sS:<W#A!)\t\u0011C5*\u0014\t\u0003\u001f%K!A\u0013\t\u0003\u0015\u0011,\u0007O]3dCR,G-I\u0001M\u00031)8/\u001a\u0011u_N#(/\u001b8hc\u0015\u0019c*V-W!\ty%K\u0004\u0002\u0010!&\u0011\u0011\u000bE\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R!%\u0011akV\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u000b\u0005a\u0003\u0012A\u00033faJ,7-\u0019;fIF*1EW.]1:\u0011qbW\u0005\u00031B\tDAI\b\u0011;\n)1oY1mC\"1q\f\u0001Q\u0001\n\u0005\u000bQB[:p]R{7\u000b\u001e:j]\u001e\u0004\u0003bB1\u0001\u0005\u0004%IAR\u0001\tUN|g\u000eU1uQ\"11\r\u0001Q\u0001\n\u0005\u000b\u0011B[:p]B\u000bG\u000f\u001b\u0011\t\u000f\u0015\u0004!\u0019!C\u0005\r\u0006q!n]8o\u0019&\u001cH\u000fU1sg\u0016\u0014\bBB4\u0001A\u0003%\u0011)A\bkg>tG*[:u!\u0006\u00148/\u001a:!\u0011\u001dI\u0007A1A\u0005\n\u0019\u000bQB[:p]6\u000b\u0007\u000fU1sg\u0016\u0014\bBB6\u0001A\u0003%\u0011)\u0001\bkg>tW*\u00199QCJ\u001cXM\u001d\u0011\t\u000f5\u0004!\u0019!C\u0005\r\u0006IQ.\u00199U_*\u001bxN\u001c\u0005\u0007_\u0002\u0001\u000b\u0011B!\u0002\u00155\f\u0007\u000fV8Kg>t\u0007\u0005C\u0003r\u0001\u0011%!/\u0001\u0007hKR\u0004&/[7ji&4X\r\u0006\u0002tmB\u0011q\u0002^\u0005\u0003kB\u00111!\u00118z\u0011\u00159\b\u000f1\u0001y\u0003\u0005\u0001\bcA=\u0002\u00025\t!P\u0003\u0002|y\u0006!qm]8o\u0015\tih0\u0001\u0004h_><G.\u001a\u0006\u0002\u007f\u0006\u00191m\\7\n\u0007\u0005\r!PA\u0007Kg>t\u0007K]5nSRLg/\u001a")
public class JsonFunctionFactory
implements TransformerFunctionFactory,
CollectionFunctionFactory.CollectionParsing {
    private final TransformerFunction jsonToString;
    private final TransformerFunction jsonPath;
    private final TransformerFunction jsonListParser;
    private final TransformerFunction jsonMapParser;
    private final TransformerFunction mapToJson;

    public Object convert(Object value, Class<?> clazz) {
        return CollectionFunctionFactory.CollectionParsing.class.convert((CollectionFunctionFactory.CollectionParsing)this, (Object)value, clazz);
    }

    public Class<?> determineClazz(String s) {
        return CollectionFunctionFactory.CollectionParsing.class.determineClazz((CollectionFunctionFactory.CollectionParsing)this, (String)s);
    }

    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.jsonToString(), this.jsonListParser(), this.jsonMapParser(), this.mapToJson(), this.jsonPath()}));
    }

    private TransformerFunction jsonToString() {
        return this.jsonToString;
    }

    private TransformerFunction jsonPath() {
        return this.jsonPath;
    }

    private TransformerFunction jsonListParser() {
        return this.jsonListParser;
    }

    private TransformerFunction jsonMapParser() {
        return this.jsonMapParser;
    }

    private TransformerFunction mapToJson() {
        return this.mapToJson;
    }

    public Object org$locationtech$geomesa$convert$json$JsonFunctionFactory$$getPrimitive(JsonPrimitive p) {
        return p.isBoolean() ? BoxesRunTime.boxToBoolean((boolean)p.getAsBoolean()) : p.getAsString();
    }

    public JsonFunctionFactory() {
        CollectionFunctionFactory.CollectionParsing.class.$init$((CollectionFunctionFactory.CollectionParsing)this);
        this.jsonToString = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonToString", "json2string"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] args) {
                return args[0].toString();
            }
        });
        this.jsonPath = new TransformerFunction.NamedTransformerFunction(this){
            private final ConcurrentHashMap<Object, JsonPath> cache;

            private ConcurrentHashMap<Object, JsonPath> cache() {
                return this.cache;
            }

            public Object eval(Object[] args, EvaluationContext ctx) {
                JsonPrimitive p;
                BoxedUnit boxedUnit;
                JsonPath path = this.cache().get(args[0]);
                if (path == null) {
                    path = JsonPath.compile((String)((String)args[0]), (Predicate[])new Predicate[0]);
                    boxedUnit = this.cache().put(args[0], path);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                JsonElement elem = (JsonElement)path.read(args[1], JsonConverter$.MODULE$.JsonConfiguration());
                Object object = elem.isJsonNull() ? null : (elem.isJsonPrimitive() ? ((p = elem.getAsJsonPrimitive()).isString() ? p.getAsString() : (p.isNumber() ? p.getAsNumber() : (p.isBoolean() ? BoxesRunTime.boxToBoolean((boolean)p.getAsBoolean()) : p.getAsString()))) : elem);
                return object;
            }
            {
                this.cache = new ConcurrentHashMap<K, V>();
            }
        };
        this.jsonListParser = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonList"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JsonFunctionFactory $outer;

            public final Object apply(Object[] args) {
                ArrayList<Object> arrayList;
                JsonArray array = (JsonArray)args[1];
                if (array.isJsonNull()) {
                    arrayList = null;
                } else {
                    Class<?> clazz = this.$outer.determineClazz((String)args[0]);
                    ArrayList<Object> result = new ArrayList<Object>(array.size());
                    for (JsonElement e : array) {
                        Object object = e.isJsonNull() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)result.add(this.$outer.convert(this.$outer.org$locationtech$geomesa$convert$json$JsonFunctionFactory$$getPrimitive(e.getAsJsonPrimitive()), clazz)));
                    }
                    arrayList = result;
                }
                return arrayList;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.jsonMapParser = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonMap"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JsonFunctionFactory $outer;

            public final Object apply(Object[] args) {
                HashMap<Object, Object> hashMap;
                Class<?> kClass = this.$outer.determineClazz((String)args[0]);
                Class<?> vClass = this.$outer.determineClazz((String)args[1]);
                JsonObject map = (JsonObject)args[2];
                if (map.isJsonNull()) {
                    hashMap = null;
                } else {
                    HashMap<Object, Object> result = new HashMap<Object, Object>(map.size());
                    for (Map.Entry e : map.entrySet()) {
                        result.put(this.$outer.convert(e.getKey(), kClass), this.$outer.convert(this.$outer.org$locationtech$geomesa$convert$json$JsonFunctionFactory$$getPrimitive(((JsonElement)e.getValue()).getAsJsonPrimitive()), vClass));
                    }
                    hashMap = result;
                }
                return hashMap;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.mapToJson = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"map2Json", "mapToJson"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] args) {
                java.util.Map map = (java.util.Map)args[0];
                Map ast = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(Object x0$1) {
                        JsonAST.JNull$ jNull$;
                        Object object = x0$1;
                        if (object == null) {
                            jNull$ = JsonAST.JNull$.MODULE$;
                        } else if (object instanceof Integer) {
                            int n = BoxesRunTime.unboxToInt((Object)object);
                            jNull$ = package$.MODULE$.JInt().apply(BigInt$.MODULE$.int2bigInt(n));
                        } else if (object instanceof Long) {
                            long l = BoxesRunTime.unboxToLong((Object)object);
                            jNull$ = package$.MODULE$.JInt().apply(BigInt$.MODULE$.long2bigInt(l));
                        } else if (object instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)object);
                            jNull$ = package$.MODULE$.JDouble().apply(d);
                        } else if (object instanceof Float) {
                            float f = BoxesRunTime.unboxToFloat((Object)object);
                            jNull$ = package$.MODULE$.JDouble().apply((double)f);
                        } else if (object instanceof Boolean) {
                            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                            jNull$ = package$.MODULE$.JBool().apply(bl);
                        } else if (object instanceof String) {
                            String string = (String)object;
                            jNull$ = package$.MODULE$.JString().apply(string);
                        } else {
                            jNull$ = package$.MODULE$.JString().apply(object.toString());
                        }
                        return jNull$;
                    }
                }).toMap(Predef$.MODULE$.$conforms());
                JsonAST.JObject x$1 = JsonDSL$.MODULE$.map2jvalue(ast, (Function1)Predef$.MODULE$.$conforms());
                Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
                return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
            }
        });
    }
}

