/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.util.Arrays;
import java.util.Set;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.resources.LazySet;

public final class CoverageFactoryFinder
extends FactoryFinder {
    private static FactoryRegistry registry;

    private CoverageFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(CoverageFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(GridCoverageFactory.class));
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridCoverageFactory getGridCoverageFactory(Hints hints) throws FactoryRegistryException {
        GridCoverageFactory coverageFactory;
        if (hints != null && hints.containsKey((Object)Hints.GRID_COVERAGE_FACTORY) && (coverageFactory = (GridCoverageFactory)((Object)hints.get((Object)Hints.GRID_COVERAGE_FACTORY))) != null) {
            return coverageFactory;
        }
        Class<CoverageFactoryFinder> clazz = CoverageFactoryFinder.class;
        synchronized (CoverageFactoryFinder.class) {
            hints = CoverageFactoryFinder.mergeSystemHints((Hints)hints);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (GridCoverageFactory)((Object)CoverageFactoryFinder.getServiceRegistry().getFactory(GridCoverageFactory.class, null, hints, null));
        }
    }

    public static synchronized Set<GridCoverageFactory> getGridCoverageFactories(Hints hints) {
        hints = CoverageFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CoverageFactoryFinder.getServiceRegistry().getFactories(GridCoverageFactory.class, null, hints));
    }

    public static synchronized void scanForPlugins() {
        if (registry != null) {
            registry.scanForPlugins();
        }
    }
}

