/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.jai;

import it.geosolutions.jaiext.JAIExt;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.registry.RIFRegistry;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.image.ImageWorker;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.logging.Logging;

public final class Registry {
    public static final String JAI_TOOLS_PRODUCT = "org.jaitools.media.jai";
    public static final String GEOTOOLS_PRODUCT = "org.geotools";

    private Registry() {
    }

    public static synchronized void setNativeAccelerationAllowed(String operation, boolean allowed, JAI jai) {
        String product = "com.sun.media.jai";
        OperationRegistry registry = jai.getOperationRegistry();
        List factories = registry.getOrderedFactoryList("rendered", operation, "com.sun.media.jai");
        if (factories != null) {
            RenderedImageFactory javaFactory = null;
            RenderedImageFactory nativeFactory = null;
            Boolean currentState = null;
            for (RenderedImageFactory factory : factories) {
                String pack = factory.getClass().getPackage().getName();
                if (pack.equals("com.sun.media.jai.mlib")) {
                    nativeFactory = factory;
                    if (javaFactory != null) {
                        currentState = Boolean.FALSE;
                    }
                }
                if (!pack.equals("com.sun.media.jai.opimage")) continue;
                javaFactory = factory;
                if (nativeFactory == null) continue;
                currentState = Boolean.TRUE;
            }
            if (ImageWorker.isJaiExtEnabled()) {
                JAIExt.setJAIAcceleration((String)operation, (boolean)allowed);
            }
            if (currentState != null && currentState != allowed) {
                RIFRegistry.unsetPreference((OperationRegistry)registry, (String)operation, (String)"com.sun.media.jai", (RenderedImageFactory)(allowed ? javaFactory : nativeFactory), (RenderedImageFactory)(allowed ? nativeFactory : javaFactory));
                RIFRegistry.setPreference((OperationRegistry)registry, (String)operation, (String)"com.sun.media.jai", (RenderedImageFactory)(allowed ? nativeFactory : javaFactory), (RenderedImageFactory)(allowed ? javaFactory : nativeFactory));
                LogRecord record = Loggings.format((Level)Level.CONFIG, (int)31, (Object)operation, (Object)(allowed ? 1 : 0));
                Registry.log("setNativeAccelerationAllowed", record);
            }
        }
    }

    public static void setNativeAccelerationAllowed(String operation, boolean allowed) {
        Registry.setNativeAccelerationAllowed(operation, allowed, JAI.getDefaultInstance());
    }

    public static boolean registerRIF(JAI jai, OperationDescriptor descriptor, String name, ContextualRenderedImageFactory crif) {
        OperationRegistry registry = jai.getOperationRegistry();
        try {
            registry.registerDescriptor((RegistryElementDescriptor)descriptor);
            registry.registerFactory("rendered", name, GEOTOOLS_PRODUCT, (Object)crif);
            return true;
        }
        catch (IllegalArgumentException exception) {
            LogRecord record = Loggings.format((Level)Level.SEVERE, (int)10, (Object)name);
            record.setSourceClassName(GridSampleDimension.class.getName());
            record.setSourceMethodName("<classinit>");
            record.setThrown(exception);
            record.setLoggerName(AbstractGridCoverage.LOGGER.getName());
            AbstractGridCoverage.LOGGER.log(record);
            return false;
        }
    }

    public static boolean registerRIF(JAI jai, OperationDescriptor descriptor, RenderedImageFactory rif, String productName) {
        OperationRegistry registry = jai.getOperationRegistry();
        try {
            new ParameterBlockJAI(descriptor.getName());
            return false;
        }
        catch (Exception e) {
            registry.registerDescriptor((RegistryElementDescriptor)descriptor);
            String descName = descriptor.getName();
            registry.registerFactory("rendered", descName, productName, (Object)rif);
            return true;
        }
    }

    private static void log(String method, LogRecord record) {
        record.setSourceClassName(Registry.class.getName());
        record.setSourceMethodName(method);
        Logger logger = Logging.getLogger(Registry.class);
        record.setLoggerName(logger.getName());
        logger.log(record);
    }
}

