/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.knn;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.knn.KNNResult;
import org.locationtech.geomesa.process.knn.KNNVisitor;
import org.opengis.feature.FeatureVisitor;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DescribeProcess(title="Geomesa-enabled K Nearest Neighbor Search", description="Performs a K Nearest Neighbor search on a Geomesa feature collection using another feature collection as input")
@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001b\ti2JT3be\u0016\u001cHOT3jO\"\u0014wN]*fCJ\u001c\u0007\u000e\u0015:pG\u0016\u001c8O\u0003\u0002\u0004\t\u0005\u00191N\u001c8\u000b\u0005\u00151\u0011a\u00029s_\u000e,7o\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dYQ\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!AD$f_6+7/\u0019)s_\u000e,7o\u001d\t\u00037\tj\u0011\u0001\b\u0006\u0003;y\tAb]2bY\u0006dwnZ4j]\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"\u0002\u0016\u0001\t\u0003Y\u0013aB3yK\u000e,H/\u001a\u000b\u0007YY*5\nV/\u0011\u00055\"T\"\u0001\u0018\u000b\u0005=\u0002\u0014AB:j[BdWM\u0003\u00022e\u0005!A-\u0019;b\u0015\t\u0019$\"\u0001\u0005hK>$xn\u001c7t\u0013\t)dFA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\")q'\u000ba\u0001Y\u0005i\u0011N\u001c9vi\u001a+\u0017\r^;sKNDcAN\u001dA\u0003\n\u001b\u0005C\u0001\u001e?\u001b\u0005Y$B\u0001\u001f>\u0003\u001d1\u0017m\u0019;pefT!!\u0002\u001a\n\u0005}Z$!\u0005#fg\u000e\u0014\u0018NY3QCJ\fW.\u001a;fe\u0006!a.Y7fC\u00059\u0014a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013\u0001R\u00015\u0013:\u0004X\u000f\u001e\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007\u0005\u001e5bi\u0002\"WMZ5oKN\u0004C\u000f[3!\u0017:s\u0005e]3be\u000eD\u0007\"\u0002$*\u0001\u0004a\u0013\u0001\u00043bi\u00064U-\u0019;ve\u0016\u001c\bFB#:\u0001\"\u0013\u0015*I\u0001GC\u0005Q\u0015a\u000b+iK\u0002\"\u0017\r^1!g\u0016$\b\u0005^8!cV,'/\u001f\u0011g_J\u0004S.\u0019;dQ&tw\r\t4fCR,(/Z:\t\u000b1K\u0003\u0019A'\u0002\u00159,X\u000eR3tSJ,G\r\u0005\u0002\u0010\u001d&\u0011q\n\u0005\u0002\b\u0013:$XmZ3sQ\u0019Y\u0015\bQ)C%\u0006\nA*I\u0001T\u0003!Z%\b\t8v[\n,'\u000fI8gA9,\u0017M]3ti\u0002rW-[4iE>\u00148\u000f\t;pAI,G/\u001e:o\u0011\u0015)\u0016\u00061\u0001W\u0003E)7\u000f^5nCR,G\rR5ti\u0006t7-\u001a\t\u0003\u001f]K!\u0001\u0017\t\u0003\r\u0011{WO\u00197fQ\u0019!\u0016\b\u0011.C7\u0006\nQ+I\u0001]\u0003\u0005,5\u000f^5nCR,\u0007e\u001c4!'\u0016\f'o\u00195!\t&\u001cH/\u00198dK\u0002Jg\u000eI7fi\u0016\u00148\u000f\t4pe\u0002Z\u0005E\\3jO\"\u0014wN]:.[5*8/\u001a3!i>\u00043/\u001a;!i\",\u0007e\u001a:b]Vd\u0017M]5us\u0002zg\r\t;iK\u0002\u001aX-\u0019:dQ\")a,\u000ba\u0001-\u0006\tR.\u0019=TK\u0006\u00148\r\u001b#jgR\fgnY3)\ruK\u0004\t\u0019\"bC\u0005q\u0016%\u00012\u0002/6\u000b\u00070[7v[\u0002\u001aX-\u0019:dQ\u0002\"\u0017n\u001d;b]\u000e,\u0007%\u001b8![\u0016$XM]:.[5*8/\u001a3!i>\u0004\u0003O]3wK:$\bE];oC^\f\u0017\u0010I9vKJLWm\u001d\u0011pM\u0002\"\b.\u001a\u0011f]RL'/\u001a\u0011uC\ndW\r\u000b\u0003*I\n;\u0007C\u0001\u001ef\u0013\t17H\u0001\bEKN\u001c'/\u001b2f%\u0016\u001cX\u000f\u001c;\"\u0003!\f\u0011dT;uaV$\bEZ3biV\u0014X\rI2pY2,7\r^5p]\"2\u0001A[7o\u0005B\u0004\"AO6\n\u00051\\$a\u0004#fg\u000e\u0014\u0018NY3Qe>\u001cWm]:\u0002\u000bQLG\u000f\\3\"\u0003=\f\u0011fR3p[\u0016\u001c\u0018-L3oC\ndW\r\u001a\u0011LA9+\u0017M]3ti\u0002rU-[4iE>\u0014\beU3be\u000eD\u0017%A9\u0002]B+'OZ8s[N\u0004\u0013\rI&!\u001d\u0016\f'/Z:uA9+\u0017n\u001a5c_J\u00043/Z1sG\"\u0004sN\u001c\u0011bA\u001d+w.\\3tC\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8!kNLgn\u001a\u0011b]>$\b.\u001a:!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000eI1tA%t\u0007/\u001e;")
public class KNearestNeighborSearchProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        KNearestNeighborSearchProcess kNearestNeighborSearchProcess = this;
        synchronized (kNearestNeighborSearchProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="inputFeatures", description="Input feature collection that defines the KNN search") SimpleFeatureCollection inputFeatures, @DescribeParameter(name="dataFeatures", description="The data set to query for matching features") SimpleFeatureCollection dataFeatures, @DescribeParameter(name="numDesired", description="K: number of nearest neighbors to return") Integer numDesired, @DescribeParameter(name="estimatedDistance", description="Estimate of Search Distance in meters for K neighbors---used to set the granularity of the search") Double estimatedDistance, @DescribeParameter(name="maxSearchDistance", description="Maximum search distance in meters---used to prevent runaway queries of the entire table") Double maxSearchDistance) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Attempting Geomesa K-Nearest Neighbor Search on collection type ").append((Object)dataFeatures.getClass().getName()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        KNNVisitor visitor = new KNNVisitor(inputFeatures, dataFeatures, numDesired, estimatedDistance, maxSearchDistance);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)dataFeatures, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return ((KNNResult)visitor.getResult()).results();
    }

    public KNearestNeighborSearchProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

