/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.audit;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AuditProvider {
    public static final String AUDIT_PROVIDER_SYS_PROPERTY = "geomesa.audit.provider.impl";

    public String getCurrentUserId();

    public Map<Object, Object> getCurrentUserDetails();

    public void configure(Map<String, Serializable> var1);

    public static class Loader {
        private static final Logger logger = LoggerFactory.getLogger(Loader.class);

        private Loader() {
        }

        public static AuditProvider load(Map<String, Serializable> params) {
            Iterator<AuditProvider> providers = ServiceLoader.load(AuditProvider.class).iterator();
            String specified = GeoMesaSystemProperties.getProperty(AuditProvider.AUDIT_PROVIDER_SYS_PROPERTY);
            if (specified != null) {
                if (specified.equals("org.locationtech.geomesa.plugin.security.SpringAuditProvider")) {
                    logger.warn("org.locationtech.geomesa.plugin.security.SpringAuditProvider is deprecated;switching to org.locationtech.geomesa.security.SpringAuditProvider");
                    specified = "org.locationtech.geomesa.security.SpringAuditProvider";
                }
                while (providers.hasNext()) {
                    AuditProvider provider = providers.next();
                    if (!specified.equals(provider.getClass().getName())) continue;
                    provider.configure(params);
                    return provider;
                }
                throw new RuntimeException("Could not load audit provider " + specified);
            }
            if (providers.hasNext()) {
                AuditProvider provider = providers.next();
                if (providers.hasNext()) {
                    StringBuilder all = new StringBuilder(provider.getClass().getName());
                    while (providers.hasNext()) {
                        all.append(", ").append(providers.next().getClass().getName());
                    }
                    throw new IllegalStateException("Found multiple AuditProvider implementations. Please specify the one to use with the system property 'geomesa.audit.provider.impl' :: " + all);
                }
                provider.configure(params);
                return provider;
            }
            return null;
        }
    }
}

