/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2;

import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.XZ2SFC;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.IndexKeySpace$class;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$BoundedRange$mcJ$sp;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z2.XZ2IndexKeySpace$;
import org.locationtech.geomesa.index.index.z2.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u00019\u0011\u0001\u0003\u0017.3\u0013:$W\r_&fsN\u0003\u0018mY3\u000b\u0005\r!\u0011A\u0001>3\u0015\t)a!A\u0003j]\u0012,\u0007P\u0003\u0002\u0006\u000f)\u0011\u0001\"C\u0001\bO\u0016|W.Z:b\u0015\tQ1\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\r\u0003\ry'oZ\u0002\u0001'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\tYI2dI\u0007\u0002/)\u0011\u0001DB\u0001\u0004CBL\u0017B\u0001\u000e\u0018\u00055Ie\u000eZ3y\u0017\u0016L8\u000b]1dKB\u0011A\u0004\t\b\u0003;yi\u0011AA\u0005\u0003?\t\tq\u0001]1dW\u0006<W-\u0003\u0002\"E\tq\u0001L\u0017\u001aJ]\u0012,\u0007PV1mk\u0016\u001c(BA\u0010\u0003!\t\u0001B%\u0003\u0002&#\t!Aj\u001c8h\u0011!9\u0003A!b\u0001\n\u0003A\u0013aA:giV\t\u0011\u0006\u0005\u0002+c5\t1F\u0003\u0002-[\u000511/[7qY\u0016T!AL\u0018\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0001gC\u0001\b_B,gnZ5t\u0013\t\u00114FA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0005g\u001a$\b\u0005\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003!\u0019\b.\u0019:eS:<W#\u0001\u001d\u0011\u0005YI\u0014B\u0001\u001e\u0018\u00055\u0019\u0006.\u0019:e'R\u0014\u0018\r^3hs\"AA\b\u0001B\u0001B\u0003%\u0001(A\u0005tQ\u0006\u0014H-\u001b8hA!Aa\b\u0001B\u0001B\u0003%q(A\u0005hK>lg)[3mIB\u0011\u0001i\u0011\b\u0003!\u0005K!AQ\t\u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005FAQa\u0012\u0001\u0005\u0002!\u000ba\u0001P5oSRtD\u0003B%K\u00172\u0003\"!\b\u0001\t\u000b\u001d2\u0005\u0019A\u0015\t\u000bY2\u0005\u0019\u0001\u001d\t\u000by2\u0005\u0019A \t\u000f9\u0003!\u0019!C\t\u001f\u0006Iq-Z8n\u0013:$W\r_\u000b\u0002!B\u0011\u0001#U\u0005\u0003%F\u00111!\u00138u\u0011\u0019!\u0006\u0001)A\u0005!\u0006Qq-Z8n\u0013:$W\r\u001f\u0011\t\u000fY\u0003!\u0019!C\t/\u0006\u00191OZ2\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!aW\u0004\u0002\u000b\r,(O^3\n\u0005uS&A\u0002-[eM35\t\u0003\u0004`\u0001\u0001\u0006I\u0001W\u0001\u0005g\u001a\u001c\u0007\u0005C\u0004b\u0001\t\u0007I\u0011\u00022\u0002\u0011%\u001c\bk\\5oiN,\u0012a\u0019\t\u0003!\u0011L!!Z\t\u0003\u000f\t{w\u000e\\3b]\"1q\r\u0001Q\u0001\n\r\f\u0011\"[:Q_&tGo\u001d\u0011\t\u000f%\u0004!\u0019!C!U\u0006Q\u0011\r\u001e;sS\n,H/Z:\u0016\u0003-\u00042\u0001\\:@\u001d\ti'O\u0004\u0002oc6\tqN\u0003\u0002q\u001b\u00051AH]8pizJ\u0011AE\u0005\u0003?EI!\u0001^;\u0003\u0007M+\u0017O\u0003\u0002 #!1q\u000f\u0001Q\u0001\n-\f1\"\u0019;ue&\u0014W\u000f^3tA!9\u0011\u0010\u0001b\u0001\n\u0003R\u0018AE5oI\u0016D8*Z=CsR,G*\u001a8hi\",\u0012a\u001f\t\u0005Yrt\b+\u0003\u0002~k\n)!+[4iiB9\u0001c`A\u0002!B\u0003\u0016bAA\u0001#\tIa)\u001e8di&|gn\r\t\u0006!\u0005\u0015\u0011\u0011B\u0005\u0004\u0003\u000f\t\"!B!se\u0006L\bc\u0001\t\u0002\f%\u0019\u0011QB\t\u0003\t\tKH/\u001a\u0005\b\u0003#\u0001\u0001\u0015!\u0003|\u0003MIg\u000eZ3y\u0017\u0016L()\u001f;f\u0019\u0016tw\r\u001e5!\u0011%\t)\u0002\u0001b\u0001\n\u0003\n9\"A\u0004tQ\u0006\u0014\u0018N\\4\u0016\u0005\u0005\r\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0001\u0002\u0011MD\u0017M]5oO\u0002Bq!a\b\u0001\t\u0003\n\t#\u0001\u0006u_&sG-\u001a=LKf$\"\"a\t\u0002D\u00055\u0013\u0011KA+!\u0015\t)#!\u0010$\u001d\u0011\t9#a\u000f\u000f\t\u0005%\u0012\u0011\b\b\u0005\u0003W\t9D\u0004\u0003\u0002.\u0005Ub\u0002BA\u0018\u0003gq1A\\A\u0019\u0013\u0005a\u0011B\u0001\u0006\f\u0013\tA\u0011\"\u0003\u0002\u0006\u000f%\u0011\u0001DB\u0005\u0003?]IA!a\u0010\u0002B\tY!k\\<LKf4\u0016\r\\;f\u0015\tyr\u0003\u0003\u0005\u0002F\u0005u\u0001\u0019AA$\u0003!9(/\u001b;bE2,\u0007c\u0001\f\u0002J%\u0019\u00111J\f\u0003\u001f]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016D\u0001\"a\u0014\u0002\u001e\u0001\u0007\u00111A\u0001\u0005i&,'\u000f\u0003\u0005\u0002T\u0005u\u0001\u0019AA\u0002\u0003\tIG\rC\u0005\u0002X\u0005u\u0001\u0013!a\u0001G\u00069A.\u001a8jK:$\bbBA.\u0001\u0011\u0005\u0013QL\u0001\u000fO\u0016$\u0018J\u001c3fqZ\u000bG.^3t)\u0015Y\u0012qLA7\u0011!\t\t'!\u0017A\u0002\u0005\r\u0014A\u00024jYR,'\u000f\u0005\u0003\u0002f\u0005%TBAA4\u0015\r\t\tgL\u0005\u0005\u0003W\n9G\u0001\u0004GS2$XM\u001d\u0005\t\u0003_\nI\u00061\u0001\u0002r\u00059Q\r\u001f9mC&t\u0007\u0003BA:\u0003sj!!!\u001e\u000b\u0007\u0005]d!A\u0003vi&d7/\u0003\u0003\u0002|\u0005U$!C#ya2\f\u0017N\\3s\u0011\u001d\ty\b\u0001C!\u0003\u0003\u000b\u0011bZ3u%\u0006tw-Z:\u0015\r\u0005\r\u0015qRAJ!\u0015a\u0017QQAE\u0013\r\t9)\u001e\u0002\t\u0013R,'/\u0019;peB)\u0011QEAFG%!\u0011QRA!\u0005%\u00196-\u00198SC:<W\rC\u0004\u0002\u0012\u0006u\u0004\u0019A\u000e\u0002\rY\fG.^3t\u0011%\t)*! \u0011\u0002\u0003\u0007\u0001+\u0001\u0006nk2$\u0018\u000e\u001d7jKJDq!!'\u0001\t\u0003\nY*A\u0007hKR\u0014\u0016M\\4f\u0005f$Xm\u001d\u000b\u0007\u0003;\u000b)+!+\u0011\u000b1\f))a(\u0011\t\u0005\u0015\u0012\u0011U\u0005\u0005\u0003G\u000b\tEA\u0005CsR,'+\u00198hK\"A\u0011qUAL\u0001\u0004\t\u0019)\u0001\u0004sC:<Wm\u001d\u0005\n\u0003\u001f\n9\n%AA\u0002\rDq!!,\u0001\t\u0003\ny+A\u0007vg\u00164U\u000f\u001c7GS2$XM\u001d\u000b\bG\u0006E\u0016\u0011XAk\u0011!\t\t*a+A\u0002\u0005M\u0006\u0003\u0002\t\u00026nI1!a.\u0012\u0005\u0019y\u0005\u000f^5p]\"A\u00111XAV\u0001\u0004\ti,\u0001\u0004d_:4\u0017n\u001a\t\u0006!\u0005U\u0016q\u0018\t\u0005\u0003\u0003\fyM\u0004\u0003\u0002D\u0006%g\u0002BA\u0015\u0003\u000bL1!a2\u0007\u0003!9Wm\u001c;p_2\u001c\u0018\u0002BAf\u0003\u001b\fqcR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3GC\u000e$xN]=\u000b\u0007\u0005\u001dg!\u0003\u0003\u0002R\u0006M'AF$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f\u0007>tg-[4\u000b\t\u0005-\u0017Q\u001a\u0005\t\u0003/\fY\u000b1\u0001\u0002Z\u0006)\u0001.\u001b8ugB!\u00111\\At\u001b\t\tiN\u0003\u0003\u0002`\u0006\u0005\u0018a\u00024bGR|'/\u001f\u0006\u0005\u0003G\f)/\u0001\u0003vi&d'bAAd\u0017%!\u0011\u0011^Ao\u0005\u0015A\u0015N\u001c;t\u000f\u001d\tiO\u0001E\u0001\u0003_\f\u0001\u0003\u0017.3\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0007u\t\tP\u0002\u0004\u0002\u0005!\u0005\u00111_\n\u0006\u0003c|\u0011Q\u001f\t\u0007\u0003o\fipG\u0012\u000f\t\u0005\u001d\u0012\u0011`\u0005\u0004\u0003w<\u0012!D%oI\u0016D8*Z=Ta\u0006\u001cW-\u0003\u0003\u0002\u0000\n\u0005!\u0001F%oI\u0016D8*Z=Ta\u0006\u001cWMR1di>\u0014\u0018PC\u0002\u0002|^AqaRAy\t\u0003\u0011)\u0001\u0006\u0002\u0002p\"A!\u0011BAy\t\u0003\u0012Y!\u0001\u0005tkB\u0004xN\u001d;t)\u0015\u0019'Q\u0002B\b\u0011\u00199#q\u0001a\u0001S!1\u0011Na\u0002A\u0002-D\u0001Ba\u0005\u0002r\u0012\u0005#QC\u0001\u0006CB\u0004H.\u001f\u000b\b\u0013\n]!\u0011\u0004B\u000e\u0011\u00199#\u0011\u0003a\u0001S!1\u0011N!\u0005A\u0002-Dq!a\u0014\u0003\u0012\u0001\u00071\r")
public class XZ2IndexKeySpace
implements IndexKeySpace<package.XZ2IndexValues, Object> {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    public final String org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$$geomField;
    private final int geomIndex;
    private final XZ2SFC sfc;
    private final boolean isPoints;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;

    public static XZ2IndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return XZ2IndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return XZ2IndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace$class.getRanges$default$2(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace$class.getRangeBytes$default$2(this);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace$class.toIndexKey$default$4(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public XZ2SFC sfc() {
        return this.sfc;
    }

    private boolean isPoints() {
        return this.isPoints;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public package.RowKeyValue<Object> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        byte[] shard;
        long xz;
        Geometry geom = (Geometry)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writable.feature().getID()})));
        }
        Envelope envelope = geom.getEnvelopeInternal();
        try {
            xz = this.sfc().index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), lenient);
            shard = this.sharding().apply(writable);
        }
        catch (Throwable throwable) {
            void var5_5;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid xz value from geometry: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5})), e);
        }
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 8 + id.length, ClassTag$.MODULE$.Byte());
        if (Predef$.MODULE$.byteArrayOps(shard).isEmpty()) {
            ByteArrays$.MODULE$.writeLong(xz, bytes, 0);
            System.arraycopy(id, 0, bytes, 8, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(shard).head());
            ByteArrays$.MODULE$.writeLong(xz, bytes, 1);
            System.arraycopy(id, 0, bytes, 9, id.length);
        }
        return new package.SingleRowKeyValue<Object>(bytes, this.sharing(), shard, BoxesRunTime.boxToLong((long)xz), tier, id, writable.values());
    }

    @Override
    public package.XZ2IndexValues getIndexValues(Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, this.org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$$geomField, this.isPoints());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)new Serializable(this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1)new Serializable(this, multiplier, bits){
            public static final long serialVersionUID = 0L;
            private final int multiplier$2;
            private final int bits$1;

            public final Seq<Tuple4<Object, Object, Object, Object>> apply(Geometry x$1) {
                return GeometryUtils$.MODULE$.bounds(x$1, this.multiplier$2, this.bits$1);
            }
            {
                this.multiplier$2 = multiplier$2;
                this.bits$1 = bits$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new package.XZ2IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    @Override
    public Iterator<package.ScanRange<Object>> getRanges(package.XZ2IndexValues values2, int multiplier) {
        package.XZ2IndexValues xZ2IndexValues = values2;
        if (xZ2IndexValues != null) {
            Tuple2 tuple2;
            XZ2SFC sfc = xZ2IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = xZ2IndexValues.bounds();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)sfc, xy);
            XZ2SFC sfc2 = (XZ2SFC)tuple22._1();
            Seq xy2 = (Seq)tuple22._2();
            Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1)new Serializable(this, multiplier){
                public static final long serialVersionUID = 0L;
                private final int multiplier$1;

                public final int apply(String t) {
                    return scala.math.package$.MODULE$.max(1, new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / this.multiplier$1);
                }
                {
                    this.multiplier$1 = multiplier$1;
                }
            });
            return sfc2.ranges(xy2, target).iterator().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final package.BoundedRange<Object> apply(IndexRange r) {
                    return new package$BoundedRange$mcJ$sp(r.lower(), r.upper());
                }
            });
        }
        throw new MatchError((Object)xZ2IndexValues);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<Object>> ranges, boolean tier) {
        return this.sharding().length() == 0 ? ranges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final package.ByteRange apply(package.ScanRange<Object> x0$1) {
                package.ScanRange<Object> scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    package.BoundedByteRange boundedByteRange = new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                    return boundedByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ2IndexKeySpace $outer;

            public final GenTraversableOnce<package.ByteRange> apply(package.ScanRange<Object> x0$2) {
                package.ScanRange<Object> scanRange = x0$2;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                    GenTraversableOnce genTraversableOnce = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                        public static final long serialVersionUID = 0L;
                        private final byte[] lower$1;
                        private final byte[] upper$1;

                        public final package.BoundedByteRange apply(byte[] p) {
                            return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$1), ByteArrays$.MODULE$.concat(p, this.upper$1));
                        }
                        {
                            this.lower$1 = lower$1;
                            this.upper$1 = upper$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return genTraversableOnce;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean useFullFilter(Option<package.XZ2IndexValues> values2, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return true;
    }

    public XZ2IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField) {
        this.sft = sft;
        this.sharding = sharding;
        this.org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$$geomField = geomField;
        IndexKeySpace$class.$init$(this);
        Predef$.MODULE$.require(Geometry.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ2IndexKeySpace $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected field ", " to have a geometry binding, but instead it has: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$$geomField}))).append((Object)this.$outer.sft().getDescriptor(this.$outer.org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$$geomField).getType().getBinding().getSimpleName()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.geomIndex = sft.indexOf(geomField);
        this.sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Class clazz = sft.getDescriptor(this.geomIndex()).getType().getBinding();
        Class<Point> clazz2 = Point.class;
        this.isPoints = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        this.attributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{geomField}));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(8 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

