/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2;

import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.Z2SFC;
import org.locationtech.geomesa.curve.Z2SFC$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.IndexKeySpace$class;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$BoundedRange$mcJ$sp;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z2.Z2IndexKeySpace$;
import org.locationtech.geomesa.index.index.z2.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileByteRef;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u0001\u0003\u00019\u0011qB\u0017\u001aJ]\u0012,\u0007pS3z'B\f7-\u001a\u0006\u0003\u0007\u0011\t!A\u001f\u001a\u000b\u0005\u00151\u0011!B5oI\u0016D(BA\u0003\b\u0015\tA\u0011\"A\u0004hK>lWm]1\u000b\u0005)Y\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001yQ\u0003\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0005-eY2%D\u0001\u0018\u0015\tAb!A\u0002ba&L!AG\f\u0003\u001b%sG-\u001a=LKf\u001c\u0006/Y2f!\ta\u0002E\u0004\u0002\u001e=5\t!!\u0003\u0002 \u0005\u00059\u0001/Y2lC\u001e,\u0017BA\u0011#\u00055Q&'\u00138eKb4\u0016\r\\;fg*\u0011qD\u0001\t\u0003!\u0011J!!J\t\u0003\t1{gn\u001a\u0005\tO\u0001\u0011)\u0019!C\u0001Q\u0005\u00191O\u001a;\u0016\u0003%\u0002\"AK\u0019\u000e\u0003-R!\u0001L\u0017\u0002\rMLW\u000e\u001d7f\u0015\tqs&A\u0004gK\u0006$XO]3\u000b\u0005AZ\u0011aB8qK:<\u0017n]\u0005\u0003e-\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011!!\u0004A!A!\u0002\u0013I\u0013\u0001B:gi\u0002B\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\tg\"\f'\u000fZ5oOV\t\u0001\b\u0005\u0002\u0017s%\u0011!h\u0006\u0002\u000e'\"\f'\u000fZ*ue\u0006$XmZ=\t\u0011q\u0002!\u0011!Q\u0001\na\n\u0011b\u001d5be\u0012Lgn\u001a\u0011\t\u0011y\u0002!\u0011!Q\u0001\n}\n\u0011bZ3p[\u001aKW\r\u001c3\u0011\u0005\u0001\u001beB\u0001\tB\u0013\t\u0011\u0015#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"\u0012\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}Q!\u0011JS&M!\ti\u0002\u0001C\u0003(\r\u0002\u0007\u0011\u0006C\u00037\r\u0002\u0007\u0001\bC\u0003?\r\u0002\u0007q\bC\u0004O\u0001\t\u0007I\u0011C(\u0002\u0007M47-F\u0001Q!\t\tF+D\u0001S\u0015\t\u0019v!A\u0003dkJ4X-\u0003\u0002V%\n)!LM*G\u0007\"1q\u000b\u0001Q\u0001\nA\u000bAa\u001d4dA!9\u0011\f\u0001b\u0001\n#Q\u0016!C4f_6Le\u000eZ3y+\u0005Y\u0006C\u0001\t]\u0013\ti\u0016CA\u0002J]RDaa\u0018\u0001!\u0002\u0013Y\u0016AC4f_6Le\u000eZ3yA!9\u0011\r\u0001b\u0001\n\u0003\u0012\u0017AC1uiJL'-\u001e;fgV\t1\rE\u0002eW~r!!\u001a6\u000f\u0005\u0019LW\"A4\u000b\u0005!l\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\ty\u0012#\u0003\u0002m[\n\u00191+Z9\u000b\u0005}\t\u0002BB8\u0001A\u0003%1-A\u0006biR\u0014\u0018NY;uKN\u0004\u0003bB9\u0001\u0005\u0004%\tE]\u0001\u0013S:$W\r_&fs\nKH/\u001a'f]\u001e$\b.F\u0001t!\u0011!GO^.\n\u0005Ul'!\u0002*jO\"$\bC\u0002\txsn[6,\u0003\u0002y#\tIa)\u001e8di&|gn\r\t\u0004!id\u0018BA>\u0012\u0005\u0015\t%O]1z!\t\u0001R0\u0003\u0002\u007f#\t!!)\u001f;f\u0011\u001d\t\t\u0001\u0001Q\u0001\nM\f1#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQ\u0002B\u0011\"!\u0002\u0001\u0005\u0004%\t%a\u0002\u0002\u000fMD\u0017M]5oOV\t\u0011\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011B=\u0002\u0011MD\u0017M]5oO\u0002Bq!a\u0004\u0001\t\u0003\n\t\"\u0001\u0006u_&sG-\u001a=LKf$\"\"a\u0005\u00024\u0005u\u0012\u0011IA#!\u0015\t)\"!\f$\u001d\u0011\t9\"a\u000b\u000f\t\u0005e\u0011\u0011\u0006\b\u0005\u00037\t9C\u0004\u0003\u0002\u001e\u0005\u0015b\u0002BA\u0010\u0003Gq1AZA\u0011\u0013\u0005a\u0011B\u0001\u0006\f\u0013\tA\u0011\"\u0003\u0002\u0006\u000f%\u0011\u0001DB\u0005\u0003?]IA!a\f\u00022\tY!k\\<LKf4\u0016\r\\;f\u0015\tyr\u0003\u0003\u0005\u00026\u00055\u0001\u0019AA\u001c\u0003!9(/\u001b;bE2,\u0007c\u0001\f\u0002:%\u0019\u00111H\f\u0003\u001f]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016Dq!a\u0010\u0002\u000e\u0001\u0007\u00110\u0001\u0003uS\u0016\u0014\bbBA\"\u0003\u001b\u0001\r!_\u0001\u0003S\u0012D!\"a\u0012\u0002\u000eA\u0005\t\u0019AA%\u0003\u001daWM\\5f]R\u00042\u0001EA&\u0013\r\ti%\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\u0006\u0001C!\u0003'\nabZ3u\u0013:$W\r\u001f,bYV,7\u000fF\u0003\u001c\u0003+\n\u0019\u0007\u0003\u0005\u0002X\u0005=\u0003\u0019AA-\u0003\u00191\u0017\u000e\u001c;feB!\u00111LA0\u001b\t\tiFC\u0002\u0002X=JA!!\u0019\u0002^\t1a)\u001b7uKJD\u0001\"!\u001a\u0002P\u0001\u0007\u0011qM\u0001\bKb\u0004H.Y5o!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7\r\u0005)Q\u000f^5mg&!\u0011\u0011OA6\u0005%)\u0005\u0010\u001d7bS:,'\u000fC\u0004\u0002v\u0001!\t%a\u001e\u0002\u0013\u001d,GOU1oO\u0016\u001cHCBA=\u0003\u000b\u000bI\tE\u0003e\u0003w\ny(C\u0002\u0002~5\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0006\u0003+\t\tiI\u0005\u0005\u0003\u0007\u000b\tDA\u0005TG\u0006t'+\u00198hK\"9\u0011qQA:\u0001\u0004Y\u0012A\u0002<bYV,7\u000fC\u0005\u0002\f\u0006M\u0004\u0013!a\u00017\u0006QQ.\u001e7uSBd\u0017.\u001a:\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\u0006iq-\u001a;SC:<WMQ=uKN$b!a%\u0002\u001c\u0006}\u0005#\u00023\u0002|\u0005U\u0005\u0003BA\u000b\u0003/KA!!'\u00022\tI!)\u001f;f%\u0006tw-\u001a\u0005\t\u0003;\u000bi\t1\u0001\u0002z\u00051!/\u00198hKND!\"a\u0010\u0002\u000eB\u0005\t\u0019AA%\u0011\u001d\t\u0019\u000b\u0001C!\u0003K\u000bQ\"^:f\rVdGNR5mi\u0016\u0014H\u0003CA%\u0003O\u000by+a3\t\u0011\u0005\u001d\u0015\u0011\u0015a\u0001\u0003S\u0003B\u0001EAV7%\u0019\u0011QV\t\u0003\r=\u0003H/[8o\u0011!\t\t,!)A\u0002\u0005M\u0016AB2p]\u001aLw\rE\u0003\u0011\u0003W\u000b)\f\u0005\u0003\u00028\u0006\u0015g\u0002BA]\u0003\u007fsA!!\u0007\u0002<&\u0019\u0011Q\u0018\u0004\u0002\u0011\u001d,w\u000e^8pYNLA!!1\u0002D\u00069r)Z8NKN\fG)\u0019;b'R|'/\u001a$bGR|'/\u001f\u0006\u0004\u0003{3\u0011\u0002BAd\u0003\u0013\u0014acR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3D_:4\u0017n\u001a\u0006\u0005\u0003\u0003\f\u0019\r\u0003\u0005\u0002N\u0006\u0005\u0006\u0019AAh\u0003\u0015A\u0017N\u001c;t!\u0011\t\t.!8\u000e\u0005\u0005M'\u0002BAk\u0003/\fqAZ1di>\u0014\u0018P\u0003\u0003\u0002Z\u0006m\u0017\u0001B;uS2T1!!0\f\u0013\u0011\ty.a5\u0003\u000b!Kg\u000e^:\b\u000f\u0005\r(\u0001#\u0001\u0002f\u0006y!LM%oI\u0016D8*Z=Ta\u0006\u001cW\rE\u0002\u001e\u0003O4a!\u0001\u0002\t\u0002\u0005%8#BAt\u001f\u0005-\bCBAw\u0003g\\2E\u0004\u0003\u0002\u0018\u0005=\u0018bAAy/\u0005i\u0011J\u001c3fq.+\u0017p\u00159bG\u0016LA!!>\u0002x\n!\u0012J\u001c3fq.+\u0017p\u00159bG\u00164\u0015m\u0019;pefT1!!=\u0018\u0011\u001d9\u0015q\u001dC\u0001\u0003w$\"!!:\t\u0011\u0005}\u0018q\u001dC!\u0005\u0003\t\u0001b];qa>\u0014Ho\u001d\u000b\u0007\u0003\u0013\u0012\u0019A!\u0002\t\r\u001d\ni\u00101\u0001*\u0011\u0019\t\u0017Q a\u0001G\"A!\u0011BAt\t\u0003\u0012Y!A\u0003baBd\u0017\u0010F\u0004J\u0005\u001b\u0011yA!\u0005\t\r\u001d\u00129\u00011\u0001*\u0011\u0019\t'q\u0001a\u0001G\"A\u0011q\bB\u0004\u0001\u0004\tI\u0005")
public class Z2IndexKeySpace
implements IndexKeySpace<package.Z2IndexValues, Object> {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    public final String org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$$geomField;
    private final Z2SFC sfc;
    private final int geomIndex;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;

    public static Z2IndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return Z2IndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return Z2IndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace$class.getRanges$default$2(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace$class.getRangeBytes$default$2(this);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace$class.toIndexKey$default$4(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public Z2SFC sfc() {
        return this.sfc;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public package.RowKeyValue<Object> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        byte[] shard;
        long z;
        Point geom = (Point)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writable.feature().getID()})));
        }
        try {
            z = this.sfc().index(geom.getX(), geom.getY(), lenient);
            shard = this.sharding().apply(writable);
        }
        catch (Throwable throwable) {
            void var5_5;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z value from geometry: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5})), e);
        }
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 8 + id.length, ClassTag$.MODULE$.Byte());
        if (Predef$.MODULE$.byteArrayOps(shard).isEmpty()) {
            ByteArrays$.MODULE$.writeLong(z, bytes, 0);
            System.arraycopy(id, 0, bytes, 8, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(shard).head());
            ByteArrays$.MODULE$.writeLong(z, bytes, 1);
            System.arraycopy(id, 0, bytes, 9, id.length);
        }
        return new package.SingleRowKeyValue<Object>(bytes, this.sharing(), shard, BoxesRunTime.boxToLong((long)z), tier, id, writable.values());
    }

    @Override
    public package.Z2IndexValues getIndexValues(Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, this.org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$$geomField, true);
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)new Serializable(this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        if (geometries.disjoint()) {
            explain.apply((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Non-intersecting geometries extracted, short-circuiting to empty query";
                }
            });
            return new package.Z2IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1)new Serializable(this, multiplier, bits){
            public static final long serialVersionUID = 0L;
            private final int multiplier$2;
            private final int bits$1;

            public final Seq<Tuple4<Object, Object, Object, Object>> apply(Geometry x$1) {
                return GeometryUtils$.MODULE$.bounds(x$1, this.multiplier$2, this.bits$1);
            }
            {
                this.multiplier$2 = multiplier$2;
                this.bits$1 = bits$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new package.Z2IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    @Override
    public Iterator<package.ScanRange<Object>> getRanges(package.Z2IndexValues values2, int multiplier) {
        package.Z2IndexValues z2IndexValues = values2;
        if (z2IndexValues != null) {
            Iterator iterator;
            Seq<Tuple4<Object, Object, Object, Object>> xy = z2IndexValues.bounds();
            Seq<Tuple4<Object, Object, Object, Object>> seq = xy;
            Seq<Tuple4<Object, Object, Object, Object>> xy2 = seq;
            if (xy2.isEmpty()) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1)new Serializable(this, multiplier){
                    public static final long serialVersionUID = 0L;
                    private final int multiplier$1;

                    public final int apply(String t) {
                        return scala.math.package$.MODULE$.max(1, new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / this.multiplier$1);
                    }
                    {
                        this.multiplier$1 = multiplier$1;
                    }
                });
                iterator = this.sfc().ranges(xy2, 64, target).iterator().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final package.BoundedRange<Object> apply(IndexRange r) {
                        return new package$BoundedRange$mcJ$sp(r.lower(), r.upper());
                    }
                });
            }
            return iterator;
        }
        throw new MatchError((Object)z2IndexValues);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<Object>> ranges, boolean tier) {
        return this.sharding().length() == 0 ? ranges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final package.ByteRange apply(package.ScanRange<Object> x0$1) {
                package.ScanRange<Object> scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    package.BoundedByteRange boundedByteRange = new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                    return boundedByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z2IndexKeySpace $outer;

            public final GenTraversableOnce<package.ByteRange> apply(package.ScanRange<Object> x0$2) {
                package.ScanRange<Object> scanRange = x0$2;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                    GenTraversableOnce genTraversableOnce = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                        public static final long serialVersionUID = 0L;
                        private final byte[] lower$1;
                        private final byte[] upper$1;

                        public final package.BoundedByteRange apply(byte[] p) {
                            return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$1), ByteArrays$.MODULE$.concat(p, this.upper$1));
                        }
                        {
                            this.lower$1 = lower$1;
                            this.upper$1 = upper$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return genTraversableOnce;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean useFullFilter(Option<package.Z2IndexValues> values2, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        BooleanRef simpleGeoms$lzy = BooleanRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        boolean looseBBox = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(hints.get((Object)QueryHints$.MODULE$.LOOSE_BBOX())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x) {
                return BoxesRunTime.unboxToBoolean((Object)x);
            }
        }).getOrElse((Function0)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final Option config$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.config$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(GeoMesaDataStoreFactory.GeoMesaDataStoreConfig x$2) {
                        return x$2.looseBBox();
                    }
                });
            }
            {
                this.config$1 = config$1;
            }
        }));
        return !looseBBox || !this.simpleGeoms$1(values2, simpleGeoms$lzy, bitmap$0);
    }

    private final boolean simpleGeoms$lzycompute$1(Option values$1, BooleanRef simpleGeoms$lzy$1, VolatileByteRef bitmap$0$1) {
        Z2IndexKeySpace z2IndexKeySpace = this;
        synchronized (z2IndexKeySpace) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                simpleGeoms$lzy$1.elem = ((IterableLike)Option$.MODULE$.option2Iterable(values$1).toSeq().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Geometry> apply(package.Z2IndexValues x$3) {
                        return x$3.geometries().values();
                    }
                }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Geometry geometry) {
                        return GeometryUtils$.MODULE$.isRectangular(geometry);
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return simpleGeoms$lzy$1.elem;
        }
    }

    private final boolean simpleGeoms$1(Option values$1, BooleanRef simpleGeoms$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.simpleGeoms$lzycompute$1(values$1, simpleGeoms$lzy$1, bitmap$0$1) : simpleGeoms$lzy$1.elem;
    }

    public Z2IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField) {
        this.sft = sft;
        this.sharding = sharding;
        this.org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$$geomField = geomField;
        IndexKeySpace$class.$init$(this);
        Predef$.MODULE$.require(Point.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z2IndexKeySpace $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected field ", " to have a point binding, but instead it has: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$$geomField}))).append((Object)this.$outer.sft().getDescriptor(this.$outer.org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$$geomField).getType().getBinding().getSimpleName()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sfc = Z2SFC$.MODULE$;
        this.geomIndex = sft.indexOf(geomField);
        this.attributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{geomField}));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(8 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

