/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.utils;

import org.geotools.feature.FeatureTypes;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;

public final class Reprojection$ {
    public static final Reprojection$ MODULE$;

    static {
        new Reprojection$();
    }

    public Reprojection apply(SimpleFeatureType returnSft, Reprojection.QueryReferenceSystems crs) {
        Reprojection reprojection;
        CoordinateReferenceSystem coordinateReferenceSystem = crs.target();
        CoordinateReferenceSystem coordinateReferenceSystem2 = crs.user();
        if (!(coordinateReferenceSystem != null ? !coordinateReferenceSystem.equals(coordinateReferenceSystem2) : coordinateReferenceSystem2 != null)) {
            CoordinateReferenceSystem coordinateReferenceSystem3 = crs.user();
            CoordinateReferenceSystem coordinateReferenceSystem4 = crs.native();
            if (!(coordinateReferenceSystem3 != null ? !coordinateReferenceSystem3.equals(coordinateReferenceSystem4) : coordinateReferenceSystem4 != null)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to reproject to the same CRS: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{crs})));
            }
            SimpleFeatureType transformed = FeatureTypes.transform((SimpleFeatureType)returnSft, (CoordinateReferenceSystem)crs.user());
            reprojection = new Reprojection.UserReprojection(SimpleFeatureTypes$.MODULE$.immutable(transformed, returnSft.getUserData()));
        } else {
            GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
            transformer.setMathTransform(CRS.findMathTransform((CoordinateReferenceSystem)crs.user(), (CoordinateReferenceSystem)crs.target(), (boolean)true));
            SimpleFeatureType transformed = FeatureTypes.transform((SimpleFeatureType)returnSft, (CoordinateReferenceSystem)crs.target());
            reprojection = new Reprojection.TransformReprojection(SimpleFeatureTypes$.MODULE$.immutable(transformed, returnSft.getUserData()), transformer);
        }
        return reprojection;
    }

    private Reprojection$() {
        MODULE$ = this;
    }
}

