/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.collections.MultiHashMap;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.PropertyExtractor;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.BindingVisitorDispatch;
import org.geotools.xsd.impl.GetPropertiesExecutor;
import org.geotools.xsd.impl.GetPropertyExecutor;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Element;

public class BindingPropertyExtractor
implements PropertyExtractor {
    Encoder encoder;
    MutablePicoContainer context;

    public BindingPropertyExtractor(Encoder encoder, MutablePicoContainer context) {
        this.encoder = encoder;
        this.context = context;
    }

    @Override
    public boolean canHandle(Object object) {
        return true;
    }

    public void setContext(MutablePicoContainer context) {
        this.context = context;
    }

    @Override
    public List properties(Object object, XSDElementDeclaration element) {
        ArrayList<Object[]> properties = new ArrayList<Object[]>();
        List children = this.encoder.getSchemaIndex().getChildElementParticles(element);
        for (XSDParticle particle : children) {
            XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
            if (child.isElementDeclarationReference()) {
                child = child.getResolvedElementDeclaration();
            }
            GetPropertyExecutor executor = new GetPropertyExecutor(object, (XSDNamedComponent)child);
            BindingVisitorDispatch.walk(object, this.encoder.getBindingWalker(), (XSDFeature)element, executor, this.context);
            if (executor.getChildObject() == null) continue;
            properties.add(new Object[]{particle, executor.getChildObject()});
        }
        GetPropertiesExecutor executor = new GetPropertiesExecutor(object, element);
        BindingVisitorDispatch.walk(object, this.encoder.getBindingWalker(), (XSDFeature)element, executor, this.context);
        if (!executor.getProperties().isEmpty()) {
            MultiHashMap map = new MultiHashMap();
            for (Object[] property : executor.getProperties()) {
                map.put(property[0], property[1]);
            }
            HashMap<QName, XSDParticle> particles = new HashMap<QName, XSDParticle>();
            for (Map.Entry entry : map.entrySet()) {
                XSDParticle particle;
                if (entry.getKey() instanceof XSDParticle) {
                    XSDParticle particle2 = (XSDParticle)entry.getKey();
                    particles.put(Schemas.getParticleName(particle2), particle2);
                    continue;
                }
                QName name = (QName)entry.getKey();
                Collection values = (Collection)entry.getValue();
                if (Encoder.COMMENT.equals(name)) {
                    Element comment = this.encoder.getDocument().createElement(Encoder.COMMENT.getLocalPart());
                    Iterator v = values.iterator();
                    while (v.hasNext()) {
                        comment.appendChild(this.encoder.getDocument().createTextNode(v.next().toString()));
                    }
                    particle = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration elementDecl = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    elementDecl.setTargetNamespace(Encoder.COMMENT.getNamespaceURI());
                    elementDecl.setName(Encoder.COMMENT.getLocalPart());
                    elementDecl.setElement(comment);
                    particle.setContent((XSDParticleContent)elementDecl);
                    particles.put(name, particle);
                    continue;
                }
                XSDElementDeclaration elementDecl = this.encoder.getSchemaIndex().getElementDeclaration(name);
                if (elementDecl == null && (particle = Schemas.getChildElementParticle(element.getType(), name.getLocalPart(), true)) != null) {
                    particles.put(name, particle);
                    continue;
                }
                if (elementDecl == null) {
                    elementDecl = this.encoder.getSchema().resolveElementDeclaration(name.getNamespaceURI(), name.getLocalPart());
                }
                XSDParticle reference = null;
                for (XSDParticle particle3 : Schemas.getChildElementParticles(element.getType(), true)) {
                    XSDElementDeclaration el = (XSDElementDeclaration)particle3.getContent();
                    if (el.isElementDeclarationReference()) {
                        el = el.getResolvedElementDeclaration();
                    }
                    if (!Schemas.isBaseType(elementDecl, el)) continue;
                    reference = particle3;
                    break;
                }
                XSDParticle particle4 = XSDFactory.eINSTANCE.createXSDParticle();
                XSDElementDeclaration wrapper = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                wrapper.setResolvedElementDeclaration(elementDecl);
                particle4.setContent((XSDParticleContent)wrapper);
                if (reference != null) {
                    particle4.setMaxOccurs(reference.getMaxOccurs());
                } else if (values.size() > 1) {
                    particle4.setMaxOccurs(-1);
                } else {
                    particle4.setMaxOccurs(1);
                }
                particles.put(name, particle4);
            }
            for (Object[] property : executor.getProperties()) {
                Collection values = (Collection)map.get(property[0]);
                QName name = property[0] instanceof XSDParticle ? Schemas.getParticleName((XSDParticle)property[0]) : (QName)property[0];
                XSDParticle particle = (XSDParticle)particles.get(name);
                if (particle == null) continue;
                if (values.size() > 1) {
                    properties.add(new Object[]{particle, values});
                } else {
                    properties.add(new Object[]{particle, values.iterator().next()});
                }
                particles.remove(name);
            }
        }
        if (properties.size() <= 1) {
            return properties;
        }
        if (object instanceof ComplexAttributeImpl && this.propertiesSortable(properties, children)) {
            ArrayList<Object[]> sortedProperties = new ArrayList<Object[]>();
            block6: for (int i = 0; i < children.size(); ++i) {
                XSDParticle particle = (XSDParticle)children.get(i);
                XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                if (child.getResolvedElementDeclaration() != null) {
                    child = child.getResolvedElementDeclaration();
                }
                for (Object[] prop : properties) {
                    XSDParticle part = (XSDParticle)prop[0];
                    XSDElementDeclaration partContent = (XSDElementDeclaration)part.getContent();
                    if (partContent.getResolvedElementDeclaration() != null) {
                        partContent = partContent.getResolvedElementDeclaration();
                    }
                    if (!child.getName().equals(partContent.getName()) || child.getTargetNamespace() != null && partContent.getTargetNamespace() != null && !child.getTargetNamespace().equals(partContent.getTargetNamespace())) continue;
                    sortedProperties.add(prop);
                    properties.remove(prop);
                    --i;
                    continue block6;
                }
            }
            return sortedProperties;
        }
        return properties;
    }

    private boolean propertiesSortable(List properties, List children) {
        if (properties.size() > children.size()) {
            return false;
        }
        for (Object[] prop : properties) {
            XSDParticle part = (XSDParticle)prop[0];
            XSDElementDeclaration partContent = (XSDElementDeclaration)part.getContent();
            if (partContent.getResolvedElementDeclaration() != null) {
                partContent = partContent.getResolvedElementDeclaration();
            }
            boolean notFound = true;
            for (int i = 0; i < children.size(); ++i) {
                XSDParticle particle = (XSDParticle)children.get(i);
                XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                if (child.getResolvedElementDeclaration() != null) {
                    child = child.getResolvedElementDeclaration();
                }
                if (!child.getName().equals(partContent.getName()) || !(child.getTargetNamespace() == null ? partContent.getTargetNamespace() == null : child.getTargetNamespace().equals(partContent.getTargetNamespace()))) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            return false;
        }
        return true;
    }
}

