/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.avro;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.locationtech.geomesa.convert.avro.AvroPath;
import org.locationtech.geomesa.utils.text.BasicParser;
import org.parboiled.errors.ParsingException;
import org.parboiled.scala.ParsingResult;
import org.parboiled.scala.package$;
import org.parboiled.scala.parserunners.BasicParseRunner$;
import org.parboiled.scala.parserunners.ReportingParseRunner;
import org.parboiled.scala.parserunners.ReportingParseRunner$;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;

public final class AvroPath$
extends BasicParser {
    public static final AvroPath$ MODULE$;
    private final AvroPath.AvroPathParser Parser;

    static {
        new AvroPath$();
    }

    private AvroPath.AvroPathParser Parser() {
        return this.Parser;
    }

    public AvroPath apply(String path2) {
        return this.parse(path2, this.parse$default$2());
    }

    public AvroPath parse(String path2, boolean report) throws ParsingException {
        if (path2 == null) {
            throw new IllegalArgumentException("Invalid path string: null");
        }
        ReportingParseRunner runner = report ? ReportingParseRunner$.MODULE$.apply(this.Parser().path()) : BasicParseRunner$.MODULE$.apply(this.Parser().path());
        ParsingResult parsing = runner.run(package$.MODULE$.string2Input(path2));
        return (AvroPath)parsing.result().getOrElse((Function0)new Serializable(path2){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final Nothing$ apply() {
                throw new ParsingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing avro path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1})));
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    public boolean parse$default$2() {
        return true;
    }

    public Object org$locationtech$geomesa$convert$avro$AvroPath$$convert(Object record) {
        List<Object> list;
        Object object = record;
        if (object instanceof Utf8) {
            Utf8 utf8 = (Utf8)object;
            list = utf8.toString();
        } else if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            list = (List<Object>)this.convertBytes(byteBuffer);
        } else if (object instanceof GenericFixed) {
            GenericFixed genericFixed = (GenericFixed)object;
            list = (List<Object>)genericFixed.bytes();
        } else if (object instanceof GenericEnumSymbol) {
            GenericEnumSymbol genericEnumSymbol = (GenericEnumSymbol)object;
            list = genericEnumSymbol.toString();
        } else if (object instanceof GenericArray) {
            GenericArray genericArray = (GenericArray)object;
            list = this.convertList((List<Object>)genericArray);
        } else {
            list = object;
        }
        return list;
    }

    private byte[] convertBytes(ByteBuffer x) {
        int start = x.position();
        int length = x.limit() - start;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.Byte());
        x.get(bytes, 0, length);
        x.position(start);
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> convertList(List<Object> list) {
        void var2_2;
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        Iterator<Object> iter = list.iterator();
        while (iter.hasNext()) {
            result.add(this.org$locationtech$geomesa$convert$avro$AvroPath$$convert(iter.next()));
        }
        return var2_2;
    }

    private AvroPath$() {
        MODULE$ = this;
        this.Parser = new AvroPath.AvroPathParser();
    }
}

