/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.DataAccess;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.analytic.MinMaxProcess$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DescribeProcess(title="Min/Max Process", description="Gets attribute bounds for a data set")
@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u00015\u0011Q\"T5o\u001b\u0006D\bK]8dKN\u001c(BA\u0002\u0005\u0003!\tg.\u00197zi&\u001c'BA\u0003\u0007\u0003\u001d\u0001(o\\2fgNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\f\u001b!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u000599Um\\'fg\u0006\u0004&o\\2fgN\u0004\"a\u0007\u0012\u000e\u0003qQ!!\b\u0010\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005}\u0001\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0005\n1aY8n\u0013\t\u0019CDA\u0006MCjLHj\\4hS:<\u0007\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\u0003\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u001d)\u00070Z2vi\u0016$B\u0001\f\u001cF+B\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005E\u0012\u0014\u0001\u00023bi\u0006T!a\r\u0006\u0002\u0011\u001d,w\u000e^8pYNL!!\u000e\u0018\u0003/MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007\"B\u001c*\u0001\u0004a\u0013\u0001\u00034fCR,(/Z:)\rYJ\u0004)\u0011\"D!\tQd(D\u0001<\u0015\taT(A\u0004gC\u000e$xN]=\u000b\u0005\u0015\u0011\u0014BA <\u0005E!Um]2sS\n,\u0007+\u0019:b[\u0016$XM]\u0001\u0005]\u0006lW-I\u00018\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003\u0011\u000b\u0011\u0005\u00165fA\u0019,\u0017\r^;sK\u0002\u001aX\r\u001e\u0011p]\u0002:\b.[2iAQ|\u0007%];fefDQAR\u0015A\u0002\u001d\u000b\u0011\"\u0019;ue&\u0014W\u000f^3\u0011\u0005!seBA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S\u0015A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014&)\r\u0015K\u0004I\u0015\"TC\u00051\u0015%\u0001+\u0002EQCW\rI1uiJL'-\u001e;fAQ|\u0007eZ1uQ\u0016\u0014\bEY8v]\u0012\u001c\bEZ8s\u0011\u001d1\u0016\u0006%AA\u0002]\u000baaY1dQ\u0016$\u0007CA\bY\u0013\tI\u0006CA\u0004C_>dW-\u00198)\u0015UK\u0004i\u0017\"]=~\u0003\u0017-I\u0001WC\u0005i\u0016A\t*fiV\u0014h\u000eI2bG\",G\r\t<bYV,7\u000f\f\u0011jM\u0002\ng/Y5mC\ndW-A\u0002nS:l\u0012\u0001A\u0001\u0004[\u0006DX$A\u0001)\t%\u001a'I\u001a\t\u0003u\u0011L!!Z\u001e\u0003\u001d\u0011+7o\u0019:jE\u0016\u0014Vm];mi\u0006\nq-A\rPkR\u0004X\u000f\u001e\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007bB5\u0001#\u0003%\tA[\u0001\u0012Kb,7-\u001e;fI\u0011,g-Y;mi\u0012\u001aT#A6+\u0005]c7&A7\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018!C;oG\",7m[3e\u0015\t\u0011(*\u0001\u0006b]:|G/\u0019;j_:L!\u0001^8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u000b\u0004\u0001mfT(\t \t\u0003u]L!\u0001_\u001e\u0003\u001f\u0011+7o\u0019:jE\u0016\u0004&o\\2fgN\fQ\u0001^5uY\u0016\f\u0013a_\u0001\u0010\u001b&tw&T1yAA\u0013xnY3tg\u0006\nQ0\u0001\u0013HKR\u001c\b%\u0019;ue&\u0014W\u000f^3!E>,h\u000eZ:!M>\u0014\b%\u0019\u0011eCR\f\u0007e]3u\u000f\u0019y(\u0001#\u0001\u0002\u0002\u0005iQ*\u001b8NCb\u0004&o\\2fgN\u00042\u0001KA\u0002\r\u0019\t!\u0001#\u0001\u0002\u0006M!\u00111AA\u0004!\rI\u0015\u0011B\u0005\u0004\u0003\u0017Q%AB!osJ+g\rC\u0004&\u0003\u0007!\t!a\u0004\u0015\u0005\u0005\u0005aaBA\n\u0003\u0007\u0001\u0011Q\u0003\u0002\u000e\u001b&tW*\u0019=WSNLGo\u001c:\u0014\r\u0005Ea\"a\u0006\u001b!\r9\u0012\u0011D\u0005\u0004\u00037!!!F$f_6+7/\u0019)s_\u000e,7o\u001d,jg&$xN\u001d\u0005\no\u0005E!\u0011!Q\u0001\n1B\u0011BRA\t\u0005\u0003\u0005\u000b\u0011B$\t\u0015Y\u000b\tB!A!\u0002\u0013\t\u0019\u0003E\u0002J\u0003KI!!\u0017&\t\u000f\u0015\n\t\u0002\"\u0001\u0002*QA\u00111FA\u0018\u0003c\t\u0019\u0004\u0005\u0003\u0002.\u0005EQBAA\u0002\u0011\u00199\u0014q\u0005a\u0001Y!1a)a\nA\u0002\u001dCqAVA\u0014\u0001\u0004\t\u0019\u0003C\u0006\u00028\u0005E\u0001R1A\u0005\n\u0005e\u0012\u0001B:uCR,\"!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005)1\u000f^1ug*\u0019\u0011Q\t\u0004\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u0013q\b\u0002\u0005'R\fG\u000fC\u0006\u0002N\u0005E\u0001\u0012!Q!\n\u0005m\u0012!B:uCR\u0004\u0003\u0002DA)\u0003#\u0001\r\u00111A\u0005\n\u0005M\u0013A\u0003:fgVdGoQ1mGV\u0011\u0011Q\u000b\t\u0004/\u0005]\u0013bAA-\t\tia)Z1ukJ,'+Z:vYRDA\"!\u0018\u0002\u0012\u0001\u0007\t\u0019!C\u0005\u0003?\naB]3tk2$8)\u00197d?\u0012*\u0017\u000f\u0006\u0003\u0002b\u0005\u001d\u0004cA%\u0002d%\u0019\u0011Q\r&\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003S\nY&!AA\u0002\u0005U\u0013a\u0001=%c!I\u0011QNA\tA\u0003&\u0011QK\u0001\fe\u0016\u001cX\u000f\u001c;DC2\u001c\u0007\u0005\u0003\u0005\u0002r\u0005EA\u0011IA:\u0003\u00151\u0018n]5u)\u0011\t\t'!\u001e\t\u0011\u0005]\u0014q\u000ea\u0001\u0003s\nqAZ3biV\u0014X\r\u0005\u0003\u0002|\u0005\rUBAA?\u0015\u0011\t9(a \u000b\u0007\u0005\u0005%\"A\u0004pa\u0016tw-[:\n\t\u0005\u0015\u0015Q\u0010\u0002\b\r\u0016\fG/\u001e:f\u0011!\tI)!\u0005\u0005B\u0005-\u0015!C4fiJ+7/\u001e7u)\t\t)\u0006C\u0004+\u0003#!\t%a$\u0015\r\u0005\u0005\u0014\u0011SAN\u0011!\t\u0019*!$A\u0002\u0005U\u0015AB:pkJ\u001cW\rE\u0002.\u0003/K1!!'/\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN{WO]2f\u0011!\ti*!$A\u0002\u0005}\u0015!B9vKJL\b\u0003BAQ\u0003Gk\u0011\u0001M\u0005\u0004\u0003K\u0003$!B)vKJL\b\u0002CAU\u0003\u0007!I!a+\u0002\u0019\r\u0014X-\u0019;f%\u0016\u001cX\u000f\u001c;\u0015\t\u0005U\u0013Q\u0016\u0005\b\u0003o\t9\u000b1\u0001H\u0001")
public class MinMaxProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        MinMaxProcess minMaxProcess = this;
        synchronized (minMaxProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="The feature set on which to query") SimpleFeatureCollection features, @DescribeParameter(name="attribute", description="The attribute to gather bounds for") String attribute, @DescribeParameter(name="cached", description="Return cached values, if available", min=0, max=1) Boolean cached) {
        BoxedUnit boxedUnit;
        Predef$.MODULE$.require(attribute != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Attribute is a required field";
            }
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Attempting min/max process on type {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MinMaxVisitor visitor = new MinMaxVisitor(features, attribute, Option$.MODULE$.apply((Object)cached).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$1) {
                return x$1;
            }
        }));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public Boolean execute$default$3() {
        return null;
    }

    public MinMaxProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }

    public static class MinMaxVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private final SimpleFeatureCollection features;
        private final String attribute;
        private final boolean cached;
        private Stat stat;
        private FeatureResult resultCalc;
        private final Logger logger;
        private volatile byte bitmap$0;

        private Stat stat$lzycompute() {
            MinMaxVisitor minMaxVisitor = this;
            synchronized (minMaxVisitor) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.stat = Stat$.MODULE$.apply((SimpleFeatureType)this.features.getSchema(), Stat$.MODULE$.MinMax(this.attribute));
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.stat;
            }
        }

        private Logger logger$lzycompute() {
            MinMaxVisitor minMaxVisitor = this;
            synchronized (minMaxVisitor) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
        }

        public List<Expression> getExpressions() {
            return GeoMesaProcessVisitor.class.getExpressions((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
        }

        private Stat stat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.stat$lzycompute() : this.stat;
        }

        private FeatureResult resultCalc() {
            return this.resultCalc;
        }

        private void resultCalc_$eq(FeatureResult x$1) {
            this.resultCalc = x$1;
        }

        public void visit(Feature feature) {
            this.stat().observe((SimpleFeature)feature);
        }

        public FeatureResult getResult() {
            return this.resultCalc() == null ? MinMaxProcess$.MODULE$.org$locationtech$geomesa$process$analytic$MinMaxProcess$$createResult(this.stat().toJson()) : this.resultCalc();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(SimpleFeatureSource source, Query query2) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Running Geomesa min/max process on source type {}", new Object[]{source.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            DataAccess dataAccess = source.getDataStore();
            if (dataAccess instanceof package.HasGeoMesaStats) {
                FeatureResult featureResult;
                DataAccess dataAccess2 = dataAccess;
                Option option = ((package.HasGeoMesaStats)dataAccess2).stats().getMinMax((SimpleFeatureType)source.getSchema(), this.attribute, query2.getFilter(), !this.cached);
                if (None$.MODULE$.equals(option)) {
                    featureResult = MinMaxProcess$.MODULE$.org$locationtech$geomesa$process$analytic$MinMaxProcess$$createResult("{}");
                } else {
                    if (!(option instanceof Some)) throw new MatchError((Object)option);
                    Some some = (Some)option;
                    MinMax mm = (MinMax)some.x();
                    featureResult = MinMaxProcess$.MODULE$.org$locationtech$geomesa$process$analytic$MinMaxProcess$$createResult(mm.toJson());
                }
                this.resultCalc_$eq(featureResult);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            } else {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Running unoptimized min/max query on {}", new Object[]{dataAccess.getClass().getName()});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                SelfClosingIterator$.MODULE$.apply(this.features.features()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MinMaxVisitor $outer;

                    public final void apply(Feature feature) {
                        this.$outer.visit(feature);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            }
        }

        public MinMaxVisitor(SimpleFeatureCollection features, String attribute, boolean cached) {
            this.features = features;
            this.attribute = attribute;
            this.cached = cached;
            GeoMesaProcessVisitor.class.$init$((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }
}

