/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.package$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@DescribeProcess(title="Arrow Conversion", description="Converts a feature collection to arrow format")
@ScalaSignature(bytes="\u0006\u0001\u0011Ma\u0001B\u0001\u0003\u00015\u0011a#\u0011:s_^\u001cuN\u001c<feNLwN\u001c)s_\u000e,7o\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001e:b]N4wN]7\u000b\u0005\u00151\u0011a\u00029s_\u000e,7o\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dYQ\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!AD$f_6+7/\u0019)s_\u000e,7o\u001d\t\u00037\tj\u0011\u0001\b\u0006\u0003;y\tAb]2bY\u0006dwnZ4j]\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"\u0002\u0016\u0001\t\u0003Y\u0013aB3yK\u000e,H/\u001a\u000b\u000eYm\"v,Z=\u0000\u0003\u0017\t9\"!\u000b\u0011\u00075\u0002$'D\u0001/\u0015\ty##\u0001\u0003vi&d\u0017BA\u0019/\u0005!IE/\u001a:bi>\u0014\bcA\u001a7q5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DGA\u0003BeJ\f\u0017\u0010\u0005\u00024s%\u0011!\b\u000e\u0002\u0005\u0005f$X\rC\u0003=S\u0001\u0007Q(\u0001\u0005gK\u0006$XO]3t!\tqT)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004tS6\u0004H.\u001a\u0006\u0003\u0005\u000e\u000bA\u0001Z1uC*\u0011AIC\u0001\tO\u0016|Go\\8mg&\u0011ai\u0010\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:Dca\u000f%P!F\u0013\u0006CA%N\u001b\u0005Q%BA&M\u0003\u001d1\u0017m\u0019;pefT!!B\"\n\u00059S%!\u0005#fg\u000e\u0014\u0018NY3QCJ\fW.\u001a;fe\u0006!a.Y7fC\u0005a\u0014a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013aU\u0001#\u0013:\u0004X\u000f\u001e\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007\u0005^8!K:\u001cw\u000eZ3\t\u000bUK\u0003\u0019\u0001,\u0002\u0017%t7\r\\;eK\u001aKGm\u001d\t\u0003\u001f]K!\u0001\u0017\t\u0003\u000f\t{w\u000e\\3b]\"BA\u000bS([#nkf,I\u0001VC\u0005a\u0016!I%oG2,H-\u001a\u0011gK\u0006$XO]3!\u0013\u0012\u001b\b%\u001b8!CJ\u0014xn\u001e\u0011gS2,\u0017aA7j]v\t\u0001\u0001C\u0003aS\u0001\u0007a+A\u0005qe>D\u0018PR5eg\"Bq\fS(c#\u000elf,I\u0001aC\u0005!\u0017\u0001\f)s_bL\bEZ3biV\u0014X\rI%Eg\u0002\"x\u000eI5oiN\u0004\u0013N\\:uK\u0006$\u0007e\u001c4!gR\u0014\u0018N\\4t\u0011\u00151\u0017\u00061\u0001h\u0003A!\u0017n\u0019;j_:\f'/\u001f$jK2$7\u000fE\u0002.Q*L!!\u001b\u0018\u0003\t1K7\u000f\u001e\t\u0003W:t!a\r7\n\u00055$\u0014A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\u001c\u001b)\u0019\u0015DuJ])t;z+ho\u001e=\"\u0003\u0019\f\u0013\u0001^\u0001 \u0003R$(/\u001b2vi\u0016\u001c\b\u0005^8!I&\u001cG/[8oCJL\b%\u001a8d_\u0012,\u0017aA7bqv\u0011\u0001\u0001a\u0001\u000fG>dG.Z2uS>tG+\u001f9fG\u0005Q\u0007\"\u0002>*\u0001\u00041\u0016!F;tK\u000e\u000b7\r[3e\t&\u001cG/[8oCJLWm\u001d\u0015\ts\"{E0U?^=\u0006\n!0I\u0001\u007f\u0003e+6/\u001a\u0011dC\u000eDW\r\u001a\u0011u_Bl3\u000eI:uCR\u001c\b\u0005K5gA\u00054\u0018-\u001b7bE2,\u0017\u0006\f\u0011pe\u0002\u0012XO\u001c\u0011bA\u0011Lh.Y7jG\u0002\u001aH/\u0019;tAE,XM]=!i>\u0004#-^5mI\u0002\"\u0017n\u0019;j_:\f'/[3t\u0011\u0019\t\t!\u000ba\u0001U\u0006I1o\u001c:u\r&,G\u000e\u001a\u0015\u000b\u007f\"{\u0015QA)\u0002\bus\u0016EAA\u0001C\t\tI!\u0001\u000bBiR\u0014\u0018NY;uK\u0002\"x\u000eI:peR\u0004#-\u001f\u0005\u0007\u0003\u001bI\u0003\u0019\u0001,\u0002\u0017M|'\u000f\u001e*fm\u0016\u00148/\u001a\u0015\f\u0003\u0017Au*!\u0005R\u0003'if,\t\u0002\u0002\u000e\u0005\u0012\u0011QC\u0001\u001f%\u00164XM]:fAQDW\r\t3fM\u0006,H\u000e\u001e\u0011t_J$\be\u001c:eKJDq!!\u0007*\u0001\u0004\tY\"A\u0005cCR\u001c\u0007nU5{KB\u0019q\"!\b\n\u0007\u0005}\u0001CA\u0004J]R,w-\u001a:)\u0017\u0005]\u0001jTA\u0012#\u0006\u0015RLX\u0011\u0003\u00033\t#!a\n\u0002e9+XNY3sA=4\u0007EZ3biV\u0014Xm\u001d\u0011u_\u0002Jgn\u00197vI\u0016\u0004\u0013N\u001c\u0011fC\u000eD\u0007E]3d_J$\u0007EY1uG\"Da!a\u000b*\u0001\u00041\u0016A\u00033pk\ndW\rU1tg\"Z\u0011\u0011\u0006%P\u0003_\t\u0016\u0011G/_C\t\tY#\t\u0002\u00024\u0005y$)^5mI\u0002\"\u0017n\u0019;j_:\f'/[3tA\u0019L'o\u001d;-AQDWM\u001c\u0011rk\u0016\u0014\u0018\u0010\t:fgVdGo\u001d\u0011j]\u0002\n\u0007e]3qCJ\fG/\u001a\u0011tG\u0006t\u0007FB\u0015\u00028E\u000bi\u0004E\u0002J\u0003sI1!a\u000fK\u00059!Um]2sS\n,'+Z:vYR\f#!a\u0010\u00025\u0015s7m\u001c3fI\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8)\u0015\u0001\t\u0019%!\u0013\u0002LE\u000by\u0005E\u0002J\u0003\u000bJ1!a\u0012K\u0005=!Um]2sS\n,\u0007K]8dKN\u001c\u0018!\u0002;ji2,\u0017EAA'\u0003A\t%O]8xA\r{gN^3sg&|g.\t\u0002\u0002R\u0005i3i\u001c8wKJ$8\u000fI1!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000e\t;pA\u0005\u0014(o\\<!M>\u0014X.\u0019;\b\u000f\u0005U#\u0001#\u0001\u0002X\u00051\u0012I\u001d:po\u000e{gN^3sg&|g\u000e\u0015:pG\u0016\u001c8\u000fE\u0002)\u000332a!\u0001\u0002\t\u0002\u0005m3\u0003BA-\u0003;\u00022aMA0\u0013\r\t\t\u0007\u000e\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0015\nI\u0006\"\u0001\u0002fQ\u0011\u0011q\u000b\u0004\b\u0003S\nI\u0006AA6\u00051\t%O]8x-&\u001c\u0018\u000e^8s'\u0019\t9GDA75A\u0019q#a\u001c\n\u0007\u0005EDAA\u000bHK>lUm]1Qe>\u001cWm]:WSNLGo\u001c:\t\u0017\u0005U\u0014q\rB\u0001B\u0003%\u0011qO\u0001\u0004g\u001a$\b\u0003BA=\u0003\u000bk!!a\u001f\u000b\u0007\u0001\u000biH\u0003\u0003\u0002\u0000\u0005\u0005\u0015a\u00024fCR,(/\u001a\u0006\u0004\u0003\u0007S\u0011aB8qK:<\u0017n]\u0005\u0005\u0003\u000f\u000bYHA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D1\"a#\u0002h\t\u0005\t\u0015!\u0003\u0002\u000e\u0006AQM\\2pI&tw\r\u0005\u0003\u0002\u0010\u0006]f\u0002BAI\u0003csA!a%\u0002,:!\u0011QSAT\u001d\u0011\t9*!*\u000f\t\u0005e\u00151\u0015\b\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"C\u0002\u0002*\u001a\tQ!\u0019:s_^LA!!,\u00020\u00061a/Z2u_JT1!!+\u0007\u0013\u0011\t\u0019,!.\u0002'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f-\u0016\u001cGo\u001c:\u000b\t\u00055\u0016qV\u0005\u0005\u0003s\u000bYLA\u000bTS6\u0004H.\u001a$fCR,(/Z#oG>$\u0017N\\4\u000b\t\u0005M\u0016Q\u0017\u0005\u000bM\u0006\u001d$\u0011!Q\u0001\n\u0005}\u0006#BAa\u0003\u0017Tg\u0002BAb\u0003\u000ftA!a'\u0002F&\tQ'C\u0002\u0002JR\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002N\u0006='aA*fc*\u0019\u0011\u0011\u001a\u001b\t\u0017\u0005M\u0017q\rB\u0001B\u0003%\u0011Q[\u0001\u0012G\u0006\u001c\u0007.\u001a#jGRLwN\\1sS\u0016\u001c\b#B\u001a\u0002X\u0006m\u0017bAAmi\t1q\n\u001d;j_:\u00042aMAo\u0013\tAF\u0007C\u0006\u0002\u0002\u0005\u001d$\u0011!Q\u0001\n\u0005\u0005\b\u0003B\u001a\u0002X*D1\"!\u0004\u0002h\t\u0005\t\u0015!\u0003\u0002V\"Y\u0011q]A4\u0005\u0003\u0005\u000b\u0011BAn\u0003%\u0001(/Z*peR,G\rC\u0006\u0002\u001a\u0005\u001d$\u0011!Q\u0001\n\u0005-\bcA\u001a\u0002n&\u0019\u0011q\u001e\u001b\u0003\u0007%sG\u000fC\u0006\u0002,\u0005\u001d$\u0011!Q\u0001\n\u0005m\u0007bB\u0013\u0002h\u0011\u0005\u0011Q\u001f\u000b\u0015\u0003o\fY0!@\u0002\u0000\n\u0005!1\u0001B\u0003\u0005\u000f\u0011IAa\u0003\u0011\t\u0005e\u0018qM\u0007\u0003\u00033B\u0001\"!\u001e\u0002t\u0002\u0007\u0011q\u000f\u0005\t\u0003\u0017\u000b\u0019\u00101\u0001\u0002\u000e\"9a-a=A\u0002\u0005}\u0006\u0002CAj\u0003g\u0004\r!!6\t\u0011\u0005\u0005\u00111\u001fa\u0001\u0003CD\u0001\"!\u0004\u0002t\u0002\u0007\u0011Q\u001b\u0005\t\u0003O\f\u0019\u00101\u0001\u0002\\\"A\u0011\u0011DAz\u0001\u0004\tY\u000f\u0003\u0005\u0002,\u0005M\b\u0019AAn\u0011-\u0011y!a\u001a\t\u0006\u0004%IA!\u0005\u0002\u001b5\fg.^1m-&\u001c\u0018\u000e^8s+\t\u0011\u0019\u0002\u0005\u0003\u0002z\nUaA\u0003B\f\u00033\u0002\n1%\u0001\u0003\u001a\t\u0011\u0012I\u001d:po6\u000bg.^1m-&\u001c\u0018\u000e^8s'\u0011\u0011)\"!\u0018\t\u0011\tu!Q\u0003D\u0001\u0005?\tQA^5tSR$BA!\t\u0003(A\u00191Ga\t\n\u0007\t\u0015BG\u0001\u0003V]&$\b\u0002CA@\u00057\u0001\rA!\u000b\u0011\t\u0005e$1F\u0005\u0005\u0005[\tYHA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\t\u0005c\u0011)B\"\u0001\u00034\u00059!/Z:vYR\u001cXC\u0001B\u001b!\u0015\t\tMa\u000e3\u0013\r\t\u0014q\u001a\u0005\f\u0005w\t9\u0007#A!B\u0013\u0011\u0019\"\u0001\bnC:,\u0018\r\u001c,jg&$xN\u001d\u0011\t\u0019\t}\u0012q\ra\u0001\u0002\u0004%IAa\r\u0002\rI,7/\u001e7u\u00111\u0011\u0019%a\u001aA\u0002\u0003\u0007I\u0011\u0002B#\u0003)\u0011Xm];mi~#S-\u001d\u000b\u0005\u0005C\u00119\u0005\u0003\u0006\u0003J\t\u0005\u0013\u0011!a\u0001\u0005k\t1\u0001\u001f\u00132\u0011%\u0011i%a\u001a!B\u0013\u0011)$A\u0004sKN,H\u000e\u001e\u0011\t\u0011\tE\u0013q\rC!\u0005'\n\u0011bZ3u%\u0016\u001cX\u000f\u001c;\u0015\u0005\tU\u0003\u0003BA}\u0005/2qA!\u0017\u0002Z\u0001\u0013YFA\u0006BeJ|wOU3tk2$8\u0003\u0003B,\u0005;\u0012YG!\u001d\u0011\t\t}#qM\u0007\u0003\u0005CRAAa\u0019\u0003f\u00059a/[:ji>\u0014(bAA@\u0007&!!\u0011\u000eB1\u0005I\t%m\u001d;sC\u000e$8)\u00197d%\u0016\u001cX\u000f\u001c;\u0011\u0007M\u0012i'C\u0002\u0003pQ\u0012q\u0001\u0015:pIV\u001cG\u000fE\u00024\u0005gJ1A!\u001e5\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011-\u0011\tDa\u0016\u0003\u0016\u0004%\tA!\u001f\u0016\u00031B!B! \u0003X\tE\t\u0015!\u0003-\u0003!\u0011Xm];miN\u0004\u0003bB\u0013\u0003X\u0011\u0005!\u0011\u0011\u000b\u0005\u0005+\u0012\u0019\tC\u0004\u00032\t}\u0004\u0019\u0001\u0017\t\u0011\t\u001d%q\u000bC!\u0005\u0013\u000b\u0001bZ3u-\u0006dW/\u001a\u000b\u0003\u0003;B!B!$\u0003X\u0005\u0005I\u0011\u0001BH\u0003\u0011\u0019w\u000e]=\u0015\t\tU#\u0011\u0013\u0005\n\u0005c\u0011Y\t%AA\u00021B!B!&\u0003XE\u0005I\u0011\u0001BL\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!'+\u00071\u0012Yj\u000b\u0002\u0003\u001eB!!q\u0014BU\u001b\t\u0011\tK\u0003\u0003\u0003$\n\u0015\u0016!C;oG\",7m[3e\u0015\r\u00119\u000bN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BV\u0005C\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011yKa\u0016\u0002\u0002\u0013\u0005#\u0011W\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tM\u0006cA\b\u00036&\u0011q\u000e\u0005\u0005\u000b\u0005s\u00139&!A\u0005\u0002\tm\u0016\u0001\u00049s_\u0012,8\r^!sSRLXCAAv\u0011)\u0011yLa\u0016\u0002\u0002\u0013\u0005!\u0011Y\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\u0019M!3\u0011\u0007M\u0012)-C\u0002\u0003HR\u00121!\u00118z\u0011)\u0011IE!0\u0002\u0002\u0003\u0007\u00111\u001e\u0005\u000b\u0005\u001b\u00149&!A\u0005B\t=\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tE\u0007C\u0002Bj\u00053\u0014\u0019-\u0004\u0002\u0003V*\u0019!q\u001b\u001b\u0002\u0015\r|G\u000e\\3di&|g.C\u00022\u0005+D!B!8\u0003X\u0005\u0005I\u0011\u0001Bp\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAn\u0005CD!B!\u0013\u0003\\\u0006\u0005\t\u0019\u0001Bb\u0011)\u0011)Oa\u0016\u0002\u0002\u0013\u0005#q]\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111\u001e\u0005\u000b\u0005W\u00149&!A\u0005B\t5\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\\\n=\bB\u0003B%\u0005S\f\t\u00111\u0001\u0003D\"A!QDA4\t\u0003\u0012\u0019\u0010\u0006\u0003\u0003\"\tU\b\u0002CA@\u0005c\u0004\rAa>\u0011\t\te(1`\u0007\u0003\u0003{JAA!@\u0002~\t9a)Z1ukJ,\u0007b\u0002\u0016\u0002h\u0011\u00053\u0011\u0001\u000b\u0007\u0005C\u0019\u0019a!\u0004\t\u0011\r\u0015!q a\u0001\u0007\u000f\taa]8ve\u000e,\u0007c\u0001 \u0004\n%\u001911B \u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f'>,(oY3\t\u0011\r=!q a\u0001\u0007#\tQ!];fef\u0004Baa\u0005\u0004\u00165\t\u0011)C\u0002\u0004\u0018\u0005\u0013Q!U;fef4qaa\u0007\u0002Z\u0011\u0019iB\u0001\rTS6\u0004H.Z!se><X*\u00198vC24\u0016n]5u_J\u001cba!\u0007\u0002^\tM\u0001bCA;\u00073\u0011\t\u0011)A\u0005\u0003oB1\"a#\u0004\u001a\t\u0005\t\u0015!\u0003\u0002\u000e\"Y1QEB\r\u0005\u0003\u0005\u000b\u0011BB\u0014\u0003\u0011\u0019xN\u001d;\u0011\u000bM\n9n!\u000b\u0011\rM\u001aYC[An\u0013\r\u0019i\u0003\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0017\u0005e1\u0011\u0004B\u0001B\u0003%\u00111\u001e\u0005\bK\reA\u0011AB\u001a))\u0019)da\u000e\u0004:\rm2Q\b\t\u0005\u0003s\u001cI\u0002\u0003\u0005\u0002v\rE\u0002\u0019AA<\u0011!\tYi!\rA\u0002\u00055\u0005\u0002CB\u0013\u0007c\u0001\raa\n\t\u0011\u0005e1\u0011\u0007a\u0001\u0003WD!b!\u0011\u0004\u001a\t\u0007I\u0011BB\"\u0003\ryW\u000f^\u000b\u0003\u0007\u000b\u0002Baa\u0012\u0004N5\u00111\u0011\n\u0006\u0004\u0007\u0017\u0012\u0012AA5p\u0013\u0011\u0019ye!\u0013\u0003+\tKH/Z!se\u0006Lx*\u001e;qkR\u001cFO]3b[\"I11KB\rA\u0003%1QI\u0001\u0005_V$\b\u0005\u0003\u0006\u0004X\re!\u0019!C\u0005\u00073\nQAY=uKN,\"aa\u0017\u0011\u000b\ru31\r\u001a\u000e\u0005\r}#\u0002BB1\u0005+\fq!\\;uC\ndW-\u0003\u0003\u0004f\r}#A\u0003'jgR\u0014UO\u001a4fe\"I1\u0011NB\rA\u0003%11L\u0001\u0007Ef$Xm\u001d\u0011\t\u0015\r54\u0011\u0004a\u0001\n\u0013\u0019y'A\u0003d_VtG/\u0006\u0002\u0004rA\u00191ga\u001d\n\u0007\rUDG\u0001\u0003M_:<\u0007BCB=\u00073\u0001\r\u0011\"\u0003\u0004|\u0005I1m\\;oi~#S-\u001d\u000b\u0005\u0005C\u0019i\b\u0003\u0006\u0003J\r]\u0014\u0011!a\u0001\u0007cB\u0011b!!\u0004\u001a\u0001\u0006Ka!\u001d\u0002\r\r|WO\u001c;!\u0011)\u0019)i!\u0007C\u0002\u0013%1qQ\u0001\u0007oJLG/\u001a:\u0016\u0005\r%\u0005\u0003BBF\u0007\u001fk!a!$\u000b\t\r-\u0013qV\u0005\u0005\u0007#\u001biI\u0001\u000fTS6\u0004H.\u001a$fCR,(/Z!se><h)\u001b7f/JLG/\u001a:\t\u0013\rU5\u0011\u0004Q\u0001\n\r%\u0015aB<sSR,'\u000f\t\u0005\t\u0005;\u0019I\u0002\"\u0011\u0004\u001aR!!\u0011EBN\u0011!\tyha&A\u0002\t%\u0002\u0002\u0003B\u0019\u00073!\tEa\r\u0007\u000f\r\u0005\u0016\u0011\f\u0003\u0004$\nI2i\\7qY\u0016D\u0018I\u001d:po6\u000bg.^1m-&\u001c\u0018\u000e^8s'\u0019\u0019y*!\u0018\u0003\u0014!Y\u0011QOBP\u0005\u0003\u0005\u000b\u0011BA<\u0011-\tYia(\u0003\u0002\u0003\u0006I!!$\t\u0015\u0019\u001cyJ!A!\u0002\u0013\ty\fC\u0006\u0004&\r}%\u0011!Q\u0001\n\r\u001d\u0002bCAt\u0007?\u0013\t\u0011)A\u0005\u00037D1\"!\u0007\u0004 \n\u0005\t\u0015!\u0003\u0002l\"9Qea(\u0005\u0002\rMFCDB[\u0007o\u001bIla/\u0004>\u000e}6\u0011\u0019\t\u0005\u0003s\u001cy\n\u0003\u0005\u0002v\rE\u0006\u0019AA<\u0011!\tYi!-A\u0002\u00055\u0005b\u00024\u00042\u0002\u0007\u0011q\u0018\u0005\t\u0007K\u0019\t\f1\u0001\u0004(!A\u0011q]BY\u0001\u0004\tY\u000e\u0003\u0005\u0002\u001a\rE\u0006\u0019AAv\u0011%a4q\u0014b\u0001\n\u0013\u0019)-\u0006\u0002\u0004HB11QLBe\u0005SIAaa3\u0004`\tY\u0011I\u001d:bs\n+hMZ3s\u0011%\u0019yma(!\u0002\u0013\u00199-A\u0005gK\u0006$XO]3tA!A!QDBP\t\u0003\u001a\u0019\u000e\u0006\u0003\u0003\"\rU\u0007\u0002CA@\u0007#\u0004\rA!\u000b\t\u0011\tE2q\u0014C!\u0005g9!ba7\u0002Z\u0005\u0005\t\u0012ABo\u0003-\t%O]8x%\u0016\u001cX\u000f\u001c;\u0011\t\u0005e8q\u001c\u0004\u000b\u00053\nI&!A\t\u0002\r\u00058CBBp\u0007G\u0014\t\bE\u0004\u0004f\u000e-HF!\u0016\u000e\u0005\r\u001d(bABui\u00059!/\u001e8uS6,\u0017\u0002BBw\u0007O\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82\u0011\u001d)3q\u001cC\u0001\u0007c$\"a!8\t\u0015\rU8q\\A\u0001\n\u000b\u001a90\u0001\u0005u_N#(/\u001b8h)\t\u0011\u0019\f\u0003\u0006\u0004|\u000e}\u0017\u0011!CA\u0007{\fQ!\u00199qYf$BA!\u0016\u0004\u0000\"9!\u0011GB}\u0001\u0004a\u0003B\u0003C\u0002\u0007?\f\t\u0011\"!\u0005\u0006\u00059QO\\1qa2LH\u0003\u0002C\u0004\t\u0013\u0001BaMAlY!QA1\u0002C\u0001\u0003\u0003\u0005\rA!\u0016\u0002\u0007a$\u0003\u0007\u0003\u0006\u0005\u0010\r}\u0017\u0011!C\u0005\t#\t1B]3bIJ+7o\u001c7wKR\ta\u0002")
public class ArrowConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ArrowConversionProcess arrowConversionProcess = this;
        synchronized (arrowConversionProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(description="Encoded feature collection")
    public java.util.Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to encode") SimpleFeatureCollection features, @DescribeParameter(name="includeFids", description="Include feature IDs in arrow file", min=0) Boolean includeFids, @DescribeParameter(name="proxyFids", description="Proxy feature IDs to ints instead of strings", min=0) Boolean proxyFids, @DescribeParameter(name="dictionaryFields", description="Attributes to dictionary encode", min=0, max=128, collectionType=String.class) java.util.List<String> dictionaryFields, @DescribeParameter(name="useCachedDictionaries", description="Use cached top-k stats (if available), or run a dynamic stats query to build dictionaries", min=0) Boolean useCachedDictionaries, @DescribeParameter(name="sortField", description="Attribute to sort by", min=0) String sortField, @DescribeParameter(name="sortReverse", description="Reverse the default sort order", min=0) Boolean sortReverse, @DescribeParameter(name="batchSize", description="Number of features to include in each record batch", min=0) Integer batchSize, @DescribeParameter(name="doublePass", description="Build dictionaries first, then query results in a separate scan", min=0) Boolean doublePass) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running arrow encoding for {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Seq toEncode = (Seq)Option$.MODULE$.apply(dictionaryFields).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(java.util.List<String> x$1) {
                return JavaConversions$.MODULE$.asScalaBuffer(x$1).toSeq();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        toEncode.foreach((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final void apply(String attribute) {
                if (this.sft$1.indexOf(attribute) == -1) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute ", " doesn't exist in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute, this.sft$1})));
                }
            }
            {
                this.sft$1 = sft$1;
            }
        });
        Option cacheDictionaries = Option$.MODULE$.apply((Object)useCachedDictionaries).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$2) {
                return x$2;
            }
        });
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids == null || Predef$.MODULE$.Boolean2boolean(includeFids), proxyFids != null && Predef$.MODULE$.Boolean2boolean(proxyFids));
        Option reverse = Option$.MODULE$.apply((Object)sortReverse).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$3) {
                return x$3;
            }
        });
        int batch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)batchSize).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$4) {
                return x$4;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt();
            }
        }));
        boolean bl = Option$.MODULE$.apply((Object)doublePass).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$5) {
                return x$5;
            }
        });
        ArrowVisitor visitor = new ArrowVisitor(sft, encoding, (Seq<String>)toEncode, (Option<Object>)cacheDictionaries, (Option<String>)Option$.MODULE$.apply((Object)sortField), (Option<Object>)reverse, false, batch, bl);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public ArrowConversionProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }

    public static class ArrowResult
    extends AbstractCalcResult
    implements Product,
    Serializable {
        private final java.util.Iterator<byte[]> results;

        public java.util.Iterator<byte[]> results() {
            return this.results;
        }

        public Object getValue() {
            return this.results();
        }

        public ArrowResult copy(java.util.Iterator<byte[]> results2) {
            return new ArrowResult(results2);
        }

        public java.util.Iterator<byte[]> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "ArrowResult";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.results();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowResult arrowResult = (ArrowResult)((Object)x$1);
            java.util.Iterator<byte[]> iterator = this.results();
            java.util.Iterator<byte[]> iterator2 = arrowResult.results();
            if (iterator == null) {
                if (iterator2 != null) {
                    return false;
                }
            } else if (!iterator.equals(iterator2)) return false;
            if (!arrowResult.canEqual((Object)this)) return false;
            return true;
        }

        public ArrowResult(java.util.Iterator<byte[]> results2) {
            this.results = results2;
            Product.class.$init$((Product)this);
        }
    }

    public static class ArrowVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final Seq<String> dictionaryFields;
        private final Option<Object> cacheDictionaries;
        private final Option<String> sortField;
        public final Option<Object> org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse;
        private final boolean preSorted;
        private final int batchSize;
        private final boolean doublePass;
        private ArrowManualVisitor manualVisitor;
        private Iterator<byte[]> result;
        private final Logger logger;
        private volatile byte bitmap$0;

        private ArrowManualVisitor manualVisitor$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    Option sort = this.sortField.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArrowVisitor $outer;

                        public final Tuple2<String, Object> apply(String s) {
                            return new Tuple2((Object)s, this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse.getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply() {
                                    return this.apply$mcZ$sp();
                                }

                                public boolean apply$mcZ$sp() {
                                    return false;
                                }
                            }));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.manualVisitor = this.dictionaryFields.isEmpty() && (this.sortField.isEmpty() || this.preSorted) ? new SimpleArrowManualVisitor(this.sft, this.encoding, (Option<Tuple2<String, Object>>)sort, this.batchSize) : new ComplexArrowManualVisitor(this.sft, this.encoding, this.dictionaryFields, (Option<Tuple2<String, Object>>)sort, this.preSorted, this.batchSize);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.manualVisitor;
            }
        }

        private Logger logger$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
        }

        public java.util.List<Expression> getExpressions() {
            return GeoMesaProcessVisitor.class.getExpressions((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
        }

        private ArrowManualVisitor manualVisitor() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.manualVisitor$lzycompute() : this.manualVisitor;
        }

        private Iterator<byte[]> result() {
            return this.result;
        }

        private void result_$eq(Iterator<byte[]> x$1) {
            this.result = x$1;
        }

        public ArrowResult getResult() {
            return this.result() == null ? new ArrowResult(JavaConversions$.MODULE$.asJavaIterator(this.manualVisitor().results())) : new ArrowResult(JavaConversions$.MODULE$.asJavaIterator(this.result()));
        }

        public void visit(Feature feature) {
            this.manualVisitor().visit((SimpleFeature)feature);
        }

        public void execute(SimpleFeatureSource source, Query query2) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Visiting source type: {}", new Object[]{source.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query2.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            query2.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_FIELDS(), (Object)this.dictionaryFields.mkString(","));
            query2.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().isDefined()));
            query2.getHints().put((Object)QueryHints$.MODULE$.ARROW_PROXY_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().contains((Object)SimpleFeatureVector.SimpleFeatureEncoding$.Encoding$.MODULE$.Min())));
            query2.getHints().put((Object)QueryHints$.MODULE$.ARROW_BATCH_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.batchSize));
            query2.getHints().put((Object)QueryHints$.MODULE$.ARROW_DOUBLE_PASS(), (Object)BoxesRunTime.boxToBoolean((boolean)this.doublePass));
            this.cacheDictionaries.foreach((Function1)new Serializable(this, query2){
                public static final long serialVersionUID = 0L;
                private final Query query$1;

                public final Object apply(boolean x$6) {
                    return this.query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_CACHED(), (Object)BoxesRunTime.boxToBoolean((boolean)x$6));
                }
                {
                    this.query$1 = query$1;
                }
            });
            this.sortField.foreach((Function1)new Serializable(this, query2){
                public static final long serialVersionUID = 0L;
                private final Query query$1;

                public final Object apply(String x$7) {
                    return this.query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), (Object)x$7);
                }
                {
                    this.query$1 = query$1;
                }
            });
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse.foreach((Function1)new Serializable(this, query2){
                public static final long serialVersionUID = 0L;
                private final Query query$1;

                public final Object apply(boolean x$8) {
                    return this.query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)x$8));
                }
                {
                    this.query$1 = query$1;
                }
            });
            SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply(source.getFeatures(query2));
            this.result_$eq((Iterator<byte[]>)features.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(SimpleFeature x$9) {
                    return (byte[])x$9.getAttribute(0);
                }
            }));
        }

        public ArrowVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, Seq<String> dictionaryFields, Option<Object> cacheDictionaries, Option<String> sortField, Option<Object> sortReverse, boolean preSorted, int batchSize, boolean doublePass) {
            this.sft = sft;
            this.encoding = encoding;
            this.dictionaryFields = dictionaryFields;
            this.cacheDictionaries = cacheDictionaries;
            this.sortField = sortField;
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse = sortReverse;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.doublePass = doublePass;
            GeoMesaProcessVisitor.class.$init$((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }

    public static interface ArrowManualVisitor {
        public void visit(SimpleFeature var1);

        public Iterator<byte[]> results();
    }

    public static class SimpleArrowManualVisitor
    implements ArrowManualVisitor {
        private final int batchSize;
        private final ByteArrayOutputStream out;
        private final ListBuffer<byte[]> bytes;
        private long count;
        private final SimpleFeatureArrowFileWriter writer;

        private ByteArrayOutputStream out() {
            return this.out;
        }

        private ListBuffer<byte[]> bytes() {
            return this.bytes;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.writer().add(feature);
            this.count_$eq(this.count() + 1L);
            if (this.count() % (long)this.batchSize == 0L) {
                this.writer().flush();
                this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
                this.out().reset();
            }
        }

        @Override
        public Iterator<byte[]> results() {
            this.writer().close();
            this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
            return this.bytes().iterator();
        }

        public SimpleArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, Option<Tuple2<String, Object>> sort, int batchSize) {
            this.batchSize = batchSize;
            this.out = new ByteArrayOutputStream();
            this.bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.count = 0L;
            this.writer = SimpleFeatureArrowFileWriter$.MODULE$.apply(sft, (OutputStream)this.out(), Predef$.MODULE$.Map().empty(), encoding, sort, package$.MODULE$.allocator());
        }
    }

    public static class ComplexArrowManualVisitor
    implements ArrowManualVisitor {
        public final SimpleFeatureType org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final Seq<String> dictionaryFields;
        private final Option<Tuple2<String, Object>> sort;
        private final boolean preSorted;
        public final int org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$batchSize;
        private final ArrayBuffer<SimpleFeature> features;

        private ArrayBuffer<SimpleFeature> features() {
            return this.features;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.features().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{ScalaSimpleFeature$.MODULE$.copy(feature)}));
        }

        @Override
        public Iterator<byte[]> results() {
            None$ none$;
            block7: {
                Iterator iterator;
                Map dictionaries;
                block6: {
                    block5: {
                        None$ ordering;
                        Map map;
                        if (this.dictionaryFields.isEmpty()) {
                            map = Predef$.MODULE$.Map().empty();
                        } else {
                            Seq indicesAndValues = (Seq)this.dictionaryFields.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ComplexArrowManualVisitor $outer;

                                public final Tuple3<String, Object, HashSet<Object>> apply(String field) {
                                    return new Tuple3((Object)field, (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft.indexOf(field)), (Object)HashSet$.MODULE$.empty());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            this.features().foreach((Function1)new Serializable(this, indicesAndValues){
                                public static final long serialVersionUID = 0L;
                                private final Seq indicesAndValues$1;

                                public final void apply(SimpleFeature f) {
                                    this.indicesAndValues$1.foreach((Function1)new Serializable(this, f){
                                        public static final long serialVersionUID = 0L;
                                        private final SimpleFeature f$1;

                                        public final boolean apply(Tuple3<String, Object, HashSet<Object>> x0$1) {
                                            Tuple3<String, Object, HashSet<Object>> tuple3 = x0$1;
                                            if (tuple3 != null) {
                                                int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                                HashSet v = (HashSet)tuple3._3();
                                                boolean bl = v.add(this.f$1.getAttribute(i));
                                                return bl;
                                            }
                                            throw new MatchError(tuple3);
                                        }
                                        {
                                            this.f$1 = f$1;
                                        }
                                    });
                                }
                                {
                                    this.indicesAndValues$1 = indicesAndValues$1;
                                }
                            });
                            map = ((TraversableOnce)indicesAndValues.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ComplexArrowManualVisitor $outer;

                                public final Tuple2<String, ArrowDictionary> apply(Tuple3<String, Object, HashSet<Object>> x0$2) {
                                    Tuple3<String, Object, HashSet<Object>> tuple3 = x0$2;
                                    if (tuple3 != null) {
                                        String n = (String)tuple3._1();
                                        int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                        HashSet v = (HashSet)tuple3._3();
                                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)ArrowDictionary$.MODULE$.create((long)i, (Object[])v.toArray(ClassTag$.MODULE$.AnyRef()), ClassTag$.MODULE$.apply(this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft.getDescriptor(i).getType().getBinding())));
                                        return tuple2;
                                    }
                                    throw new MatchError(tuple3);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        }
                        dictionaries = map;
                        none$ = ordering = this.preSorted ? None$.MODULE$ : this.sort.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ComplexArrowManualVisitor $outer;

                            public final Ordering<SimpleFeature> apply(Tuple2<String, Object> x0$3) {
                                Tuple2<String, Object> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    String field = (String)tuple2._1();
                                    boolean reverse = tuple2._2$mcZ$sp();
                                    Ordering o = SimpleFeatureOrdering$.MODULE$.apply(this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft.indexOf(field));
                                    Ordering ordering = reverse ? o.reverse() : o;
                                    return ordering;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (!None$.MODULE$.equals(none$)) break block5;
                        iterator = this.features().iterator();
                        break block6;
                    }
                    if (!(none$ instanceof Some)) break block7;
                    Some some = (Some)none$;
                    Ordering o = (Ordering)some.x();
                    iterator = ((IndexedSeqLike)this.features().sorted(o)).iterator();
                }
                Iterator sorted = iterator;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                SimpleFeatureArrowFileWriter writer = SimpleFeatureArrowFileWriter$.MODULE$.apply(this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft, (OutputStream)out, dictionaries, this.encoding, this.sort, package$.MODULE$.allocator());
                return new Iterator<byte[]>(this, sorted, out, writer){
                    private final /* synthetic */ ComplexArrowManualVisitor $outer;
                    private final Iterator sorted$1;
                    private final ByteArrayOutputStream out$1;
                    private final SimpleFeatureArrowFileWriter writer$1;

                    public Iterator<byte[]> seq() {
                        return Iterator.class.seq((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.class.isEmpty((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.class.isTraversableAgain((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.class.hasDefiniteSize((Iterator)this);
                    }

                    public Iterator<byte[]> take(int n) {
                        return Iterator.class.take((Iterator)this, (int)n);
                    }

                    public Iterator<byte[]> drop(int n) {
                        return Iterator.class.drop((Iterator)this, (int)n);
                    }

                    public Iterator<byte[]> slice(int from, int until) {
                        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<byte[], B> f) {
                        return Iterator.class.map((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.class.$plus$plus((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                        return Iterator.class.flatMap((Iterator)this, f);
                    }

                    public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                        return Iterator.class.filter((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                        return Iterator.class.corresponds((Iterator)this, that, p);
                    }

                    public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                        return Iterator.class.withFilter((Iterator)this, p);
                    }

                    public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                        return Iterator.class.filterNot((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                        return Iterator.class.collect((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                        return Iterator.class.scanLeft((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                        return Iterator.class.scanRight((Iterator)this, z, op);
                    }

                    public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                        return Iterator.class.takeWhile((Iterator)this, p);
                    }

                    public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                        return Iterator.class.partition((Iterator)this, p);
                    }

                    public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                        return Iterator.class.span((Iterator)this, p);
                    }

                    public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                        return Iterator.class.dropWhile((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                        return Iterator.class.zip((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.class.padTo((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                        return Iterator.class.zipWithIndex((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<byte[], U> f) {
                        Iterator.class.foreach((Iterator)this, f);
                    }

                    public boolean forall(Function1<byte[], Object> p) {
                        return Iterator.class.forall((Iterator)this, p);
                    }

                    public boolean exists(Function1<byte[], Object> p) {
                        return Iterator.class.exists((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.class.contains((Iterator)this, (Object)elem);
                    }

                    public Option<byte[]> find(Function1<byte[], Object> p) {
                        return Iterator.class.find((Iterator)this, p);
                    }

                    public int indexWhere(Function1<byte[], Object> p) {
                        return Iterator.class.indexWhere((Iterator)this, p);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.class.indexOf((Iterator)this, elem);
                    }

                    public BufferedIterator<byte[]> buffered() {
                        return Iterator.class.buffered((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.class.grouped((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
                    }

                    public int length() {
                        return Iterator.class.length((Iterator)this);
                    }

                    public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                        return Iterator.class.duplicate((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.class.sameElements((Iterator)this, that);
                    }

                    public Traversable<byte[]> toTraversable() {
                        return Iterator.class.toTraversable((Iterator)this);
                    }

                    public Iterator<byte[]> toIterator() {
                        return Iterator.class.toIterator((Iterator)this);
                    }

                    public Stream<byte[]> toStream() {
                        return Iterator.class.toStream((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.class.toString((Iterator)this);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.class.sliding$default$2((Iterator)this);
                    }

                    public List<byte[]> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.class.size((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<byte[], Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, byte[], B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<byte[], B, B> op) {
                        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<byte[]> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public Iterable<byte[]> toIterable() {
                        return TraversableOnce.class.toIterable((TraversableOnce)this);
                    }

                    public Seq<byte[]> toSeq() {
                        return TraversableOnce.class.toSeq((TraversableOnce)this);
                    }

                    public IndexedSeq<byte[]> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.class.toBuffer((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<byte[]> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    public boolean hasNext() {
                        return this.sorted$1.hasNext();
                    }

                    public byte[] next() {
                        this.out$1.reset();
                        for (int i = 0; i < this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$batchSize && this.sorted$1.hasNext(); ++i) {
                            this.writer$1.add((SimpleFeature)this.sorted$1.next());
                        }
                        if (this.sorted$1.hasNext()) {
                            this.writer$1.flush();
                        } else {
                            this.writer$1.close();
                        }
                        return this.out$1.toByteArray();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sorted$1 = sorted$1;
                        this.out$1 = out$1;
                        this.writer$1 = writer$1;
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Iterator.class.$init$((Iterator)this);
                    }
                };
            }
            throw new MatchError((Object)none$);
        }

        public ComplexArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, Seq<String> dictionaryFields, Option<Tuple2<String, Object>> sort, boolean preSorted, int batchSize) {
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft = sft;
            this.encoding = encoding;
            this.dictionaryFields = dictionaryFields;
            this.sort = sort;
            this.preSorted = preSorted;
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$batchSize = batchSize;
            this.features = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
    }
}

