/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$Counters$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0001\u0003\u00015\u00111cR3p\u001b\u0016\u001c\u0018mT;uaV$hi\u001c:nCRT!a\u0001\u0003\u0002\u00135\f\u0007O]3ek\u000e,'BA\u0003\u0007\u0003\u0011QwNY:\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001BaD\u000b\u0018;5\t\u0001C\u0003\u0002\u0004#)\u0011!cE\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005QQ\u0011AB1qC\u000eDW-\u0003\u0002\u0017!\taq*\u001e;qkR4uN]7biB\u0011\u0001dG\u0007\u00023)\u0011!$E\u0001\u0003S>L!\u0001H\r\u0003\tQ+\u0007\u0010\u001e\t\u0003=\u0015j\u0011a\b\u0006\u0003A\u0005\naa]5na2,'B\u0001\u0012$\u0003\u001d1W-\u0019;ve\u0016T!\u0001\n\u0006\u0002\u000f=\u0004XM\\4jg&\u0011ae\b\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000b!\u0002A\u0011A\u0015\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0016\u0001\u001b\u0005\u0011\u0001\"B\u0017\u0001\t\u0003r\u0013aD4fiJ+7m\u001c:e/JLG/\u001a:\u0015\u0005=\u0012\u0004\u0003B\b1/uI!!\r\t\u0003\u0019I+7m\u001c:e/JLG/\u001a:\t\u000bMb\u0003\u0019\u0001\u001b\u0002\u000f\r|g\u000e^3yiB\u0011q\"N\u0005\u0003mA\u0011!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\")\u0001\b\u0001C!s\u0005\u00012\r[3dW>+H\u000f];u'B,7m\u001d\u000b\u0003u\u0001\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012A!\u00168ji\")1g\u000ea\u0001\u0003B\u0011qBQ\u0005\u0003\u0007B\u0011!BS8c\u0007>tG/\u001a=u\u0011\u0015)\u0005\u0001\"\u0011G\u0003I9W\r^(viB,HoQ8n[&$H/\u001a:\u0015\u0005\u001dS\u0005CA\bI\u0013\tI\u0005CA\bPkR\u0004X\u000f^\"p[6LG\u000f^3s\u0011\u0015\u0019D\t1\u00015\u000f\u0015a%\u0001#\u0001N\u0003M9Um\\'fg\u0006|U\u000f\u001e9vi\u001a{'/\\1u!\tYcJB\u0003\u0002\u0005!\u0005qj\u0005\u0002O!B\u00111(U\u0005\u0003%r\u0012a!\u00118z%\u00164\u0007\"\u0002\u0015O\t\u0003!F#A'\b\u000bYs\u0005\u0012A,\u0002\u0011\r{WO\u001c;feN\u0004\"\u0001W-\u000e\u000393QA\u0017(\t\u0002m\u0013\u0001bQ8v]R,'o]\n\u00033BCQ\u0001K-\u0005\u0002u#\u0012a\u0016\u0005\b?f\u0013\r\u0011\"\u0001a\u0003\u00159%o\\;q+\u0005\t\u0007C\u00012h\u001b\u0005\u0019'B\u00013f\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\fAA[1wC&\u0011\u0001n\u0019\u0002\u0007'R\u0014\u0018N\\4\t\r)L\u0006\u0015!\u0003b\u0003\u00199%o\\;qA!9A.\u0017b\u0001\n\u0003\u0001\u0017aB,sSR$XM\u001c\u0005\u0007]f\u0003\u000b\u0011B1\u0002\u0011]\u0013\u0018\u000e\u001e;f]\u0002Bq\u0001]-C\u0002\u0013\u0005\u0001-\u0001\u0004GC&dW\r\u001a\u0005\u0007ef\u0003\u000b\u0011B1\u0002\u000f\u0019\u000b\u0017\u000e\\3eA!)AO\u0014C\u0001k\u0006I1/\u001a;PkR\u0004X\u000f\u001e\u000b\buYl\u0018\u0011CA\u000e\u0011\u001598\u000f1\u0001y\u0003\u0011\u0019wN\u001c4\u0011\u0005e\\X\"\u0001>\u000b\u0005]\f\u0012B\u0001?{\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")ap\u001da\u0001\u007f\u00061\u0001/\u0019:b[N\u0004\u0002\"!\u0001\u0002\b\u00055\u0011Q\u0002\b\u0004w\u0005\r\u0011bAA\u0003y\u00051\u0001K]3eK\u001aLA!!\u0003\u0002\f\t\u0019Q*\u00199\u000b\u0007\u0005\u0015A\b\u0005\u0003\u0002\u0002\u0005=\u0011b\u00015\u0002\f!9\u00111C:A\u0002\u0005U\u0011aA:giB\u0019a$a\u0006\n\u0007\u0005eqDA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D\u0011\"!\bt!\u0003\u0005\r!a\b\u0002\u000f%tG-[2fgB)1(!\t\u0002&%\u0019\u00111\u0005\u001f\u0003\r=\u0003H/[8o!\u0019\t9#a\u000e\u0002\u000e9!\u0011\u0011FA\u001a\u001d\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018\u0019\u00051AH]8pizJ\u0011!P\u0005\u0004\u0003ka\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003s\tYDA\u0002TKFT1!!\u000e=\u0011\u001d\tyD\u0014C\u0001\u0003\u0003\n!cY8oM&<WO]3ECR\f7\u000b^8sKR)!(a\u0011\u0002N!A\u0011QIA\u001f\u0001\u0004\t9%A\u0002k_\n\u00042aDA%\u0013\r\tY\u0005\u0005\u0002\u0004\u0015>\u0014\u0007B\u0002@\u0002>\u0001\u0007q\u0010\u000b\u0005\u0002>\u0005E\u0013qKA.!\rY\u00141K\u0005\u0004\u0003+b$A\u00033faJ,7-\u0019;fI\u0006\u0012\u0011\u0011L\u0001\u000ekN,\u0007e]3u\u001fV$\b/\u001e;2\u0013\r\ni!!\u0018\u0002f\u0005}\u0013\u0002BA0\u0003C\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012$bAA2y\u0005QA-\u001a9sK\u000e\fG/\u001a32\u0013\r\n9'!\u001b\u0002l\u0005\rdbA\u001e\u0002j%\u0019\u00111\r\u001f2\u000b\tZD(!\u001c\u0003\u000bM\u001c\u0017\r\\1\u0007\r\u0005Ed\nAA:\u0005M9Um\\'fg\u0006\u0014VmY8sI^\u0013\u0018\u000e^3s'\u0015\tygLA;!\u0011\t9(!\"\u000e\u0005\u0005e$\u0002BA>\u0003{\nAb]2bY\u0006dwnZ4j]\u001eTA!a \u0002\u0002\u0006AA/\u001f9fg\u00064WM\u0003\u0002\u0002\u0004\u0006\u00191m\\7\n\t\u0005\u001d\u0015\u0011\u0010\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0005\u007f\u0003_\u0012\t\u0011)A\u0005\u007f\"Y\u0011QDA8\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011%\u0019\u0014q\u000eB\u0001B\u0003%A\u0007C\u0004)\u0003_\"\t!!%\u0015\u0011\u0005M\u0015QSAL\u00033\u00032\u0001WA8\u0011\u0019q\u0018q\u0012a\u0001\u007f\"A\u0011QDAH\u0001\u0004\ty\u0002\u0003\u00044\u0003\u001f\u0003\r\u0001\u000e\u0005\u000b\u0003;\u000byG1A\u0005\n\u0005}\u0015A\u00013t+\t\t\t\u000b\u0005\u0003\u0002$\u00065VBAAS\u0015\u0011\t9+!+\u0002\t\u0011\fG/\u0019\u0006\u0004\u0003WS\u0011\u0001C4f_R|w\u000e\\:\n\t\u0005=\u0016Q\u0015\u0002\n\t\u0006$\u0018m\u0015;pe\u0016D\u0011\"a-\u0002p\u0001\u0006I!!)\u0002\u0007\u0011\u001c\b\u0005\u0003\u0006\u00028\u0006=$\u0019!C\u0005\u0003s\u000bqa\u001e:ji\u0016\u00148/\u0006\u0002\u0002<BA\u0011QXAd\u0003\u001b\tI-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003\u001diW\u000f^1cY\u0016T1!!2=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0013\ty\fE\u0004\u0002$\u0006-\u0017QC\u000f\n\t\u00055\u0017Q\u0015\u0002\u000e\r\u0016\fG/\u001e:f/JLG/\u001a:\t\u0013\u0005E\u0017q\u000eQ\u0001\n\u0005m\u0016\u0001C<sSR,'o\u001d\u0011\t\u0015\u0005U\u0017q\u000eb\u0001\n\u0013\t9.A\u0004xe&$H/\u001a8\u0016\u0005\u0005e\u0007cA\b\u0002\\&\u0019\u0011Q\u001c\t\u0003\u000f\r{WO\u001c;fe\"I\u0011\u0011]A8A\u0003%\u0011\u0011\\\u0001\toJLG\u000f^3oA!Q\u0011Q]A8\u0005\u0004%I!a6\u0002\r\u0019\f\u0017\u000e\\3e\u0011%\tI/a\u001c!\u0002\u0013\tI.A\u0004gC&dW\r\u001a\u0011\t\u0011\u00055\u0018q\u000eC!\u0003_\fQa\u001e:ji\u0016$RAOAy\u0003kDq!a=\u0002l\u0002\u0007q#A\u0002lKfDq!a>\u0002l\u0002\u0007Q$A\u0003wC2,X\r\u0003\u0005\u0002|\u0006=D\u0011BA\u007f\u00031\u0019'/Z1uK^\u0013\u0018\u000e^3s)\u0011\tI-a@\t\u0011\t\u0005\u0011\u0011 a\u0001\u0003\u001b\t\u0001\u0002^=qK:\u000bW.\u001a\u0005\t\u0005\u000b\ty\u0007\"\u0011\u0003\b\u0005)1\r\\8tKR\u0019!H!\u0003\t\rM\u0012\u0019\u00011\u00015\u0011%\u0011iATI\u0001\n\u0003\u0011y!A\ntKR|U\u000f\u001e9vi\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\u0012)\"\u0011q\u0004B\nW\t\u0011)\u0002\u0005\u0003\u0003\u0018\t\u0005RB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0010y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\"\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class GeoMesaOutputFormat
extends OutputFormat<Text, SimpleFeature> {
    public static Option<Seq<String>> setOutput$default$4() {
        return GeoMesaOutputFormat$.MODULE$.setOutput$default$4();
    }

    public static void configureDataStore(Job job, scala.collection.immutable.Map<String, String> map) {
        GeoMesaOutputFormat$.MODULE$.configureDataStore(job, map);
    }

    public static void setOutput(Configuration configuration, scala.collection.immutable.Map<String, String> map, SimpleFeatureType simpleFeatureType, Option<Seq<String>> option) {
        GeoMesaOutputFormat$.MODULE$.setOutput(configuration, map, simpleFeatureType, option);
    }

    public RecordWriter<Text, SimpleFeature> getRecordWriter(TaskAttemptContext context) {
        scala.collection.immutable.Map<String, String> params = GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration());
        Option<Seq<String>> indices = GeoMesaConfigurator$.MODULE$.getIndicesOut(context.getConfiguration());
        return new GeoMesaRecordWriter(params, indices, context);
    }

    public void checkOutputSpecs(JobContext context) {
        Map params = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration())).asJava();
        if (((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(DataStoreFinder.getAvailableDataStores()).asScala()).exists((Function1)new Serializable(this, params){
            public static final long serialVersionUID = 0L;
            private final Map params$1;

            public final boolean apply(DataStoreFactorySpi x$1) {
                return x$1.canProcess(this.params$1);
            }
            {
                this.params$1 = params$1;
            }
        })) {
            return;
        }
        throw new IOException("Data store connection parameters are not set");
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new NullOutputFormat().getOutputCommitter(context);
    }

    public static class GeoMesaRecordWriter
    extends RecordWriter<Text, SimpleFeature>
    implements LazyLogging {
        private final Option<Seq<String>> indices;
        private final DataStore org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$ds;
        private final scala.collection.mutable.Map<String, FeatureWriter<SimpleFeatureType, SimpleFeature>> writers;
        private final Counter written;
        private final Counter failed;
        private final Logger logger;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            GeoMesaRecordWriter geoMesaRecordWriter = this;
            synchronized (geoMesaRecordWriter) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        public DataStore org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$ds() {
            return this.org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$ds;
        }

        private scala.collection.mutable.Map<String, FeatureWriter<SimpleFeatureType, SimpleFeature>> writers() {
            return this.writers;
        }

        private Counter written() {
            return this.written;
        }

        private Counter failed() {
            return this.failed;
        }

        public void write(Text key, SimpleFeature value) {
            try {
                String sftName = value.getFeatureType().getTypeName();
                FeatureWriter writer = (FeatureWriter)this.writers().getOrElseUpdate((Object)sftName, (Function0)new Serializable(this, sftName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ GeoMesaRecordWriter $outer;
                    private final String sftName$1;

                    public final FeatureWriter<SimpleFeatureType, SimpleFeature> apply() {
                        return this.$outer.org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$createWriter(this.sftName$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sftName$1 = sftName$1;
                    }
                });
                FeatureUtils$.MODULE$.write(writer, value, true);
                this.written().increment(1L);
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing feature '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataUtilities.encodeFeature((SimpleFeature)value)})), (Throwable)exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.failed().increment(1L);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public FeatureWriter<SimpleFeatureType, SimpleFeature> org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$createWriter(String typeName) {
            DataStore dataStore = this.org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$ds();
            if (dataStore instanceof GeoMesaDataStore) {
                Seq seq;
                GeoMesaDataStore geoMesaDataStore = (GeoMesaDataStore)dataStore;
                SimpleFeatureType sft = geoMesaDataStore.getSchema(typeName);
                Option<Seq<String>> option = this.indices;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Seq names = (Seq)some.x();
                    seq = (Seq)names.map((Function1)new Serializable(this, sft, geoMesaDataStore){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;
                        private final GeoMesaDataStore x2$1;

                        public final GeoMesaFeatureIndex<Nothing$, Nothing$> apply(String x$4) {
                            return this.x2$1.manager().index(this.sft$1, x$4, IndexMode$.MODULE$.Write());
                        }
                        {
                            this.sft$1 = sft$1;
                            this.x2$1 = x2$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    seq = geoMesaDataStore.manager().indices(sft, IndexMode$.MODULE$.Write());
                }
                Seq i = seq;
                return geoMesaDataStore.getIndexWriterAppend(typeName, i);
            }
            this.indices.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GeoMesaRecordWriter $outer;

                public final void apply(Seq<String> i) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Ignoring index config '{}' for non-geomesa data store {}", new Object[]{i.mkString(","), this.$outer.org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$ds()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return this.org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$ds().getFeatureWriterAppend(typeName, Transaction.AUTO_COMMIT);
        }

        public void close(TaskAttemptContext context) {
            this.writers().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Option<Throwable> apply(FeatureWriter<SimpleFeatureType, SimpleFeature> v) {
                    return CloseQuietly$.MODULE$.apply(v);
                }
            });
            this.org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$ds().dispose();
        }

        public GeoMesaRecordWriter(scala.collection.immutable.Map<String, String> params, Option<Seq<String>> indices, TaskAttemptContext context) {
            this.indices = indices;
            LazyLogging.class.$init$((LazyLogging)this);
            this.org$locationtech$geomesa$jobs$mapreduce$GeoMesaOutputFormat$GeoMesaRecordWriter$$ds = DataStoreFinder.getDataStore((Map)((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava()));
            this.writers = Map$.MODULE$.empty();
            this.written = context.getCounter(GeoMesaOutputFormat$Counters$.MODULE$.Group(), GeoMesaOutputFormat$Counters$.MODULE$.Written());
            this.failed = context.getCounter(GeoMesaOutputFormat$Counters$.MODULE$.Group(), GeoMesaOutputFormat$Counters$.MODULE$.Failed());
        }
    }
}

