/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class PolygonHandler
implements ShapeHandler {
    protected static final Logger LOGGER = Logging.getLogger(PolygonHandler.class);
    GeometryFactory geometryFactory;
    final ShapeType shapeType;

    public PolygonHandler(GeometryFactory gf) {
        this.shapeType = ShapeType.POLYGON;
        this.geometryFactory = gf;
    }

    public PolygonHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.POLYGON && type != ShapeType.POLYGONM && type != ShapeType.POLYGONZ) {
            throw new ShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    boolean pointInList(Coordinate testPoint, Coordinate[] pointList) {
        for (int t = pointList.length - 1; t >= 0; --t) {
            Coordinate p = pointList[t];
            if (testPoint.x != p.x || testPoint.y != p.y || testPoint.z != p.z && !Double.isNaN(testPoint.z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public int getLength(Object geometry) {
        int length;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        int nrings = 0;
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int npoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.POLYGONZ) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16 + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGONM) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGON) {
            length = 44 + 4 * nrings + 16 * npoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Polygon, got " + this.shapeType);
        }
        return length;
    }

    @Override
    public Object read(ByteBuffer buffer, ShapeType type, boolean flatFeature) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int dimensions = this.shapeType == ShapeType.POLYGONZ && !flatFeature ? 3 : 2;
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        CoordinateSequence coords = this.readCoordinates(buffer, numPoints, dimensions);
        int offset = 0;
        for (int part = 0; part < numParts; ++part) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            int close = 0;
            if (coords.getOrdinate(start, 0) != coords.getOrdinate(finish - 1, 0) || coords.getOrdinate(start, 1) != coords.getOrdinate(finish - 1, 1)) {
                close = 1;
            }
            if (dimensions == 3 && coords.getOrdinate(start, 2) != coords.getOrdinate(finish - 1, 2)) {
                close = 1;
            }
            CoordinateSequence csRing = JTS.createCS(this.geometryFactory.getCoordinateSequenceFactory(), length + close, dimensions);
            for (int i = 0; i < length; ++i) {
                csRing.setOrdinate(i, 0, coords.getOrdinate(offset, 0));
                csRing.setOrdinate(i, 1, coords.getOrdinate(offset, 1));
                if (dimensions == 3) {
                    csRing.setOrdinate(i, 2, coords.getOrdinate(offset, 2));
                }
                ++offset;
            }
            if (close == 1) {
                csRing.setOrdinate(length, 0, coords.getOrdinate(start, 0));
                csRing.setOrdinate(length, 1, coords.getOrdinate(start, 1));
                if (dimensions == 3) {
                    csRing.setOrdinate(length, 2, coords.getOrdinate(start, 2));
                }
            }
            if (csRing.size() != 0 && csRing.size() <= 3) continue;
            LinearRing ring = this.geometryFactory.createLinearRing(csRing);
            if (CoordinateSequences.isCCW(csRing)) {
                holes.add(ring);
                continue;
            }
            shells.add(ring);
        }
        if (shells.size() == 1) {
            return this.createMulti((LinearRing)shells.get(0), holes);
        }
        if (holes.size() == 1 && shells.size() == 0) {
            return this.createMulti((LinearRing)holes.get(0));
        }
        ArrayList holesForShells = this.assignHolesToShells(shells, holes);
        Geometry g = this.buildGeometries(shells, holes, holesForShells);
        return g;
    }

    private CoordinateSequence readCoordinates(ByteBuffer buffer, int numPoints, int dimensions) {
        int t;
        CoordinateSequence cs = JTS.createCS(this.geometryFactory.getCoordinateSequenceFactory(), numPoints, dimensions);
        DoubleBuffer dbuffer = buffer.asDoubleBuffer();
        double[] ordinates = new double[numPoints * 2];
        dbuffer.get(ordinates);
        for (t = 0; t < numPoints; ++t) {
            cs.setOrdinate(t, 0, ordinates[t * 2]);
            cs.setOrdinate(t, 1, ordinates[t * 2 + 1]);
        }
        if (dimensions > 2) {
            dbuffer.position(dbuffer.position() + 2);
            dbuffer.get(ordinates, 0, numPoints);
            for (t = 0; t < numPoints; ++t) {
                cs.setOrdinate(t, 2, ordinates[t]);
            }
        }
        return cs;
    }

    private Geometry buildGeometries(List shells, List holes, List holesForShells) {
        int i;
        Polygon[] polygons = shells.size() > 0 ? new Polygon[shells.size()] : new Polygon[holes.size()];
        for (i = 0; i < shells.size(); ++i) {
            polygons[i] = this.geometryFactory.createPolygon((LinearRing)shells.get(i), ((ArrayList)holesForShells.get(i)).toArray(new LinearRing[0]));
        }
        if (shells.size() == 0) {
            int ii = holes.size();
            for (i = 0; i < ii; ++i) {
                LinearRing hole = (LinearRing)holes.get(i);
                polygons[i] = this.geometryFactory.createPolygon(hole, null);
            }
        }
        MultiPolygon g = this.geometryFactory.createMultiPolygon(polygons);
        return g;
    }

    ArrayList assignHolesToShells(ArrayList shells, ArrayList holes) {
        int i;
        ArrayList holesForShells = new ArrayList(shells.size());
        for (i = 0; i < shells.size(); ++i) {
            holesForShells.add(new ArrayList());
        }
        for (i = 0; i < holes.size(); ++i) {
            LinearRing testRing = (LinearRing)holes.get(i);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            for (int j = 0; j < shells.size(); ++j) {
                LinearRing tryRing = (LinearRing)shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && (CGAlgorithms.isPointInRing((Coordinate)testPt, (Coordinate[])coordList) || this.pointInList(testPt, coordList))) {
                    isContained = true;
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                shells.add(testRing);
                holesForShells.add(new ArrayList());
                continue;
            }
            ((ArrayList)holesForShells.get(shells.indexOf(minShell))).add(testRing);
        }
        return holesForShells;
    }

    private MultiPolygon createMulti(LinearRing single) {
        return this.createMulti(single, Collections.EMPTY_LIST);
    }

    private MultiPolygon createMulti(LinearRing single, List holes) {
        return this.geometryFactory.createMultiPolygon(new Polygon[]{this.geometryFactory.createPolygon(single, holes.toArray(new LinearRing[holes.size()]))});
    }

    private MultiPolygon createNull() {
        return this.geometryFactory.createMultiPolygon(null);
    }

    @Override
    public void write(ByteBuffer buffer, Object geometry) {
        int seqSize;
        CoordinateSequence coords;
        int ringN;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        ArrayList<CoordinateSequence> allCoords = new ArrayList<CoordinateSequence>();
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            allCoords.add(p.getExteriorRing().getCoordinateSequence());
            for (ringN = 0; ringN < p.getNumInteriorRing(); ++ringN) {
                allCoords.add(p.getInteriorRingN(ringN).getCoordinateSequence());
            }
        }
        CoordinateSequence[] coordinates = allCoords.toArray(new CoordinateSequence[allCoords.size()]);
        int nrings = coordinates.length;
        int npoints = multi.getNumPoints();
        buffer.putInt(nrings);
        buffer.putInt(npoints);
        int count = 0;
        for (int t = 0; t < nrings; ++t) {
            buffer.putInt(count);
            count += coordinates[t].size();
        }
        double[] zExtreame = new double[]{Double.NaN, Double.NaN};
        for (ringN = 0; ringN < nrings; ++ringN) {
            coords = coordinates[ringN];
            JTSUtilities.zMinMax(coords, zExtreame);
            seqSize = coords.size();
            for (int coordN = 0; coordN < seqSize; ++coordN) {
                buffer.putDouble(coords.getOrdinate(coordN, 0));
                buffer.putDouble(coords.getOrdinate(coordN, 1));
            }
        }
        if (this.shapeType == ShapeType.POLYGONZ) {
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (ringN = 0; ringN < nrings; ++ringN) {
                coords = coordinates[ringN];
                seqSize = coords.size();
                for (int coordN = 0; coordN < seqSize; ++coordN) {
                    double z = coords.getOrdinate(coordN, 2);
                    if (Double.isNaN(z)) {
                        buffer.putDouble(0.0);
                        continue;
                    }
                    buffer.putDouble(z);
                }
            }
        }
        if (this.shapeType == ShapeType.POLYGONM || this.shapeType == ShapeType.POLYGONZ) {
            ArrayList<Double> values = new ArrayList<Double>();
            for (int ringN2 = 0; ringN2 < nrings; ++ringN2) {
                CoordinateSequence coords2 = coordinates[ringN2];
                int seqSize2 = coords2.size();
                for (int coordN = 0; coordN < seqSize2; ++coordN) {
                    double m = coords2.getM(coordN);
                    values.add(m);
                }
            }
            double edge = (Double)values.stream().min(Double::compare).get();
            buffer.putDouble(!Double.isNaN(edge) ? edge : -1.0E41);
            edge = (Double)values.stream().max(Double::compare).get();
            buffer.putDouble(!Double.isNaN(edge) ? edge : -1.0E41);
            values.forEach(x -> buffer.putDouble(!Double.isNaN(x) ? x : -1.0E41));
        }
    }
}

