/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet;

import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetWriter;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage$;
import org.locationtech.geomesa.parquet.ParquetPathReader;
import org.locationtech.geomesa.parquet.SimpleFeatureParquetWriter$;
import org.locationtech.geomesa.parquet.package;
import org.locationtech.geomesa.parquet.package$ReadFilter$;
import org.locationtech.geomesa.parquet.package$ReadSchema$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001-\u0011\u0001\u0004U1scV,GOR5mKNK8\u000f^3n'R|'/Y4f\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011aB4f_6,7/\u0019\u0006\u0003\u000f!\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\u000b\u000e\u00039Q!a\u0004\t\u0002\r\r|W.\\8o\u0015\t\t\"#A\u0004ti>\u0014\u0018mZ3\u000b\u0005M!\u0011A\u00014t\u0013\t)bBA\rBEN$(/Y2u\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0007\"C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r1\u0003\u001d\u0019wN\u001c;fqR\u0004\"!G\u0017\u000f\u0005iQcBA\u000e)\u001d\tarE\u0004\u0002\u001eM9\u0011a$\n\b\u0003?\u0011r!\u0001I\u0012\u000e\u0003\u0005R!A\t\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0014\t%\u0011\u0011CE\u0005\u0003SA\t1!\u00199j\u0013\tYC&A\u0004qC\u000e\\\u0017mZ3\u000b\u0005%\u0002\u0012B\u0001\u00180\u0005E1\u0015\u000e\\3TsN$X-\\\"p]R,\u0007\u0010\u001e\u0006\u0003W1J!a\u0006\u000b\t\u0013I\u0002!\u0011!Q\u0001\nM:\u0014\u0001C7fi\u0006$\u0017\r^1\u0011\u0005Q*T\"\u0001\u0017\n\u0005Yb#aD*u_J\fw-Z'fi\u0006$\u0017\r^1\n\u0005I\"\u0002\"B\u001d\u0001\t\u0003Q\u0014A\u0002\u001fj]&$h\bF\u0002<{y\u0002\"\u0001\u0010\u0001\u000e\u0003\tAQa\u0006\u001dA\u0002aAQA\r\u001dA\u0002MBQ\u0001\u0011\u0001\u0005R\u0005\u000bAb\u0019:fCR,wK]5uKJ$2AQ%U!\t\u0019eI\u0004\u0002\u001b\t&\u0011Q\tL\u0001\u0012\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0017BA$I\u0005A1\u0015\u000e\\3TsN$X-\\,sSR,'O\u0003\u0002FY!)!j\u0010a\u0001\u0017\u0006!a-\u001b7f!\ta%+D\u0001N\u0015\t\u0019bJ\u0003\u0002P!\u00061\u0001.\u00193p_BT!!\u0015\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u0019VJ\u0001\u0003QCRD\u0007\"B+@\u0001\u00041\u0016\u0001C8cg\u0016\u0014h/\u001a:\u0011\u0005]KV\"\u0001-\u000b\u0005Us\u0011B\u0001.Y\u0005I1\u0015\u000e\\3TsN$X-\\(cg\u0016\u0014h/\u001a:\t\u000bq\u0003A\u0011K/\u0002\u0019\r\u0014X-\u0019;f%\u0016\fG-\u001a:\u0015\u0007y;g\u000f\u0005\u0002`I:\u0011\u0001M\u0019\b\u00037\u0005L!a\u0004\t\n\u0005\rt\u0011!G!cgR\u0014\u0018m\u0019;GS2,7+_:uK6\u001cFo\u001c:bO\u0016L!!\u001a4\u0003)\u0019KG.Z*zgR,W\u000eU1uQJ+\u0017\rZ3s\u0015\t\u0019g\u0002C\u0003i7\u0002\u0007\u0011.\u0001\u0004gS2$XM\u001d\t\u0004U6|W\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\r=\u0003H/[8o!\t\u0001H/D\u0001r\u0015\tA'O\u0003\u0002t\u0011\u00059q\u000e]3oO&\u001c\u0018BA;r\u0005\u00191\u0015\u000e\u001c;fe\")qo\u0017a\u0001q\u0006IAO]1og\u001a|'/\u001c\t\u0004U6L\b#\u00026{y\u0006\u001d\u0011BA>l\u0005\u0019!V\u000f\u001d7feA\u0019Q0!\u0001\u000f\u0005)t\u0018BA@l\u0003\u0019\u0001&/\u001a3fM&!\u00111AA\u0003\u0005\u0019\u0019FO]5oO*\u0011qp\u001b\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0019\u0019\u0018.\u001c9mK*\u0019\u0011\u0011\u0003:\u0002\u000f\u0019,\u0017\r^;sK&!\u0011QCA\u0006\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0004\b\u00033\u0011\u0001\u0012AA\u000e\u0003a\u0001\u0016M]9vKR4\u0015\u000e\\3TsN$X-\\*u_J\fw-\u001a\t\u0004y\u0005uaAB\u0001\u0003\u0011\u0003\tyb\u0005\u0003\u0002\u001e\u0005\u0005\u0002c\u00016\u0002$%\u0019\u0011QE6\u0003\r\u0005s\u0017PU3g\u0011\u001dI\u0014Q\u0004C\u0001\u0003S!\"!a\u0007\t\u0015\u00055\u0012Q\u0004b\u0001\n\u0003\ty#\u0001\u0005F]\u000e|G-\u001b8h+\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\t1\fgn\u001a\u0006\u0003\u0003w\tAA[1wC&!\u00111AA\u001b\u0011%\t\t%!\b!\u0002\u0013\t\t$A\u0005F]\u000e|G-\u001b8hA!Q\u0011QIA\u000f\u0005\u0004%\t!a\f\u0002\u001b\u0019KG.Z#yi\u0016t7/[8o\u0011%\tI%!\b!\u0002\u0013\t\t$\u0001\bGS2,W\t\u001f;f]NLwN\u001c\u0011\t\u0015\u00055\u0013Q\u0004b\u0001\n\u0003\ty#A\u000bQCJ\fX/\u001a;D_6\u0004(/Z:tS>tw\n\u001d;\t\u0013\u0005E\u0013Q\u0004Q\u0001\n\u0005E\u0012A\u0006)beF,X\r^\"p[B\u0014Xm]:j_:|\u0005\u000f\u001e\u0011\u0007\u000f\u0005U\u0013Q\u0004\u0001\u0002X\t9\u0002+\u0019:rk\u0016$h)\u001b7f'f\u001cH/Z7Xe&$XM]\n\u0006\u0003'\nIF\u0011\t\u0005\u0003g\tY&\u0003\u0003\u0002^\u0005U\"AB(cU\u0016\u001cG\u000fC\u0006\u0002b\u0005M#\u0011!Q\u0001\n\u0005\u001d\u0011aA:gi\"I!*a\u0015\u0003\u0002\u0003\u0006Ia\u0013\u0005\f\u0003O\n\u0019F!A!\u0002\u0013\tI'\u0001\u0003d_:4\u0007\u0003BA6\u0003_j!!!\u001c\u000b\u0007\u0005\u001dd*\u0003\u0003\u0002r\u00055$!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0005V\u0003'\u0012\t\u0011)A\u0005-\"9\u0011(a\u0015\u0005\u0002\u0005]DCCA=\u0003{\ny(!!\u0002\u0004B!\u00111PA*\u001b\t\ti\u0002\u0003\u0005\u0002b\u0005U\u0004\u0019AA\u0004\u0011\u0019Q\u0015Q\u000fa\u0001\u0017\"A\u0011qMA;\u0001\u0004\tI\u0007\u0003\u0005V\u0003k\u0002\n\u00111\u0001W\u0011)\t9)a\u0015C\u0002\u0013%\u0011\u0011R\u0001\u0007oJLG/\u001a:\u0016\u0005\u0005-\u0005CBAG\u0003'\u000b9*\u0004\u0002\u0002\u0010*\u0019q*!%\u000b\u0005\r\u0001\u0016\u0002BAK\u0003\u001f\u0013Q\u0002U1scV,Go\u0016:ji\u0016\u0014\b\u0003BA\u0005\u00033KA!a'\u0002\f\ti1+[7qY\u00164U-\u0019;ve\u0016D\u0011\"a(\u0002T\u0001\u0006I!a#\u0002\u000f]\u0014\u0018\u000e^3sA!A\u00111UA*\t\u0003\n)+A\u0003xe&$X\r\u0006\u0003\u0002(\u00065\u0006c\u00016\u0002*&\u0019\u00111V6\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003_\u000b\t\u000b1\u0001\u0002\u0018\u0006\ta\r\u0003\u0005\u00024\u0006MC\u0011IA[\u0003\u00151G.^:i)\t\t9\u000b\u0003\u0005\u0002:\u0006MC\u0011IA[\u0003\u0015\u0019Gn\\:f\u000f)\ti,!\b\u0002\u0002#\u0005\u0011qX\u0001\u0018!\u0006\u0014\u0018/^3u\r&dWmU=ti\u0016lwK]5uKJ\u0004B!a\u001f\u0002B\u001aQ\u0011QKA\u000f\u0003\u0003E\t!a1\u0014\t\u0005\u0005\u0017\u0011\u0005\u0005\bs\u0005\u0005G\u0011AAd)\t\ty\f\u0003\u0006\u0002L\u0006\u0005\u0017\u0013!C\u0001\u0003\u001b\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAAhU\r1\u0016\u0011[\u0016\u0003\u0003'\u0004B!!6\u0002`6\u0011\u0011q\u001b\u0006\u0005\u00033\fY.A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\\6\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0006]'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ParquetFileSystemStorage
extends AbstractFileSystemStorage {
    public static String ParquetCompressionOpt() {
        return ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt();
    }

    public static String FileExtension() {
        return ParquetFileSystemStorage$.MODULE$.FileExtension();
    }

    public static String Encoding() {
        return ParquetFileSystemStorage$.MODULE$.Encoding();
    }

    public FileSystemStorage.FileSystemWriter createWriter(Path file, FileSystemObserver observer) {
        Configuration sftConf = new Configuration(super.context().conf());
        StorageConfiguration$.MODULE$.setSft(sftConf, super.metadata().sft());
        return new ParquetFileSystemWriter(super.metadata().sft(), file, sftConf, observer);
    }

    public AbstractFileSystemStorage.FileSystemPathReader createReader(Option<Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform) {
        package.ReadSchema readSchema = package$ReadSchema$.MODULE$.apply(super.metadata().sft(), filter, transform);
        if (readSchema != null) {
            Tuple2 tuple2;
            SimpleFeatureType readSft = readSchema.read();
            Option<Tuple2<String, SimpleFeatureType>> readTransform = readSchema.transform();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)readSft, readTransform);
            SimpleFeatureType readSft2 = (SimpleFeatureType)tuple22._1();
            Option readTransform2 = (Option)tuple22._2();
            package.ReadFilter readFilter = package$ReadFilter$.MODULE$.apply(readSft2, filter);
            if (readFilter != null) {
                BoxedUnit boxedUnit;
                Tuple2 tuple23;
                Option<FilterPredicate> fc = readFilter.parquet();
                Option<Filter> residualFilter = readFilter.residual();
                Tuple2 tuple24 = tuple23 = new Tuple2(fc, residualFilter);
                Option fc2 = (Option)tuple24._1();
                Option residualFilter2 = (Option)tuple24._2();
                FilterCompat.Filter parquetFilter = (FilterCompat.Filter)fc2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FilterCompat.Filter apply(FilterPredicate x$1) {
                        return FilterCompat.get((FilterPredicate)x$1);
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FilterCompat.Filter apply() {
                        return FilterCompat.NOOP;
                    }
                });
                Option gtFilter = residualFilter2.map((Function1)new Serializable(this, readSft2){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType readSft$1;

                    public final Filter apply(Filter x$3) {
                        return FastFilterFactory$.MODULE$.optimize(this.readSft$1, x$3);
                    }
                    {
                        this.readSft$1 = readSft$1;
                    }
                });
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Parquet filter: {} and modified gt filter: {}", new Object[]{parquetFilter, gtFilter.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final IncludeFilter apply() {
                            return Filter.INCLUDE;
                        }
                    })});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Configuration conf = new Configuration(super.context().conf());
                StorageConfiguration$.MODULE$.setSft(conf, readSft2);
                return new ParquetPathReader(conf, readSft2, parquetFilter, (Option<Filter>)gtFilter, (Option<Tuple2<String, SimpleFeatureType>>)readTransform2);
            }
            throw new MatchError((Object)readFilter);
        }
        throw new MatchError((Object)readSchema);
    }

    public ParquetFileSystemStorage(package.FileSystemContext context, StorageMetadata metadata) {
        super(context, metadata, ParquetFileSystemStorage$.MODULE$.FileExtension());
    }

    public static class ParquetFileSystemWriter
    implements FileSystemStorage.FileSystemWriter {
        private final FileSystemObserver observer;
        private final ParquetWriter<SimpleFeature> writer;

        private ParquetWriter<SimpleFeature> writer() {
            return this.writer;
        }

        public void write(SimpleFeature f) {
            this.writer().write((Object)f);
            this.observer.write(f);
        }

        public void flush() {
            this.observer.flush();
        }

        public void close() {
            CloseQuietly$.MODULE$.apply((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Closeable[]{this.writer(), this.observer}))).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(Throwable e) {
                    throw e;
                }
            });
        }

        public ParquetFileSystemWriter(SimpleFeatureType sft, Path file, Configuration conf, FileSystemObserver observer) {
            this.observer = observer;
            this.writer = SimpleFeatureParquetWriter$.MODULE$.builder(file, conf).build();
        }
    }
}

