/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.data;

import com.datastax.driver.core.GettableByNameData;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.locationtech.geomesa.cassandra.data.CassandraIndexAdapter$;
import org.locationtech.geomesa.index.api.IndexAdapter$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.TableBasedMetadata;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.MaybeSynchronized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u00015\u0011qcQ1tg\u0006tGM]1CC\u000e\\W\rZ'fi\u0006$\u0017\r^1\u000b\u0005\r!\u0011\u0001\u00023bi\u0006T!!\u0002\u0004\u0002\u0013\r\f7o]1oIJ\f'BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001)\"AD\u0011\u0014\u0007\u0001yq\u0003\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\rARdH\u0007\u00023)\u0011!dG\u0001\t[\u0016$\u0018\rZ1uC*\u0011ADB\u0001\u0006S:$W\r_\u0005\u0003=e\u0011!\u0003V1cY\u0016\u0014\u0015m]3e\u001b\u0016$\u0018\rZ1uCB\u0011\u0001%\t\u0007\u0001\t\u0015\u0011\u0003A1\u0001$\u0005\u0005!\u0016C\u0001\u0013+!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!J\u0016\n\u000512#aA!os\"Aa\u0006\u0001BC\u0002\u0013\u0005q&A\u0004tKN\u001c\u0018n\u001c8\u0016\u0003A\u0002\"!\r\u001e\u000e\u0003IR!a\r\u001b\u0002\t\r|'/\u001a\u0006\u0003kY\na\u0001\u001a:jm\u0016\u0014(BA\u001c9\u0003!!\u0017\r^1ti\u0006D(\"A\u001d\u0002\u0007\r|W.\u0003\u0002<e\t91+Z:tS>t\u0007\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u0011M,7o]5p]\u0002B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001Q\u0001\bG\u0006$\u0018\r\\8h+\u0005\t\u0005C\u0001\"F\u001d\t)3)\u0003\u0002EM\u00051\u0001K]3eK\u001aL!AR$\u0003\rM#(/\u001b8h\u0015\t!e\u0005\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003B\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0003\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\u0002\u0015M,'/[1mSj,'/F\u0001N!\rqel\b\b\u0003\u001frs!\u0001U.\u000f\u0005ESfB\u0001*Z\u001d\t\u0019\u0006L\u0004\u0002U/6\tQK\u0003\u0002W\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005q1\u0011B\u0001\u000e\u001c\u0013\ti\u0016$A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'AE'fi\u0006$\u0017\r^1TKJL\u0017\r\\5{KJT!!X\r\t\u0011\t\u0004!\u0011!Q\u0001\n5\u000b1b]3sS\u0006d\u0017N_3sA!)A\r\u0001C\u0001K\u00061A(\u001b8jiz\"BA\u001a5jUB\u0019q\rA\u0010\u000e\u0003\tAQAL2A\u0002ABQaP2A\u0002\u0005CQaS2A\u00025CQ\u0001\u001c\u0001\u0005R5\f!c\u00195fG.Le\rV1cY\u0016,\u00050[:ugV\ta\u000e\u0005\u0002&_&\u0011\u0001O\n\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011\b\u0001\"\u0015t\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u0003Q\u0004\"!J;\n\u0005Y4#\u0001B+oSRDQ\u0001\u001f\u0001\u0005Re\f\u0011c\u0019:fCR,W)\u001c9us\n\u000b7m[;q)\t1'\u0010C\u0003|o\u0002\u0007\u0011)A\u0005uS6,7\u000f^1na\")Q\u0010\u0001C)}\u0006)qO]5uKR!Ao`A\u0002\u0011\u0019\t\t\u0001 a\u0001\u0003\u0006AA/\u001f9f\u001d\u0006lW\rC\u0004\u0002\u0006q\u0004\r!a\u0002\u0002\tI|wo\u001d\t\u0007\u0003\u0013\t\t\"a\u0006\u000f\t\u0005-\u0011q\u0002\b\u0004)\u00065\u0011\"A\u0014\n\u0005u3\u0013\u0002BA\n\u0003+\u00111aU3r\u0015\tif\u0005\u0005\u0004&\u00033\t\u0015QD\u0005\u0004\u000371#A\u0002+va2,'\u0007E\u0003&\u0003?\t\u0019#C\u0002\u0002\"\u0019\u0012Q!\u0011:sCf\u00042!JA\u0013\u0013\r\t9C\n\u0002\u0005\u0005f$X\rC\u0004\u0002,\u0001!\t&!\f\u0002\r\u0011,G.\u001a;f)\u0015!\u0018qFA\u0019\u0011\u001d\t\t!!\u000bA\u0002\u0005C\u0001\"a\r\u0002*\u0001\u0007\u0011QG\u0001\u0005W\u0016L8\u000fE\u0003\u0002\n\u0005E\u0011\tC\u0004\u0002:\u0001!\t&a\u000f\u0002\u0013M\u001c\u0017M\u001c,bYV,GCBA\u001f\u0003\u0007\n)\u0005E\u0003&\u0003\u007f\ti\"C\u0002\u0002B\u0019\u0012aa\u00149uS>t\u0007bBA\u0001\u0003o\u0001\r!\u0011\u0005\b\u0003\u000f\n9\u00041\u0001B\u0003\rYW-\u001f\u0005\b\u0003\u0017\u0002A\u0011KA'\u0003)\u00198-\u00198WC2,Xm\u001d\u000b\u0007\u0003\u001f\ny&!\u0019\u0011\r\u0005E\u00131LA\f\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013AC2pY2,7\r^5p]*\u0019\u0011\u0011\f\u0004\u0002\u000bU$\u0018\u000e\\:\n\t\u0005u\u00131\u000b\u0002\u0012\u00072|7/Z1cY\u0016LE/\u001a:bi>\u0014\bbBA\u0001\u0003\u0013\u0002\r!\u0011\u0005\n\u0003G\nI\u0005%AA\u0002\u0005\u000ba\u0001\u001d:fM&D\bbBA4\u0001\u0011E\u0013\u0011N\u0001\tg\u000e\fgnS3zgR\u0011\u00111\u000e\t\u0007\u0003#\nY&!\u001c\u0011\u000b\u0015\nI\"Q!\t\r\u0005E\u0004\u0001\"\u0011t\u0003\u0015\u0019Gn\\:f\u0001")
public class CassandraBackedMetadata<T>
implements TableBasedMetadata<T> {
    private final Session session;
    private final String catalog;
    private final package.MetadataSerializer<T> serializer;
    private final MaybeSynchronized<Object> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists;
    private final long org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry;
    private final LoadingCache<Tuple2<String, String>, Option<Object>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache;
    private final LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, Object>>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache;
    private final DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    private final Logger logger;
    private volatile byte bitmap$0;

    public MaybeSynchronized<Object> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists;
    }

    public long org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry;
    }

    public LoadingCache<Tuple2<String, String>, Option<T>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache;
    }

    public LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache;
    }

    private DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$lzycompute() {
        CassandraBackedMetadata cassandraBackedMetadata = this;
        synchronized (cassandraBackedMetadata) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter = TableBasedMetadata.class.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter((TableBasedMetadata)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
        }
    }

    public DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$lzycompute() : this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    }

    public void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists_$eq(MaybeSynchronized x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists = x$1;
    }

    public void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry_$eq(long x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry = x$1;
    }

    public void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache_$eq(LoadingCache x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache = x$1;
    }

    public void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache_$eq(LoadingCache x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache = x$1;
    }

    public String[] getFeatureTypes() {
        return TableBasedMetadata.class.getFeatureTypes((TableBasedMetadata)this);
    }

    public Option<T> read(String typeName, String key, boolean cache) {
        return TableBasedMetadata.class.read((TableBasedMetadata)this, (String)typeName, (String)key, (boolean)cache);
    }

    public Seq<Tuple2<String, T>> scan(String typeName, String prefix, boolean cache) {
        return TableBasedMetadata.class.scan((TableBasedMetadata)this, (String)typeName, (String)prefix, (boolean)cache);
    }

    public void insert(String typeName, String key, T value) {
        TableBasedMetadata.class.insert((TableBasedMetadata)this, (String)typeName, (String)key, value);
    }

    public void insert(String typeName, Map<String, T> kvPairs) {
        TableBasedMetadata.class.insert((TableBasedMetadata)this, (String)typeName, kvPairs);
    }

    public void invalidateCache(String typeName, String key) {
        TableBasedMetadata.class.invalidateCache((TableBasedMetadata)this, (String)typeName, (String)key);
    }

    public void remove(String typeName, String key) {
        TableBasedMetadata.class.remove((TableBasedMetadata)this, (String)typeName, (String)key);
    }

    public void remove(String typeName, Seq<String> keys) {
        TableBasedMetadata.class.remove((TableBasedMetadata)this, (String)typeName, keys);
    }

    public void delete(String typeName) {
        TableBasedMetadata.class.delete((TableBasedMetadata)this, (String)typeName);
    }

    public void backup(String typeName) {
        TableBasedMetadata.class.backup((TableBasedMetadata)this, (String)typeName);
    }

    public void ensureTableExists() {
        TableBasedMetadata.class.ensureTableExists((TableBasedMetadata)this);
    }

    public String scanValues$default$2() {
        return TableBasedMetadata.class.scanValues$default$2((TableBasedMetadata)this);
    }

    private Logger logger$lzycompute() {
        CassandraBackedMetadata cassandraBackedMetadata = this;
        synchronized (cassandraBackedMetadata) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public T readRequired(String typeName, String key) {
        return (T)GeoMesaMetadata.class.readRequired((GeoMesaMetadata)this, (String)typeName, (String)key);
    }

    public boolean read$default$3() {
        return GeoMesaMetadata.class.read$default$3((GeoMesaMetadata)this);
    }

    public boolean scan$default$3() {
        return GeoMesaMetadata.class.scan$default$3((GeoMesaMetadata)this);
    }

    public Session session() {
        return this.session;
    }

    public String catalog() {
        return this.catalog;
    }

    public package.MetadataSerializer<T> serializer() {
        return this.serializer;
    }

    public boolean checkIfTableExists() {
        Metadata m = this.session().getCluster().getMetadata();
        KeyspaceMetadata km = m.getKeyspace(this.session().getLoggedKeyspace());
        return km.getTable(this.catalog()) != null;
    }

    public void createTable() {
        this.session().execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE IF NOT EXISTS ", " (sft text, key text, value text, PRIMARY KEY ((sft), key))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalog()})));
    }

    public CassandraBackedMetadata<T> createEmptyBackup(String timestamp) {
        String full = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", "_bak"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalog(), timestamp}));
        String table = new StringOps(Predef$.MODULE$.augmentString(full)).lengthCompare(CassandraIndexAdapter$.MODULE$.TableNameLimit()) <= 0 ? full : IndexAdapter$.MODULE$.truncateTableName(full, CassandraIndexAdapter$.MODULE$.TableNameLimit());
        return new CassandraBackedMetadata<T>(this.session(), table, this.serializer());
    }

    public void write(String typeName, Seq<Tuple2<String, byte[]>> rows) {
        rows.foreach((Function1)new Serializable(this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraBackedMetadata $outer;
            private final String typeName$1;

            public final ResultSet apply(Tuple2<String, byte[]> x0$1) {
                Tuple2<String, byte[]> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    byte[] value = (byte[])tuple2._2();
                    ResultSet resultSet = this.$outer.session().execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (sft, key, value) VALUES (?, ?, ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.catalog()})), new Object[]{this.typeName$1, key, new String(value, StandardCharsets.UTF_8)});
                    return resultSet;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$1 = typeName$1;
            }
        });
    }

    public void delete(String typeName, Seq<String> keys) {
        keys.foreach((Function1)new Serializable(this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraBackedMetadata $outer;
            private final String typeName$2;

            public final ResultSet apply(String key) {
                Delete.Where query = QueryBuilder.delete().from(this.$outer.catalog()).where(QueryBuilder.eq((String)"sft", (Object)this.typeName$2)).and(QueryBuilder.eq((String)"key", (Object)key));
                return this.$outer.session().execute((Statement)query);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$2 = typeName$2;
            }
        });
    }

    public Option<byte[]> scanValue(String typeName, String key) {
        Select query = QueryBuilder.select((String[])new String[]{"value"}).from(this.catalog());
        query.where(QueryBuilder.eq((String)"sft", (Object)typeName)).and(QueryBuilder.eq((String)"key", (Object)key));
        List rows = this.session().execute((Statement)query).all();
        return JavaConversions$.MODULE$.asScalaBuffer(rows).length() < 1 ? None$.MODULE$ : new Some((Object)((GettableByNameData)JavaConversions$.MODULE$.asScalaBuffer(rows).head()).getString("value").getBytes(StandardCharsets.UTF_8));
    }

    public CloseableIterator<Tuple2<String, byte[]>> scanValues(String typeName, String prefix) {
        Select.Where select2 = QueryBuilder.select((String[])new String[]{"key", "value"}).from(this.catalog()).where(QueryBuilder.eq((String)"sft", (Object)typeName));
        Iterator iter = JavaConversions$.MODULE$.asScalaIterator(this.session().execute((Statement)select2).all().iterator()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, byte[]> apply(Row row) {
                return new Tuple2((Object)row.getString("key"), (Object)row.getString("value").getBytes(StandardCharsets.UTF_8));
            }
        });
        return prefix == null || prefix.isEmpty() ? CloseableIterator$.MODULE$.apply(iter, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CloseableIterator$.MODULE$.apply$default$2();
            }
        }) : CloseableIterator$.MODULE$.apply(iter.filter((Function1)new Serializable(this, prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final boolean apply(Tuple2<String, byte[]> x0$2) {
                Tuple2<String, byte[]> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = k.startsWith(this.prefix$1);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.prefix$1 = prefix$1;
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CloseableIterator$.MODULE$.apply$default$2();
            }
        });
    }

    public CloseableIterator<Tuple2<String, String>> scanKeys() {
        Select select2 = QueryBuilder.select((String[])new String[]{"sft", "key"}).from(this.catalog());
        Iterator values = JavaConversions$.MODULE$.asScalaIterator(this.session().execute((Statement)select2).all().iterator()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Row row) {
                return new Tuple2((Object)row.getString("sft"), (Object)row.getString("key"));
            }
        });
        return CloseableIterator$.MODULE$.apply(values, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CloseableIterator$.MODULE$.apply$default$2();
            }
        });
    }

    public void close() {
    }

    public CassandraBackedMetadata(Session session, String catalog, package.MetadataSerializer<T> serializer) {
        this.session = session;
        this.catalog = catalog;
        this.serializer = serializer;
        GeoMesaMetadata.class.$init$((GeoMesaMetadata)this);
        LazyLogging.class.$init$((LazyLogging)this);
        TableBasedMetadata.class.$init$((TableBasedMetadata)this);
    }
}

