/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.data;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.querybuilder.Select;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.data.CassandraIndexAdapter$;
import org.locationtech.geomesa.cassandra.data.CassandraQueryPlan;
import org.locationtech.geomesa.cassandra.data.EmptyPlan;
import org.locationtech.geomesa.cassandra.data.StatementPlan;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper$;
import org.locationtech.geomesa.cassandra.package;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.api.IndexAdapter;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WritableFeature$;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.ColumnGroups;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rMc\u0001B\u0001\u0003\u00015\u0011QcQ1tg\u0006tGM]1J]\u0012,\u00070\u00113baR,'O\u0003\u0002\u0004\t\u0005!A-\u0019;b\u0015\t)a!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002\u0006\u0011\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\r)\"\u0004H\u0007\u0002-)\u0011q\u0003G\u0001\u0004CBL'BA\r\u0007\u0003\u0015Ig\u000eZ3y\u0013\tYbC\u0001\u0007J]\u0012,\u00070\u00113baR,'\u000f\u0005\u0002\u001e=5\t!!\u0003\u0002 \u0005\t\u00112)Y:tC:$'/\u0019#bi\u0006\u001cFo\u001c:f!\t\t\u0003&D\u0001#\u0015\t\u0019C%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002&M\u0005AA/\u001f9fg\u00064WMC\u0001(\u0003\r\u0019w.\\\u0005\u0003S\t\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0005\u0011\u001c\b\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\b\u0006\u00020aA\u0011Q\u0004\u0001\u0005\u0006W1\u0002\r\u0001\b\u0005\be\u0001\u0011\r\u0011\"\u00114\u00039!\u0018M\u00197f\u001d\u0006lW\rT5nSR,\u0012\u0001\u000e\t\u0004\u001fU:\u0014B\u0001\u001c\u0011\u0005\u0019y\u0005\u000f^5p]B\u0011q\u0002O\u0005\u0003sA\u00111!\u00138u\u0011\u0019Y\u0004\u0001)A\u0005i\u0005yA/\u00192mK:\u000bW.\u001a'j[&$\b\u0005C\u0003>\u0001\u0011\u0005c(A\u0006de\u0016\fG/\u001a+bE2,G\u0003B C+~\u0003\"a\u0004!\n\u0005\u0005\u0003\"\u0001B+oSRDQ!\u0007\u001fA\u0002\r\u00034\u0001R%T!\u0011)Ri\u0012*\n\u0005\u00193\"aE$f_6+7/\u0019$fCR,(/Z%oI\u0016D\bC\u0001%J\u0019\u0001!\u0011B\u0013\"\u0002\u0002\u0003\u0005)\u0011A&\u0003\u0007}#\u0013'\u0005\u0002M\u001fB\u0011q\"T\u0005\u0003\u001dB\u0011qAT8uQ&tw\r\u0005\u0002\u0010!&\u0011\u0011\u000b\u0005\u0002\u0004\u0003:L\bC\u0001%T\t%!&)!A\u0001\u0002\u000b\u00051JA\u0002`IIBQA\u0016\u001fA\u0002]\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0007=)\u0004\f\u0005\u0002Z9:\u0011qBW\u0005\u00037B\ta\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111\f\u0005\u0005\u0007Ar\"\t\u0019A1\u0002\rM\u0004H.\u001b;t!\ry!\rZ\u0005\u0003GB\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0004K6\u0004hB\u00014l\u001d\t9'.D\u0001i\u0015\tIG\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011A\u000eE\u0001\ba\u0006\u001c7.Y4f\u0013\tqwNA\u0002TKFT!\u0001\u001c\t\u0011\u0007=\t8/\u0003\u0002s!\t)\u0011I\u001d:bsB\u0011q\u0002^\u0005\u0003kB\u0011AAQ=uK\")q\u000f\u0001C!q\u0006Y!/\u001a8b[\u0016$\u0016M\u00197f)\ry\u0014p\u001f\u0005\u0006uZ\u0004\r\u0001W\u0001\u0005MJ|W\u000eC\u0003}m\u0002\u0007\u0001,\u0001\u0002u_\")a\u0010\u0001C!\u007f\u0006aA-\u001a7fi\u0016$\u0016M\u00197fgR\u0019q(!\u0001\t\u000f\u0005\rQ\u00101\u0001\u0002\u0006\u00051A/\u00192mKN\u00042!Z7Y\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\t1b\u00197fCJ$\u0016M\u00197fgR)q(!\u0004\u0002\u0010!A\u00111AA\u0004\u0001\u0004\t)\u0001\u0003\u0005\u0002\u0012\u0005\u001d\u0001\u0019AA\n\u0003\u0019\u0001(/\u001a4jqB\u0019q\"\u000e9\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u0005y1M]3bi\u0016\fV/\u001a:z!2\fg\u000e\u0006\u0003\u0002\u001c\u0005\u0005\u0002cA\u000f\u0002\u001e%\u0019\u0011q\u0004\u0002\u0003%\r\u000b7o]1oIJ\f\u0017+^3ssBc\u0017M\u001c\u0005\t\u0003G\t)\u00021\u0001\u0002&\u0005A1\u000f\u001e:bi\u0016<\u0017\u0010\u0005\u0003\u0002(\u0005}b\u0002BA\u0015\u0003{qA!a\u000b\u0002<9!\u0011QFA\u001d\u001d\u0011\ty#a\u000e\u000f\t\u0005E\u0012Q\u0007\b\u0004O\u0006M\u0012\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\tIb!\u0003\u0002\u00181%\u0011ANF\u0005\u0005\u0003\u0003\n\u0019EA\u0007Rk\u0016\u0014\u0018p\u0015;sCR,w-\u001f\u0006\u0003YZAq!a\u0012\u0001\t\u0003\nI%\u0001\u0007de\u0016\fG/Z,sSR,'\u000f\u0006\u0005\u0002L\re2QHB)!\u0011\tiE!\u0015\u000f\t\u0005=\u0013q\u000b\b\u0005\u0003#\n)F\u0004\u0003\u0002.\u0005M\u0013BA\u0003\u0007\u0013\t\u0019AaB\u0004\u0002Z\tA\t!a\u0017\u0002+\r\u000b7o]1oIJ\f\u0017J\u001c3fq\u0006#\u0017\r\u001d;feB\u0019Q$!\u0018\u0007\r\u0005\u0011\u0001\u0012AA0'\u0015\tiFDA1!\r\t\u00131M\u0005\u0004\u0003K\u0012#a\u0003'bufdunZ4j]\u001eDq!LA/\t\u0003\tI\u0007\u0006\u0002\u0002\\!Q\u0011QNA/\u0005\u0004%\t!a\u001c\u0002\u001dQ\u000b'\r\\3OC6,G*[7jiV\tq\u0007\u0003\u0005\u0002t\u0005u\u0003\u0015!\u00038\u0003=!\u0016M\u00197f\u001d\u0006lW\rT5nSR\u0004\u0003\u0002CA<\u0003;\"\t!!\u001f\u0002\u0013M$\u0018\r^3nK:$H\u0003CA>\u0003'\u000b9*a'\u0011\t\u0005u\u0014qR\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006a\u0011/^3ss\n,\u0018\u000e\u001c3fe*!\u0011QQAD\u0003\u0011\u0019wN]3\u000b\t\u0005%\u00151R\u0001\u0007IJLg/\u001a:\u000b\u0007\u00055e%\u0001\u0005eCR\f7\u000f^1y\u0013\u0011\t\t*a \u0003\rM+G.Z2u\u0011\u001d\t)*!\u001eA\u0002a\u000b\u0001b[3zgB\f7-\u001a\u0005\b\u00033\u000b)\b1\u0001Y\u0003\u0015!\u0018M\u00197f\u0011!\ti*!\u001eA\u0002\u0005}\u0015\u0001C2sSR,'/[1\u0011\t\u0015l\u0017\u0011\u0015\t\u0005\u0003G\u000b9K\u0004\u0003\u0002R\u0005\u0015\u0016B\u00017\u0005\u0013\u0011\tI+a+\u0003\u0019\r{G.^7o'\u0016dWm\u0019;\u000b\u00051$aaBAX\u0003;\u0002\u0011\u0011\u0017\u0002\u001b\u0007\u0006\u001c8/\u00198ee\u0006\u0014Vm];miN$vNR3biV\u0014Xm]\n\u0005\u0003[\u000b\u0019\f\u0005\u0004\u00026\u0006m\u0016\u0011\u0019\b\u0005\u0003S\t9,C\u0002\u0002:Z\t\u0011\"U;fef\u0004F.\u00198\n\t\u0005u\u0016q\u0018\u0002\u0017\u0013:$W\r\u001f*fgVdGo\u001d+p\r\u0016\fG/\u001e:fg*\u0019\u0011\u0011\u0018\f\u0011\t\u0005\r\u0017QY\u0007\u0003\u0003\u0007KA!a2\u0002\u0004\n\u0019!k\\<\t\u0017\u0005-\u0017Q\u0016B\u0001B\u0003%\u0011QZ\u0001\u0007?&tG-\u001a=1\r\u0005=\u00171[Am!\u0019)R)!5\u0002XB\u0019\u0001*a5\u0005\u0017\u0005U\u0017\u0011ZA\u0001\u0002\u0003\u0015\ta\u0013\u0002\u0004?\u0012*\u0004c\u0001%\u0002Z\u0012Y\u00111\\Ae\u0003\u0003\u0005\tQ!\u0001L\u0005\ryFE\u000e\u0005\f\u0003?\fiK!A!\u0002\u0013\t\t/\u0001\u0003`g\u001a$\b\u0003BAr\u0003cl!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005-\u0018Q^\u0001\bM\u0016\fG/\u001e:f\u0015\r\tyOC\u0001\b_B,gnZ5t\u0013\u0011\t\u00190!:\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\rC\u0004.\u0003[#\t!a>\u0015\r\u0005e\u0018Q B\u0006!\u0011\tY0!,\u000e\u0005\u0005u\u0003\u0002CAf\u0003k\u0004\r!a@1\r\t\u0005!Q\u0001B\u0005!\u0019)RIa\u0001\u0003\bA\u0019\u0001J!\u0002\u0005\u0017\u0005U\u0017Q`A\u0001\u0002\u0003\u0015\ta\u0013\t\u0004\u0011\n%AaCAn\u0003{\f\t\u0011!A\u0003\u0002-C\u0001\"a8\u0002v\u0002\u0007\u0011\u0011\u001d\u0005\b[\u00055F\u0011\u0001B\b)\t\tI\u0010\u0003\u0007\u0003\u0014\u00055\u0006\u0019!a\u0001\n\u0013\u0011)\"\u0001\u0007jIN+'/[1mSj,'/\u0006\u0002\u0003\u0018AIqB!\u0007qo]\u0012i\u0002W\u0005\u0004\u00057\u0001\"!\u0003$v]\u000e$\u0018n\u001c85!\u0011\t\u0019Oa\b\n\t\t\u0005\u0012Q\u001d\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u0019\t\u0015\u0012Q\u0016a\u0001\u0002\u0004%IAa\n\u0002!%$7+\u001a:jC2L'0\u001a:`I\u0015\fHcA \u0003*!Q!1\u0006B\u0012\u0003\u0003\u0005\rAa\u0006\u0002\u0007a$\u0013\u0007C\u0005\u00030\u00055\u0006\u0015)\u0003\u0003\u0018\u0005i\u0011\u000eZ*fe&\fG.\u001b>fe\u0002B\u0001Ba\r\u0002.\u0012\u0005#QG\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005;\u00119\u0004\u0003\u0005\u0003:\tE\u0002\u0019AAa\u0003\u0019\u0011Xm];mi\"A!QHAW\t#\u0012y$\u0001\tde\u0016\fG/Z*fe&\fG.\u001b>feV\u0011!\u0011\t\t\u0005\u0005\u0007\u0012i%\u0004\u0002\u0003F)!!q\tB%\u0003\u0011Y'/_8\u000b\u0007\t-c!\u0001\u0005gK\u0006$XO]3t\u0013\u0011\u0011yE!\u0012\u0003+-\u0013\u0018p\u001c$fCR,(/Z*fe&\fG.\u001b>fe\u001a9!1KA/\u0001\tU#\u0001F\"bgN\fg\u000e\u001a:b\u0013:$W\r_,sSR,'oE\u0003\u0003R\t]\u0003\u0005\u0005\u0004\u0003Z\t}#Q\r\b\u0005\u0003S\u0011Y&C\u0002\u0003^Y\tA\"\u00138eKb\fE-\u00199uKJLAA!\u0019\u0003d\ty!)Y:f\u0013:$W\r_,sSR,'OC\u0002\u0003^Y\u00012!\u0006B4\u0013\r\u0011IG\u0006\u0002\u0010/JLG/\u00192mK\u001a+\u0017\r^;sK\"I1F!\u0015\u0003\u0002\u0003\u0006I\u0001\b\u0005\u000e\u0005_\u0012\tF!A!\u0002\u0013\u0011\tHa!\u0002\u000f%tG-[2fgB!Q-\u001cB:a\u0019\u0011)H!\u001f\u0003\u0000A1Q#\u0012B<\u0005{\u00022\u0001\u0013B=\t-\u0011YH!\u001c\u0002\u0002\u0003\u0005)\u0011A&\u0003\u0007}#s\u0007E\u0002I\u0005\u007f\"1B!!\u0003n\u0005\u0005\t\u0011!B\u0001\u0017\n\u0019q\f\n\u001d\n\t\t=$q\f\u0005\f\u0005\u000f\u0013\tF!A!\u0002\u0013\u0011I)A\u0004xe\u0006\u0004\b/\u001a:\u0011\r\t-%\u0011\u0013B3\u001d\u0011\tIC!$\n\u0007\t=e#A\bXe&$\u0018M\u00197f\r\u0016\fG/\u001e:f\u0013\u0011\u0011\u0019J!&\u0003\u001d\u0019+\u0017\r^;sK^\u0013\u0018\r\u001d9fe*\u0019!q\u0012\f\t\u0013Y\u0013\tF!A!\u0002\u00139\u0006bB\u0017\u0003R\u0011\u0005!1\u0014\u000b\u000b\u0005;\u0013yJ!)\u00032\nM\u0006\u0003BA~\u0005#Baa\u000bBM\u0001\u0004a\u0002\u0002\u0003B8\u00053\u0003\rAa)\u0011\t\u0015l'Q\u0015\u0019\u0007\u0005O\u0013YKa,\u0011\rU)%\u0011\u0016BW!\rA%1\u0016\u0003\f\u0005w\u0012\t+!A\u0001\u0002\u000b\u00051\nE\u0002I\u0005_#1B!!\u0003\"\u0006\u0005\t\u0011!B\u0001\u0017\"A!q\u0011BM\u0001\u0004\u0011I\t\u0003\u0004W\u00053\u0003\ra\u0016\u0005\u000b\u0005o\u0013\tF1A\u0005\n\te\u0016aB7baB,'o]\u000b\u0003\u0005w\u0003BaD9\u0003>BIqBa0\u0003D\n5'QZ\u0005\u0004\u0005\u0003\u0004\"A\u0002+va2,7\u0007\u0005\u0003\u0003F\n%WB\u0001Bd\u0015\tIB!\u0003\u0003\u0003L\n\u001d'!F\"bgN\fg\u000e\u001a:b\u0007>dW/\u001c8NCB\u0004XM\u001d\t\u0005\u0003\u0007\u0014y-\u0003\u0003\u0003R\u0006\r%!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\"I!Q\u001bB)A\u0003%!1X\u0001\t[\u0006\u0004\b/\u001a:tA!Q!\u0011\u001cB)\u0001\u0004%I!a\u001c\u0002\u0003%D!B!8\u0003R\u0001\u0007I\u0011\u0002Bp\u0003\u0015Iw\fJ3r)\ry$\u0011\u001d\u0005\n\u0005W\u0011Y.!AA\u0002]B\u0001B!:\u0003R\u0001\u0006KaN\u0001\u0003S\u0002B\u0001B!;\u0003R\u0011E#1^\u0001\u0006oJLG/\u001a\u000b\b\u007f\t5(q^B\u0002\u0011!\tYOa:A\u0002\t\u0015\u0004\u0002\u0003By\u0005O\u0004\rAa=\u0002\rY\fG.^3t!\u0011y\u0011O!>1\t\t](q \t\u0007\u0003O\u0011IP!@\n\t\tm\u00181\t\u0002\f%><8*Z=WC2,X\rE\u0002I\u0005\u007f$1b!\u0001\u0003p\u0006\u0005\t\u0011!B\u0001\u0017\n\u0019q\fJ\u001d\t\u0011\r\u0015!q\u001da\u0001\u0007\u000f\ta!\u001e9eCR,\u0007cA\b\u0004\n%\u001911\u0002\t\u0003\u000f\t{w\u000e\\3b]\"A1q\u0002B)\t#\u001a\t\"\u0001\u0004eK2,G/\u001a\u000b\u0006\u007f\rM1Q\u0003\u0005\t\u0003W\u001ci\u00011\u0001\u0003f!A!\u0011_B\u0007\u0001\u0004\u00199\u0002\u0005\u0003\u0010c\u000ee\u0001\u0007BB\u000e\u0007?\u0001b!a\n\u0003z\u000eu\u0001c\u0001%\u0004 \u0011Y1\u0011EB\u000b\u0003\u0003\u0005\tQ!\u0001L\u0005\u0011yF%\r\u0019\t\u0011\r\u0015\"\u0011\u000bC!\u0007O\tQA\u001a7vg\"$\u0012a\u0010\u0005\t\u0007W\u0011\t\u0006\"\u0011\u0004(\u0005)1\r\\8tK\"A1qFA/\t\u0013\u0019\t$A\u0003eK\n,x\rF\u0002Y\u0007gA\u0001b!\u000e\u0004.\u0001\u00071qG\u0001\tE&tG-\u001b8hgB\u0019Q-\u001c\b\t\u0011\rm\u0012Q\ta\u0001\u0003C\f1a\u001d4u\u0011!\u0011y'!\u0012A\u0002\r}\u0002\u0003B3n\u0007\u0003\u0002daa\u0011\u0004H\r5\u0003CB\u000bF\u0007\u000b\u001aY\u0005E\u0002I\u0007\u000f\"1b!\u0013\u0004>\u0005\u0005\t\u0011!B\u0001\u0017\n\u0019q\fJ\u001a\u0011\u0007!\u001bi\u0005B\u0006\u0004P\ru\u0012\u0011!A\u0001\u0006\u0003Y%aA0%i!Aa+!\u0012\u0011\u0002\u0003\u0007q\u000b")
public class CassandraIndexAdapter
implements IndexAdapter<CassandraDataStore>,
StrictLogging {
    public final CassandraDataStore org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds;
    private final Option<Object> tableNameLimit;
    private final Logger logger;
    private final ColumnGroups groups;

    public static Select statement(String string, String string2, Seq<package.ColumnSelect> seq) {
        return CassandraIndexAdapter$.MODULE$.statement(string, string2, seq);
    }

    public static int TableNameLimit() {
        return CassandraIndexAdapter$.MODULE$.TableNameLimit();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ColumnGroups groups() {
        return this.groups;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$groups_$eq(ColumnGroups x$1) {
        this.groups = x$1;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$tableNameLimit_$eq(Option x$1) {
    }

    public Option<String> createWriter$default$3() {
        return IndexAdapter.class.createWriter$default$3((IndexAdapter)this);
    }

    public Option<Object> tableNameLimit() {
        return this.tableNameLimit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTable(GeoMesaFeatureIndex<?, ?> index, Option<String> partition, Function0<Seq<byte[]>> splits) {
        BoxedUnit boxedUnit;
        Tuple2 tuple22;
        Cluster cluster = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().getCluster();
        String table = index.configureTableName(partition, this.tableNameLimit());
        if (cluster.getMetadata().getKeyspace(this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().getLoggedKeyspace()).getTable(table) != null) return;
        Seq<package.NamedColumn> columns = CassandraColumnMapper$.MODULE$.apply(index).columns();
        Tuple2 tuple2 = columns.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(package.NamedColumn x$1) {
                return x$1.partition();
            }
        });
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq partitions = (Seq)tuple2._1();
        Seq pks = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitions, (Object)pks);
        Seq partitions2 = (Seq)tuple23._1();
        Seq pks2 = (Seq)tuple23._2();
        String create = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, ((TraversableOnce)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(package.NamedColumn c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.name(), c.cType()}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)partitions2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(package.NamedColumn x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("(", ", ", ")")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pks2.nonEmpty() ? ((TraversableOnce)pks2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(package.NamedColumn x$4) {
                return x$4.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ", ", ", "") : ""}))).toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(create);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().execute(create);
            return;
        }
        catch (AlreadyExistsException alreadyExistsException) {}
    }

    public void renameTable(String from, String to) {
        throw new NotImplementedError("Cassandra does not support renaming tables");
    }

    public void deleteTables(Seq<String> tables) {
        tables.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraIndexAdapter $outer;

            public final ResultSet apply(String table) {
                BoxedUnit boxedUnit;
                String delete2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(delete2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().execute(delete2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void clearTables(Seq<String> tables, Option<byte[]> prefix) {
        if (prefix.isDefined()) {
            throw new IllegalArgumentException("Received a range in `clearTables` but table sharing should be disabled");
        }
        tables.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraIndexAdapter $outer;

            public final ResultSet apply(String table) {
                BoxedUnit boxedUnit;
                String truncate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(truncate);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().execute(truncate);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public CassandraQueryPlan createQueryPlan(package.QueryStrategy strategy) {
        package.QueryStrategy queryStrategy = strategy;
        if (queryStrategy != null) {
            CassandraQueryPlan cassandraQueryPlan;
            Tuple5 tuple5;
            package.FilterStrategy filter = queryStrategy.filter();
            Seq keyRanges = queryStrategy.keyRanges();
            Seq tieredKeyRanges = queryStrategy.tieredKeyRanges();
            Option ecql = queryStrategy.ecql();
            Hints hints = queryStrategy.hints();
            Tuple5 tuple52 = tuple5 = new Tuple5((Object)filter, (Object)keyRanges, (Object)tieredKeyRanges, (Object)ecql, (Object)hints);
            package.FilterStrategy filter2 = (package.FilterStrategy)tuple52._1();
            Seq keyRanges2 = (Seq)tuple52._2();
            Seq tieredKeyRanges2 = (Seq)tuple52._3();
            Option ecql2 = (Option)tuple52._4();
            Hints hints2 = (Hints)tuple52._5();
            Some hook = new Some((Object)new LocalQueryRunner.ArrowDictionaryHook(this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.stats(), filter2.filter()));
            Some reducer = new Some((Object)new LocalQueryRunner.LocalTransformReducer(strategy.index().sft(), ecql2, (Option)None$.MODULE$, QueryHints$.MODULE$.RichHints(hints2).getTransform(), hints2, (Option)hook));
            if (keyRanges2.isEmpty()) {
                cassandraQueryPlan = new EmptyPlan(filter2, (Option<QueryPlan.FeatureReducer>)reducer);
            } else {
                CassandraColumnMapper mapper = CassandraColumnMapper$.MODULE$.apply(strategy.index());
                Seq ranges = (Seq)keyRanges2.flatMap((Function1)new Serializable(this, tieredKeyRanges2, mapper){
                    public static final long serialVersionUID = 0L;
                    private final Seq tieredKeyRanges$1;
                    private final CassandraColumnMapper mapper$1;

                    public final Seq<package.RowSelect> apply(package.ScanRange<?> x$6) {
                        return this.mapper$1.select(x$6, (Seq<package.ByteRange>)this.tieredKeyRanges$1);
                    }
                    {
                        this.tieredKeyRanges$1 = tieredKeyRanges$1;
                        this.mapper$1 = mapper$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq tables = strategy.index().getTablesForQuery(filter2.filter());
                String ks = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().getLoggedKeyspace();
                Seq statements = (Seq)tables.flatMap((Function1)new Serializable(this, ranges, ks){
                    public static final long serialVersionUID = 0L;
                    private final Seq ranges$1;
                    public final String ks$1;

                    public final Seq<Select> apply(String table) {
                        return (Seq)this.ranges$1.map((Function1)new Serializable(this, table){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6 $outer;
                            private final String table$1;

                            public final Select apply(package.RowSelect r) {
                                return CassandraIndexAdapter$.MODULE$.statement(this.$outer.ks$1, this.table$1, r.clauses());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.table$1 = table$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    {
                        this.ranges$1 = ranges$1;
                        this.ks$1 = ks$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                CassandraResultsToFeatures rowsToFeatures = new CassandraResultsToFeatures(strategy.index(), strategy.index().sft());
                int threads = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.config().queryThreads();
                Option sort = QueryHints$.MODULE$.RichHints(hints2).getSortFields();
                Option max = QueryHints$.MODULE$.RichHints(hints2).getMaxFeatures();
                Option project = QueryHints$.MODULE$.RichHints(hints2).getProjection();
                cassandraQueryPlan = new StatementPlan(filter2, (Seq<String>)tables, (Seq<Statement>)statements, threads, (Option<Filter>)ecql2, (QueryPlan.ResultsToFeatures<Row>)rowsToFeatures, (Option<QueryPlan.FeatureReducer>)reducer, (Option<Seq<Tuple2<String, Object>>>)sort, (Option<Object>)max, (Option<Reprojection.QueryReferenceSystems>)project);
            }
            return cassandraQueryPlan;
        }
        throw new MatchError((Object)queryStrategy);
    }

    public CassandraIndexWriter createWriter(SimpleFeatureType sft, Seq<GeoMesaFeatureIndex<?, ?>> indices, Option<String> partition) {
        return new CassandraIndexWriter(this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds, indices, (WritableFeature.FeatureWrapper<WritableFeature>)WritableFeature$.MODULE$.wrapper(sft, this.groups()), partition);
    }

    public CassandraIndexAdapter(CassandraDataStore ds) {
        this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds = ds;
        IndexAdapter.class.$init$((IndexAdapter)this);
        StrictLogging.class.$init$((StrictLogging)this);
        this.tableNameLimit = new Some((Object)BoxesRunTime.boxToInteger((int)CassandraIndexAdapter$.MODULE$.TableNameLimit()));
    }

    public static class CassandraIndexWriter
    extends IndexAdapter.BaseIndexWriter<WritableFeature>
    implements StrictLogging {
        public final CassandraDataStore org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds;
        public final Option<String> org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$partition;
        private final Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement>[] mappers;
        private int i;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        private Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement>[] mappers() {
            return this.mappers;
        }

        private int i() {
            return this.i;
        }

        private void i_$eq(int x$1) {
            this.i = x$1;
        }

        public void write(WritableFeature feature, package.RowKeyValue<?>[] values, boolean update) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement> tuple3;
                block6: {
                    package.RowKeyValue<?> rowKeyValue;
                    block9: {
                        block8: {
                            BoxedUnit boxedUnit;
                            PreparedStatement statement2;
                            CassandraColumnMapper mapper;
                            block7: {
                                BoxedUnit boxedUnit2;
                                Tuple2 tuple2;
                                tuple3 = this.mappers()[this.i()];
                                if (tuple3 == null) break block6;
                                CassandraColumnMapper mapper2 = (CassandraColumnMapper)tuple3._1();
                                PreparedStatement statement3 = (PreparedStatement)tuple3._2();
                                Tuple2 tuple22 = tuple2 = new Tuple2((Object)mapper2, (Object)statement3);
                                mapper = (CassandraColumnMapper)tuple22._1();
                                statement2 = (PreparedStatement)tuple22._2();
                                rowKeyValue = values[this.i()];
                                if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block7;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Seq<Object> bindings = mapper.bind(singleRowKeyValue);
                                if (this.logger().underlying().isTraceEnabled()) {
                                    this.logger().underlying().trace("{} : {}", (Object[])new String[]{statement2.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                boxedUnit = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)statement2.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                break block8;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block9;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, mapper, statement2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ CassandraIndexWriter $outer;
                                private final CassandraColumnMapper mapper$2;
                                private final PreparedStatement statement$1;

                                public final ResultSet apply(package.SingleRowKeyValue<Object> kv) {
                                    BoxedUnit boxedUnit;
                                    Seq<Object> bindings = this.mapper$2.bind(kv);
                                    if (this.$outer.logger().underlying().isTraceEnabled()) {
                                        this.$outer.logger().underlying().trace("{} : {}", (Object[])new String[]{this.statement$1.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)this.statement$1.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mapper$2 = mapper$2;
                                    this.statement$1 = statement$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple3);
            }
        }

        public void delete(WritableFeature feature, package.RowKeyValue<?>[] values) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement> tuple3;
                block6: {
                    package.RowKeyValue<?> rowKeyValue;
                    block9: {
                        block8: {
                            BoxedUnit boxedUnit;
                            PreparedStatement statement2;
                            CassandraColumnMapper mapper;
                            block7: {
                                BoxedUnit boxedUnit2;
                                Tuple2 tuple2;
                                tuple3 = this.mappers()[this.i()];
                                if (tuple3 == null) break block6;
                                CassandraColumnMapper mapper2 = (CassandraColumnMapper)tuple3._1();
                                PreparedStatement statement3 = (PreparedStatement)tuple3._3();
                                Tuple2 tuple22 = tuple2 = new Tuple2((Object)mapper2, (Object)statement3);
                                mapper = (CassandraColumnMapper)tuple22._1();
                                statement2 = (PreparedStatement)tuple22._2();
                                rowKeyValue = values[this.i()];
                                if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block7;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Seq<Object> bindings = mapper.bindDelete(singleRowKeyValue);
                                if (this.logger().underlying().isTraceEnabled()) {
                                    this.logger().underlying().trace("{} : {}", (Object[])new String[]{statement2.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                boxedUnit = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)statement2.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                break block8;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block9;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, mapper, statement2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ CassandraIndexWriter $outer;
                                private final CassandraColumnMapper mapper$3;
                                private final PreparedStatement statement$2;

                                public final ResultSet apply(package.SingleRowKeyValue<Object> kv) {
                                    BoxedUnit boxedUnit;
                                    Seq<Object> bindings = this.mapper$3.bindDelete(kv);
                                    if (this.$outer.logger().underlying().isTraceEnabled()) {
                                        this.$outer.logger().underlying().trace("{} : {}", (Object[])new String[]{this.statement$2.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)this.statement$2.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mapper$3 = mapper$3;
                                    this.statement$2 = statement$2;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple3);
            }
        }

        public void flush() {
        }

        public void close() {
        }

        public CassandraIndexWriter(CassandraDataStore ds, Seq<GeoMesaFeatureIndex<?, ?>> indices, WritableFeature.FeatureWrapper<WritableFeature> wrapper, Option<String> partition) {
            this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds = ds;
            this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$partition = partition;
            super(indices, wrapper);
            StrictLogging.class.$init$((StrictLogging)this);
            this.mappers = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])super.indices().toArray(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraIndexWriter $outer;

                public final Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement> apply(GeoMesaFeatureIndex<?, ?> index) {
                    CassandraColumnMapper mapper = CassandraColumnMapper$.MODULE$.apply(index);
                    Seq seq = index.getTableNames(this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$partition);
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                        String t;
                        String string;
                        String table = string = (t = (String)((SeqLike)some.get()).apply(0));
                        PreparedStatement insert = mapper.insert(this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session(), table);
                        PreparedStatement delete2 = mapper.delete(this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session(), table);
                        return new Tuple3((Object)mapper, (Object)insert, (Object)delete2);
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single table but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq.mkString(", ")})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            this.i = 0;
        }
    }

    public static class CassandraResultsToFeatures
    extends QueryPlan.IndexResultsToFeatures<Row> {
        private Function4<byte[], Object, Object, SimpleFeature, String> idSerializer;

        private Function4<byte[], Object, Object, SimpleFeature, String> idSerializer() {
            return this.idSerializer;
        }

        private void idSerializer_$eq(Function4<byte[], Object, Object, SimpleFeature, String> x$1) {
            this.idSerializer = x$1;
        }

        public SimpleFeature apply(Row result) {
            byte[] bytes = ((String)result.get(CassandraColumnMapper$.MODULE$.FeatureIdColumnName(), String.class)).getBytes(StandardCharsets.UTF_8);
            String fid = (String)this.idSerializer().apply((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)bytes.length), null);
            ByteBuffer sf = result.getBytes(CassandraColumnMapper$.MODULE$.SimpleFeatureColumnName());
            byte[] bytes2 = (byte[])Array$.MODULE$.ofDim(sf.limit(), ClassTag$.MODULE$.Byte());
            sf.get(bytes2);
            return this.serializer().deserialize(fid, bytes2);
        }

        public KryoFeatureSerializer createSerializer() {
            this.idSerializer_$eq((Function4<byte[], Object, Object, SimpleFeature, String>)GeoMesaFeatureIndex$.MODULE$.idFromBytes(this.index().sft()));
            return KryoFeatureSerializer$.MODULE$.apply(this.index().sft(), SerializationOption.SerializationOptions$.MODULE$.builder().lazy().withoutId().build());
        }

        public CassandraResultsToFeatures(GeoMesaFeatureIndex<?, ?> _index, SimpleFeatureType _sft) {
            super(_index, _sft);
        }

        public CassandraResultsToFeatures() {
            this(null, null);
        }
    }
}

