/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.apache.avro.Schema;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils$;
import org.locationtech.geomesa.tools.Command;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam$class;
import org.locationtech.geomesa.tools.RequiredFeatureSpecParam;
import org.locationtech.geomesa.tools.RequiredFeatureSpecParam$class;
import org.locationtech.geomesa.tools.utils.CLArgResolver$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u001b\tIr)\u001a8fe\u0006$X-\u0011<s_N\u001b\u0007.Z7b\u0007>lW.\u00198e\u0015\t\u0019A!\u0001\u0004fqB|'\u000f\u001e\u0006\u0003\u000b\u0019\tQ\u0001^8pYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BAA\u0004D_6l\u0017M\u001c3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\teH\u0001\u0005]\u0006lW-F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\u0001A\u0003%\u0001%A\u0003oC6,\u0007\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\u0002\rA\f'/Y7t+\u0005i\u0003C\u0001\u0018D\u001d\tyCH\u0004\u00021w9\u0011\u0011G\u000f\b\u0003eer!a\r\u001d\u000f\u0005Q:T\"A\u001b\u000b\u0005Yb\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119Q!\u0010\u0002\t\u0002y\n\u0011dR3oKJ\fG/Z!we>\u001c6\r[3nC\u000e{W.\\1oIB\u0011Ad\u0010\u0004\u0006\u0003\tA\t\u0001Q\n\u0003\u007f9AQ!G \u0005\u0002\t#\u0012A\u0010\u0004\u0005\t~\u0002QI\u0001\rHK:,'/\u0019;f\u0003Z\u0014xnU2iK6\f\u0007+\u0019:b[N\u001cBa\u0011\bG\u0013B\u0011QcR\u0005\u0003\u0011\u0012\u0011\u0001DU3rk&\u0014X\r\u001a$fCR,(/Z*qK\u000e\u0004\u0016M]1n!\t)\"*\u0003\u0002L\t\t)r\n\u001d;j_:\fG\u000eV=qK:\u000bW.\u001a)be\u0006l\u0007\"B\rD\t\u0003iE#\u0001(\u0011\u0005=\u001bU\"A )\t\r\u000b6\f\u0018\t\u0003%fk\u0011a\u0015\u0006\u0003)V\u000b!B[2p[6\fg\u000eZ3s\u0015\t1v+A\u0003cKV\u001cHOC\u0001Y\u0003\r\u0019w.\\\u0005\u00035N\u0013!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0003u\u000b\u0001gR3oKJ\fG/\u001a\u0011b]\u0002\neO]8!g\u000eDW-\\1!MJ|W\u000eI1!'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007BB0\u0001A\u0003%Q&A\u0004qCJ\fWn\u001d\u0011\t\u000b\u0005\u0004A\u0011\t2\u0002\u000f\u0015DXmY;uKR\t1\r\u0005\u0002\u0010I&\u0011Q\r\u0005\u0002\u0005+:LG\u000f")
public class GenerateAvroSchemaCommand
implements Command {
    private final String name;
    private final GenerateAvroSchemaParams params = new GenerateAvroSchemaParams();

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public GenerateAvroSchemaParams params() {
        return this.params;
    }

    @Override
    public void execute() {
        SimpleFeatureType sft = CLArgResolver$.MODULE$.getSft(this.params().spec(), this.params().featureName());
        Schema schema = AvroSimpleFeatureUtils$.MODULE$.generateSchema(sft, true, true, AvroSimpleFeatureUtils$.MODULE$.generateSchema$default$4());
        Command$.MODULE$.output().info(schema.toString(true));
    }

    public GenerateAvroSchemaCommand() {
        this.name = "gen-avro-schema";
    }

    @Parameters(commandDescription="Generate an Avro schema from a SimpleFeatureType")
    public static class GenerateAvroSchemaParams
    implements RequiredFeatureSpecParam,
    OptionalTypeNameParam {
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either", required=true)
        private String spec;

        @Override
        public String featureName() {
            return this.featureName;
        }

        @Override
        @TraitSetter
        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String spec() {
            return this.spec;
        }

        @Override
        @TraitSetter
        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public GenerateAvroSchemaParams() {
            RequiredFeatureSpecParam$class.$init$(this);
            OptionalTypeNameParam$class.$init$(this);
        }
    }
}

