/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.clearspring.CountMinSketch;
import org.locationtech.geomesa.utils.clearspring.CountMinSketch$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.stats.Frequency$;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$class;
import org.locationtech.geomesa.utils.stats.Z3Frequency$;
import org.locationtech.geomesa.utils.stats.Z3Frequency$$anonfun$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.ListMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tEe\u0001B\u0001\u0003\u00015\u00111BW\u001aGe\u0016\fX/\u001a8ds*\u00111\u0001B\u0001\u0006gR\fGo\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0005'R\fG\u000f\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u0005a1oY1mC2|wmZ5oO*\u0011QDH\u0001\tif\u0004Xm]1gK*\tq$A\u0002d_6L!!\t\u000e\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005\u00191O\u001a;\u0016\u0003\u0015\u0002\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\rMLW\u000e\u001d7f\u0015\tQ3&A\u0004gK\u0006$XO]3\u000b\u00051R\u0011aB8qK:<\u0017n]\u0005\u0003]\u001d\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011!\u0001\u0004A!A!\u0002\u0013)\u0013\u0001B:gi\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\u0005O\u0016|W.F\u00015!\t)\u0004H\u0004\u0002\u0010m%\u0011q\u0007E\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028!!AA\b\u0001B\u0001B\u0003%A'A\u0003hK>l\u0007\u0005\u0003\u0005?\u0001\t\u0015\r\u0011\"\u00014\u0003\r!Go\u001a\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005i\u0005!A\r^4!\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0015A\u00029fe&|G-F\u0001E!\t)UK\u0004\u0002G%:\u0011q\t\u0015\b\u0003\u0011>s!!\u0013(\u000f\u0005)kU\"A&\u000b\u00051c\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011\u0011KB\u0001\u0006GV\u0014h/Z\u0005\u0003'R\u000b!\u0002V5nKB+'/[8e\u0015\t\tf!\u0003\u0002W/\nQA+[7f!\u0016\u0014\u0018n\u001c3\u000b\u0005M#\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\u000fA,'/[8eA!A1\f\u0001BC\u0002\u0013\u0005A,A\u0005qe\u0016\u001c\u0017n]5p]V\tQ\f\u0005\u0002\u0010=&\u0011q\f\u0005\u0002\u0004\u0013:$\b\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B/\u0002\u0015A\u0014XmY5tS>t\u0007\u0005\u0003\u0005d\u0001\t\u0015\r\u0011\"\u0001e\u0003\r)\u0007o]\u000b\u0002KB\u0011qBZ\u0005\u0003OB\u0011a\u0001R8vE2,\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011B3\u0002\t\u0015\u00048\u000f\t\u0005\tW\u0002\u0011)\u0019!C\u0001I\u0006Q1m\u001c8gS\u0012,gnY3\t\u00115\u0004!\u0011!Q\u0001\n\u0015\f1bY8oM&$WM\\2fA!)q\u000e\u0001C\u0001a\u00061A(\u001b8jiz\"\u0002\"\u001d:tiV4x\u000f\u001f\t\u0003+\u0001AQa\t8A\u0002\u0015BQA\r8A\u0002QBQA\u00108A\u0002QBQA\u00118A\u0002\u0011CQa\u00178A\u0002uCqa\u00198\u0011\u0002\u0003\u0007Q\rC\u0004l]B\u0005\t\u0019A3\u0006\ti\u0004\u0001%\u001d\u0002\u0002'\"AA\u0010\u0001EC\u0002\u0013\u0005A,A\u0005hK>l\u0017J\u001c3fq\"21P`A\u0002\u0003\u000b\u0001\"aD@\n\u0007\u0005\u0005\u0001C\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0013AM\u0019\tGQ\n9!a\u0004\u0002\n%!\u0011\u0011BA\u0006\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e)\u0019\u0011Q\u0002\t\u0002\u0015\u0011,\u0007O]3dCR,G-M\u0005$\u0003#\t\u0019\"!\u0006\u0002\u000e9\u0019q\"a\u0005\n\u0007\u00055\u0001#M\u0003#\u001fA\t9BA\u0003tG\u0006d\u0017\rC\u0005\u0002\u001c\u0001A\t\u0011)Q\u0005;\u0006Qq-Z8n\u0013:$W\r\u001f\u0011\t\u0013\u0005}\u0001\u0001#b\u0001\n\u0003a\u0016\u0001\u00033uO&sG-\u001a=)\u000f\u0005ua0a\t\u0002&\u0005\na(\r\u0005$i\u0005\u001d\u0011qEA\u0005c%\u0019\u0013\u0011CA\n\u0003S\ti!M\u0003#\u001fA\t9\u0002C\u0005\u0002.\u0001A\t\u0011)Q\u0005;\u0006IA\r^4J]\u0012,\u0007\u0010\t\u0005\t\u0003c\u0001!\u0019!C\u00059\u0006\tq\rC\u0004\u00026\u0001\u0001\u000b\u0011B/\u0002\u0005\u001d\u0004\u0003\u0002CA\u001d\u0001\t\u0007I\u0011\u0002/\u0002\u0003\u0011Dq!!\u0010\u0001A\u0003%Q,\u0001\u0002eA!I\u0011\u0011\t\u0001C\u0002\u0013%\u00111I\u0001\u0005[\u0006\u001c8.\u0006\u0002\u0002FA\u0019q\"a\u0012\n\u0007\u0005%\u0003C\u0001\u0003M_:<\u0007\u0002CA'\u0001\u0001\u0006I!!\u0012\u0002\u000b5\f7o\u001b\u0011\t\u0013\u0005E\u0003A1A\u0005\n\u0005M\u0013aA:gGV\u0011\u0011Q\u000b\t\u0005\u0003/\nI&D\u0001U\u0013\r\tY\u0006\u0016\u0002\u00065N\u001afi\u0011\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002V\u0005!1OZ2!\u0011%\t\u0019\u0007\u0001b\u0001\n\u0013\t)'A\u0005uS6,Gk\u001c\"j]V\u0011\u0011q\r\t\u0005\u0003S\nyG\u0004\u0003\u0002X\u0005-\u0014bAA7)\u0006Q!)\u001b8oK\u0012$\u0016.\\3\n\t\u0005E\u00141\u000f\u0002\u0011)&lW\rV8CS:tW\r\u001a+j[\u0016T1!!\u001cU\u0011!\t9\b\u0001Q\u0001\n\u0005\u001d\u0014A\u0003;j[\u0016$vNQ5oA!Q\u00111\u0010\u0001C\u0002\u0013\u0005!!! \u0002\u0011M\\W\r^2iKN,\"!a \u0011\u0011\u0005\u0005\u00151RAH\u0003+k!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\b[V$\u0018M\u00197f\u0015\r\tI\tE\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAG\u0003\u0007\u00131!T1q!\ry\u0011\u0011S\u0005\u0004\u0003'\u0003\"!B*i_J$\b\u0003BAL\u0003;k!!!'\u000b\u0007\u0005mE!A\u0006dY\u0016\f'o\u001d9sS:<\u0017\u0002BAP\u00033\u0013abQ8v]Rl\u0015N\\*lKR\u001c\u0007\u000e\u0003\u0005\u0002$\u0002\u0001\u000b\u0011BA@\u0003%\u00198.\u001a;dQ\u0016\u001c\b\u0005\u0003\u0005\u0002(\u0002!\tAAAU\u0003%qWm^*lKR\u001c\u0007.\u0006\u0002\u0002\u0016\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0016!\u0002;p\u0017\u0016LHCBAY\u0003o\u000b9\rE\u0004\u0010\u0003g\u000by)!\u0012\n\u0007\u0005U\u0006C\u0001\u0004UkBdWM\r\u0005\be\u0005-\u0006\u0019AA]!\u0011\tY,a1\u000e\u0005\u0005u&b\u0001\u001a\u0002@*\u0019\u0011\u0011\u0019\u0005\u0002\u0007)$8/\u0003\u0003\u0002F\u0006u&\u0001C$f_6,GO]=\t\u000fy\nY\u000b1\u0001\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017\u0001B;uS2T!!a5\u0002\t)\fg/Y\u0005\u0005\u0003/\fiM\u0001\u0003ECR,\u0007bBAn\u0001\u0011\u0005\u0011Q\\\u0001\u0006G>,h\u000e\u001e\u000b\u0007\u0003\u000b\ny.!9\t\u000fI\nI\u000e1\u0001\u0002:\"9a(!7A\u0002\u0005%\u0007bBAs\u0001\u0011\u0005\u0011q]\u0001\fG>,h\u000e\u001e#je\u0016\u001cG\u000f\u0006\u0004\u0002F\u0005%\u0018Q\u001e\u0005\t\u0003W\f\u0019\u000f1\u0001\u0002\u0010\u0006\u0019!-\u001b8\t\u0011\u0005=\u00181\u001da\u0001\u0003\u000b\n!A_\u001a\t\u000f\u0005M\b\u0001\"\u0001\u0002D\u0005!1/\u001b>f\u0011\u001d\t9\u0010\u0001C\u0001\u0003s\f1b\u001d9mSR\u0014\u0015\u0010V5nKV\u0011\u00111 \t\u0007\u0003{\u00149A!\u0004\u000f\t\u0005}(1\u0001\b\u0004\u0015\n\u0005\u0011\"A\t\n\u0007\t\u0015\u0001#A\u0004qC\u000e\\\u0017mZ3\n\t\t%!1\u0002\u0002\u0004'\u0016\f(b\u0001B\u0003!A1q\"a-\u0002\u0010FDqA!\u0005\u0001\t\u0003\u0012\u0019\"A\u0004pEN,'O^3\u0015\t\tU!1\u0004\t\u0004\u001f\t]\u0011b\u0001B\r!\t!QK\\5u\u0011!\u0011iBa\u0004A\u0002\t}\u0011AA:g!\r1#\u0011E\u0005\u0004\u0005G9#!D*j[BdWMR3biV\u0014X\rC\u0004\u0003(\u0001!\tE!\u000b\u0002\u0013UtwNY:feZ,G\u0003\u0002B\u000b\u0005WA\u0001B!\b\u0003&\u0001\u0007!q\u0004\u0005\b\u0005_\u0001A\u0011\tB\u0019\u0003\u0015!\u0003\u000f\\;t)\r\t(1\u0007\u0005\b\u0005k\u0011i\u00031\u0001r\u0003\u0015yG\u000f[3s\u0011\u001d\u0011I\u0004\u0001C!\u0005w\t\u0001\u0002\n9mkN$S-\u001d\u000b\u0005\u0005+\u0011i\u0004C\u0004\u00036\t]\u0002\u0019A9\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D\u0005)1\r\\3beR\u0011!Q\u0003\u0005\b\u0005\u000f\u0002A\u0011\tB%\u0003\u001dI7/R7qif,\"Aa\u0013\u0011\u0007=\u0011i%C\u0002\u0003PA\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0003T\u0001!\tE!\u0016\u0002\u0019Q|'j]8o\u001f\nTWm\u0019;\u0016\u0005\t]\u0003cA\b\u0003Z%\u0019!1\f\t\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003`\u0001!\tE!\u0019\u0002\u0019%\u001cX)];jm\u0006dWM\u001c;\u0015\t\t-#1\r\u0005\b\u0005k\u0011i\u00061\u0001\u0015\u000f%\u00119GAA\u0001\u0012\u0003\u0011I'A\u0006[g\u0019\u0013X-];f]\u000eL\bcA\u000b\u0003l\u0019A\u0011AAA\u0001\u0012\u0003\u0011igE\u0002\u0003l9Aqa\u001cB6\t\u0003\u0011\t\b\u0006\u0002\u0003j!Q!Q\u000fB6#\u0003%\tAa\u001e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011IHK\u0002f\u0005wZ#A! \u0011\t\t}$\u0011R\u0007\u0003\u0005\u0003SAAa!\u0003\u0006\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000f\u0003\u0012AC1o]>$\u0018\r^5p]&!!1\u0012BA\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u001f\u0013Y'%A\u0005\u0002\t]\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s\u0007")
public class Z3Frequency
implements Stat,
LazyLogging {
    private final SimpleFeatureType sft;
    private final String geom;
    private final String dtg;
    private final Enumeration.Value period;
    private final int precision;
    private final double eps;
    private final double confidence;
    private int geomIndex;
    private int dtgIndex;
    private final int g;
    private final int d;
    private final long mask;
    private final Z3SFC sfc;
    private final Function1<Object, BinnedTime> timeToBin;
    private final Map<Object, CountMinSketch> sketches;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static double $lessinit$greater$default$7() {
        return Z3Frequency$.MODULE$.$lessinit$greater$default$7();
    }

    public static double $lessinit$greater$default$6() {
        return Z3Frequency$.MODULE$.$lessinit$greater$default$6();
    }

    private int geomIndex$lzycompute() {
        Z3Frequency z3Frequency2 = this;
        synchronized (z3Frequency2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.geomIndex = this.g();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.geomIndex;
        }
    }

    private int dtgIndex$lzycompute() {
        Z3Frequency z3Frequency2 = this;
        synchronized (z3Frequency2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dtgIndex = this.d();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.dtgIndex;
        }
    }

    private Logger logger$lzycompute() {
        Z3Frequency z3Frequency2 = this;
        synchronized (z3Frequency2) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat$class.$plus$eq(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat$class.$plus(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat$class.toJson(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String geom() {
        return this.geom;
    }

    public String dtg() {
        return this.dtg;
    }

    public Enumeration.Value period() {
        return this.period;
    }

    public int precision() {
        return this.precision;
    }

    public double eps() {
        return this.eps;
    }

    public double confidence() {
        return this.confidence;
    }

    public int geomIndex() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.geomIndex$lzycompute() : this.geomIndex;
    }

    public int dtgIndex() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dtgIndex$lzycompute() : this.dtgIndex;
    }

    private int g() {
        return this.g;
    }

    private int d() {
        return this.d;
    }

    private long mask() {
        return this.mask;
    }

    private Z3SFC sfc() {
        return this.sfc;
    }

    private Function1<Object, BinnedTime> timeToBin() {
        return this.timeToBin;
    }

    public Map<Object, CountMinSketch> sketches() {
        return this.sketches;
    }

    public CountMinSketch newSketch() {
        return CountMinSketch$.MODULE$.apply(this.eps(), this.confidence(), Frequency$.MODULE$.Seed());
    }

    private Tuple2<Object, Object> toKey(Geometry geom, Date dtg) {
        BinnedTime binnedTime = (BinnedTime)this.timeToBin().apply((Object)BoxesRunTime.boxToLong((long)dtg.getTime()));
        if (binnedTime != null) {
            Tuple2 tuple2;
            short b = binnedTime.bin();
            long o = binnedTime.offset();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)o));
            short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
            long o2 = tuple22._2$mcJ$sp();
            Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
            long z = this.sfc().index(centroid.getX(), centroid.getY(), o2, this.sfc().index$default$4()) & this.mask();
            return new Tuple2((Object)BoxesRunTime.boxToShort((short)b2), (Object)BoxesRunTime.boxToLong((long)z));
        }
        throw new MatchError((Object)binnedTime);
    }

    public long count(Geometry geom, Date dtg) {
        Tuple2<Object, Object> tuple2 = this.toKey(geom, dtg);
        if (tuple2 != null) {
            Tuple2 tuple22;
            short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
            long z3 = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)z3));
            short bin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long z32 = tuple23._2$mcJ$sp();
            return this.countDirect(bin2, z32);
        }
        throw new MatchError(tuple2);
    }

    public long countDirect(short bin, long z3) {
        return BoxesRunTime.unboxToLong((Object)this.sketches().get((Object)BoxesRunTime.boxToShort((short)bin)).map((Function1)new Serializable(this, z3){
            public static final long serialVersionUID = 0L;
            private final long z3$1;

            public final long apply(CountMinSketch x$3) {
                return x$3.estimateCount(this.z3$1);
            }
            {
                this.z3$1 = z3$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.sketches().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(CountMinSketch x$4) {
                return x$4.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public Seq<Tuple2<Object, Z3Frequency>> splitByTime() {
        return (Seq)this.sketches().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Frequency $outer;

            public final Tuple2<Object, Z3Frequency> apply(Tuple2<Object, CountMinSketch> x0$1) {
                Tuple2<Object, CountMinSketch> tuple2 = x0$1;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    CountMinSketch sketch = (CountMinSketch)tuple2._2();
                    Z3Frequency freq = new Z3Frequency(this.$outer.sft(), this.$outer.geom(), this.$outer.dtg(), this.$outer.period(), this.$outer.precision(), this.$outer.eps(), this.$outer.confidence());
                    freq.sketches().put((Object)BoxesRunTime.boxToShort((short)w), (Object)sketch);
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)w), (Object)freq);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.g());
        Date dtg = (Date)sf.getAttribute(this.d());
        if (geom != null && dtg != null) {
            try {
                Tuple2 tuple2;
                Tuple2<Object, Object> tuple22 = this.toKey(geom, dtg);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                short bin = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z3 = tuple22._2$mcJ$sp();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)z3));
                short bin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                ((CountMinSketch)this.sketches().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)bin2), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Z3Frequency $outer;

                    public final CountMinSketch apply() {
                        return this.$outer.newSketch();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).add(z32, 1L);
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, exception.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
    }

    /*
     * WARNING - void declaration
     */
    public Z3Frequency $plus(Z3Frequency other) {
        void var2_2;
        Z3Frequency plus2 = new Z3Frequency(this.sft(), this.geom(), this.dtg(), this.period(), this.precision(), this.eps(), this.confidence());
        plus2.$plus$eq(this);
        plus2.$plus$eq(other);
        return var2_2;
    }

    public void $plus$eq(Z3Frequency other) {
        ((IterableLike)other.sketches().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$6) {
                return ((CountMinSketch)x$6._2()).size() > 0L;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Frequency $outer;

            public final void apply(Tuple2<Object, CountMinSketch> x0$2) {
                Tuple2<Object, CountMinSketch> tuple2 = x0$2;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    CountMinSketch sketch = (CountMinSketch)tuple2._2();
                    ((CountMinSketch)this.$outer.sketches().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)w), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$$plus$eq$2 $outer;

                        public final CountMinSketch apply() {
                            return this.$outer.org$locationtech$geomesa$utils$stats$Z3Frequency$$anonfun$$$outer().newSketch();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })).$plus$eq(sketch);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ Z3Frequency org$locationtech$geomesa$utils$stats$Z3Frequency$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void clear() {
        this.sketches().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CountMinSketch x$7) {
                x$7.clear();
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.sketches().values().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CountMinSketch x$8) {
                return x$8.size() == 0L;
            }
        });
    }

    @Override
    public Object toJsonObject() {
        Tuple2 tuple2 = (Tuple2)this.sketches().values().headOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(CountMinSketch s) {
                return new Tuple2.mcDD.sp(s.eps(), s.confidence());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply() {
                return new Tuple2.mcDD.sp(0.0, 0.0);
            }
        });
        if (tuple2 != null) {
            Tuple2.mcDD.sp sp2;
            double e = tuple2._1$mcD$sp();
            double c = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(e, c);
            double e2 = sp3._1$mcD$sp();
            double c2 = sp3._2$mcD$sp();
            return ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eps"), (Object)BoxesRunTime.boxToDouble((double)e2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confidence"), (Object)BoxesRunTime.boxToDouble((double)c2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToLong((long)this.size()))}));
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat2 = other;
        if (!(stat2 instanceof Z3Frequency)) return false;
        Z3Frequency z3Frequency2 = (Z3Frequency)stat2;
        String string2 = this.geom();
        String string3 = z3Frequency2.geom();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        String string4 = this.dtg();
        String string5 = z3Frequency2.dtg();
        if (string4 == null) {
            if (string5 != null) {
                return false;
            }
        } else if (!string4.equals(string5)) return false;
        Enumeration.Value value2 = this.period();
        Enumeration.Value value3 = z3Frequency2.period();
        if (value2 == null) {
            if (value3 != null) {
                return false;
            }
        } else if (!value2.equals(value3)) return false;
        if (this.precision() != z3Frequency2.precision()) return false;
        Map nonEmpty = (Map)this.sketches().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$10) {
                return ((CountMinSketch)x$10._2()).size() > 0L;
            }
        });
        Map sNonEmpty = (Map)z3Frequency2.sketches().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$11) {
                return ((CountMinSketch)x$11._2()).size() > 0L;
            }
        });
        Iterable iterable = nonEmpty.keys();
        Iterable iterable2 = sNonEmpty.keys();
        if (iterable == null) {
            if (iterable2 != null) {
                return false;
            }
        } else if (!iterable.equals(iterable2)) return false;
        if (!nonEmpty.keys().forall((Function1)new Serializable(this, z3Frequency2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Frequency $outer;
            private final Z3Frequency x2$1;

            public final boolean apply(short k) {
                return ((CountMinSketch)this.$outer.sketches().apply((Object)BoxesRunTime.boxToShort((short)k))).isEquivalent((CountMinSketch)this.x2$1.sketches().apply((Object)BoxesRunTime.boxToShort((short)k)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.x2$1 = x2$1;
            }
        })) return false;
        return true;
    }

    public Z3Frequency(SimpleFeatureType sft, String geom, String dtg, Enumeration.Value period, int precision, double eps, double confidence) {
        this.sft = sft;
        this.geom = geom;
        this.dtg = dtg;
        this.period = period;
        this.precision = precision;
        this.eps = eps;
        this.confidence = confidence;
        Stat$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.g = sft.indexOf(geom);
        this.d = sft.indexOf(dtg);
        this.mask = Frequency$.MODULE$.getMask(precision);
        this.sfc = Z3SFC$.MODULE$.apply(period);
        this.timeToBin = BinnedTime$.MODULE$.timeToBinnedTime(period);
        this.sketches = Map$.MODULE$.empty();
    }
}

