/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.api;

import org.locationtech.geomesa.index.api.WritableFeature;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005EbaB\u0001\u0003!\u0003\r\n!\u0004\u0002\u000e'\"\f'\u000fZ*ue\u0006$XmZ=\u000b\u0005\r!\u0011aA1qS*\u0011QAB\u0001\u0006S:$W\r\u001f\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!\u0006\u0001\u0007\u0002Y\tQ!\u00199qYf$\"aF\u000f\u0011\u0007=A\"$\u0003\u0002\u001a!\t)\u0011I\u001d:bsB\u0011qbG\u0005\u00039A\u0011AAQ=uK\")a\u0004\u0006a\u0001?\u00059a-Z1ukJ,\u0007C\u0001\u0011\"\u001b\u0005\u0011\u0011B\u0001\u0012\u0003\u0005=9&/\u001b;bE2,g)Z1ukJ,\u0007\"\u0002\u0013\u0001\r\u0003)\u0013AB:iCJ$7/F\u0001'!\r9sf\u0006\b\u0003Q5r!!\u000b\u0017\u000e\u0003)R!a\u000b\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012B\u0001\u0018\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001M\u0019\u0003\u0007M+\u0017O\u0003\u0002/!!)1\u0007\u0001D\u0001i\u00051A.\u001a8hi\",\u0012!\u000e\t\u0003\u001fYJ!a\u000e\t\u0003\u0007%sGoB\u0003:\u0005!\u0005!(A\u0007TQ\u0006\u0014Hm\u0015;sCR,w-\u001f\t\u0003Am2Q!\u0001\u0002\t\u0002q\u001a\"a\u000f\b\t\u000byZD\u0011A \u0002\rqJg.\u001b;?)\u0005Q\u0004bB!<\u0005\u0004%IAQ\u0001\nS:\u001cH/\u00198dKN,\u0012a\u0011\t\u0005\t.+T*D\u0001F\u0015\t1u)\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001S%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\taUIA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"AT(\u000e\u0003m2A\u0001U\u001e\u0001#\n\t2\u000b[1sIN#(/\u0019;fOfLU\u000e\u001d7\u0014\u0007=s!\u000b\u0005\u0002!\u0001!AAe\u0014BC\u0002\u0013\u0005C+F\u0001V!\r9ckF\u0005\u0003/F\u0012!\"\u00138eKb,GmU3r\u0011!IvJ!A!\u0002\u0013)\u0016aB:iCJ$7\u000f\t\u0005\u0006}=#\ta\u0017\u000b\u0003\u001brCQ\u0001\n.A\u0002UCQ!F(\u0005By#\"aF0\t\u000byi\u0006\u0019A\u0010\t\u000fMz%\u0019!C!i!1!m\u0014Q\u0001\nU\nq\u0001\\3oORD\u0007\u0005\u0003\u0004ew\u0001\u0006IaQ\u0001\u000bS:\u001cH/\u00198dKN\u0004\u0003\"B\u000b<\t\u00031GC\u0001*h\u0011\u0015AW\r1\u00016\u0003\u0015\u0019w.\u001e8u\u000f\u0015Q7\b#\u0001l\u0003=qun\u00155be\u0012\u001cFO]1uK\u001eL\bC\u0001(m\r\u0015i7\b#\u0001o\u0005=qun\u00155be\u0012\u001cFO]1uK\u001eL8c\u00017\u000f%\")a\b\u001cC\u0001aR\t1\u000eC\u0003\u0016Y\u0012\u0005#\u000f\u0006\u0002\u0018g\")a$\u001da\u0001?!9A\u0005\u001cb\u0001\n\u0003*\u0003BB-mA\u0003%a\u0005C\u00044Y\n\u0007I\u0011\t\u001b\t\r\td\u0007\u0015!\u00036\u000f\u0015I8\b#\u0001{\u00039Q6\u000b[1sIN#(/\u0019;fOf\u0004\"AT>\u0007\u000bq\\\u0004\u0012A?\u0003\u001di\u001b\u0006.\u0019:e'R\u0014\u0018\r^3hsN\u00111P\u0004\u0005\u0006}m$\ta \u000b\u0002u\"1Qc\u001fC\u0001\u0003\u0007!2AUA\u0003\u0011!\t9!!\u0001A\u0002\u0005%\u0011aA:giB!\u00111BA\f\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011AB:j[BdWMC\u0002\u001f\u0003'Q1!!\u0006\u000b\u0003\u001dy\u0007/\u001a8hSNLA!!\u0007\u0002\u000e\t\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\b\u000f\u0005u1\b#\u0001\u0002 \u00051\u0012\t\u001e;sS\n,H/Z*iCJ$7\u000b\u001e:bi\u0016<\u0017\u0010E\u0002O\u0003C1q!a\t<\u0011\u0003\t)C\u0001\fBiR\u0014\u0018NY;uKNC\u0017M\u001d3TiJ\fG/Z4z'\r\t\tC\u0004\u0005\b}\u0005\u0005B\u0011AA\u0015)\t\ty\u0002C\u0004\u0016\u0003C!\t!!\f\u0015\u0007I\u000by\u0003\u0003\u0005\u0002\b\u0005-\u0002\u0019AA\u0005\u0001")
public interface ShardStrategy {
    public byte[] apply(WritableFeature var1);

    public Seq<byte[]> shards();

    public int length();

    public static class ShardStrategyImpl
    implements ShardStrategy {
        private final IndexedSeq<byte[]> shards;
        private final int length;

        public IndexedSeq<byte[]> shards() {
            return this.shards;
        }

        @Override
        public byte[] apply(WritableFeature feature) {
            byte[] byArray;
            try {
                byArray = (byte[])this.shards().apply(feature.idHash() % this.shards().length());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                byArray = (byte[])this.shards().head();
            }
            return byArray;
        }

        @Override
        public int length() {
            return this.length;
        }

        public ShardStrategyImpl(IndexedSeq<byte[]> shards) {
            this.shards = shards;
            this.length = ((byte[])shards.head()).length;
        }
    }
}

