/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.google.common.util.concurrent.MoreExecutors;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Function;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.PartitionSchemeFactory$;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadataFactory;
import org.locationtech.geomesa.fs.storage.common.metadata.MetadataSerialization$;
import org.locationtech.geomesa.fs.storage.common.metadata.package$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class FileBasedMetadataFactory$
implements MethodProfiling {
    public static final FileBasedMetadataFactory$ MODULE$;
    private final String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$MetadataDirectory;
    private final String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$StoragePath;
    private final ScheduledExecutorService org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$executor;
    private final ConcurrentHashMap<String, FileBasedMetadataFactory.MetadataLoader> org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new FileBasedMetadataFactory$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        FileBasedMetadataFactory$ fileBasedMetadataFactory$ = this;
        synchronized (fileBasedMetadataFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$MetadataDirectory() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$MetadataDirectory;
    }

    public String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$StoragePath() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$StoragePath;
    }

    public ScheduledExecutorService org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$executor() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$executor;
    }

    public ConcurrentHashMap<String, FileBasedMetadataFactory.MetadataLoader> org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache;
    }

    public String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$key(package.FileSystemContext context) {
        return (String)context.namespace().map((Function1)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final package.FileSystemContext context$3;

            public final String apply(String ns) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ns, this.context$3.root().toUri()}));
            }
            {
                this.context$3 = context$3;
            }
        }).getOrElse((Function0)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final package.FileSystemContext context$3;

            public final String apply() {
                return this.context$3.root().toUri().toString();
            }
            {
                this.context$3 = context$3;
            }
        });
    }

    public Option<FileBasedMetadataFactory.MetadataLoader> org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cached(package.FileSystemContext context) {
        Function<String, FileBasedMetadataFactory.MetadataLoader> loader = new Function<String, FileBasedMetadataFactory.MetadataLoader>(context){
            private final package.FileSystemContext context$2;

            public FileBasedMetadataFactory.MetadataLoader apply(String ignored) {
                FileBasedMetadataFactory.MetadataLoader metadataLoader;
                Path file = new Path(this.context$2.root(), FileBasedMetadataFactory$.MODULE$.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$StoragePath());
                if (PathCache$.MODULE$.exists(this.context$2.fc(), file, PathCache$.MODULE$.exists$default$3())) {
                    Path directory = new Path(this.context$2.root(), FileBasedMetadataFactory$.MODULE$.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$MetadataDirectory());
                    package.Metadata meta = (package.Metadata)WithClose$.MODULE$.apply((Object)this.context$2.fc().open(file), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final package.Metadata apply(InputStream in) {
                            return MetadataSerialization$.MODULE$.deserialize(in);
                        }
                    });
                    boolean leaf = meta.leafStorage();
                    SimpleFeatureType sft = package$.MODULE$.namespaced(meta.sft(), (Option<String>)this.context$2.namespace());
                    PartitionScheme scheme = PartitionSchemeFactory$.MODULE$.load(sft, meta.scheme());
                    metadataLoader = new FileBasedMetadataFactory.MetadataLoader(new FileBasedMetadata(this.context$2.fc(), directory, sft, meta.encoding(), scheme, leaf));
                } else {
                    metadataLoader = null;
                }
                return metadataLoader;
            }
            {
                this.context$2 = context$2;
            }
        };
        return Option$.MODULE$.apply((Object)this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache().computeIfAbsent(this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$key(context), loader));
    }

    public void org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$write(FileContext fc, Path root, package.Metadata metadata) {
        Path file = new Path(root, this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$StoragePath());
        if (PathCache$.MODULE$.exists(fc, file, true)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metadata file already exists at path '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
        }
        WithClose$.MODULE$.apply((Object)fc.create(file, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final package.Metadata metadata$1;

            public final void apply(FSDataOutputStream out) {
                MetadataSerialization$.MODULE$.serialize((OutputStream)out, this.metadata$1);
                out.hflush();
                out.hsync();
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        PathCache$.MODULE$.register(fc, file, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
    }

    private FileBasedMetadataFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$MetadataDirectory = "metadata";
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$StoragePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/storage.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$MetadataDirectory()}));
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$executor = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache = new ConcurrentHashMap();
    }
}

