/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.geohash.VincentyModel$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class GeoHashIterator$ {
    public static final GeoHashIterator$ MODULE$;
    private final GeometryFactory geometryFactory;
    private final Map<Object, Object> mapDegreesToMeters;
    private final double precisionDegreesToMeters;

    static {
        new GeoHashIterator$();
    }

    public GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public Tuple2<GeoHash, GeoHash> getBoundingGeoHashes(Traversable<Point> points, int precision, double radiusInMeters) {
        Tuple4 tuple4 = (Tuple4)points.foldLeft((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)), (Function2)new Serializable(precision){
            public static final long serialVersionUID = 0L;
            private final int precision$1;

            public final Tuple4<Object, Object, Object, Object> apply(Tuple4<Object, Object, Object, Object> x0$1, Point x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    Tuple4 tuple4 = (Tuple4)tuple2._1();
                    Point point = (Point)tuple2._2();
                    if (tuple4 != null) {
                        long xMin = BoxesRunTime.unboxToLong((Object)tuple4._1());
                        long xMax = BoxesRunTime.unboxToLong((Object)tuple4._2());
                        long yMin = BoxesRunTime.unboxToLong((Object)tuple4._3());
                        long yMax = BoxesRunTime.unboxToLong((Object)tuple4._4());
                        long[] lArray = GeoHash$.MODULE$.gridIndicesForLatLong(GeoHash$.MODULE$.apply(point, this.precision$1));
                        Option option2 = Array$.MODULE$.unapplySeq((Object)lArray);
                        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                            Tuple2.mcJJ.sp sp2;
                            long y = BoxesRunTime.unboxToLong((Object)((SeqLike)option2.get()).apply(0));
                            long x = BoxesRunTime.unboxToLong((Object)((SeqLike)option2.get()).apply(1));
                            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(y, x);
                            long y2 = sp3._1$mcJ$sp();
                            long x2 = sp3._2$mcJ$sp();
                            Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.min(xMin, x2)), (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(xMax, x2)), (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.min(yMin, y2)), (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(yMax, y2)));
                            return tuple42;
                        }
                        throw new MatchError((Object)lArray);
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.precision$1 = precision$1;
            }
        });
        if (tuple4 != null) {
            Tuple4 tuple42;
            long lonMin = BoxesRunTime.unboxToLong((Object)tuple4._1());
            long lonMax = BoxesRunTime.unboxToLong((Object)tuple4._2());
            long latMin = BoxesRunTime.unboxToLong((Object)tuple4._3());
            long latMax = BoxesRunTime.unboxToLong((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToLong((long)lonMin), (Object)BoxesRunTime.boxToLong((long)lonMax), (Object)BoxesRunTime.boxToLong((long)latMin), (Object)BoxesRunTime.boxToLong((long)latMax));
            long lonMin2 = BoxesRunTime.unboxToLong((Object)tuple43._1());
            long lonMax2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
            long latMin2 = BoxesRunTime.unboxToLong((Object)tuple43._3());
            long latMax2 = BoxesRunTime.unboxToLong((Object)tuple43._4());
            GeoHash gh = GeoHash$.MODULE$.composeGeoHashFromBitIndicesAndPrec(latMin2, lonMin2, precision);
            Point point = this.geometryFactory().createPoint(new Coordinate(gh.x(), gh.y()));
            Point left = VincentyModel$.MODULE$.moveWithBearingAndDistance(point, -90.0, radiusInMeters);
            Point ptLL = VincentyModel$.MODULE$.moveWithBearingAndDistance(left, 180.0, radiusInMeters);
            GeoHash gh2 = GeoHash$.MODULE$.composeGeoHashFromBitIndicesAndPrec(latMax2, lonMax2, precision);
            Point point2 = this.geometryFactory().createPoint(new Coordinate(gh2.x(), gh2.y()));
            Point right = VincentyModel$.MODULE$.moveWithBearingAndDistance(point2, 0.0, radiusInMeters);
            Point ptUR = VincentyModel$.MODULE$.moveWithBearingAndDistance(right, 90.0, radiusInMeters);
            return new Tuple2((Object)GeoHash$.MODULE$.apply(ptLL, precision), (Object)GeoHash$.MODULE$.apply(ptUR, precision));
        }
        throw new MatchError((Object)tuple4);
    }

    public double getDimensionPrecisionInMeters(double nearLatitude, boolean isLatitude, int dimensionBits) {
        double d;
        if (isLatitude) {
            d = 2.0004E7 / (double)(1 << dimensionBits);
        } else {
            double radiusAtEquator = 4.007516E7;
            double radiusNearLatitude = radiusAtEquator * Math.cos(nearLatitude * Math.PI / 180.0);
            double circumferenceNearLatitude = radiusNearLatitude * 2.0 * Math.PI;
            d = circumferenceNearLatitude / (double)(1 << dimensionBits);
        }
        return d;
    }

    public double convertRadiusInMetersToDegrees(double meters) {
        Point point = this.geometryFactory().createPoint(new Coordinate(67.5, 35.0));
        return this.getSegmentLengthInDegrees(point, VincentyModel$.MODULE$.moveWithBearingAndDistance(point, 45.0, meters));
    }

    private final Map<Object, Object> mapDegreesToMeters() {
        return this.mapDegreesToMeters;
    }

    private final double precisionDegreesToMeters() {
        return 100000.0;
    }

    public double convertRadiusInDegreesToMeters(double degreeRadius) {
        double degrees = (double)Math.round(degreeRadius * 100000.0) / 100000.0;
        return BoxesRunTime.unboxToDouble((Object)this.mapDegreesToMeters().getOrElseUpdate((Object)BoxesRunTime.boxToDouble((double)degrees), (Function0)new Serializable(degrees){
            public static final long serialVersionUID = 0L;
            private final double degrees$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return GeoHashIterator$.MODULE$.convertRadiusInDegreesToMetersViaIntervalHalving(this.degrees$1, 45.0);
            }
            {
                this.degrees$1 = degrees$1;
            }
        }));
    }

    public double convertRadiusInDegreesToMetersViaIntervalHalving(double degrees, double azimuth) {
        Point a = this.geometryFactory().createPoint(new Coordinate(67.5, 35.0));
        double minMeters = 0.01;
        double maxMeters = 1.0E7;
        double midMeters = 0.5 * (minMeters + maxMeters);
        double midDegrees = this.getSegmentLengthInDegrees(a, VincentyModel$.MODULE$.moveWithBearingAndDistance(a, azimuth, midMeters));
        while (Math.abs(midMeters - minMeters) > 0.01) {
            if (midDegrees == degrees) {
                return midMeters;
            }
            if (midDegrees > degrees) {
                maxMeters = midMeters;
            } else if (midDegrees < degrees) {
                minMeters = midMeters;
            }
            midMeters = 0.5 * (minMeters + maxMeters);
            midDegrees = this.getSegmentLengthInDegrees(a, VincentyModel$.MODULE$.moveWithBearingAndDistance(a, azimuth, midMeters));
        }
        return midMeters;
    }

    public double getSegmentLengthInDegrees(Point a, Point b) {
        return Math.hypot(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public double getSegmentLengthInMeters(Point a, Point b) {
        return VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(a, b).getDistanceInMeters();
    }

    private GeoHashIterator$() {
        MODULE$ = this;
        this.geometryFactory = new GeometryFactory(new PrecisionModel(), 4326);
        this.mapDegreesToMeters = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

