/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import java.awt.geom.Point2D;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.geomesa.utils.geohash.GeomDistance;
import org.locationtech.geomesa.utils.geohash.GeomDistance$Distance$;
import org.locationtech.geomesa.utils.geohash.GeomDistance$class;
import org.locationtech.geomesa.utils.text.ObjectPoolFactory$;
import org.locationtech.geomesa.utils.text.ObjectPoolUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import scala.Serializable;

public final class VincentyModel$
implements GeomDistance {
    public static final VincentyModel$ MODULE$;
    private final GeometryFactory org$locationtech$geomesa$utils$geohash$VincentyModel$$geometryFactory;
    private final ObjectPoolUtils<GeodeticCalculator> geodeticCalculatorPool;
    private volatile GeomDistance$Distance$ Distance$module;

    static {
        new VincentyModel$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GeomDistance$Distance$ Distance$lzycompute() {
        VincentyModel$ vincentyModel$ = this;
        synchronized (vincentyModel$) {
            if (this.Distance$module != null) return this.Distance$module;
            this.Distance$module = new GeomDistance$Distance$(this);
            return this.Distance$module;
        }
    }

    @Override
    public GeomDistance$Distance$ Distance() {
        return this.Distance$module == null ? this.Distance$lzycompute() : this.Distance$module;
    }

    public GeometryFactory org$locationtech$geomesa$utils$geohash$VincentyModel$$geometryFactory() {
        return this.org$locationtech$geomesa$utils$geohash$VincentyModel$$geometryFactory;
    }

    private ObjectPoolUtils<GeodeticCalculator> geodeticCalculatorPool() {
        return this.geodeticCalculatorPool;
    }

    public GeomDistance.Distance getDistanceBetweenTwoPoints(Point a, Point b) {
        return this.getDistanceBetweenTwoPoints(a.getX(), a.getY(), b.getX(), b.getY());
    }

    public GeomDistance.Distance getDistanceBetweenTwoPoints(double x1, double y1, double x2, double y2) {
        return (GeomDistance.Distance)this.geodeticCalculatorPool().withResource(new Serializable(x1, y1, x2, y2){
            public static final long serialVersionUID = 0L;
            private final double x1$1;
            private final double y1$1;
            private final double x2$1;
            private final double y2$1;

            public final GeomDistance.Distance apply(GeodeticCalculator calc) {
                calc.setStartingGeographicPoint(this.x1$1, this.y1$1);
                calc.setDestinationGeographicPoint(this.x2$1, this.y2$1);
                return new GeomDistance.Distance(VincentyModel$.MODULE$, calc.getOrthodromicDistance());
            }
            {
                this.x1$1 = x1$1;
                this.y1$1 = y1$1;
                this.x2$1 = x2$1;
                this.y2$1 = y2$1;
            }
        });
    }

    public Point moveWithBearingAndDistance(Point a, double bearing, double distance) {
        return this.moveWithBearingAndDistance(a.getX(), a.getY(), bearing, distance);
    }

    public Point moveWithBearingAndDistance(double x, double y, double bearing, double distance) {
        return (Point)this.geodeticCalculatorPool().withResource(new Serializable(x, y, bearing, distance){
            public static final long serialVersionUID = 0L;
            private final double x$1;
            private final double y$1;
            private final double bearing$1;
            private final double distance$1;

            public final Point apply(GeodeticCalculator calc) {
                calc.setStartingGeographicPoint(this.x$1, this.y$1);
                calc.setDirection(this.bearing$1, this.distance$1);
                Point2D point = calc.getDestinationGeographicPoint();
                return VincentyModel$.MODULE$.org$locationtech$geomesa$utils$geohash$VincentyModel$$geometryFactory().createPoint(new Coordinate(point.getX(), point.getY()));
            }
            {
                this.x$1 = x$1;
                this.y$1 = y$1;
                this.bearing$1 = bearing$1;
                this.distance$1 = distance$1;
            }
        });
    }

    private VincentyModel$() {
        MODULE$ = this;
        GeomDistance$class.$init$(this);
        this.org$locationtech$geomesa$utils$geohash$VincentyModel$$geometryFactory = new GeometryFactory(new PrecisionModel(), 4326);
        this.geodeticCalculatorPool = ObjectPoolFactory$.MODULE$.apply(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GeodeticCalculator apply() {
                return new GeodeticCalculator();
            }
        }, ObjectPoolFactory$.MODULE$.apply$default$2());
    }
}

