/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;

public final class MixedGeometryCheck$
implements LazyLogging {
    public static final MixedGeometryCheck$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new MixedGeometryCheck$();
    }

    private Logger logger$lzycompute() {
        MixedGeometryCheck$ mixedGeometryCheck$ = this;
        synchronized (mixedGeometryCheck$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void validateGeometryType(SimpleFeatureType sft) {
        GeometryDescriptor gd = sft.getGeometryDescriptor();
        if (gd != null) {
            Class clazz = gd.getType().getBinding();
            Class<Geometry> clazz2 = Geometry.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) && !GeoMesaSchemaValidator$.MODULE$.declared(sft, SimpleFeatureTypes$Configs$.MODULE$.MixedGeometries())) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Trying to create a schema with mixed geometry type ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", ":Geometry'. Queries may be slower when using mixed geometries. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gd.getLocalName()}))).append((Object)"If this is intentional, you may override this check by putting Boolean.TRUE into the ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SimpleFeatureType user data under the key '", "' before calling createSchema, or by "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$Configs$.MODULE$.MixedGeometries()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"setting the system property '", "' to 'true'. Otherwise, please specify a single "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$Configs$.MODULE$.MixedGeometries()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geometry type (e.g. Point, LineString, Polygon, etc)."})).s((Seq)Nil$.MODULE$)).toString());
            }
        }
    }

    private MixedGeometryCheck$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

