/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.text;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.text.DateParsing$TemporalQueries$;
import scala.MatchError;

public final class DateParsing$ {
    public static final DateParsing$ MODULE$;
    private final DateTimeFormatter format;
    private final ZonedDateTime Epoch;

    static {
        new DateParsing$();
    }

    private DateTimeFormatter format() {
        return this.format;
    }

    public ZonedDateTime Epoch() {
        return this.Epoch;
    }

    public ZonedDateTime parse(String value2, DateTimeFormatter format) {
        TemporalAccessor temporalAccessor;
        block5: {
            ZonedDateTime zonedDateTime;
            block3: {
                block4: {
                    block2: {
                        ZonedDateTime zonedDateTime2;
                        temporalAccessor = format.parseBest(value2, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
                        if (!(temporalAccessor instanceof ZonedDateTime)) break block2;
                        zonedDateTime = zonedDateTime2 = (ZonedDateTime)temporalAccessor;
                        break block3;
                    }
                    if (!(temporalAccessor instanceof LocalDateTime)) break block4;
                    LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
                    zonedDateTime = localDateTime.atZone(ZoneOffset.UTC);
                    break block3;
                }
                if (!(temporalAccessor instanceof LocalDate)) break block5;
                LocalDate localDate = (LocalDate)temporalAccessor;
                zonedDateTime = localDate.atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
            }
            return zonedDateTime;
        }
        throw new MatchError((Object)temporalAccessor);
    }

    public DateTimeFormatter parse$default$2() {
        return this.format();
    }

    public Instant parseInstant(String value2, DateTimeFormatter format) {
        TemporalAccessor temporalAccessor;
        block5: {
            Instant instant;
            block3: {
                block4: {
                    block2: {
                        temporalAccessor = format.parseBest(value2, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
                        if (!(temporalAccessor instanceof ZonedDateTime)) break block2;
                        ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
                        instant = zonedDateTime.toInstant();
                        break block3;
                    }
                    if (!(temporalAccessor instanceof LocalDateTime)) break block4;
                    LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
                    instant = localDateTime.toInstant(ZoneOffset.UTC);
                    break block3;
                }
                if (!(temporalAccessor instanceof LocalDate)) break block5;
                LocalDate localDate = (LocalDate)temporalAccessor;
                instant = localDate.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC);
            }
            return instant;
        }
        throw new MatchError((Object)temporalAccessor);
    }

    public DateTimeFormatter parseInstant$default$2() {
        return this.format();
    }

    public Date parseDate(String value2, DateTimeFormatter format) {
        TemporalAccessor temporalAccessor;
        block5: {
            Date date;
            block3: {
                block4: {
                    block2: {
                        temporalAccessor = format.parseBest(value2, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
                        if (!(temporalAccessor instanceof ZonedDateTime)) break block2;
                        ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
                        date = Date.from(zonedDateTime.toInstant());
                        break block3;
                    }
                    if (!(temporalAccessor instanceof LocalDateTime)) break block4;
                    LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
                    date = Date.from(localDateTime.toInstant(ZoneOffset.UTC));
                    break block3;
                }
                if (!(temporalAccessor instanceof LocalDate)) break block5;
                LocalDate localDate = (LocalDate)temporalAccessor;
                date = Date.from(localDate.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC));
            }
            return date;
        }
        throw new MatchError((Object)temporalAccessor);
    }

    public DateTimeFormatter parseDate$default$2() {
        return this.format();
    }

    public long parseMillis(String value2, DateTimeFormatter format) {
        TemporalAccessor temporalAccessor;
        block5: {
            long l;
            block3: {
                block4: {
                    block2: {
                        temporalAccessor = format.parseBest(value2, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
                        if (!(temporalAccessor instanceof ZonedDateTime)) break block2;
                        ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
                        l = zonedDateTime.toInstant().toEpochMilli();
                        break block3;
                    }
                    if (!(temporalAccessor instanceof LocalDateTime)) break block4;
                    LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
                    l = localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
                    break block3;
                }
                if (!(temporalAccessor instanceof LocalDate)) break block5;
                LocalDate localDate = (LocalDate)temporalAccessor;
                l = localDate.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC).toEpochMilli();
            }
            return l;
        }
        throw new MatchError((Object)temporalAccessor);
    }

    public DateTimeFormatter parseMillis$default$2() {
        return this.format();
    }

    public String format(ZonedDateTime value2, DateTimeFormatter format) {
        return value2.format(format);
    }

    public DateTimeFormatter format$default$2() {
        return this.format();
    }

    public String formatDate(Date value2, DateTimeFormatter format) {
        return ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant(value2), ZoneOffset.UTC).format(format);
    }

    public DateTimeFormatter formatDate$default$2() {
        return this.format();
    }

    public String formatInstant(Instant value2, DateTimeFormatter format) {
        return ZonedDateTime.ofInstant(value2, ZoneOffset.UTC).format(format);
    }

    public DateTimeFormatter formatInstant$default$2() {
        return this.format();
    }

    public String formatMillis(long value2, DateTimeFormatter format) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(value2), ZoneOffset.UTC).format(format);
    }

    public DateTimeFormatter formatMillis$default$2() {
        return this.format();
    }

    private DateParsing$() {
        MODULE$ = this;
        this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseLenient().optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalEnd().optionalEnd().optionalStart().appendOffsetId().toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        this.Epoch = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
    }
}

