/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFind
extends ExtensionFunctionDefinition {
    public static final StructuredQName name = new StructuredQName("map", "http://www.w3.org/2005/xpath-functions/map", "find");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.SINGLE_ATOMIC};

    @Override
    public StructuredQName getFunctionQName() {
        return name;
    }

    @Override
    public int getMinimumNumberOfArguments() {
        return 2;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.makeSequenceType(ArrayItemType.ANY_ARRAY_TYPE, 16384);
    }

    @Override
    public boolean trustResultType() {
        return true;
    }

    @Override
    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                ArrayList<Sequence> result = new ArrayList<Sequence>();
                AtomicValue key = (AtomicValue)arguments[1].head();
                MapFind.this.processSequence(arguments[0], key, result);
                return new SimpleArrayItem(result);
            }
        };
    }

    private void processSequence(Sequence in, AtomicValue key, List<Sequence> result) throws XPathException {
        Item item;
        SequenceIterator iter = in.iterate();
        while ((item = iter.next()) != null) {
            if (item instanceof ArrayItem) {
                for (Sequence sequence : (ArrayItem)item) {
                    this.processSequence(sequence, key, result);
                }
                continue;
            }
            if (!(item instanceof MapItem)) continue;
            Sequence value = ((MapItem)item).get(key);
            if (value != null) {
                result.add(value);
            }
            for (KeyValuePair entry : (MapItem)item) {
                this.processSequence(entry.value, key, result);
            }
        }
    }
}

