/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.tools.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import java.io.File;
import java.util.List;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.tools.CassandraConnectionParams$class;
import org.locationtech.geomesa.cassandra.tools.CassandraDataStoreCommand;
import org.locationtech.geomesa.cassandra.tools.CassandraDataStoreCommand$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.DistributedCombineParam;
import org.locationtech.geomesa.tools.DistributedCommand;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.InteractiveCommand;
import org.locationtech.geomesa.tools.OptionalCredentialsParams;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001f\t12)Y:tC:$'/Y%oO\u0016\u001cHoQ8n[\u0006tGM\u0003\u0002\u0004\t\u0005A1m\\7nC:$7O\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\nG\u0006\u001c8/\u00198ee\u0006T!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f$!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0019qcG\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\r%tw-Z:u\u0015\t)\u0001\"\u0003\u0002\u001d1\ti\u0011J\\4fgR\u001cu.\\7b]\u0012\u0004\"AH\u0011\u000e\u0003}Q!\u0001\t\u0004\u0002\t\u0011\fG/Y\u0005\u0003E}\u0011!cQ1tg\u0006tGM]1ECR\f7\u000b^8sKB\u0011A%J\u0007\u0002\t%\u0011a\u0005\u0002\u0002\u001a\u0007\u0006\u001c8/\u00198ee\u0006$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG\rC\u0003)\u0001\u0011\u0005\u0011&\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u0002\u0005!9Q\u0006\u0001b\u0001\n\u0003r\u0013A\u00029be\u0006l7/F\u00010!\t\u0001tI\u0004\u00022\u0001:\u0011!g\u0010\b\u0003gyr!\u0001N\u001f\u000f\u0005UbdB\u0001\u001c<\u001d\t9$(D\u00019\u0015\tId\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u000f\u0015\t%\u0001#\u0001C\u0003Y\u0019\u0015m]:b]\u0012\u0014\u0018-\u00138hKN$8i\\7nC:$\u0007CA\u0016D\r\u0015\t!\u0001#\u0001E'\t\u0019\u0005\u0003C\u0003)\u0007\u0012\u0005a\tF\u0001C\r\u0011A5\tA%\u0003+\r\u000b7o]1oIJ\f\u0017J\\4fgR\u0004\u0016M]1ngN!q\t\u0005&V!\tY%K\u0004\u0002M!:\u0011Qj\u0014\b\u0003i9K!!\u0002\u0005\n\u0005eQ\u0012BA)\u0019\u00035IenZ3ti\u000e{W.\\1oI&\u00111\u000b\u0016\u0002\r\u0013:<Wm\u001d;QCJ\fWn\u001d\u0006\u0003#b\u0001\"AV-\u000f\u0005I:\u0016B\u0001-\u0005\u0003e\u0019\u0015m]:b]\u0012\u0014\u0018\rR1uCN#xN]3D_6l\u0017M\u001c3\n\u0005i[&\u0001G\"bgN\fg\u000e\u001a:b\t\u0006$\u0018m\u0015;pe\u0016\u0004\u0016M]1ng*\u0011\u0001\f\u0002\u0005\u0006Q\u001d#\t!\u0018\u000b\u0002=B\u0011qlR\u0007\u0002\u0007\"\"q)Y6m!\t\u0011\u0017.D\u0001d\u0015\t!W-\u0001\u0006kG>lW.\u00198eKJT!AZ4\u0002\u000b\t,Wo\u001d;\u000b\u0003!\f1aY8n\u0013\tQ7M\u0001\u0006QCJ\fW.\u001a;feN\f!cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0006\nQ.\u0001\u0019J]\u001e,7\u000f^\u0018d_:4XM\u001d;!m\u0006\u0014\u0018n\\;tA\u0019LG.\u001a\u0011g_Jl\u0017\r^:!S:$x\u000eI$f_6+7/\u0019\u0005\u0007_\u0002\u0001\u000b\u0011B\u0018\u0002\u000fA\f'/Y7tA!)\u0011\u000f\u0001C!e\u00069Q\r_3dkR,G#A:\u0011\u0005E!\u0018BA;\u0013\u0005\u0011)f.\u001b;")
public class CassandraIngestCommand
implements IngestCommand<CassandraDataStore>,
CassandraDataStoreCommand {
    private final CassandraIngestParams params;
    private final String name;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;

    @Override
    public Map<String, String> connection() {
        return CassandraDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public Seq<String> libjarsFiles() {
        return IngestCommand.class.libjarsFiles((IngestCommand)this);
    }

    public Runnable createIngest(Enumeration.Value mode, SimpleFeatureType sft, Config converter, Seq<String> inputs) {
        return IngestCommand.class.createIngest((IngestCommand)this, (Enumeration.Value)mode, (SimpleFeatureType)sft, (Config)converter, inputs);
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return InteractiveCommand.class.console((InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        InteractiveCommand.class.setConsole((InteractiveCommand)this, (Object)c);
    }

    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return DistributedCommand.class.libjarsPaths((DistributedCommand)this);
    }

    public <T> T withDataStore(Function1<CassandraDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public CassandraIngestParams params() {
        return this.params;
    }

    public void execute() {
        if (JavaConversions$.MODULE$.asScalaBuffer(this.params().files()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String path) {
                return PathUtils$.MODULE$.isRemote(path);
            }
        })) {
            throw new ParameterException("The Cassandra ingest tool does not support distributed ingest.");
        }
        IngestCommand.class.execute((IngestCommand)this);
    }

    public CassandraIngestCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        DistributedCommand.class.$init$((DistributedCommand)this);
        InteractiveCommand.class.$init$((InteractiveCommand)this);
        IngestCommand.class.$init$((IngestCommand)this);
        CassandraDataStoreCommand$class.$init$(this);
        this.params = new CassandraIngestParams();
    }

    @Parameters(commandDescription="Ingest/convert various file formats into GeoMesa")
    public static class CassandraIngestParams
    implements IngestCommand.IngestParams,
    CassandraDataStoreCommand.CassandraDataStoreParams {
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-P", "--contact-point"}, description="Cassandra contact point (address of a Cassandra node)", required=true)
        private String contactPoint;
        @Parameter(names={"-k", "--key-space"}, description="Cassandra key space (must already exist)", required=true)
        private String keySpace;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
        private Integer threads;
        @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
        private boolean srcList;
        @Parameter(names={"--no-tracking"}, description="Return immediately after submitting ingest job (distributed jobs)")
        private boolean noWaitForCompletion;
        @Parameter(names={"--combine-inputs"}, description="Combine multiple input files into a single input split (distributed jobs)")
        private boolean combineInputs;
        @Parameter(names={"--split-max-size"}, description="Maximum size of a split in bytes (distributed jobs)")
        private Integer maxSplitSize;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, auto-detection will be attempted")
        private String inputFormat;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter")
        private String config;
        @Parameter(names={"--converter-error-mode"}, description="Override the converter error mode - 'skip-bad-records' or 'raise-errors'", converter=ParameterConverters.ErrorModeConverter.class)
        private Enumeration.Value errorMode;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;
        private volatile boolean bitmap$0;

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String contactPoint() {
            return this.contactPoint;
        }

        @Override
        @TraitSetter
        public void contactPoint_$eq(String x$1) {
            this.contactPoint = x$1;
        }

        @Override
        public String keySpace() {
            return this.keySpace;
        }

        @Override
        @TraitSetter
        public void keySpace_$eq(String x$1) {
            this.keySpace = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public boolean srcList() {
            return this.srcList;
        }

        public void srcList_$eq(boolean x$1) {
            this.srcList = x$1;
        }

        public boolean noWaitForCompletion() {
            return this.noWaitForCompletion;
        }

        public void noWaitForCompletion_$eq(boolean x$1) {
            this.noWaitForCompletion = x$1;
        }

        public boolean waitForCompletion() {
            return IngestCommand.IngestParams.class.waitForCompletion((IngestCommand.IngestParams)this);
        }

        public boolean combineInputs() {
            return this.combineInputs;
        }

        public void combineInputs_$eq(boolean x$1) {
            this.combineInputs = x$1;
        }

        public Integer maxSplitSize() {
            return this.maxSplitSize;
        }

        public void maxSplitSize_$eq(Integer x$1) {
            this.maxSplitSize = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            CassandraIngestParams cassandraIngestParams = this;
            synchronized (cassandraIngestParams) {
                if (!this.bitmap$0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = true;
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return this.bitmap$0 ? this.mode : this.mode$lzycompute();
        }

        public String inputFormat() {
            return this.inputFormat;
        }

        public void inputFormat_$eq(String x$1) {
            this.inputFormat = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public String config() {
            return this.config;
        }

        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        public Enumeration.Value errorMode() {
            return this.errorMode;
        }

        public void errorMode_$eq(Enumeration.Value x$1) {
            this.errorMode = x$1;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public CassandraIngestParams() {
            OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
            OptionalFeatureSpecParam.class.$init$((OptionalFeatureSpecParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ConverterConfigParam.class.$init$((ConverterConfigParam)this);
            InputFilesParam.class.$init$((InputFilesParam)this);
            OptionalInputFormatParam.class.$init$((OptionalInputFormatParam)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            DistributedCombineParam.class.$init$((DistributedCombineParam)this);
            IngestCommand.IngestParams.class.$init$((IngestCommand.IngestParams)this);
            PasswordParams.class.$init$((PasswordParams)this);
            OptionalCredentialsParams.class.$init$((OptionalCredentialsParams)this);
            CassandraConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
        }
    }
}

