/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector.impl;

import io.netty.buffer.ArrowBuf;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryVector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public abstract class AbstractMultiPolygonVector<T extends FieldVector>
extends AbstractGeometryVector<MultiPolygon, ListVector, T> {
    private final ListVector innerVector;
    private final ListVector innerInnerVector;
    private final FixedSizeListVector tuples;

    public static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null, metadata);
    }

    protected AbstractMultiPolygonVector(String name, BufferAllocator allocator, Map<String, String> metadata) {
        this(new ListVector(name, allocator, AbstractMultiPolygonVector.createFieldType(metadata), null));
    }

    protected AbstractMultiPolygonVector(String name, AbstractContainerVector container, Map<String, String> metadata) {
        this((ListVector)container.addOrGet(name, AbstractMultiPolygonVector.createFieldType(metadata), ListVector.class));
    }

    protected AbstractMultiPolygonVector(ListVector vector) {
        super(vector);
        if (vector.getDataVector().equals(BaseRepeatedValueVector.DEFAULT_DATA_VECTOR)) {
            vector.initializeChildrenFromFields(this.getFields());
            vector.allocateNew();
        }
        this.innerVector = (ListVector)vector.getChildrenFromFields().get(0);
        this.innerInnerVector = (ListVector)this.innerVector.getChildrenFromFields().get(0);
        this.tuples = (FixedSizeListVector)this.innerInnerVector.getChildrenFromFields().get(0);
        this.setOrdinalVector((FieldVector)this.tuples.getChildrenFromFields().get(0));
    }

    @Override
    public void set(int index, MultiPolygon geom) {
        if (index == 0) {
            ((ListVector)this.vector).setLastSet(0);
            this.innerVector.setLastSet(0);
            this.innerInnerVector.setLastSet(0);
        }
        int innerIndex = ((ListVector)this.vector).startNewValue(index);
        if (geom == null) {
            ((ListVector)this.vector).endValue(index, 0);
            BitVectorHelper.setValidityBit((ArrowBuf)((ListVector)this.vector).getValidityBuffer(), (int)index, (int)0);
        } else {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Polygon poly = (Polygon)geom.getGeometryN(i);
                int innerInnerIndex = this.innerVector.startNewValue(innerIndex + i);
                for (int j = 0; j < poly.getNumInteriorRing() + 1; ++j) {
                    LineString line = j == 0 ? poly.getExteriorRing() : poly.getInteriorRingN(j - 1);
                    int position = this.innerInnerVector.startNewValue(innerInnerIndex + j);
                    for (int k = 0; k < line.getNumPoints(); ++k) {
                        Coordinate p = line.getCoordinateN(k);
                        this.tuples.setNotNull(position + k);
                        this.writeOrdinal((position + k) * 2, p.y);
                        this.writeOrdinal((position + k) * 2 + 1, p.x);
                    }
                    this.innerInnerVector.endValue(innerInnerIndex + j, line.getNumPoints());
                }
                this.innerVector.endValue(innerIndex + i, poly.getNumInteriorRing() + 1);
            }
            ((ListVector)this.vector).endValue(index, geom.getNumGeometries());
        }
    }

    @Override
    public MultiPolygon get(int index) {
        if (((ListVector)this.vector).isNull(index)) {
            return null;
        }
        int outerOuterOffsetStart = ((ListVector)this.vector).getOffsetBuffer().getInt(index * 4);
        int outerOuterOffsetEnd = ((ListVector)this.vector).getOffsetBuffer().getInt((index + 1) * 4);
        Polygon[] polygons = new Polygon[outerOuterOffsetEnd - outerOuterOffsetStart];
        for (int k = 0; k < polygons.length; ++k) {
            int outerOffsetStart = this.innerVector.getOffsetBuffer().getInt((outerOuterOffsetStart + k) * 4);
            int outerOffsetEnd = this.innerVector.getOffsetBuffer().getInt((outerOuterOffsetStart + k + 1) * 4);
            LinearRing shell = null;
            LinearRing[] holes = new LinearRing[outerOffsetEnd - outerOffsetStart - 1];
            for (int j = 0; j < holes.length + 1; ++j) {
                int offsetStart = this.innerInnerVector.getOffsetBuffer().getInt((outerOffsetStart + j) * 4);
                int offsetEnd = this.innerInnerVector.getOffsetBuffer().getInt((outerOffsetStart + j + 1) * 4);
                Coordinate[] coordinates = new Coordinate[offsetEnd - offsetStart];
                for (int i = 0; i < coordinates.length; ++i) {
                    double y = this.readOrdinal((offsetStart + i) * 2);
                    double x = this.readOrdinal((offsetStart + i) * 2 + 1);
                    coordinates[i] = new Coordinate(x, y);
                }
                LinearRing ring = factory.createLinearRing(coordinates);
                if (j == 0) {
                    shell = ring;
                    continue;
                }
                holes[j - 1] = ring;
            }
            polygons[k] = factory.createPolygon(shell, holes);
        }
        return factory.createMultiPolygon(polygons);
    }
}

