_geomesa-cassandra(){
  local cur prev;
  COMPREPLY=();
  cur="${COMP_WORDS[COMP_CWORD]}";
  prev="${COMP_WORDS[COMP_CWORD-1]}";

  if [[ "${COMP_WORDS[1]}" == "help" ]]; then
    COMPREPLY=( $(compgen -W "get-type-names describe-schema help env version get-sft-config create-schema remove-schema delete-features ingest export playback explain update-schema configure classpath scala-console" ${cur}));
    return 0;
  fi;

  case ${COMP_CWORD} in
    1)
      COMPREPLY=( $(compgen -W "get-type-names describe-schema help env version get-sft-config create-schema remove-schema delete-features ingest export playback explain update-schema configure classpath scala-console" ${cur}));
      ;;
    [2-9] | [1-9][0-9])
      if [[ "${cur}" =~ ^-[a-zA-Z-]?+$ ]]; then
        case ${COMP_WORDS[1]} in
                    get-type-names)
              COMPREPLY=( $(compgen -W "--password --key-space --user --catalog --contact-point" -- ${cur}));
              return 0;
              ;;
                  describe-schema)
              COMPREPLY=( $(compgen -W "--contact-point --key-space --catalog --feature-name --password --user" -- ${cur}));
              return 0;
              ;;
                  help)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  env)
              COMPREPLY=( $(compgen -W "--concise --converters --list-sfts --describe-sfts --exclude-user-data --format --sfts --list-converters --describe-converters" -- ${cur}));
              return 0;
              ;;
                  version)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  get-sft-config)
              COMPREPLY=( $(compgen -W "--exclude-user-data --user --format --feature-name --key-space --concise --contact-point --catalog --password" -- ${cur}));
              return 0;
              ;;
                  create-schema)
              COMPREPLY=( $(compgen -W "--key-space --feature-name --user --dtg --spec --catalog --contact-point --use-shared-tables --password" -- ${cur}));
              return 0;
              ;;
                  remove-schema)
              COMPREPLY=( $(compgen -W "--catalog --pattern --feature-name --contact-point --force --key-space --user --password" -- ${cur}));
              return 0;
              ;;
                  delete-features)
              COMPREPLY=( $(compgen -W "--feature-name --user --password --cql --contact-point --key-space --catalog" -- ${cur}));
              return 0;
              ;;
                  ingest)
              COMPREPLY=( $(compgen -W "--catalog --threads --no-tracking --force --src-list --combine-inputs --input-format --converter-error-mode --feature-name --contact-point --user --password --converter --run-mode --split-max-size --key-space --spec" -- ${cur}));
              return 0;
              ;;
                  export)
              COMPREPLY=( $(compgen -W "--contact-point --attribute --chunk-size --feature-name --force --hints --key-space --index --sort-by --num-reducers --cql --catalog --output-format --output --no-header --max-features --run-mode --gzip --attributes --user --password --sort-descending" -- ${cur}));
              return 0;
              ;;
                  playback)
              COMPREPLY=( $(compgen -W "--user --attributes --sort-descending --run-mode --output --output-format --dtg --key-space --cql --hints --chunk-size --rate --num-reducers --password --interval --no-header --attribute --catalog --max-features --gzip --step-window --sort-by --force --contact-point --feature-name" -- ${cur}));
              return 0;
              ;;
                  explain)
              COMPREPLY=( $(compgen -W "--hints --key-space --user --contact-point --cql --feature-name --index --attributes --password --catalog" -- ${cur}));
              return 0;
              ;;
                  update-schema)
              COMPREPLY=( $(compgen -W "--rename --add-keyword --key-space --password --rename-attribute --rename-tables --add-attribute --user --feature-name --catalog --force --remove-keyword --enable-stats --no-backup --contact-point" -- ${cur}));
              return 0;
              ;;
                  configure)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  classpath)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  scala-console)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
              esac;
      else
        compopt -o filenames -o nospace;
        COMPREPLY=( $(compgen -f "$2") );
      fi;
      return 0;
      ;;
    *)
      COMPREPLY=();
      ;;
  esac;
};
complete -F _geomesa-cassandra geomesa-cassandra;
complete -F _geomesa-cassandra bin/geomesa-cassandra;


       