/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2.validators;

import com.codahale.metrics.Counter;
import com.typesafe.scalalogging.Logger;
import java.util.Date;
import java.util.Locale;
import org.locationtech.geomesa.convert2.metrics.ConverterMetrics;
import org.locationtech.geomesa.convert2.validators.IndexValidatorFactory$;
import org.locationtech.geomesa.convert2.validators.SimpleFeatureValidator;
import org.locationtech.geomesa.convert2.validators.SimpleFeatureValidatorFactory;
import org.locationtech.geomesa.convert2.validators.package$Errors$;
import org.locationtech.geomesa.convert2.validators.package$NoValidator$;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.utils.conf.IndexId;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\ree\u0001B\u0001\u0003\u00015\u0011Q#\u00138eKb4\u0016\r\\5eCR|'OR1di>\u0014\u0018P\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$xN]:\u000b\u0005\u00151\u0011\u0001C2p]Z,'\u000f\u001e\u001a\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\ti2+[7qY\u00164U-\u0019;ve\u00164\u0016\r\\5eCR|'OR1di>\u0014\u0018\u0010C\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011Q\u0003\u0001\u0005\b;\u0001\u0011\r\u0011\"\u0011\u001f\u0003\u0011q\u0017-\\3\u0016\u0003}\u0001\"\u0001I\u0012\u000f\u0005=\t\u0013B\u0001\u0012\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0002\u0002BB\u0014\u0001A\u0003%q$A\u0003oC6,\u0007\u0005C\u0003*\u0001\u0011\u0005#&A\u0003baBd\u0017\u0010\u0006\u0003,]i\n\u0005CA\u000b-\u0013\ti#A\u0001\fTS6\u0004H.\u001a$fCR,(/\u001a,bY&$\u0017\r^8s\u0011\u0015y\u0003\u00061\u00011\u0003\r\u0019h\r\u001e\t\u0003caj\u0011A\r\u0006\u0003gQ\naa]5na2,'BA\u001b7\u0003\u001d1W-\u0019;ve\u0016T!a\u000e\u0006\u0002\u000f=\u0004XM\\4jg&\u0011\u0011H\r\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\"B\u001e)\u0001\u0004a\u0014aB7fiJL7m\u001d\t\u0003{}j\u0011A\u0010\u0006\u0003w\u0011I!\u0001\u0011 \u0003!\r{gN^3si\u0016\u0014X*\u001a;sS\u000e\u001c\b\"\u0002\")\u0001\u0004\u0019\u0015AB2p]\u001aLw\rE\u0002\u0010\t~I!!\u0012\t\u0003\r=\u0003H/[8o\u000f\u00159%\u0001#\u0001I\u0003UIe\u000eZ3y-\u0006d\u0017\u000eZ1u_J4\u0015m\u0019;pef\u0004\"!F%\u0007\u000b\u0005\u0011\u0001\u0012\u0001&\u0014\u0007%s1\n\u0005\u0002M'6\tQJ\u0003\u0002O\u001f\u0006a1oY1mC2|wmZ5oO*\u0011\u0001+U\u0001\tif\u0004Xm]1gK*\t!+A\u0002d_6L!\u0001V'\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\u00063%#\tA\u0016\u000b\u0002\u0011\"9\u0001,\u0013b\u0001\n\u0003I\u0016\u0001\u0002(b[\u0016,\u0012A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000bA\u0001\\1oO*\tq,\u0001\u0003kCZ\f\u0017B\u0001\u0013]\u0011\u0019\u0011\u0017\n)A\u00055\u0006)a*Y7fA!9A-\u0013b\u0001\n\u0003I\u0016aD$f_6tU\u000f\u001c7D_VtG/\u001a:\t\r\u0019L\u0005\u0015!\u0003[\u0003A9Um\\7Ok2d7i\\;oi\u0016\u0014\b\u0005C\u0004i\u0013\n\u0007I\u0011A-\u0002#\u001d+w.\u001c\"pk:$7oQ8v]R,'\u000f\u0003\u0004k\u0013\u0002\u0006IAW\u0001\u0013\u000f\u0016|WNQ8v]\u0012\u001c8i\\;oi\u0016\u0014\b\u0005C\u0004m\u0013\n\u0007I\u0011A-\u0002\u001d\u0011#xMT;mY\u000e{WO\u001c;fe\"1a.\u0013Q\u0001\ni\u000bq\u0002\u0012;h\u001dVdGnQ8v]R,'\u000f\t\u0005\ba&\u0013\r\u0011\"\u0001Z\u0003A!Eo\u001a\"pk:$7oQ8v]R,'\u000f\u0003\u0004s\u0013\u0002\u0006IAW\u0001\u0012\tR<'i\\;oIN\u001cu.\u001e8uKJ\u0004\u0003b\u0002;J\u0005\u0004%\t!W\u0001\u000f5J\"v\u000e^1m\u0007>,h\u000e^3s\u0011\u00191\u0018\n)A\u00055\u0006y!L\r+pi\u0006d7i\\;oi\u0016\u0014\b\u0005C\u0004y\u0013\n\u0007I\u0011A-\u0002\u001di\u001bDk\u001c;bY\u000e{WO\u001c;fe\"1!0\u0013Q\u0001\ni\u000bqBW\u001aU_R\fGnQ8v]R,'\u000f\t\u0005\by&\u0013\r\u0011\"\u0003~\u0003I9\u0006n\u001c7f/>\u0014H\u000eZ#om\u0016dw\u000e]3\u0016\u0003y\u00042a`A\u0007\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011a\u00016ug*!\u0011qAA\u0005\u0003!9Wm\\7fiJL(bAA\u0006\u0015\u0005Aq-Z8u_>d7/\u0003\u0003\u0002\u0010\u0005\u0005!A\u0005*fM\u0016\u0014XM\\2fI\u0016sg/\u001a7pa\u0016Dq!a\u0005JA\u0003%a0A\nXQ>dWmV8sY\u0012,eN^3m_B,\u0007E\u0002\u0004\u0002\u0018%#\u0015\u0011\u0004\u0002\u000e\u000bJ\u0014xN]\"pk:$XM]:\u0014\u000f\u0005Ua\"a\u0007\u0002\"A\u0019q\"!\b\n\u0007\u0005}\u0001CA\u0004Qe>$Wo\u0019;\u0011\u0007=\t\u0019#C\u0002\u0002&A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D1\"!\u000b\u0002\u0016\tU\r\u0011\"\u0001\u0002,\u00059Q.[:tS:<WCAA\u0017!\u0011\ty#a\u000e\u000e\u0005\u0005E\"bA\u001e\u00024)\u0019\u0011QG)\u0002\u0011\r|G-\u00195bY\u0016LA!!\u000f\u00022\t91i\\;oi\u0016\u0014\bbCA\u001f\u0003+\u0011\t\u0012)A\u0005\u0003[\t\u0001\"\\5tg&tw\r\t\u0005\f\u0003\u0003\n)B!f\u0001\n\u0003\tY#\u0001\u0004c_VtGm\u001d\u0005\f\u0003\u000b\n)B!E!\u0002\u0013\ti#A\u0004c_VtGm\u001d\u0011\t\u000fe\t)\u0002\"\u0001\u0002JQ1\u00111JA(\u0003#\u0002B!!\u0014\u0002\u00165\t\u0011\n\u0003\u0005\u0002*\u0005\u001d\u0003\u0019AA\u0017\u0011!\t\t%a\u0012A\u0002\u00055\u0002BCA+\u0003+\t\t\u0011\"\u0001\u0002X\u0005!1m\u001c9z)\u0019\tY%!\u0017\u0002\\!Q\u0011\u0011FA*!\u0003\u0005\r!!\f\t\u0015\u0005\u0005\u00131\u000bI\u0001\u0002\u0004\ti\u0003\u0003\u0006\u0002`\u0005U\u0011\u0013!C\u0001\u0003C\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002d)\"\u0011QFA3W\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA9!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCA=\u0003+\t\n\u0011\"\u0001\u0002b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CA?\u0003+\t\t\u0011\"\u0011Z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\"Q\u0011\u0011QA\u000b\u0003\u0003%\t!a!\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0005cA\b\u0002\b&\u0019\u0011\u0011\u0012\t\u0003\u0007%sG\u000f\u0003\u0006\u0002\u000e\u0006U\u0011\u0011!C\u0001\u0003\u001f\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0012\u0006]\u0005cA\b\u0002\u0014&\u0019\u0011Q\u0013\t\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002\u001a\u0006-\u0015\u0011!a\u0001\u0003\u000b\u000b1\u0001\u001f\u00132\u0011)\ti*!\u0006\u0002\u0002\u0013\u0005\u0013qT\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0015\t\u0007\u0003G\u000bI+!%\u000e\u0005\u0005\u0015&bAAT!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0016Q\u0015\u0002\t\u0013R,'/\u0019;pe\"Q\u0011qVA\u000b\u0003\u0003%\t!!-\u0002\u0011\r\fg.R9vC2$B!a-\u0002:B\u0019q\"!.\n\u0007\u0005]\u0006CA\u0004C_>dW-\u00198\t\u0015\u0005e\u0015QVA\u0001\u0002\u0004\t\t\n\u0003\u0006\u0002>\u0006U\u0011\u0011!C!\u0003\u007f\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u000bC!\"a1\u0002\u0016\u0005\u0005I\u0011IAc\u0003!!xn\u0015;sS:<G#\u0001.\t\u0015\u0005%\u0017QCA\u0001\n\u0003\nY-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003g\u000bi\r\u0003\u0006\u0002\u001a\u0006\u001d\u0017\u0011!a\u0001\u0003#;\u0011\"!5J\u0003\u0003EI!a5\u0002\u001b\u0015\u0013(o\u001c:D_VtG/\u001a:t!\u0011\ti%!6\u0007\u0013\u0005]\u0011*!A\t\n\u0005]7CBAk\u00033\f\t\u0003\u0005\u0006\u0002\\\u0006\u0005\u0018QFA\u0017\u0003\u0017j!!!8\u000b\u0007\u0005}\u0007#A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0018Q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\r\u0002V\u0012\u0005\u0011q\u001d\u000b\u0003\u0003'D!\"a1\u0002V\u0006\u0005IQIAc\u0011%I\u0013Q[A\u0001\n\u0003\u000bi\u000f\u0006\u0004\u0002L\u0005=\u0018\u0011\u001f\u0005\t\u0003S\tY\u000f1\u0001\u0002.!A\u0011\u0011IAv\u0001\u0004\ti\u0003\u0003\u0006\u0002v\u0006U\u0017\u0011!CA\u0003o\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002z\n\u0005\u0001\u0003B\bE\u0003w\u0004raDA\u007f\u0003[\ti#C\u0002\u0002\u0000B\u0011a\u0001V;qY\u0016\u0014\u0004B\u0003B\u0002\u0003g\f\t\u00111\u0001\u0002L\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t\u001d\u0011Q[A\u0001\n\u0013\u0011I!A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0006!\rY&QB\u0005\u0004\u0005\u001fa&AB(cU\u0016\u001cGO\u0002\u0004\u0003\u0014%#%Q\u0003\u0002\u000b5J\u001au.\u001e8uKJ\u001c8c\u0002B\t\u001d\u0005m\u0011\u0011\u0005\u0005\f\u00053\u0011\tB!f\u0001\n\u0003\u0011Y\"\u0001\u0003hK>lWCAA&\u0011-\u0011yB!\u0005\u0003\u0012\u0003\u0006I!a\u0013\u0002\u000b\u001d,w.\u001c\u0011\t\u0017\t\r\"\u0011\u0003BK\u0002\u0013\u0005\u00111F\u0001\u0006i>$\u0018\r\u001c\u0005\f\u0005O\u0011\tB!E!\u0002\u0013\ti#\u0001\u0004u_R\fG\u000e\t\u0005\b3\tEA\u0011\u0001B\u0016)\u0019\u0011iCa\f\u00032A!\u0011Q\nB\t\u0011!\u0011IB!\u000bA\u0002\u0005-\u0003\u0002\u0003B\u0012\u0005S\u0001\r!!\f\t\u0015\u0005U#\u0011CA\u0001\n\u0003\u0011)\u0004\u0006\u0004\u0003.\t]\"\u0011\b\u0005\u000b\u00053\u0011\u0019\u0004%AA\u0002\u0005-\u0003B\u0003B\u0012\u0005g\u0001\n\u00111\u0001\u0002.!Q\u0011q\fB\t#\u0003%\tA!\u0010\u0016\u0005\t}\"\u0006BA&\u0003KB!\"!\u001f\u0003\u0012E\u0005I\u0011AA1\u0011%\tiH!\u0005\u0002\u0002\u0013\u0005\u0013\f\u0003\u0006\u0002\u0002\nE\u0011\u0011!C\u0001\u0003\u0007C!\"!$\u0003\u0012\u0005\u0005I\u0011\u0001B%)\u0011\t\tJa\u0013\t\u0015\u0005e%qIA\u0001\u0002\u0004\t)\t\u0003\u0006\u0002\u001e\nE\u0011\u0011!C!\u0003?C!\"a,\u0003\u0012\u0005\u0005I\u0011\u0001B))\u0011\t\u0019La\u0015\t\u0015\u0005e%qJA\u0001\u0002\u0004\t\t\n\u0003\u0006\u0002>\nE\u0011\u0011!C!\u0003\u007fC!\"a1\u0003\u0012\u0005\u0005I\u0011IAc\u0011)\tIM!\u0005\u0002\u0002\u0013\u0005#1\f\u000b\u0005\u0003g\u0013i\u0006\u0003\u0006\u0002\u001a\ne\u0013\u0011!a\u0001\u0003#;\u0011B!\u0019J\u0003\u0003EIAa\u0019\u0002\u0015i\u00134i\\;oi\u0016\u00148\u000f\u0005\u0003\u0002N\t\u0015d!\u0003B\n\u0013\u0006\u0005\t\u0012\u0002B4'\u0019\u0011)G!\u001b\u0002\"AQ\u00111\\Aq\u0003\u0017\niC!\f\t\u000fe\u0011)\u0007\"\u0001\u0003nQ\u0011!1\r\u0005\u000b\u0003\u0007\u0014)'!A\u0005F\u0005\u0015\u0007\"C\u0015\u0003f\u0005\u0005I\u0011\u0011B:)\u0019\u0011iC!\u001e\u0003x!A!\u0011\u0004B9\u0001\u0004\tY\u0005\u0003\u0005\u0003$\tE\u0004\u0019AA\u0017\u0011)\t)P!\u001a\u0002\u0002\u0013\u0005%1\u0010\u000b\u0005\u0005{\u0012\t\t\u0005\u0003\u0010\t\n}\u0004cB\b\u0002~\u0006-\u0013Q\u0006\u0005\u000b\u0005\u0007\u0011I(!AA\u0002\t5\u0002B\u0003B\u0004\u0005K\n\t\u0011\"\u0003\u0003\n\u00191!qQ%E\u0005\u0013\u0013!BW\u001aD_VtG/\u001a:t'\u001d\u0011)IDA\u000e\u0003CA1B!\u0007\u0003\u0006\nU\r\u0011\"\u0001\u0003\u001c!Y!q\u0004BC\u0005#\u0005\u000b\u0011BA&\u0011-\u0011\tJ!\"\u0003\u0016\u0004%\tAa\u0007\u0002\u0007\u0011$x\rC\u0006\u0003\u0016\n\u0015%\u0011#Q\u0001\n\u0005-\u0013\u0001\u00023uO\u0002B1Ba\t\u0003\u0006\nU\r\u0011\"\u0001\u0002,!Y!q\u0005BC\u0005#\u0005\u000b\u0011BA\u0017\u0011\u001dI\"Q\u0011C\u0001\u0005;#\u0002Ba(\u0003\"\n\r&Q\u0015\t\u0005\u0003\u001b\u0012)\t\u0003\u0005\u0003\u001a\tm\u0005\u0019AA&\u0011!\u0011\tJa'A\u0002\u0005-\u0003\u0002\u0003B\u0012\u00057\u0003\r!!\f\t\u0015\u0005U#QQA\u0001\n\u0003\u0011I\u000b\u0006\u0005\u0003 \n-&Q\u0016BX\u0011)\u0011IBa*\u0011\u0002\u0003\u0007\u00111\n\u0005\u000b\u0005#\u00139\u000b%AA\u0002\u0005-\u0003B\u0003B\u0012\u0005O\u0003\n\u00111\u0001\u0002.!Q\u0011q\fBC#\u0003%\tA!\u0010\t\u0015\u0005e$QQI\u0001\n\u0003\u0011i\u0004\u0003\u0006\u00038\n\u0015\u0015\u0013!C\u0001\u0003C\nabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u0002~\t\u0015\u0015\u0011!C!3\"Q\u0011\u0011\u0011BC\u0003\u0003%\t!a!\t\u0015\u00055%QQA\u0001\n\u0003\u0011y\f\u0006\u0003\u0002\u0012\n\u0005\u0007BCAM\u0005{\u000b\t\u00111\u0001\u0002\u0006\"Q\u0011Q\u0014BC\u0003\u0003%\t%a(\t\u0015\u0005=&QQA\u0001\n\u0003\u00119\r\u0006\u0003\u00024\n%\u0007BCAM\u0005\u000b\f\t\u00111\u0001\u0002\u0012\"Q\u0011Q\u0018BC\u0003\u0003%\t%a0\t\u0015\u0005\r'QQA\u0001\n\u0003\n)\r\u0003\u0006\u0002J\n\u0015\u0015\u0011!C!\u0005#$B!a-\u0003T\"Q\u0011\u0011\u0014Bh\u0003\u0003\u0005\r!!%\b\u0013\t]\u0017*!A\t\n\te\u0017A\u0003.4\u0007>,h\u000e^3sgB!\u0011Q\nBn\r%\u00119)SA\u0001\u0012\u0013\u0011in\u0005\u0004\u0003\\\n}\u0017\u0011\u0005\t\r\u00037\u0014\t/a\u0013\u0002L\u00055\"qT\u0005\u0005\u0005G\fiNA\tBEN$(/Y2u\rVt7\r^5p]NBq!\u0007Bn\t\u0003\u00119\u000f\u0006\u0002\u0003Z\"Q\u00111\u0019Bn\u0003\u0003%)%!2\t\u0013%\u0012Y.!A\u0005\u0002\n5H\u0003\u0003BP\u0005_\u0014\tPa=\t\u0011\te!1\u001ea\u0001\u0003\u0017B\u0001B!%\u0003l\u0002\u0007\u00111\n\u0005\t\u0005G\u0011Y\u000f1\u0001\u0002.!Q\u0011Q\u001fBn\u0003\u0003%\tIa>\u0015\t\te8\u0011\u0001\t\u0005\u001f\u0011\u0013Y\u0010E\u0005\u0010\u0005{\fY%a\u0013\u0002.%\u0019!q \t\u0003\rQ+\b\u000f\\34\u0011)\u0011\u0019A!>\u0002\u0002\u0003\u0007!q\u0014\u0005\u000b\u0005\u000f\u0011Y.!A\u0005\n\t%aABB\u0004\u0013\u0012\u0019IAA\u0006[eY\u000bG.\u001b3bi>\u00148#BB\u0003\u0005\u0017Y\u0003b\u0003B\r\u0007\u000b\u0011\t\u0011)A\u0005\u0003\u000bC1ba\u0004\u0004\u0006\t\u0005\t\u0015!\u0003\u0003.\u0005A1m\\;oi\u0016\u00148\u000fC\u0004\u001a\u0007\u000b!\taa\u0005\u0015\r\rU1qCB\r!\u0011\tie!\u0002\t\u0011\te1\u0011\u0003a\u0001\u0003\u000bC\u0001ba\u0004\u0004\u0012\u0001\u0007!Q\u0006\u0005\t\u0007;\u0019)\u0001\"\u0011\u0004 \u0005Aa/\u00197jI\u0006$X\rF\u0002 \u0007CA\u0001ba\t\u0004\u001c\u0001\u00071QE\u0001\u0003g\u001a\u00042!MB\u0014\u0013\r\u0019IC\r\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u0011\r52Q\u0001C!\u0007_\tQa\u00197pg\u0016$\"a!\r\u0011\u0007=\u0019\u0019$C\u0002\u00046A\u0011A!\u00168ji\u001a11\u0011H%\u0005\u0007w\u00111BW\u001aWC2LG-\u0019;peN)1q\u0007B\u0006W!Y!\u0011DB\u001c\u0005\u0003\u0005\u000b\u0011BAC\u0011-\u0011\tja\u000e\u0003\u0002\u0003\u0006I!!\"\t\u0017\r\r3q\u0007B\u0001B\u0003%1QI\u0001\b[&tG)\u0019;f!\u0011\u00199e!\u0014\u000e\u0005\r%#bAB&=\u0006!Q\u000f^5m\u0013\u0011\u0019ye!\u0013\u0003\t\u0011\u000bG/\u001a\u0005\f\u0007'\u001a9D!A!\u0002\u0013\u0019)%A\u0004nCb$\u0015\r^3\t\u0017\r=1q\u0007B\u0001B\u0003%!q\u0014\u0005\b3\r]B\u0011AB-)1\u0019Yf!\u0018\u0004`\r\u000541MB3!\u0011\tiea\u000e\t\u0011\te1q\u000ba\u0001\u0003\u000bC\u0001B!%\u0004X\u0001\u0007\u0011Q\u0011\u0005\t\u0007\u0007\u001a9\u00061\u0001\u0004F!A11KB,\u0001\u0004\u0019)\u0005\u0003\u0005\u0004\u0010\r]\u0003\u0019\u0001BP\u0011%\u0019Iga\u000eC\u0002\u0013%a$\u0001\u0006eCR,')\u001a4pe\u0016D\u0001b!\u001c\u00048\u0001\u0006IaH\u0001\fI\u0006$XMQ3g_J,\u0007\u0005C\u0005\u0004r\r]\"\u0019!C\u0005=\u0005IA-\u0019;f\u0003\u001a$XM\u001d\u0005\t\u0007k\u001a9\u0004)A\u0005?\u0005QA-\u0019;f\u0003\u001a$XM\u001d\u0011\t\u0011\ru1q\u0007C!\u0007s\"2aHB>\u0011!\u0019\u0019ca\u001eA\u0002\r\u0015\u0002\u0002CB\u0017\u0007o!\tea\f\u0007\r\r\u0005\u0015\nABB\u0005YQ\u0016J\u001c3fqZ\u000bG.\u001b3bi>\u0014h)Y2u_JL8cAB@7!9\u0011da \u0005\u0002\r\u001dECABE!\u0011\tiea \t\u0011u\u0019yH1A\u0005BeCqaJB@A\u0003%!\fC\u0004*\u0007\u007f\"\te!%\u0015\u000f-\u001a\u0019j!&\u0004\u0018\"1qfa$A\u0002ABaaOBH\u0001\u0004a\u0004B\u0002\"\u0004\u0010\u0002\u00071\t")
public class IndexValidatorFactory
implements SimpleFeatureValidatorFactory {
    private final String name = IndexValidatorFactory$.MODULE$.Name();

    public static Logger logger() {
        return IndexValidatorFactory$.MODULE$.logger();
    }

    public static String Z3TotalCounter() {
        return IndexValidatorFactory$.MODULE$.Z3TotalCounter();
    }

    public static String Z2TotalCounter() {
        return IndexValidatorFactory$.MODULE$.Z2TotalCounter();
    }

    public static String DtgBoundsCounter() {
        return IndexValidatorFactory$.MODULE$.DtgBoundsCounter();
    }

    public static String DtgNullCounter() {
        return IndexValidatorFactory$.MODULE$.DtgNullCounter();
    }

    public static String GeomBoundsCounter() {
        return IndexValidatorFactory$.MODULE$.GeomBoundsCounter();
    }

    public static String GeomNullCounter() {
        return IndexValidatorFactory$.MODULE$.GeomNullCounter();
    }

    public static String Name() {
        return IndexValidatorFactory$.MODULE$.Name();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SimpleFeatureValidator apply(SimpleFeatureType sft, ConverterMetrics metrics, Option<String> config) {
        SimpleFeatureValidator simpleFeatureValidator;
        int geom = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        int dtg = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }));
        Seq enabled = (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends IndexId, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.mode().write() ? A1.name().toLowerCase(Locale.US) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(IndexId x1) {
                IndexId indexId = x1;
                boolean bl = indexId.mode().write();
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (enabled.contains((Object)"z3") || enabled.contains((Object)"xz3") || enabled.isEmpty() && geom != -1 && dtg != -1) {
            Date minDate = Date.from(BinnedTime$.MODULE$.ZMinDate().toInstant());
            Date maxDate = Date.from(BinnedTime$.MODULE$.maxDate(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).toInstant());
            ErrorCounters geom2 = new ErrorCounters(metrics.counter(IndexValidatorFactory$.MODULE$.GeomNullCounter()), metrics.counter(IndexValidatorFactory$.MODULE$.GeomBoundsCounter()));
            ErrorCounters dtg2 = new ErrorCounters(metrics.counter(IndexValidatorFactory$.MODULE$.DtgNullCounter()), metrics.counter(IndexValidatorFactory$.MODULE$.DtgBoundsCounter()));
            Z3Counters counters = new Z3Counters(geom2, dtg2, metrics.counter(IndexValidatorFactory$.MODULE$.Z3TotalCounter()));
            simpleFeatureValidator = new Z3Validator(geom, dtg, minDate, maxDate, counters);
        } else if (enabled.contains((Object)"z2") || enabled.contains((Object)"xz2") || enabled.isEmpty() && geom != -1) {
            ErrorCounters geom3 = new ErrorCounters(metrics.counter(IndexValidatorFactory$.MODULE$.GeomNullCounter()), metrics.counter(IndexValidatorFactory$.MODULE$.GeomBoundsCounter()));
            Z2Counters counters = new Z2Counters(geom3, metrics.counter(IndexValidatorFactory$.MODULE$.Z2TotalCounter()));
            simpleFeatureValidator = new Z2Validator(geom, counters);
        } else {
            simpleFeatureValidator = package$NoValidator$.MODULE$;
        }
        return simpleFeatureValidator;
    }

    public static class Z3Counters
    implements Product,
    Serializable {
        private final ErrorCounters geom;
        private final ErrorCounters dtg;
        private final Counter total;

        public ErrorCounters geom() {
            return this.geom;
        }

        public ErrorCounters dtg() {
            return this.dtg;
        }

        public Counter total() {
            return this.total;
        }

        public Z3Counters copy(ErrorCounters geom, ErrorCounters dtg, Counter total) {
            return new Z3Counters(geom, dtg, total);
        }

        public ErrorCounters copy$default$1() {
            return this.geom();
        }

        public ErrorCounters copy$default$2() {
            return this.dtg();
        }

        public Counter copy$default$3() {
            return this.total();
        }

        public String productPrefix() {
            return "Z3Counters";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = this.total();
                    break;
                }
                case 1: {
                    object = this.dtg();
                    break;
                }
                case 0: {
                    object = this.geom();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Z3Counters;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Z3Counters)) return false;
            boolean bl = true;
            if (!bl) return false;
            Z3Counters z3Counters = (Z3Counters)x$1;
            ErrorCounters errorCounters = this.geom();
            ErrorCounters errorCounters2 = z3Counters.geom();
            if (errorCounters == null) {
                if (errorCounters2 != null) {
                    return false;
                }
            } else if (!((Object)errorCounters).equals(errorCounters2)) return false;
            ErrorCounters errorCounters3 = this.dtg();
            ErrorCounters errorCounters4 = z3Counters.dtg();
            if (errorCounters3 == null) {
                if (errorCounters4 != null) {
                    return false;
                }
            } else if (!((Object)errorCounters3).equals(errorCounters4)) return false;
            Counter counter = this.total();
            Counter counter2 = z3Counters.total();
            if (counter == null) {
                if (counter2 != null) {
                    return false;
                }
            } else if (!counter.equals(counter2)) return false;
            if (!z3Counters.canEqual(this)) return false;
            return true;
        }

        public Z3Counters(ErrorCounters geom, ErrorCounters dtg, Counter total) {
            this.geom = geom;
            this.dtg = dtg;
            this.total = total;
            Product.class.$init$((Product)this);
        }
    }

    public static class Z2Counters
    implements Product,
    Serializable {
        private final ErrorCounters geom;
        private final Counter total;

        public ErrorCounters geom() {
            return this.geom;
        }

        public Counter total() {
            return this.total;
        }

        public Z2Counters copy(ErrorCounters geom, Counter total) {
            return new Z2Counters(geom, total);
        }

        public ErrorCounters copy$default$1() {
            return this.geom();
        }

        public Counter copy$default$2() {
            return this.total();
        }

        public String productPrefix() {
            return "Z2Counters";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.total();
                    break;
                }
                case 0: {
                    object = this.geom();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Z2Counters;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Z2Counters)) return false;
            boolean bl = true;
            if (!bl) return false;
            Z2Counters z2Counters = (Z2Counters)x$1;
            ErrorCounters errorCounters = this.geom();
            ErrorCounters errorCounters2 = z2Counters.geom();
            if (errorCounters == null) {
                if (errorCounters2 != null) {
                    return false;
                }
            } else if (!((Object)errorCounters).equals(errorCounters2)) return false;
            Counter counter = this.total();
            Counter counter2 = z2Counters.total();
            if (counter == null) {
                if (counter2 != null) {
                    return false;
                }
            } else if (!counter.equals(counter2)) return false;
            if (!z2Counters.canEqual(this)) return false;
            return true;
        }

        public Z2Counters(ErrorCounters geom, Counter total) {
            this.geom = geom;
            this.total = total;
            Product.class.$init$((Product)this);
        }
    }

    public static class Z3Validator
    implements SimpleFeatureValidator {
        private final int geom;
        private final int dtg;
        private final Date minDate;
        private final Date maxDate;
        private final Z3Counters counters;
        private final String dateBefore;
        private final String dateAfter;

        private String dateBefore() {
            return this.dateBefore;
        }

        private String dateAfter() {
            return this.dateAfter;
        }

        @Override
        public String validate(SimpleFeature sf) {
            String string;
            Date d = (Date)sf.getAttribute(this.dtg);
            Geometry g = (Geometry)sf.getAttribute(this.geom);
            String error = null;
            if (g == null) {
                this.counters.geom().missing().inc();
                error = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, package$Errors$.MODULE$.GeomNull()}));
            } else if (!IndexValidatorFactory$.MODULE$.org$locationtech$geomesa$convert2$validators$IndexValidatorFactory$$WholeWorldEnvelope().contains(g.getEnvelopeInternal())) {
                this.counters.geom().bounds().inc();
                error = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, package$Errors$.MODULE$.GeomBounds()}));
            }
            if (d == null) {
                this.counters.dtg().missing().inc();
                error = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, package$Errors$.MODULE$.DateNull()}));
            } else if (d.before(this.minDate)) {
                this.counters.dtg().bounds().inc();
                error = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, this.dateBefore()}));
            } else if (d.after(this.maxDate)) {
                this.counters.dtg().bounds().inc();
                error = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, this.dateAfter()}));
            }
            if (error == null) {
                string = null;
            } else {
                this.counters.total().inc();
                string = error.substring(6);
            }
            return string;
        }

        @Override
        public void close() {
        }

        public Z3Validator(int geom, int dtg, Date minDate, Date maxDate, Z3Counters counters) {
            this.geom = geom;
            this.dtg = dtg;
            this.minDate = minDate;
            this.maxDate = maxDate;
            this.counters = counters;
            this.dateBefore = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date is before minimum indexable date (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{minDate}));
            this.dateAfter = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date is after maximum indexable date (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{maxDate}));
        }
    }

    public static class Z2Validator
    implements SimpleFeatureValidator {
        private final int geom;
        private final Z2Counters counters;

        @Override
        public String validate(SimpleFeature sf) {
            String string;
            Geometry g = (Geometry)sf.getAttribute(this.geom);
            if (g == null) {
                this.counters.geom().missing().inc();
                this.counters.total().inc();
                string = package$Errors$.MODULE$.GeomNull();
            } else if (IndexValidatorFactory$.MODULE$.org$locationtech$geomesa$convert2$validators$IndexValidatorFactory$$WholeWorldEnvelope().contains(g.getEnvelopeInternal())) {
                string = null;
            } else {
                this.counters.geom().bounds().inc();
                this.counters.total().inc();
                string = package$Errors$.MODULE$.GeomBounds();
            }
            return string;
        }

        @Override
        public void close() {
        }

        public Z2Validator(int geom, Z2Counters counters) {
            this.geom = geom;
            this.counters = counters;
        }
    }

    public static class ErrorCounters
    implements Product,
    Serializable {
        private final Counter missing;
        private final Counter bounds;

        public Counter missing() {
            return this.missing;
        }

        public Counter bounds() {
            return this.bounds;
        }

        public ErrorCounters copy(Counter missing, Counter bounds) {
            return new ErrorCounters(missing, bounds);
        }

        public Counter copy$default$1() {
            return this.missing();
        }

        public Counter copy$default$2() {
            return this.bounds();
        }

        public String productPrefix() {
            return "ErrorCounters";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Counter counter;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    counter = this.bounds();
                    break;
                }
                case 0: {
                    counter = this.missing();
                }
            }
            return counter;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ErrorCounters;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ErrorCounters)) return false;
            boolean bl = true;
            if (!bl) return false;
            ErrorCounters errorCounters = (ErrorCounters)x$1;
            Counter counter = this.missing();
            Counter counter2 = errorCounters.missing();
            if (counter == null) {
                if (counter2 != null) {
                    return false;
                }
            } else if (!counter.equals(counter2)) return false;
            Counter counter3 = this.bounds();
            Counter counter4 = errorCounters.bounds();
            if (counter3 == null) {
                if (counter4 != null) {
                    return false;
                }
            } else if (!counter3.equals(counter4)) return false;
            if (!errorCounters.canEqual(this)) return false;
            return true;
        }

        public ErrorCounters(Counter missing, Counter bounds) {
            this.missing = missing;
            this.bounds = bounds;
            Product.class.$init$((Product)this);
        }
    }

    public static class ZIndexValidatorFactory
    extends IndexValidatorFactory {
        private final String name;

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public SimpleFeatureValidator apply(SimpleFeatureType sft, ConverterMetrics metrics, Option<String> config) {
            BoxedUnit boxedUnit;
            if (IndexValidatorFactory$.MODULE$.logger().underlying().isWarnEnabled()) {
                IndexValidatorFactory$.MODULE$.logger().underlying().warn("'z-index' validator is deprecated, using 'index' instead");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return super.apply(sft, metrics, config);
        }

        public ZIndexValidatorFactory() {
            this.name = "z-index";
        }
    }
}

