/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.linsol.qr;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.decomposition.TriangularSolver_DDRM;
import org.ejml.dense.row.decomposition.qr.QRDecompositionHouseholderColumn_DDRM;
import org.ejml.dense.row.decomposition.qr.QrHelperFunctions_DDRM;
import org.ejml.dense.row.linsol.LinearSolverAbstract_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;

public class LinearSolverQrHouseCol_DDRM
extends LinearSolverAbstract_DDRM {
    private QRDecompositionHouseholderColumn_DDRM decomposer;
    private DMatrixRMaj a = new DMatrixRMaj(1, 1);
    private DMatrixRMaj temp = new DMatrixRMaj(1, 1);
    protected int maxRows = -1;
    protected int maxCols = -1;
    private double[][] QR;
    private DMatrixRMaj R = new DMatrixRMaj(1, 1);
    private double[] gammas;

    public LinearSolverQrHouseCol_DDRM() {
        this.decomposer = new QRDecompositionHouseholderColumn_DDRM();
    }

    public void setMaxSize(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
    }

    public boolean setA(DMatrixRMaj A) {
        if (A.numRows < A.numCols) {
            throw new IllegalArgumentException("Can't solve for wide systems.  More variables than equations.");
        }
        if (A.numRows > this.maxRows || A.numCols > this.maxCols) {
            this.setMaxSize(A.numRows, A.numCols);
        }
        this.R.reshape(A.numCols, A.numCols);
        this.a.reshape(A.numRows, 1);
        this.temp.reshape(A.numRows, 1);
        this._setA(A);
        if (!this.decomposer.decompose(A)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        this.decomposer.getR(this.R, true);
        return true;
    }

    public double quality() {
        return SpecializedOps_DDRM.qualityTriangular((DMatrixD1)this.R);
    }

    public void solve(DMatrixRMaj B, DMatrixRMaj X) {
        if (X.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + X.numRows + " expected = " + this.numCols);
        }
        if (B.numRows != this.numRows || B.numCols != X.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int BnumCols = B.numCols;
        for (int colB = 0; colB < BnumCols; ++colB) {
            int i;
            for (i = 0; i < this.numRows; ++i) {
                this.a.data[i] = B.data[i * BnumCols + colB];
            }
            for (int n = 0; n < this.numCols; ++n) {
                double[] u = this.QR[n];
                double vv = u[n];
                u[n] = 1.0;
                QrHelperFunctions_DDRM.rank1UpdateMultR(this.a, u, this.gammas[n], 0, n, this.numRows, this.temp.data);
                u[n] = vv;
            }
            TriangularSolver_DDRM.solveU(this.R.data, this.a.data, this.numCols);
            for (i = 0; i < this.numCols; ++i) {
                X.data[i * X.numCols + colB] = this.a.data[i];
            }
        }
    }

    public boolean modifiesA() {
        return false;
    }

    public boolean modifiesB() {
        return false;
    }

    public QRDecomposition<DMatrixRMaj> getDecomposition() {
        return this.decomposer;
    }
}

