/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet.io;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.locationtech.geomesa.parquet.io.SimpleFeatureParquetSchema;
import org.locationtech.geomesa.parquet.io.SimpleFeatureParquetSchema$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureWriteSupport$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureWriteSupport$MultiPolygonAttributeWriter$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureWriteSupport$SimpleFeatureWriter$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0015Mb\u0001B\u0001\u0003\u00015\u0011\u0011dU5na2,g)Z1ukJ,wK]5uKN+\b\u000f]8si*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\u000fA\f'/];fi*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002E\u0002\u0010/ei\u0011\u0001\u0005\u0006\u0003#I\t1!\u00199j\u0015\t\u0019B#\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003\u000bUQ!A\u0006\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tA\u0002C\u0001\u0007Xe&$XmU;qa>\u0014H\u000f\u0005\u0002\u001bC5\t1D\u0003\u0002\u001d;\u000511/[7qY\u0016T!AH\u0010\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0001EC\u0001\b_B,gnZ5t\u0013\t\u00113DA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\u0006I\u0001!\t!J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"a\n\u0001\u000e\u0003\tA\u0011\"\u000b\u0001A\u0002\u0003\u0007I\u0011\u0002\u0016\u0002\r]\u0014\u0018\u000e^3s+\u0005Y\u0003C\u0001\u0017;\u001d\t9SfB\u0003/\u0005!\u0005q&A\rTS6\u0004H.\u001a$fCR,(/Z,sSR,7+\u001e9q_J$\bCA\u00141\r\u0015\t!\u0001#\u00012'\t\u0001$\u0007\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VM\u001a\u0005\u0006IA\"\t!\u000f\u000b\u0002_\u0019!1\b\r\u0001=\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s'\tQ$\u0007\u0003\u0005?u\t\u0005\t\u0015!\u0003@\u0003)\tG\u000f\u001e:jEV$Xm\u001d\t\u0004g\u0001\u0013\u0015BA!5\u0005\u0015\t%O]1z!\r\u0019EIM\u0007\u0002a\u0019)Q\tMA\u0001\r\ny\u0011\t\u001e;sS\n,H/Z,sSR,'/\u0006\u0002H7N\u0011AI\r\u0005\t\u0013\u0012\u0013\t\u0011)A\u0005\u0015\u0006!a.Y7f!\tYeJ\u0004\u00024\u0019&\u0011Q\nN\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002Ni!A!\u000b\u0012B\u0001B\u0003%1+A\u0003j]\u0012,\u0007\u0010\u0005\u00024)&\u0011Q\u000b\u000e\u0002\u0004\u0013:$\b\"\u0002\u0013E\t\u00039Fc\u0001-bEB\u00191\tR-\u0011\u0005i[F\u0002\u0001\u0003\u00069\u0012\u0013\r!\u0018\u0002\u0002)F\u0011aL\r\t\u0003g}K!\u0001\u0019\u001b\u0003\u000f9{G\u000f[5oO\")\u0011J\u0016a\u0001\u0015\")!K\u0016a\u0001'\")A\r\u0012C\u0001K\u0006)\u0011\r\u001d9msR\u0019a-[9\u0011\u0005M:\u0017B\u000155\u0005\u0011)f.\u001b;\t\u000b)\u001c\u0007\u0019A6\u0002\u0011\r|gn];nKJ\u0004\"\u0001\\8\u000e\u00035T!!\u00058\u000b\u0005\r!\u0012B\u00019n\u00059\u0011VmY8sI\u000e{gn];nKJDQA]2A\u0002e\u000bQA^1mk\u0016DQ\u0001\u001e#\u0007\u0012U\fQa\u001e:ji\u0016$2A\u001a<x\u0011\u0015Q7\u000f1\u0001l\u0011\u0015\u00118\u000f1\u0001Z\u0011\u0015!#\b\"\u0001z)\tQ8\u0010\u0005\u0002Du!)a\b\u001fa\u0001\u007f!9QP\u000fb\u0001\n\u0013q\u0018\u0001\u00024jIN,\u0012a \t\u0004\u0007\u0006\u0005aABA\u0002a\u0001\t)AA\u0005GS\u0012<&/\u001b;feN!\u0011\u0011AA\u0004!\r\u0019EI\u0013\u0005\n%\u0006\u0005!\u0011!Q\u0001\nMCq\u0001JA\u0001\t\u0003\ti\u0001F\u0002\u0000\u0003\u001fAaAUA\u0006\u0001\u0004\u0019\u0006b\u0002;\u0002\u0002\u0011E\u00131\u0003\u000b\u0006M\u0006U\u0011q\u0003\u0005\u0007U\u0006E\u0001\u0019A6\t\rI\f\t\u00021\u0001K\u0011\u001d\tYB\u000fQ\u0001\n}\fQAZ5eg\u0002Ba\u0001\u001e\u001e\u0005\u0002\u0005}A#\u00024\u0002\"\u0005\r\u0002B\u00026\u0002\u001e\u0001\u00071\u000e\u0003\u0004s\u0003;\u0001\r!G\u0004\b\u0003O\u0001\u0004\u0012AA\u0015\u0003M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s!\r\u0019\u00151\u0006\u0004\u0007wAB\t!!\f\u0014\u0007\u0005-\"\u0007C\u0004%\u0003W!\t!!\r\u0015\u0005\u0005%\u0002b\u00023\u0002,\u0011\u0005\u0011Q\u0007\u000b\u0004u\u0006]\u0002\u0002CA\u001d\u0003g\u0001\r!a\u000f\u0002\u0007M4G\u000fE\u0002\u001b\u0003{I1!a\u0010\u001c\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\b\u0003\u0007\u0002D\u0011AA#\u0003%\tG\u000f\u001e:jEV$X\r\u0006\u0004\u0002H\u0005e\u0013\u0011\u000e\u0019\u0005\u0003\u0013\ni\u0005\u0005\u0003D\t\u0006-\u0003c\u0001.\u0002N\u0011a\u0011qJA!\u0003\u0003\u0005\tQ!\u0001\u0002R\t\u0019q\fJ\u0019\u0012\u0007y\u000b\u0019\u0006E\u00024\u0003+J1!a\u00165\u0005\r\te.\u001f\u0005\t\u00037\n\t\u00051\u0001\u0002^\u0005QA-Z:de&\u0004Ho\u001c:\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019\u001e\u0003\u0011!\u0018\u0010]3\n\t\u0005\u001d\u0014\u0011\r\u0002\u0014\u0003R$(/\u001b2vi\u0016$Um]2sSB$xN\u001d\u0005\u0007%\u0006\u0005\u0003\u0019A*\t\u000f\u0005\r\u0003\u0007\"\u0001\u0002nQA\u0011qNA=\u0003w\ni\b\r\u0003\u0002r\u0005U\u0004\u0003B\"E\u0003g\u00022AWA;\t1\t9(a\u001b\u0002\u0002\u0003\u0005)\u0011AA)\u0005\ryFE\r\u0005\u0007\u0013\u0006-\u0004\u0019\u0001&\t\rI\u000bY\u00071\u0001T\u0011!\ty(a\u001bA\u0002\u0005\u0005\u0015\u0001\u00032j]\u0012LgnZ:\u0011\r\u0005\r\u00151SAM\u001d\u0011\t))a$\u000f\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#\r\u0003\u0019a$o\\8u}%\tQ'C\u0002\u0002\u0012R\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0006]%aA*fc*\u0019\u0011\u0011\u0013\u001b\u0011\t\u0005m\u0015Q\u0018\b\u0005\u0003;\u000b9L\u0004\u0003\u0002 \u0006Ef\u0002BAQ\u0003[sA!a)\u0002,:!\u0011QUAU\u001d\u0011\t9)a*\n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011bAAX\r\u0005Aa-Z1ukJ,7/\u0003\u0003\u00024\u0006U\u0016!D:fe&\fG.\u001b>bi&|gNC\u0002\u00020\u001aIA!!/\u0002<\u0006QqJ\u00196fGR$\u0016\u0010]3\u000b\t\u0005M\u0016QW\u0005\u0005\u0003\u007f\u000b\tM\u0001\u0006PE*,7\r\u001e+za\u0016TA!!/\u0002<\"9\u0011Q\u0019\u0019\u0005\n\u0005\u001d\u0017\u0001C4f_6,GO]=\u0015\u0011\u0005%\u00171[Ak\u0003/\u0004D!a3\u0002PB!1\tRAg!\rQ\u0016q\u001a\u0003\r\u0003#\f\u0019-!A\u0001\u0002\u000b\u0005\u0011\u0011\u000b\u0002\u0004?\u0012\u001a\u0004BB%\u0002D\u0002\u0007!\n\u0003\u0004S\u0003\u0007\u0004\ra\u0015\u0005\t\u00033\f\u0019\r1\u0001\u0002\u001a\u00069!-\u001b8eS:<gABAoa\u0001\tyN\u0001\u0006ECR,wK]5uKJ\u001cB!a7\u0002bB!1\tRAr!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\fA!\u001e;jY*\u0011\u0011Q^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002r\u0006\u001d(\u0001\u0002#bi\u0016D\u0011\"SAn\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0013I\u000bYN!A!\u0002\u0013\u0019\u0006b\u0002\u0013\u0002\\\u0012\u0005\u0011\u0011 \u000b\u0007\u0003w\fi0a@\u0011\u0007\r\u000bY\u000e\u0003\u0004J\u0003o\u0004\rA\u0013\u0005\u0007%\u0006]\b\u0019A*\t\u000fQ\fY\u000e\"\u0015\u0003\u0004Q)aM!\u0002\u0003\b!1!N!\u0001A\u0002-DqA\u001dB\u0001\u0001\u0004\t\u0019O\u0002\u0004\u0003\fA\u0002!Q\u0002\u0002\r\t>,(\r\\3Xe&$XM]\n\u0005\u0005\u0013\u0011y\u0001\u0005\u0003D\t\nE\u0001\u0003\u0002B\n\u00053i!A!\u0006\u000b\t\t]\u00111^\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u001c\tU!A\u0002#pk\ndW\rC\u0005J\u0005\u0013\u0011\t\u0011)A\u0005\u0015\"I!K!\u0003\u0003\u0002\u0003\u0006Ia\u0015\u0005\bI\t%A\u0011\u0001B\u0012)\u0019\u0011)Ca\n\u0003*A\u00191I!\u0003\t\r%\u0013\t\u00031\u0001K\u0011\u0019\u0011&\u0011\u0005a\u0001'\"9AO!\u0003\u0005R\t5B#\u00024\u00030\tE\u0002B\u00026\u0003,\u0001\u00071\u000eC\u0004s\u0005W\u0001\rA!\u0005\u0007\r\tU\u0002\u0007\u0001B\u001c\u0005-1En\\1u/JLG/\u001a:\u0014\t\tM\"\u0011\b\t\u0005\u0007\u0012\u0013Y\u0004\u0005\u0003\u0003\u0014\tu\u0012\u0002\u0002B \u0005+\u0011QA\u00127pCRD\u0011\"\u0013B\u001a\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0013I\u0013\u0019D!A!\u0002\u0013\u0019\u0006b\u0002\u0013\u00034\u0011\u0005!q\t\u000b\u0007\u0005\u0013\u0012YE!\u0014\u0011\u0007\r\u0013\u0019\u0004\u0003\u0004J\u0005\u000b\u0002\rA\u0013\u0005\u0007%\n\u0015\u0003\u0019A*\t\u000fQ\u0014\u0019\u0004\"\u0015\u0003RQ)aMa\u0015\u0003V!1!Na\u0014A\u0002-DqA\u001dB(\u0001\u0004\u0011YD\u0002\u0004\u0003ZA\u0002!1\f\u0002\u000e\u0013:$XmZ3s/JLG/\u001a:\u0014\t\t]#Q\f\t\u0005\u0007\u0012\u0013y\u0006\u0005\u0003\u0003\u0014\t\u0005\u0014\u0002\u0002B2\u0005+\u0011q!\u00138uK\u001e,'\u000fC\u0005J\u0005/\u0012\t\u0011)A\u0005\u0015\"I!Ka\u0016\u0003\u0002\u0003\u0006Ia\u0015\u0005\bI\t]C\u0011\u0001B6)\u0019\u0011iGa\u001c\u0003rA\u00191Ia\u0016\t\r%\u0013I\u00071\u0001K\u0011\u0019\u0011&\u0011\u000ea\u0001'\"9AOa\u0016\u0005R\tUD#\u00024\u0003x\te\u0004B\u00026\u0003t\u0001\u00071\u000eC\u0004s\u0005g\u0002\rAa\u0018\u0007\r\tu\u0004\u0007\u0001B@\u0005)auN\\4Xe&$XM]\n\u0005\u0005w\u0012\t\t\u0005\u0003D\t\n\r\u0005\u0003\u0002B\n\u0005\u000bKAAa\"\u0003\u0016\t!Aj\u001c8h\u0011%I%1\u0010B\u0001B\u0003%!\nC\u0005S\u0005w\u0012\t\u0011)A\u0005'\"9AEa\u001f\u0005\u0002\t=EC\u0002BI\u0005'\u0013)\nE\u0002D\u0005wBa!\u0013BG\u0001\u0004Q\u0005B\u0002*\u0003\u000e\u0002\u00071\u000bC\u0004u\u0005w\"\tF!'\u0015\u000b\u0019\u0014YJ!(\t\r)\u00149\n1\u0001l\u0011\u001d\u0011(q\u0013a\u0001\u0005\u00073aA!)1\u0001\t\r&\u0001D*ue&twm\u0016:ji\u0016\u00148\u0003\u0002BP\u0003\u000fA\u0011\"\u0013BP\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0013I\u0013yJ!A!\u0002\u0013\u0019\u0006b\u0002\u0013\u0003 \u0012\u0005!1\u0016\u000b\u0007\u0005[\u0013yK!-\u0011\u0007\r\u0013y\n\u0003\u0004J\u0005S\u0003\rA\u0013\u0005\u0007%\n%\u0006\u0019A*\t\u000fQ\u0014y\n\"\u0015\u00036R)aMa.\u0003:\"1!Na-A\u0002-DaA\u001dBZ\u0001\u0004QeA\u0002B_a\u0001\u0011yLA\u0006CsR,7o\u0016:ji\u0016\u00148\u0003\u0002B^\u0005\u0003\u0004Ba\u0011#\u0003DB!1\u0007\u0011Bc!\r\u0019$qY\u0005\u0004\u0005\u0013$$\u0001\u0002\"zi\u0016D\u0011\"\u0013B^\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0013I\u0013YL!A!\u0002\u0013\u0019\u0006b\u0002\u0013\u0003<\u0012\u0005!\u0011\u001b\u000b\u0007\u0005'\u0014)Na6\u0011\u0007\r\u0013Y\f\u0003\u0004J\u0005\u001f\u0004\rA\u0013\u0005\u0007%\n=\u0007\u0019A*\t\u000fQ\u0014Y\f\"\u0015\u0003\\R)aM!8\u0003`\"1!N!7A\u0002-DqA\u001dBm\u0001\u0004\u0011\u0019M\u0002\u0004\u0003dB\u0002!Q\u001d\u0002\u000e\u0005>|G.Z1o/JLG/\u001a:\u0014\t\t\u0005(q\u001d\t\u0005\u0007\u0012\u0013I\u000f\u0005\u0003\u0003\u0014\t-\u0018\u0002\u0002Bw\u0005+\u0011qAQ8pY\u0016\fg\u000eC\u0005J\u0005C\u0014\t\u0011)A\u0005\u0015\"I!K!9\u0003\u0002\u0003\u0006Ia\u0015\u0005\bI\t\u0005H\u0011\u0001B{)\u0019\u00119P!?\u0003|B\u00191I!9\t\r%\u0013\u0019\u00101\u0001K\u0011\u0019\u0011&1\u001fa\u0001'\"9AO!9\u0005R\t}H#\u00024\u0004\u0002\r\r\u0001B\u00026\u0003~\u0002\u00071\u000eC\u0004s\u0005{\u0004\rA!;\u0007\r\r\u001d\u0001\u0007AB\u0005\u0005)a\u0015n\u001d;Xe&$XM]\n\u0005\u0007\u000b\u0019Y\u0001\u0005\u0003D\t\u000e5\u0001#BAs\u0007\u001f\u0011\u0014\u0002BB\t\u0003O\u0014A\u0001T5ti\"I\u0011j!\u0002\u0003\u0002\u0003\u0006IA\u0013\u0005\n%\u000e\u0015!\u0011!Q\u0001\nMC1b!\u0007\u0004\u0006\t\u0005\t\u0015!\u0003\u0002\u001a\u0006Ia/\u00197vKRK\b/\u001a\u0005\bI\r\u0015A\u0011AB\u000f)!\u0019yb!\t\u0004$\r\u0015\u0002cA\"\u0004\u0006!1\u0011ja\u0007A\u0002)CaAUB\u000e\u0001\u0004\u0019\u0006\u0002CB\r\u00077\u0001\r!!'\t\u0015\r%2Q\u0001b\u0001\n\u0013\u0019Y#A\u0007fY\u0016lWM\u001c;Xe&$XM]\u000b\u0002\u0005\"A1qFB\u0003A\u0003%!)\u0001\bfY\u0016lWM\u001c;Xe&$XM\u001d\u0011\t\u000fQ\u001c)\u0001\"\u0015\u00044Q)am!\u000e\u00048!1!n!\rA\u0002-DqA]B\u0019\u0001\u0004\u0019iA\u0002\u0004\u0004<A\u00021Q\b\u0002\n\u001b\u0006\u0004xK]5uKJ\u001cBa!\u000f\u0004@A!1\tRB!!\u0019\t)oa\u00113e%!1QIAt\u0005\ri\u0015\r\u001d\u0005\n\u0013\u000ee\"\u0011!Q\u0001\n)C\u0011BUB\u001d\u0005\u0003\u0005\u000b\u0011B*\t\u0017\r53\u0011\bB\u0001B\u0003%\u0011\u0011T\u0001\bW\u0016LH+\u001f9f\u0011-\u0019Ib!\u000f\u0003\u0002\u0003\u0006I!!'\t\u000f\u0011\u001aI\u0004\"\u0001\u0004TQQ1QKB,\u00073\u001aYf!\u0018\u0011\u0007\r\u001bI\u0004\u0003\u0004J\u0007#\u0002\rA\u0013\u0005\u0007%\u000eE\u0003\u0019A*\t\u0011\r53\u0011\u000ba\u0001\u00033C\u0001b!\u0007\u0004R\u0001\u0007\u0011\u0011\u0014\u0005\u000b\u0007C\u001aID1A\u0005\n\r-\u0012!C6fs^\u0013\u0018\u000e^3s\u0011!\u0019)g!\u000f!\u0002\u0013\u0011\u0015AC6fs^\u0013\u0018\u000e^3sA!Q1\u0011NB\u001d\u0005\u0004%Iaa\u000b\u0002\u0017Y\fG.^3Xe&$XM\u001d\u0005\t\u0007[\u001aI\u0004)A\u0005\u0005\u0006aa/\u00197vK^\u0013\u0018\u000e^3sA!9Ao!\u000f\u0005R\rED#\u00024\u0004t\rU\u0004B\u00026\u0004p\u0001\u00071\u000eC\u0004s\u0007_\u0002\ra!\u0011\u0007\r\re\u0004\u0007AB>\u0005))V/\u001b3Xe&$XM]\n\u0005\u0007o\u001ai\b\u0005\u0003D\t\u000e}\u0004\u0003BAs\u0007\u0003KAaa!\u0002h\n!Q+V%E\u0011%I5q\u000fB\u0001B\u0003%!\nC\u0005S\u0007o\u0012\t\u0011)A\u0005'\"9Aea\u001e\u0005\u0002\r-ECBBG\u0007\u001f\u001b\t\nE\u0002D\u0007oBa!SBE\u0001\u0004Q\u0005B\u0002*\u0004\n\u0002\u00071\u000bC\u0004u\u0007o\"\tf!&\u0015\u000b\u0019\u001c9j!'\t\r)\u001c\u0019\n1\u0001l\u0011\u001d\u001181\u0013a\u0001\u0007\u007f2aa!(1\u0001\r}%\u0001\u0006)pS:$\u0018\t\u001e;sS\n,H/Z,sSR,'o\u0005\u0003\u0004\u001c\u000e\u0005\u0006\u0003B\"E\u0007G\u0003Ba!*\u000406\u00111q\u0015\u0006\u0005\u0007S\u001bY+\u0001\u0003hK>l'bABW\u0011\u0005\u0019!\u000e^:\n\t\rE6q\u0015\u0002\u0006!>Lg\u000e\u001e\u0005\n\u0013\u000em%\u0011!Q\u0001\n)C\u0011BUBN\u0005\u0003\u0005\u000b\u0011B*\t\u000f\u0011\u001aY\n\"\u0001\u0004:R111XB_\u0007\u007f\u00032aQBN\u0011\u0019I5q\u0017a\u0001\u0015\"1!ka.A\u0002MCq\u0001^BN\t\u0003\u001a\u0019\rF\u0003g\u0007\u000b\u001c9\r\u0003\u0004k\u0007\u0003\u0004\ra\u001b\u0005\be\u000e\u0005\u0007\u0019ABR\r\u0019\u0019Y\r\r\u0001\u0004N\nIB*\u001b8f'R\u0014\u0018N\\4BiR\u0014\u0018NY;uK^\u0013\u0018\u000e^3s'\u0011\u0019Ima4\u0011\t\r#5\u0011\u001b\t\u0005\u0007K\u001b\u0019.\u0003\u0003\u0004V\u000e\u001d&A\u0003'j]\u0016\u001cFO]5oO\"I\u0011j!3\u0003\u0002\u0003\u0006IA\u0013\u0005\n%\u000e%'\u0011!Q\u0001\nMCq\u0001JBe\t\u0003\u0019i\u000e\u0006\u0004\u0004`\u000e\u000581\u001d\t\u0004\u0007\u000e%\u0007BB%\u0004\\\u0002\u0007!\n\u0003\u0004S\u00077\u0004\ra\u0015\u0005\bi\u000e%G\u0011IBt)\u001517\u0011^Bv\u0011\u0019Q7Q\u001da\u0001W\"9!o!:A\u0002\rEgABBxa\u0001\u0019\tPA\rNk2$\u0018\u000eU8j]R\fE\u000f\u001e:jEV$Xm\u0016:ji\u0016\u00148\u0003BBw\u0007g\u0004Ba\u0011#\u0004vB!1QUB|\u0013\u0011\u0019Ipa*\u0003\u00155+H\u000e^5Q_&tG\u000fC\u0005J\u0007[\u0014\t\u0011)A\u0005\u0015\"I!k!<\u0003\u0002\u0003\u0006Ia\u0015\u0005\bI\r5H\u0011\u0001C\u0001)\u0019!\u0019\u0001\"\u0002\u0005\bA\u00191i!<\t\r%\u001by\u00101\u0001K\u0011\u0019\u00116q a\u0001'\"9Ao!<\u0005B\u0011-A#\u00024\u0005\u000e\u0011=\u0001B\u00026\u0005\n\u0001\u00071\u000eC\u0004s\t\u0013\u0001\ra!>\u0007\u000f\u0011M\u0001'!\u0001\u0005\u0016\t\u0019\u0012IY:ue\u0006\u001cG\u000fT5oKN<&/\u001b;feV!Aq\u0003C\u000f'\u0011!\t\u0002\"\u0007\u0011\t\r#E1\u0004\t\u00045\u0012uAa\u0002/\u0005\u0012\t\u0007AqD\t\u0004=\u0012\u0005\u0002\u0003BBS\tGIA\u0001\"\n\u0004(\nAq)Z8nKR\u0014\u0018\u0010C\u0005J\t#\u0011\t\u0011)A\u0005\u0015\"I!\u000b\"\u0005\u0003\u0002\u0003\u0006Ia\u0015\u0005\bI\u0011EA\u0011\u0001C\u0017)\u0019!y\u0003\"\r\u00054A)1\t\"\u0005\u0005\u001c!1\u0011\nb\u000bA\u0002)CaA\u0015C\u0016\u0001\u0004\u0019\u0006\u0002\u0003C\u001c\t#1\t\u0002\"\u000f\u0002\u000b1Lg.Z:\u0015\t\u0011mBQ\b\t\u0007\u0003\u0007\u000b\u0019j!5\t\u000fI$)\u00041\u0001\u0005\u001c!9A\u000f\"\u0005\u0005B\u0011\u0005C#\u00024\u0005D\u0011\u0015\u0003B\u00026\u0005@\u0001\u00071\u000eC\u0004s\t\u007f\u0001\r\u0001b\u0007\u0007\r\u0011%\u0003\u0007\u0001C&\u0005Y\u0001v\u000e\\=h_:\fE\u000f\u001e:jEV$Xm\u0016:ji\u0016\u00148\u0003\u0002C$\t\u001b\u0002Ra\u0011C\t\t\u001f\u0002Ba!*\u0005R%!A1KBT\u0005\u001d\u0001v\u000e\\=h_:D\u0011\"\u0013C$\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0013I#9E!A!\u0002\u0013\u0019\u0006b\u0002\u0013\u0005H\u0011\u0005A1\f\u000b\u0007\t;\"y\u0006\"\u0019\u0011\u0007\r#9\u0005\u0003\u0004J\t3\u0002\rA\u0013\u0005\u0007%\u0012e\u0003\u0019A*\t\u0011\u0011]Bq\tC)\tK\"B\u0001b\u000f\u0005h!9!\u000fb\u0019A\u0002\u0011=cA\u0002C6a\u0001!iG\u0001\u0010Nk2$\u0018\u000eT5oKN#(/\u001b8h\u0003R$(/\u001b2vi\u0016<&/\u001b;feN!A\u0011\u000eC8!\u0015\u0019E\u0011\u0003C9!\u0011\u0019)\u000bb\u001d\n\t\u0011U4q\u0015\u0002\u0010\u001bVdG/\u001b'j]\u0016\u001cFO]5oO\"I\u0011\n\"\u001b\u0003\u0002\u0003\u0006IA\u0013\u0005\n%\u0012%$\u0011!Q\u0001\nMCq\u0001\nC5\t\u0003!i\b\u0006\u0004\u0005\u0000\u0011\u0005E1\u0011\t\u0004\u0007\u0012%\u0004BB%\u0005|\u0001\u0007!\n\u0003\u0004S\tw\u0002\ra\u0015\u0005\t\to!I\u0007\"\u0015\u0005\bR!A1\bCE\u0011\u001d\u0011HQ\u0011a\u0001\tc2a\u0001\"$1\u0001\u0011=%aG'vYRL\u0007k\u001c7zO>t\u0017\t\u001e;sS\n,H/Z,sSR,'o\u0005\u0003\u0005\f\u0012E\u0005\u0003B\"E\t'\u0003Ba!*\u0005\u0016&!AqSBT\u00051iU\u000f\u001c;j!>d\u0017pZ8o\u0011%IE1\u0012B\u0001B\u0003%!\nC\u0005S\t\u0017\u0013\t\u0011)A\u0005'\"9A\u0005b#\u0005\u0002\u0011}EC\u0002CQ\tG#)\u000bE\u0002D\t\u0017Ca!\u0013CO\u0001\u0004Q\u0005B\u0002*\u0005\u001e\u0002\u00071\u000bC\u0004u\t\u0017#\t\u0005\"+\u0015\u000b\u0019$Y\u000b\",\t\r)$9\u000b1\u0001l\u0011\u001d\u0011Hq\u0015a\u0001\t'Cq\u0001\"-1\t\u0013!\u0019,\u0001\txe&$X\rT5oKN#(/\u001b8h1R)a\r\".\u00058\"1!\u000eb,A\u0002-D\u0001\u0002\"/\u00050\u0002\u00071\u0011[\u0001\u0005e&tw\rC\u0004\u0005>B\"I\u0001b0\u0002!]\u0014\u0018\u000e^3MS:,7\u000b\u001e:j]\u001eLF#\u00024\u0005B\u0012\r\u0007B\u00026\u0005<\u0002\u00071\u000e\u0003\u0005\u0005:\u0012m\u0006\u0019ABi\u0011-!9\r\u0001a\u0001\u0002\u0004%I\u0001\"3\u0002\u0015]\u0014\u0018\u000e^3s?\u0012*\u0017\u000fF\u0002g\t\u0017D\u0011\u0002\"4\u0005F\u0006\u0005\t\u0019A\u0016\u0002\u0007a$\u0013\u0007C\u0004\u0005R\u0002\u0001\u000b\u0015B\u0016\u0002\u000f]\u0014\u0018\u000e^3sA!Q!\u000e\u0001a\u0001\u0002\u0004%I\u0001\"6\u0016\u0003-D1\u0002\"7\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0005\\\u0006a1m\u001c8tk6,'o\u0018\u0013fcR\u0019a\r\"8\t\u0013\u00115Gq[A\u0001\u0002\u0004Y\u0007b\u0002Cq\u0001\u0001\u0006Ka[\u0001\nG>t7/^7fe\u0002B\u0011\u0002\":\u0001\u0005\u0004%\t\u0005b:\u0002\u000f\u001d,GOT1nKV\t!\nC\u0004\u0005l\u0002\u0001\u000b\u0011\u0002&\u0002\u0011\u001d,GOT1nK\u0002Bq\u0001b<\u0001\t\u0003\"\t0\u0001\u0003j]&$H\u0003\u0002Cz\u000b#\u0001B\u0001\">\u0006\f9!Aq_C\u0004\u001d\u0011!I0\"\u0002\u000f\t\u0011mX1\u0001\b\u0005\t{,\tA\u0004\u0003\u0002&\u0012}\u0018B\u0001\f\u000b\u0013\t)Q#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0004\u000b\u0013\u0001\u0012\u0001D,sSR,7+\u001e9q_J$\u0018\u0002BC\u0007\u000b\u001f\u0011Ab\u0016:ji\u0016\u001cuN\u001c;fqRT1!\"\u0003\u0011\u0011!)\u0019\u0002\"<A\u0002\u0015U\u0011\u0001B2p]\u001a\u0004B!b\u0006\u0006\u001e5\u0011Q\u0011\u0004\u0006\u0005\u000b')YB\u0003\u0002\u0014+%!QqDC\r\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9Q1\u0005\u0001\u0005B\u0015\u0015\u0012a\u00049sKB\f'/\u001a$pe^\u0013\u0018\u000e^3\u0015\u0007\u0019,9\u0003C\u0004\u0006*\u0015\u0005\u0002\u0019A6\u0002\u001dI,7m\u001c:e\u0007>t7/^7fe\"1A\u000f\u0001C!\u000b[!2AZC\u0018\u0011\u001d)\t$b\u000bA\u0002e\taA]3d_J$\u0007")
public class SimpleFeatureWriteSupport
extends WriteSupport<SimpleFeature> {
    private SimpleFeatureWriter writer;
    private RecordConsumer consumer;
    private final String getName;

    public static AttributeWriter<?> attribute(String string, int n, Seq<Enumeration.Value> seq) {
        return SimpleFeatureWriteSupport$.MODULE$.attribute(string, n, seq);
    }

    public static AttributeWriter<?> attribute(AttributeDescriptor attributeDescriptor, int n) {
        return SimpleFeatureWriteSupport$.MODULE$.attribute(attributeDescriptor, n);
    }

    private SimpleFeatureWriter writer() {
        return this.writer;
    }

    private void writer_$eq(SimpleFeatureWriter x$1) {
        this.writer = x$1;
    }

    private RecordConsumer consumer() {
        return this.consumer;
    }

    private void consumer_$eq(RecordConsumer x$1) {
        this.consumer = x$1;
    }

    public String getName() {
        return this.getName;
    }

    public WriteSupport.WriteContext init(Configuration conf) {
        SimpleFeatureParquetSchema schema = (SimpleFeatureParquetSchema)SimpleFeatureParquetSchema$.MODULE$.write(conf).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException("Could not extract SimpleFeatureType from write context");
            }
        });
        this.writer_$eq(SimpleFeatureWriteSupport$SimpleFeatureWriter$.MODULE$.apply(schema.sft()));
        return new WriteSupport.WriteContext(schema.schema(), schema.metadata());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.consumer_$eq(recordConsumer);
    }

    public void write(SimpleFeature record) {
        this.writer().write(this.consumer(), record);
    }

    public SimpleFeatureWriteSupport() {
        this.getName = "SimpleFeatureWriteSupport";
    }

    public static class FidWriter
    extends AttributeWriter<String> {
        @Override
        public void write(RecordConsumer consumer, String value) {
            consumer.addBinary(Binary.fromString((String)value));
        }

        public FidWriter(int index) {
            super(SimpleFeatureParquetSchema$.MODULE$.FeatureIdField(), index);
        }
    }

    public static class MapWriter
    extends AttributeWriter<Map<Object, Object>> {
        private final AttributeWriter<Object> keyWriter;
        private final AttributeWriter<Object> valueWriter;

        private AttributeWriter<Object> keyWriter() {
            return this.keyWriter;
        }

        private AttributeWriter<Object> valueWriter() {
            return this.valueWriter;
        }

        @Override
        public void write(RecordConsumer consumer, Map<Object, Object> value) {
            consumer.startGroup();
            if (!value.isEmpty()) {
                consumer.startField("map", 0);
                for (Map.Entry<Object, Object> entry : value.entrySet()) {
                    consumer.startGroup();
                    this.keyWriter().apply(consumer, entry.getKey());
                    Object v = entry.getValue();
                    if (v != null) {
                        this.valueWriter().apply(consumer, v);
                    }
                    consumer.endGroup();
                }
                consumer.endField("map", 0);
            }
            consumer.endGroup();
        }

        public MapWriter(String name, int index, Enumeration.Value keyType, Enumeration.Value valueType) {
            super(name, index);
            this.keyWriter = SimpleFeatureWriteSupport$.MODULE$.attribute("key", 0, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{keyType}))));
            this.valueWriter = SimpleFeatureWriteSupport$.MODULE$.attribute("value", 1, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{valueType}))));
        }
    }

    public static class DateWriter
    extends AttributeWriter<Date> {
        @Override
        public void write(RecordConsumer consumer, Date value) {
            consumer.addLong(value.getTime());
        }

        public DateWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class LongWriter
    extends AttributeWriter<Long> {
        @Override
        public void write(RecordConsumer consumer, Long value) {
            consumer.addLong(Predef$.MODULE$.Long2long(value));
        }

        public LongWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class ListWriter
    extends AttributeWriter<List<Object>> {
        private final AttributeWriter<Object> elementWriter;

        private AttributeWriter<Object> elementWriter() {
            return this.elementWriter;
        }

        @Override
        public void write(RecordConsumer consumer, List<Object> value) {
            consumer.startGroup();
            if (!value.isEmpty()) {
                consumer.startField("list", 0);
                Iterator<Object> iter = value.iterator();
                while (iter.hasNext()) {
                    consumer.startGroup();
                    Object item = iter.next();
                    if (item != null) {
                        this.elementWriter().apply(consumer, item);
                    }
                    consumer.endGroup();
                }
                consumer.endField("list", 0);
            }
            consumer.endGroup();
        }

        public ListWriter(String name, int index, Enumeration.Value valueType) {
            super(name, index);
            this.elementWriter = SimpleFeatureWriteSupport$.MODULE$.attribute("element", 0, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{valueType}))));
        }
    }

    public static class UuidWriter
    extends AttributeWriter<UUID> {
        @Override
        public void write(RecordConsumer consumer, UUID value) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(value.getMostSignificantBits());
            bb.putLong(value.getLeastSignificantBits());
            consumer.addBinary(Binary.fromConstantByteArray((byte[])bb.array()));
        }

        public UuidWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class FloatWriter
    extends AttributeWriter<Float> {
        @Override
        public void write(RecordConsumer consumer, Float value) {
            consumer.addFloat(Predef$.MODULE$.Float2float(value));
        }

        public FloatWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class BytesWriter
    extends AttributeWriter<byte[]> {
        @Override
        public void write(RecordConsumer consumer, byte[] value) {
            consumer.addBinary(Binary.fromConstantByteArray((byte[])value));
        }

        public BytesWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class DoubleWriter
    extends AttributeWriter<Double> {
        @Override
        public void write(RecordConsumer consumer, Double value) {
            consumer.addDouble(Predef$.MODULE$.Double2double(value));
        }

        public DoubleWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class StringWriter
    extends AttributeWriter<String> {
        @Override
        public void write(RecordConsumer consumer, String value) {
            consumer.addBinary(Binary.fromString((String)value));
        }

        public StringWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class IntegerWriter
    extends AttributeWriter<Integer> {
        @Override
        public void write(RecordConsumer consumer, Integer value) {
            consumer.addInteger(Predef$.MODULE$.Integer2int(value));
        }

        public IntegerWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class BooleanWriter
    extends AttributeWriter<Boolean> {
        @Override
        public void write(RecordConsumer consumer, Boolean value) {
            consumer.addBoolean(Predef$.MODULE$.Boolean2boolean(value));
        }

        public BooleanWriter(String name, int index) {
            super(name, index);
        }
    }

    public static abstract class AttributeWriter<T> {
        private final String name;
        private final int index;

        public void apply(RecordConsumer consumer, T value) {
            if (value != null) {
                consumer.startField(this.name, this.index);
                this.write(consumer, value);
                consumer.endField(this.name, this.index);
            }
        }

        public abstract void write(RecordConsumer var1, T var2);

        public AttributeWriter(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }

    public static class SimpleFeatureWriter {
        private final AttributeWriter<Object>[] attributes;
        private final FidWriter fids;

        private FidWriter fids() {
            return this.fids;
        }

        public void write(RecordConsumer consumer, SimpleFeature value) {
            consumer.startMessage();
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].apply(consumer, value.getAttribute(i));
            }
            this.fids().apply(consumer, value.getID());
            consumer.endMessage();
        }

        public SimpleFeatureWriter(AttributeWriter<Object>[] attributes) {
            this.attributes = attributes;
            this.fids = new FidWriter(attributes.length);
        }
    }

    public static abstract class AbstractLinesWriter<T extends Geometry>
    extends AttributeWriter<T> {
        public abstract Seq<LineString> lines(T var1);

        @Override
        public void write(RecordConsumer consumer, T value) {
            Seq<LineString> lines2 = this.lines(value);
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startGroup();
            consumer.startField("list", 0);
            lines2.foreach((Function1)new Serializable(this, consumer){
                public static final long serialVersionUID = 0L;
                private final RecordConsumer consumer$1;

                public final void apply(LineString line) {
                    this.consumer$1.startGroup();
                    SimpleFeatureWriteSupport$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureWriteSupport$$writeLineStringX(this.consumer$1, line);
                    this.consumer$1.endGroup();
                }
                {
                    this.consumer$1 = consumer$1;
                }
            });
            consumer.endField("list", 0);
            consumer.endGroup();
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.startGroup();
            consumer.startField("list", 0);
            lines2.foreach((Function1)new Serializable(this, consumer){
                public static final long serialVersionUID = 0L;
                private final RecordConsumer consumer$1;

                public final void apply(LineString line) {
                    this.consumer$1.startGroup();
                    SimpleFeatureWriteSupport$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureWriteSupport$$writeLineStringY(this.consumer$1, line);
                    this.consumer$1.endGroup();
                }
                {
                    this.consumer$1 = consumer$1;
                }
            });
            consumer.endField("list", 0);
            consumer.endGroup();
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public AbstractLinesWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class PointAttributeWriter
    extends AttributeWriter<Point> {
        @Override
        public void write(RecordConsumer consumer, Point value) {
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.addDouble(value.getX());
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.addDouble(value.getY());
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public PointAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class PolygonAttributeWriter
    extends AbstractLinesWriter<Polygon> {
        @Override
        public Seq<LineString> lines(Polygon value) {
            return (Seq)Seq$.MODULE$.tabulate(value.getNumInteriorRing() + 1, (Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final Polygon value$1;

                public final LineString apply(int i) {
                    return i == 0 ? this.value$1.getExteriorRing() : this.value$1.getInteriorRingN(i - 1);
                }
                {
                    this.value$1 = value$1;
                }
            });
        }

        public PolygonAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class LineStringAttributeWriter
    extends AttributeWriter<LineString> {
        @Override
        public void write(RecordConsumer consumer, LineString value) {
            int i;
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            for (i = 0; i < value.getNumPoints(); ++i) {
                consumer.addDouble(value.getCoordinateN((int)i).x);
            }
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            for (i = 0; i < value.getNumPoints(); ++i) {
                consumer.addDouble(value.getCoordinateN((int)i).y);
            }
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public LineStringAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class MultiPointAttributeWriter
    extends AttributeWriter<MultiPoint> {
        @Override
        public void write(RecordConsumer consumer, MultiPoint value) {
            int i;
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            for (i = 0; i < value.getNumPoints(); ++i) {
                consumer.addDouble(((Point)value.getGeometryN(i)).getX());
            }
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            for (i = 0; i < value.getNumPoints(); ++i) {
                consumer.addDouble(((Point)value.getGeometryN(i)).getY());
            }
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public MultiPointAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class MultiPolygonAttributeWriter
    extends AttributeWriter<MultiPolygon> {
        @Override
        public void write(RecordConsumer consumer, MultiPolygon value) {
            Seq polys = (Seq)Seq$.MODULE$.tabulate(value.getNumGeometries(), (Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final MultiPolygon value$3;

                public final Seq<LineString> apply(int i) {
                    Polygon poly = (Polygon)this.value$3.getGeometryN(i);
                    return (Seq)Seq$.MODULE$.tabulate(poly.getNumInteriorRing() + 1, (Function1)new Serializable(this, poly){
                        public static final long serialVersionUID = 0L;
                        private final Polygon poly$1;

                        public final LineString apply(int i) {
                            return i == 0 ? this.poly$1.getExteriorRing() : this.poly$1.getInteriorRingN(i - 1);
                        }
                        {
                            this.poly$1 = poly$1;
                        }
                    });
                }
                {
                    this.value$3 = value$3;
                }
            });
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startGroup();
            consumer.startField("list", 0);
            polys.foreach((Function1)new Serializable(this, consumer){
                public static final long serialVersionUID = 0L;
                public final RecordConsumer consumer$2;

                public final void apply(Seq<LineString> lines2) {
                    this.consumer$2.startGroup();
                    this.consumer$2.startField("element", 0);
                    this.consumer$2.startGroup();
                    this.consumer$2.startField("list", 0);
                    lines2.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MultiPolygonAttributeWriter$$anonfun$write$3 $outer;

                        public final void apply(LineString line) {
                            this.$outer.consumer$2.startGroup();
                            SimpleFeatureWriteSupport$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureWriteSupport$$writeLineStringX(this.$outer.consumer$2, line);
                            this.$outer.consumer$2.endGroup();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.consumer$2.endField("list", 0);
                    this.consumer$2.endGroup();
                    this.consumer$2.endField("element", 0);
                    this.consumer$2.endGroup();
                }
                {
                    this.consumer$2 = consumer$2;
                }
            });
            consumer.endField("list", 0);
            consumer.endGroup();
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.startGroup();
            consumer.startField("list", 0);
            polys.foreach((Function1)new Serializable(this, consumer){
                public static final long serialVersionUID = 0L;
                public final RecordConsumer consumer$2;

                public final void apply(Seq<LineString> lines2) {
                    this.consumer$2.startGroup();
                    this.consumer$2.startField("element", 0);
                    this.consumer$2.startGroup();
                    this.consumer$2.startField("list", 0);
                    lines2.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MultiPolygonAttributeWriter$$anonfun$write$4 $outer;

                        public final void apply(LineString line) {
                            this.$outer.consumer$2.startGroup();
                            SimpleFeatureWriteSupport$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureWriteSupport$$writeLineStringY(this.$outer.consumer$2, line);
                            this.$outer.consumer$2.endGroup();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.consumer$2.endField("list", 0);
                    this.consumer$2.endGroup();
                    this.consumer$2.endField("element", 0);
                    this.consumer$2.endGroup();
                }
                {
                    this.consumer$2 = consumer$2;
                }
            });
            consumer.endField("list", 0);
            consumer.endGroup();
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public MultiPolygonAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class MultiLineStringAttributeWriter
    extends AbstractLinesWriter<MultiLineString> {
        @Override
        public Seq<LineString> lines(MultiLineString value) {
            return (Seq)Seq$.MODULE$.tabulate(value.getNumGeometries(), (Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final MultiLineString value$2;

                public final LineString apply(int i) {
                    return (LineString)this.value$2.getGeometryN(i);
                }
                {
                    this.value$2 = value$2;
                }
            });
        }

        public MultiLineStringAttributeWriter(String name, int index) {
            super(name, index);
        }
    }
}

