/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.io;

import com.google.common.collect.HashBiMap;
import com.google.common.primitives.Ints;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.util.TransferPair;
import org.locationtech.geomesa.arrow.io.DeltaWriter;
import org.locationtech.geomesa.arrow.io.DeltaWriter$;
import org.locationtech.geomesa.arrow.io.DeltaWriter$$anonfun$15$;
import org.locationtech.geomesa.arrow.io.DeltaWriter$$anonfun$org$locationtech$geomesa$arrow$io$DeltaWriter$;
import org.locationtech.geomesa.arrow.io.DeltaWriter$$anonfun$org$locationtech$geomesa$arrow$io$DeltaWriter$$reduceWithSort$2$;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowIO$;
import org.locationtech.geomesa.arrow.io.records.RecordBatchLoader;
import org.locationtech.geomesa.arrow.io.records.RecordBatchLoader$;
import org.locationtech.geomesa.arrow.io.records.RecordBatchUnloader;
import org.locationtech.geomesa.arrow.package$ArrowAllocator$;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeReader;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeReader$;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeWriter$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionaryReader;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.GeometryVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.io.CloseWithLogging$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class DeltaWriter$
implements StrictLogging {
    public static final DeltaWriter$ MODULE$;
    private final DictionaryProvider.MapDictionaryProvider org$locationtech$geomesa$arrow$io$DeltaWriter$$provider;
    private final Ordering<Object> org$locationtech$geomesa$arrow$io$DeltaWriter$$dictionaryOrdering;
    private final Object queueOrdering;
    private final Logger logger;

    static {
        new DeltaWriter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public DictionaryProvider.MapDictionaryProvider org$locationtech$geomesa$arrow$io$DeltaWriter$$provider() {
        return this.org$locationtech$geomesa$arrow$io$DeltaWriter$$provider;
    }

    public Ordering<Object> org$locationtech$geomesa$arrow$io$DeltaWriter$$dictionaryOrdering() {
        return this.org$locationtech$geomesa$arrow$io$DeltaWriter$$dictionaryOrdering;
    }

    private Object queueOrdering() {
        return this.queueOrdering;
    }

    public CloseableIterator<byte[]> reduce(SimpleFeatureType sft, Seq<String> dictionaryFields, SimpleFeatureVector.SimpleFeatureEncoding encoding, Option<Tuple2<String, Object>> sort, int batchSize, CloseableIterator<byte[]> deltas, BufferAllocator allocator2) {
        return this.reduce(sft, dictionaryFields, encoding, sort, batchSize, deltas);
    }

    public CloseableIterator<byte[]> reduce(SimpleFeatureType sft, Seq<String> dictionaryFields, SimpleFeatureVector.SimpleFeatureEncoding encoding, Option<Tuple2<String, Object>> sort, int batchSize, CloseableIterator<byte[]> deltas) {
        return new DeltaWriter.ReducingIterator(sft, dictionaryFields, encoding, sort, batchSize, deltas);
    }

    public CloseableIterator<byte[]> org$locationtech$geomesa$arrow$io$DeltaWriter$$reduceNoSort(SimpleFeatureType sft, Seq<String> dictionaryFields, SimpleFeatureVector.SimpleFeatureEncoding encoding, DeltaWriter.MergedDictionaries mergedDictionaries, int batchSize, byte[][][] threadedBatches) {
        BoxedUnit boxedUnit;
        BufferAllocator allocator2 = package$ArrowAllocator$.MODULE$.apply("delta-reduce");
        SimpleFeatureVector result = SimpleFeatureVector$.MODULE$.create(sft, mergedDictionaries.dictionaries(), encoding, batchSize, allocator2);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("merge unsorted deltas - read schema {}", new Object[]{result.underlying().getField()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        CloseableIterator<byte[]> iter = new CloseableIterator<byte[]>(dictionaryFields, mergedDictionaries, batchSize, threadedBatches, allocator2, result){
            private final RecordBatchLoader loader;
            private final RecordBatchUnloader unloader;
            private final Seq<Tuple2<String, Function3<Object, Object, Map<Integer, Integer>, BoxedUnit>>> transfers;
            private final Iterator<byte[][]> threadIterator;
            private int org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$threadIndex;
            private Iterator<byte[]> batches;
            private scala.collection.immutable.Map<String, Map<Integer, Integer>> org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$mappings;
            private int org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count;
            private final Seq dictionaryFields$1;
            private final DeltaWriter.MergedDictionaries mergedDictionaries$1;
            private final int batchSize$1;
            private final BufferAllocator allocator$1;
            public final SimpleFeatureVector result$1;

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
                return Iterator.class.map((Iterator)this, (Function1)f);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
                return Iterator.class.filter((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
                return Iterator.class.filterNot((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
                return Iterator.class.collect((Iterator)this, (PartialFunction)pf);
            }

            public <B> CloseableIterator<B> map(Function1<byte[], B> f) {
                return CloseableIterator.class.map((CloseableIterator)this, f);
            }

            public CloseableIterator<byte[]> filter(Function1<byte[], Object> p) {
                return CloseableIterator.class.filter((CloseableIterator)this, p);
            }

            public CloseableIterator<byte[]> filterNot(Function1<byte[], Object> p) {
                return CloseableIterator.class.filterNot((CloseableIterator)this, p);
            }

            public CloseableIterator<byte[]> take(int n) {
                return CloseableIterator.class.take((CloseableIterator)this, (int)n);
            }

            public <B> CloseableIterator<B> collect(PartialFunction<byte[], B> pf) {
                return CloseableIterator.class.collect((CloseableIterator)this, pf);
            }

            public <B> CloseableIterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return CloseableIterator.class.$plus$plus((CloseableIterator)this, that);
            }

            public <B> CloseableIterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                return CloseableIterator.class.flatMap((CloseableIterator)this, f);
            }

            public Iterator<byte[]> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<byte[]> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<byte[]> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<byte[], U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<byte[], Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<byte[], Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<byte[]> find(Function1<byte[], Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<byte[], Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<byte[]> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<byte[]> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<byte[]> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<byte[]> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<byte[]> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<byte[], Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<byte[]> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<byte[]> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<byte[]> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<byte[]> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<byte[]> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private RecordBatchLoader loader() {
                return this.loader;
            }

            private RecordBatchUnloader unloader() {
                return this.unloader;
            }

            private Seq<Tuple2<String, Function3<Object, Object, Map<Integer, Integer>, BoxedUnit>>> transfers() {
                return this.transfers;
            }

            private Iterator<byte[][]> threadIterator() {
                return this.threadIterator;
            }

            public int org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$threadIndex() {
                return this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$threadIndex;
            }

            private void org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$threadIndex_$eq(int x$1) {
                this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$threadIndex = x$1;
            }

            private Iterator<byte[]> batches() {
                return this.batches;
            }

            private void batches_$eq(Iterator<byte[]> x$1) {
                this.batches = x$1;
            }

            public scala.collection.immutable.Map<String, Map<Integer, Integer>> org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$mappings() {
                return this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$mappings;
            }

            private void org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$mappings_$eq(scala.collection.immutable.Map<String, Map<Integer, Integer>> x$1) {
                this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$mappings = x$1;
            }

            public int org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count() {
                return this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count;
            }

            private void org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count_$eq(int x$1) {
                this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count = x$1;
            }

            public boolean hasNext() {
                return this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count() < this.loader().vector().getValueCount() || this.loadNextBatch();
            }

            public byte[] next() {
                IntRef total = IntRef.create((int)0);
                while (total.elem < this.batchSize$1 && this.hasNext()) {
                    int toRead = package$.MODULE$.min(this.batchSize$1 - total.elem, this.loader().vector().getValueCount() - this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count());
                    this.transfers().foreach((Function1)new Serializable(this, total, toRead){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.3 $outer;
                        private final IntRef total$1;
                        private final int toRead$1;

                        public final void apply(Tuple2<String, Function3<Object, Object, Map<Integer, Integer>, BoxedUnit>> x0$2) {
                            Tuple2<String, Function3<Object, Object, Map<Integer, Integer>, BoxedUnit>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                String name = (String)tuple2._1();
                                Function3 transfer = (Function3)tuple2._2();
                                Map mapping = (Map)this.$outer.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$mappings().get((Object)name).orNull(Predef$.MODULE$.$conforms());
                                if (DeltaWriter$.MODULE$.logger().underlying().isTraceEnabled()) {
                                    DeltaWriter$.MODULE$.logger().underlying().trace("dictionary mappings for {}: {}", new Object[]{name, mapping});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                for (int i = 0; i < this.toRead$1; ++i) {
                                    transfer.apply((Object)BoxesRunTime.boxToInteger((int)(i + this.$outer.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count())), (Object)BoxesRunTime.boxToInteger((int)(i + this.total$1.elem)), (Object)mapping);
                                }
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.total$1 = total$1;
                            this.toRead$1 = toRead$1;
                        }
                    });
                    this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count_$eq(this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count() + toRead);
                    total.elem += toRead;
                }
                return this.unloader().unload(total.elem);
            }

            public void close() {
                CloseWithLogging$.MODULE$.apply((Object)this.loader().vector());
                CloseWithLogging$.MODULE$.apply((Object)this.result$1);
                CloseWithLogging$.MODULE$.apply((Object)this.mergedDictionaries$1);
                CloseWithLogging$.MODULE$.apply((Object)this.allocator$1);
            }

            private boolean loadNextBatch() {
                boolean bl;
                block2: {
                    while (true) {
                        if (this.batches().hasNext()) {
                            byte[] batch = (byte[])this.batches().next();
                            IntRef offset = IntRef.create((int)8);
                            this.dictionaryFields$1.foreach((Function1)new Serializable(this, batch, offset){
                                public static final long serialVersionUID = 0L;
                                private final byte[] batch$1;
                                private final IntRef offset$1;

                                public final void apply(String x$6) {
                                    this.offset$1.elem += Ints.fromBytes((byte)this.batch$1[this.offset$1.elem], (byte)this.batch$1[this.offset$1.elem + 1], (byte)this.batch$1[this.offset$1.elem + 2], (byte)this.batch$1[this.offset$1.elem + 3]) + 4;
                                }
                                {
                                    this.batch$1 = batch$1;
                                    this.offset$1 = offset$1;
                                }
                            });
                            int messageLength = Ints.fromBytes((byte)batch[offset.elem], (byte)batch[offset.elem + 1], (byte)batch[offset.elem + 2], (byte)batch[offset.elem + 3]);
                            offset.elem += 4;
                            this.loader().load(batch, offset.elem, messageLength);
                            if (this.loader().vector().getValueCount() <= 0) continue;
                            this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count_$eq(0);
                            bl = true;
                            break block2;
                        }
                        if (!this.threadIterator().hasNext()) break;
                        this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$threadIndex_$eq(this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$threadIndex() + 1);
                        this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$mappings_$eq((scala.collection.immutable.Map<String, Map<Integer, Integer>>)((scala.collection.immutable.Map)this.mergedDictionaries$1.mappings().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.3 $outer;

                            public final Tuple2<String, Map<Integer, Integer>> apply(Tuple2<String, Map<Integer, Integer>[]> x0$3) {
                                Tuple2<String, Map<Integer, Integer>[]> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    String f = (String)tuple2._1();
                                    Map[] m = (Map[])tuple2._2();
                                    Tuple2 tuple22 = new Tuple2((Object)f, (Object)m[this.$outer.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$threadIndex()]);
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())));
                        this.batches_$eq((Iterator<byte[]>)Predef$.MODULE$.refArrayOps((Object[])this.threadIterator().next()).iterator());
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.dictionaryFields$1 = dictionaryFields$1;
                this.mergedDictionaries$1 = mergedDictionaries$1;
                this.batchSize$1 = batchSize$1;
                this.allocator$1 = allocator$1;
                this.result$1 = result$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                CloseableIterator.class.$init$((CloseableIterator)this);
                this.loader = RecordBatchLoader$.MODULE$.apply(result$1.underlying().getField(), allocator$1);
                this.unloader = new RecordBatchUnloader(result$1);
                this.transfers = (Seq)JavaConversions$.MODULE$.asScalaBuffer(this.loader().vector().getChildrenFromFields()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.3 $outer;

                    public final Tuple2<String, Function3<Object, Object, Map<Integer, Integer>, BoxedUnit>> apply(FieldVector fromVector) {
                        Object object;
                        String name = fromVector.getField().getName();
                        FieldVector toVector = this.$outer.result$1.underlying().getChild(name);
                        if (fromVector.getField().getDictionary() == null) {
                            if (SimpleFeatureVector$.MODULE$.isGeometryVector(fromVector)) {
                                GeometryVector from = GeometryFields.wrap((FieldVector)fromVector);
                                GeometryVector to = GeometryFields.wrap((FieldVector)toVector);
                                object = new Serializable(this, from, to){
                                    public static final long serialVersionUID = 0L;
                                    private final GeometryVector from$2;
                                    private final GeometryVector to$2;

                                    public final void apply(int fromIndex, int toIndex, Map<Integer, Integer> x$4) {
                                        this.from$2.transfer(fromIndex, toIndex, this.to$2);
                                    }
                                    {
                                        this.from$2 = from$2;
                                        this.to$2 = to$2;
                                    }
                                };
                            } else {
                                TransferPair pair = fromVector.makeTransferPair((ValueVector)toVector);
                                object = new Serializable(this, pair){
                                    public static final long serialVersionUID = 0L;
                                    private final TransferPair pair$1;

                                    public final void apply(int fromIndex, int toIndex, Map<Integer, Integer> x$5) {
                                        this.pair$1.copyValueSafe(fromIndex, toIndex);
                                    }
                                    {
                                        this.pair$1 = pair$1;
                                    }
                                };
                            }
                        } else {
                            IntVector from = (IntVector)fromVector;
                            IntVector to = (IntVector)toVector;
                            object = new Serializable(this, from, to){
                                public static final long serialVersionUID = 0L;
                                private final IntVector from$1;
                                private final IntVector to$1;

                                public final void apply(int fromIndex, int toIndex, Map<Integer, Integer> mapping) {
                                    Integer n = this.from$1.getObject(fromIndex);
                                    if (n == null) {
                                        this.to$1.setNull(toIndex);
                                    } else {
                                        this.to$1.setSafe(toIndex, Predef$.MODULE$.Integer2int((Integer)mapping.apply((Object)n)));
                                    }
                                }
                                {
                                    this.from$1 = from$1;
                                    this.to$1 = to$1;
                                }
                            };
                        }
                        Object transfer = object;
                        return new Tuple2((Object)name, transfer);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                this.threadIterator = Predef$.MODULE$.refArrayOps((Object[])threadedBatches$1).iterator();
                this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$threadIndex = -1;
                this.batches = scala.package$.MODULE$.Iterator().empty();
                this.org$locationtech$geomesa$arrow$io$DeltaWriter$$anon$$count = 0;
            }
        };
        return SimpleFeatureArrowIO$.MODULE$.createFile(result, (Option<Tuple2<String, Object>>)None$.MODULE$, iter);
    }

    public CloseableIterator<byte[]> org$locationtech$geomesa$arrow$io$DeltaWriter$$reduceWithSort(SimpleFeatureType sft, Seq<String> dictionaryFields, SimpleFeatureVector.SimpleFeatureEncoding encoding, DeltaWriter.MergedDictionaries mergedDictionaries, String sortBy, boolean reverse, int batchSize, byte[][][] threadedBatches) {
        BoxedUnit boxedUnit;
        BufferAllocator allocator2 = package$ArrowAllocator$.MODULE$.apply("delta-reduce-sort");
        Object getSortAttribute = mergedDictionaries.dictionaries().contains((Object)sortBy) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(ArrowAttributeReader reader, Map<Integer, Integer> mappings, int i) {
                return (Integer)mappings.apply((Object)((ArrowDictionaryReader)reader).getEncoded(i));
            }
        } : new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(ArrowAttributeReader reader, Map<Integer, Integer> x$7, int i) {
                return reader.apply(i);
            }
        };
        SimpleFeatureVector result = SimpleFeatureVector$.MODULE$.create(sft, mergedDictionaries.dictionaries(), encoding, SimpleFeatureVector$.MODULE$.create$default$4(), allocator2);
        RecordBatchUnloader unloader = new RecordBatchUnloader(result);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("merging sorted deltas - read schema: {}", new Object[]{result.underlying().getField()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ArrayBuilder mergeBuilder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(Tuple4.class));
        mergeBuilder.sizeHint(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.refArrayOps((Object[])threadedBatches).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int sum, byte[][] a) {
                return sum + a.length;
            }
        })));
        ScalaImplicits.RichArray$.MODULE$.foreachIndex$extension(ScalaImplicits$.MODULE$.RichArray((Object)threadedBatches), (Function2)new Serializable(sft, dictionaryFields, encoding, mergedDictionaries, sortBy, allocator2, result, mergeBuilder){
            public static final long serialVersionUID = 0L;
            public final SimpleFeatureType sft$1;
            public final Seq dictionaryFields$2;
            public final SimpleFeatureVector.SimpleFeatureEncoding encoding$1;
            public final DeltaWriter.MergedDictionaries mergedDictionaries$2;
            public final String sortBy$1;
            public final BufferAllocator allocator$2;
            public final SimpleFeatureVector result$2;
            public final ArrayBuilder mergeBuilder$1;

            public final void apply(byte[][] x0$4, int x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$4, (Object)BoxesRunTime.boxToInteger((int)x1$1));
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    byte[][] batches = (byte[][])tuple2._1();
                    int batchIndex = tuple2._2$mcI$sp();
                    scala.collection.immutable.Map mappings = (scala.collection.immutable.Map)this.mergedDictionaries$2.mappings().map((Function1)new Serializable(this, batchIndex){
                        public static final long serialVersionUID = 0L;
                        private final int batchIndex$1;

                        public final Tuple2<String, Map<Integer, Integer>> apply(Tuple2<String, Map<Integer, Integer>[]> x0$5) {
                            Tuple2<String, Map<Integer, Integer>[]> tuple2 = x0$5;
                            if (tuple2 != null) {
                                String f = (String)tuple2._1();
                                Map[] m = (Map[])tuple2._2();
                                Tuple2 tuple22 = new Tuple2((Object)f, (Object)m[this.batchIndex$1]);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.batchIndex$1 = batchIndex$1;
                        }
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    if (DeltaWriter$.MODULE$.logger().underlying().isTraceEnabled()) {
                        DeltaWriter$.MODULE$.logger().underlying().trace("loading {} batch(es) from a single thread", new Object[]{BoxesRunTime.boxToInteger((int)batches.length)});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Predef$.MODULE$.refArrayOps((Object[])batches).foreach((Function1)new Serializable(this, mappings){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$locationtech$geomesa$arrow$io$DeltaWriter$$reduceWithSort$2 $outer;
                        public final scala.collection.immutable.Map mappings$1;

                        public final ArrayBuilder<Tuple4<StructVector, ArrowAttributeReader, Seq<Function2<Object, Object, BoxedUnit>>, Map<Integer, Integer>>> apply(byte[] batch) {
                            RecordBatchLoader loader = RecordBatchLoader$.MODULE$.apply(this.$outer.result$2.underlying().getField(), this.$outer.allocator$2);
                            IntRef offset = IntRef.create((int)8);
                            this.$outer.dictionaryFields$2.foreach((Function1)new Serializable(this, offset, batch){
                                public static final long serialVersionUID = 0L;
                                private final IntRef offset$2;
                                private final byte[] batch$2;

                                public final void apply(String x$8) {
                                    this.offset$2.elem += Ints.fromBytes((byte)this.batch$2[this.offset$2.elem], (byte)this.batch$2[this.offset$2.elem + 1], (byte)this.batch$2[this.offset$2.elem + 2], (byte)this.batch$2[this.offset$2.elem + 3]) + 4;
                                }
                                {
                                    this.offset$2 = offset$2;
                                    this.batch$2 = batch$2;
                                }
                            });
                            int messageLength = Ints.fromBytes((byte)batch[offset.elem], (byte)batch[offset.elem + 1], (byte)batch[offset.elem + 2], (byte)batch[offset.elem + 3]);
                            offset.elem += 4;
                            loader.load(batch, offset.elem, messageLength);
                            Seq transfers = (Seq)JavaConversions$.MODULE$.asScalaBuffer(loader.vector().getChildrenFromFields()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$org$locationtech$geomesa$arrow$io$DeltaWriter$$reduceWithSort$2$$anonfun$apply$7 $outer;

                                public final Function2<Object, Object, BoxedUnit> apply(FieldVector fromVector) {
                                    Object object;
                                    FieldVector toVector = this.$outer.org$locationtech$geomesa$arrow$io$DeltaWriter$$anonfun$$anonfun$$$outer().result$2.underlying().getChild(fromVector.getField().getName());
                                    if (fromVector.getField().getDictionary() == null) {
                                        if (SimpleFeatureVector$.MODULE$.isGeometryVector(fromVector)) {
                                            GeometryVector from = GeometryFields.wrap((FieldVector)fromVector);
                                            GeometryVector to = GeometryFields.wrap((FieldVector)toVector);
                                            object = new Serializable(this, from, to){
                                                public static final long serialVersionUID = 0L;
                                                private final GeometryVector from$3;
                                                private final GeometryVector to$4;

                                                public final void apply(int fromIndex, int toIndex) {
                                                    this.apply$mcVII$sp(fromIndex, toIndex);
                                                }

                                                public void apply$mcVII$sp(int fromIndex, int toIndex) {
                                                    this.from$3.transfer(fromIndex, toIndex, this.to$4);
                                                }
                                                {
                                                    this.from$3 = from$3;
                                                    this.to$4 = to$4;
                                                }
                                            };
                                        } else {
                                            TransferPair transfer = fromVector.makeTransferPair((ValueVector)toVector);
                                            object = new Serializable(this, transfer){
                                                public static final long serialVersionUID = 0L;
                                                private final TransferPair transfer$1;

                                                public final void apply(int fromIndex, int toIndex) {
                                                    this.apply$mcVII$sp(fromIndex, toIndex);
                                                }

                                                public void apply$mcVII$sp(int fromIndex, int toIndex) {
                                                    this.transfer$1.copyValueSafe(fromIndex, toIndex);
                                                }
                                                {
                                                    this.transfer$1 = transfer$1;
                                                }
                                            };
                                        }
                                    } else {
                                        Map mapping = (Map)this.$outer.mappings$1.apply((Object)fromVector.getField().getName());
                                        IntVector to = (IntVector)toVector;
                                        object = new Serializable(this, mapping, to, fromVector){
                                            public static final long serialVersionUID = 0L;
                                            private final Map mapping$1;
                                            private final IntVector to$3;
                                            private final FieldVector fromVector$1;

                                            public final void apply(int fromIndex, int toIndex) {
                                                this.apply$mcVII$sp(fromIndex, toIndex);
                                            }

                                            public void apply$mcVII$sp(int fromIndex, int toIndex) {
                                                Integer n = (Integer)this.fromVector$1.getObject(fromIndex);
                                                if (n == null) {
                                                    this.to$3.setNull(toIndex);
                                                } else {
                                                    this.to$3.setSafe(toIndex, Predef$.MODULE$.Integer2int((Integer)this.mapping$1.apply((Object)n)));
                                                }
                                            }
                                            {
                                                this.mapping$1 = mapping$1;
                                                this.to$3 = to$3;
                                                this.fromVector$1 = fromVector$1;
                                            }
                                        };
                                    }
                                    return object;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Buffer$.MODULE$.canBuildFrom());
                            StructVector mapVector = (StructVector)loader.vector();
                            Option dict = this.$outer.mergedDictionaries$2.dictionaries().get((Object)this.$outer.sortBy$1);
                            ArrowAttributeReader sortReader = ArrowAttributeReader$.MODULE$.apply(this.$outer.sft$1.getDescriptor(this.$outer.sortBy$1), mapVector.getChild(this.$outer.sortBy$1), (Option<ArrowDictionary>)dict, this.$outer.encoding$1);
                            return (ArrayBuilder)this.$outer.mergeBuilder$1.$plus$eq((Object)new Tuple4((Object)mapVector, (Object)sortReader, (Object)transfers, this.mappings$1.get((Object)this.$outer.sortBy$1).orNull(Predef$.MODULE$.$conforms())));
                        }

                        public /* synthetic */ anonfun$org$locationtech$geomesa$arrow$io$DeltaWriter$$reduceWithSort$2 org$locationtech$geomesa$arrow$io$DeltaWriter$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.mappings$1 = mappings$1;
                        }
                    });
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.sft$1 = sft$1;
                this.dictionaryFields$2 = dictionaryFields$2;
                this.encoding$1 = encoding$1;
                this.mergedDictionaries$2 = mergedDictionaries$2;
                this.sortBy$1 = sortBy$1;
                this.allocator$2 = allocator$2;
                this.result$2 = result$2;
                this.mergeBuilder$1 = mergeBuilder$1;
            }
        });
        Tuple4[] toMerge = (Tuple4[])mergeBuilder.result();
        Ordering o = reverse ? this.queueOrdering().reverse() : this.queueOrdering();
        PriorityQueue queue = (PriorityQueue)PriorityQueue$.MODULE$.empty(o);
        ScalaImplicits.RichArray$.MODULE$.foreachIndex$extension(ScalaImplicits$.MODULE$.RichArray((Object)toMerge), (Function2)new Serializable((Function3)getSortAttribute, queue){
            public static final long serialVersionUID = 0L;
            private final Function3 getSortAttribute$1;
            private final PriorityQueue queue$1;

            public final Object apply(Tuple4<StructVector, ArrowAttributeReader, Seq<Function2<Object, Object, BoxedUnit>>, Map<Integer, Integer>> x0$6, int x1$2) {
                Tuple2 tuple2 = new Tuple2(x0$6, (Object)BoxesRunTime.boxToInteger((int)x1$2));
                if (tuple2 != null) {
                    Tuple4 tuple4 = (Tuple4)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (tuple4 != null) {
                        StructVector vector = (StructVector)tuple4._1();
                        ArrowAttributeReader sort = (ArrowAttributeReader)tuple4._2();
                        Map mappings = (Map)tuple4._4();
                        BoxedUnit boxedUnit = vector.getValueCount() > 0 ? this.queue$1.$plus$eq((Object)new Tuple3(this.getSortAttribute$1.apply((Object)sort, (Object)mappings, (Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)0))) : BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.getSortAttribute$1 = getSortAttribute$1;
                this.queue$1 = queue$1;
            }
        });
        CloseableIterator<byte[]> merged = new CloseableIterator<byte[]>(mergedDictionaries, batchSize, allocator2, (Function3)getSortAttribute, result, unloader, toMerge, queue){
            private byte[] batch;
            private final DeltaWriter.MergedDictionaries mergedDictionaries$2;
            private final int batchSize$2;
            private final BufferAllocator allocator$2;
            private final Function3 getSortAttribute$1;
            private final SimpleFeatureVector result$2;
            private final RecordBatchUnloader unloader$1;
            private final Tuple4[] toMerge$1;
            private final PriorityQueue queue$1;

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
                return Iterator.class.map((Iterator)this, (Function1)f);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
                return Iterator.class.filter((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
                return Iterator.class.filterNot((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
                return Iterator.class.collect((Iterator)this, (PartialFunction)pf);
            }

            public <B> CloseableIterator<B> map(Function1<byte[], B> f) {
                return CloseableIterator.class.map((CloseableIterator)this, f);
            }

            public CloseableIterator<byte[]> filter(Function1<byte[], Object> p) {
                return CloseableIterator.class.filter((CloseableIterator)this, p);
            }

            public CloseableIterator<byte[]> filterNot(Function1<byte[], Object> p) {
                return CloseableIterator.class.filterNot((CloseableIterator)this, p);
            }

            public CloseableIterator<byte[]> take(int n) {
                return CloseableIterator.class.take((CloseableIterator)this, (int)n);
            }

            public <B> CloseableIterator<B> collect(PartialFunction<byte[], B> pf) {
                return CloseableIterator.class.collect((CloseableIterator)this, pf);
            }

            public <B> CloseableIterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return CloseableIterator.class.$plus$plus((CloseableIterator)this, that);
            }

            public <B> CloseableIterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                return CloseableIterator.class.flatMap((CloseableIterator)this, f);
            }

            public Iterator<byte[]> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<byte[]> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<byte[]> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<byte[], U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<byte[], Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<byte[], Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<byte[]> find(Function1<byte[], Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<byte[], Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<byte[]> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<byte[]> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<byte[]> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<byte[]> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<byte[]> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<byte[], Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<byte[]> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<byte[]> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<byte[]> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<byte[]> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<byte[]> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private byte[] batch() {
                return this.batch;
            }

            private void batch_$eq(byte[] x$1) {
                this.batch = x$1;
            }

            public boolean hasNext() {
                if (this.batch() == null) {
                    this.batch_$eq(DeltaWriter$.MODULE$.org$locationtech$geomesa$arrow$io$DeltaWriter$$nextBatch$1(this.batchSize$2, this.getSortAttribute$1, this.result$2, this.unloader$1, this.toMerge$1, this.queue$1));
                }
                return this.batch() != null;
            }

            /*
             * WARNING - void declaration
             */
            public byte[] next() {
                void var1_1;
                byte[] res = this.batch();
                this.batch_$eq(null);
                return var1_1;
            }

            public void close() {
                CloseWithLogging$.MODULE$.apply((Object)this.result$2);
                Predef$.MODULE$.refArrayOps((Object[])this.toMerge$1).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Throwable> apply(Tuple4<StructVector, ArrowAttributeReader, Seq<Function2<Object, Object, BoxedUnit>>, Map<Integer, Integer>> x0$7) {
                        Tuple4<StructVector, ArrowAttributeReader, Seq<Function2<Object, Object, BoxedUnit>>, Map<Integer, Integer>> tuple4 = x0$7;
                        if (tuple4 != null) {
                            StructVector vector = (StructVector)tuple4._1();
                            Option option = CloseWithLogging$.MODULE$.apply((Object)vector);
                            return option;
                        }
                        throw new MatchError(tuple4);
                    }
                });
                CloseWithLogging$.MODULE$.apply((Object)this.mergedDictionaries$2);
                CloseWithLogging$.MODULE$.apply((Object)this.allocator$2);
            }
            {
                this.mergedDictionaries$2 = mergedDictionaries$2;
                this.batchSize$2 = batchSize$2;
                this.allocator$2 = allocator$2;
                this.getSortAttribute$1 = getSortAttribute$1;
                this.result$2 = result$2;
                this.unloader$1 = unloader$1;
                this.toMerge$1 = toMerge$1;
                this.queue$1 = queue$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                CloseableIterator.class.$init$((CloseableIterator)this);
            }
        };
        return SimpleFeatureArrowIO$.MODULE$.createFile(result, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)sortBy, (Object)BoxesRunTime.boxToBoolean((boolean)reverse))), merged);
    }

    public DeltaWriter.MergedDictionaries org$locationtech$geomesa$arrow$io$DeltaWriter$$mergeDictionaries(SimpleFeatureType sft, Seq<String> dictionaryFields, byte[][][] deltas, SimpleFeatureVector.SimpleFeatureEncoding encoding) {
        BoxedUnit boxedUnit;
        BufferAllocator allocator2 = package$ArrowAllocator$.MODULE$.apply("merge-dictionaries");
        if (dictionaryFields.isEmpty()) {
            return new DeltaWriter.MergedDictionaries((scala.collection.immutable.Map<String, ArrowDictionary>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, Map<Integer, Integer>[]>)Predef$.MODULE$.Map().empty(), allocator2);
        }
        ArrowAttributeReader[] results = this.org$locationtech$geomesa$arrow$io$DeltaWriter$$createNewVectors$1(sft, dictionaryFields, encoding, allocator2);
        PriorityQueue queue = (PriorityQueue)PriorityQueue$.MODULE$.empty(this.queueOrdering());
        Tuple3[] allMerges = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])deltas).map((Function1)new Serializable(sft, dictionaryFields, encoding, allocator2, results, queue){
            public static final long serialVersionUID = 0L;
            public final SimpleFeatureType sft$2;
            public final Seq dictionaryFields$3;
            public final SimpleFeatureVector.SimpleFeatureEncoding encoding$2;
            public final BufferAllocator allocator$3;
            private final ArrowAttributeReader[] results$1;
            public final PriorityQueue queue$2;

            public final Tuple3<ArrowAttributeReader[], TransferPair[], HashBiMap<Integer, Integer>[]> apply(byte[][] deltas) {
                ArrowAttributeReader[] dictionaries2 = DeltaWriter$.MODULE$.org$locationtech$geomesa$arrow$io$DeltaWriter$$createNewVectors$1(this.sft$2, this.dictionaryFields$3, this.encoding$2, this.allocator$3);
                Tuple2[] toMerge = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])deltas).map((Function1)new Serializable(this, dictionaries2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.15 $outer;
                    public final ArrowAttributeReader[] dictionaries$1;

                    public final Tuple2<ArrowAttributeReader[], TransferPair[]> apply(byte[] bytes) {
                        BoxedUnit boxedUnit;
                        ArrowAttributeReader[] vectors = DeltaWriter$.MODULE$.org$locationtech$geomesa$arrow$io$DeltaWriter$$createNewVectors$1(this.$outer.sft$2, this.$outer.dictionaryFields$3, this.$outer.encoding$2, this.$outer.allocator$3);
                        int offset = 8;
                        for (int i = 0; i < this.dictionaries$1.length; ++i) {
                            int length = Ints.fromBytes((byte)bytes[offset], (byte)bytes[offset + 1], (byte)bytes[offset + 2], (byte)bytes[offset + 3]);
                            offset += 4;
                            if (length <= 0) continue;
                            RecordBatchLoader$.MODULE$.apply(vectors[i].vector(), this.$outer.allocator$3).load(bytes, offset, length);
                            offset += length;
                        }
                        if (DeltaWriter$.MODULE$.logger().underlying().isTraceEnabled()) {
                            DeltaWriter$.MODULE$.logger().underlying().trace("dictionary deltas: {}", new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])vectors).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(ArrowAttributeReader v) {
                                    return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), v.getValueCount()).map((Function1)new Serializable(this, v){
                                        public static final long serialVersionUID = 0L;
                                        private final ArrowAttributeReader v$1;

                                        public final Object apply(int i) {
                                            return this.v$1.apply(i);
                                        }
                                        {
                                            this.v$1 = v$1;
                                        }
                                    }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(";")});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        TransferPair[] transfers = (TransferPair[])ScalaImplicits.RichArray$.MODULE$.mapWithIndex$extension(ScalaImplicits$.MODULE$.RichArray((Object)vectors), (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$15$$anonfun$16 $outer;

                            public final TransferPair apply(ArrowAttributeReader x0$8, int x1$3) {
                                Tuple2 tuple2 = new Tuple2((Object)x0$8, (Object)BoxesRunTime.boxToInteger((int)x1$3));
                                if (tuple2 != null) {
                                    ArrowAttributeReader v = (ArrowAttributeReader)tuple2._1();
                                    int j = tuple2._2$mcI$sp();
                                    TransferPair transferPair = v.vector().makeTransferPair((ValueVector)this.$outer.dictionaries$1[j].vector());
                                    return transferPair;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ClassTag$.MODULE$.apply(TransferPair.class));
                        return new Tuple2((Object)vectors, (Object)transfers);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dictionaries$1 = dictionaries$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                int[][] offsets = (int[][])Array$.MODULE$.tabulate(toMerge.length, (Function1)new Serializable(this, dictionaries2, toMerge){
                    public static final long serialVersionUID = 0L;
                    private final ArrowAttributeReader[] dictionaries$1;
                    private final Tuple2[] toMerge$2;

                    /*
                     * WARNING - void declaration
                     */
                    public final int[] apply(int batch) {
                        void var3_3;
                        int[] offset = (int[])Array$.MODULE$.fill(this.dictionaries$1.length, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }, ClassTag$.MODULE$.Int());
                        for (int i = 0; i < batch; ++i) {
                            ScalaImplicits.RichArray$.MODULE$.foreachIndex$extension(ScalaImplicits$.MODULE$.RichArray(this.toMerge$2[i]._1()), (Function2)new Serializable(this, offset){
                                public static final long serialVersionUID = 0L;
                                private final int[] offset$3;

                                public final void apply(ArrowAttributeReader x0$9, int x1$4) {
                                    Tuple2 tuple2 = new Tuple2((Object)x0$9, (Object)BoxesRunTime.boxToInteger((int)x1$4));
                                    if (tuple2 != null) {
                                        ArrowAttributeReader v = (ArrowAttributeReader)tuple2._1();
                                        int j = tuple2._2$mcI$sp();
                                        this.offset$3[j] = this.offset$3[j] + v.getValueCount();
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                                {
                                    this.offset$3 = offset$3;
                                }
                            });
                        }
                        return var3_3;
                    }
                    {
                        this.dictionaries$1 = dictionaries$1;
                        this.toMerge$2 = toMerge$2;
                    }
                }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
                TransferPair[] transfers = (TransferPair[])Array$.MODULE$.ofDim(dictionaries2.length, ClassTag$.MODULE$.apply(TransferPair.class));
                HashBiMap[] mappings = (HashBiMap[])Array$.MODULE$.fill(dictionaries2.length, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final HashBiMap<Integer, Integer> apply() {
                        return HashBiMap.create();
                    }
                }, ClassTag$.MODULE$.apply(HashBiMap.class));
                IntRef i = IntRef.create((int)0);
                while (i.elem < dictionaries2.length) {
                    ScalaImplicits.RichArray$.MODULE$.foreachIndex$extension(ScalaImplicits$.MODULE$.RichArray((Object)toMerge), (Function2)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.15 $outer;
                        private final IntRef i$3;

                        public final Serializable apply(Tuple2<ArrowAttributeReader[], TransferPair[]> x0$10, int x1$5) {
                            Tuple2 tuple2 = new Tuple2(x0$10, (Object)BoxesRunTime.boxToInteger((int)x1$5));
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._1();
                                int batch = tuple2._2$mcI$sp();
                                if (tuple22 != null) {
                                    ArrowAttributeReader[] vectors = (ArrowAttributeReader[])tuple22._1();
                                    Option option = vectors[this.i$3.elem].getValueCount() > 0 ? this.$outer.queue$2.$plus$eq((Object)new Tuple3(vectors[this.i$3.elem].apply(0), (Object)BoxesRunTime.boxToInteger((int)batch), (Object)BoxesRunTime.boxToInteger((int)0))) : CloseWithLogging$.MODULE$.apply((Object)vectors[this.i$3.elem].vector());
                                    return option;
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.i$3 = i$3;
                        }
                    });
                    int count = 0;
                    while (this.queue$2.nonEmpty()) {
                        Tuple3 tuple3 = (Tuple3)this.queue$2.dequeue();
                        if (tuple3 != null) {
                            Tuple2.mcII.sp sp2;
                            int batch = BoxesRunTime.unboxToInt((Object)tuple3._2());
                            int j = BoxesRunTime.unboxToInt((Object)tuple3._3());
                            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(batch, j);
                            int batch2 = sp3._1$mcI$sp();
                            int j2 = sp3._2$mcI$sp();
                            Tuple2 tuple2 = toMerge[batch2];
                            if (tuple2 != null) {
                                Tuple2 tuple22;
                                ArrowAttributeReader[] vectors = (ArrowAttributeReader[])tuple2._1();
                                TransferPair[] transfers2 = (TransferPair[])tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)vectors, (Object)transfers2);
                                ArrowAttributeReader[] vectors2 = (ArrowAttributeReader[])tuple23._1();
                                TransferPair[] transfers3 = (TransferPair[])tuple23._2();
                                transfers3[i.elem].copyValueSafe(j2, count);
                                mappings[i.elem].put((Object)Predef$.MODULE$.int2Integer(offsets[batch2][i.elem] + j2), (Object)Predef$.MODULE$.int2Integer(count));
                                int jpp = j2 + 1;
                                Object object = jpp < vectors2[i.elem].getValueCount() ? this.queue$2.$plus$eq((Object)new Tuple3(vectors2[i.elem].apply(jpp), (Object)BoxesRunTime.boxToInteger((int)batch2), (Object)BoxesRunTime.boxToInteger((int)jpp))) : CloseWithLogging$.MODULE$.apply((Object)vectors2[i.elem].vector());
                                ++count;
                                continue;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        throw new MatchError((Object)tuple3);
                    }
                    dictionaries2[i.elem].vector().setValueCount(count);
                    transfers[i.elem] = dictionaries2[i.elem].vector().makeTransferPair((ValueVector)this.results$1[i.elem].vector());
                    ++i.elem;
                }
                return new Tuple3((Object)dictionaries2, (Object)transfers, (Object)mappings);
            }
            {
                this.sft$2 = sft$2;
                this.dictionaryFields$3 = dictionaryFields$3;
                this.encoding$2 = encoding$2;
                this.allocator$3 = allocator$3;
                this.results$1 = results$1;
                this.queue$2 = queue$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        scala.collection.mutable.Map[][] mappings = (scala.collection.mutable.Map[][])Array$.MODULE$.fill(results.length, (Function0)new Serializable(allMerges){
            public static final long serialVersionUID = 0L;
            private final Tuple3[] allMerges$1;

            public final scala.collection.mutable.Map<Integer, Integer>[] apply() {
                return (scala.collection.mutable.Map[])Array$.MODULE$.fill(this.allMerges$1.length, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.mutable.Map<Integer, Integer> apply() {
                        return Map$.MODULE$.empty();
                    }
                }, ClassTag$.MODULE$.apply(scala.collection.mutable.Map.class));
            }
            {
                this.allMerges$1 = allMerges$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(scala.collection.mutable.Map.class)));
        ScalaImplicits.RichArray$.MODULE$.foreachIndex$extension(ScalaImplicits$.MODULE$.RichArray((Object)results), (Function2)new Serializable(queue, allMerges, mappings){
            public static final long serialVersionUID = 0L;
            public final PriorityQueue queue$2;
            private final Tuple3[] allMerges$1;
            private final scala.collection.mutable.Map[][] mappings$2;

            public final void apply(ArrowAttributeReader x0$11, int x1$6) {
                Tuple2 tuple2 = new Tuple2((Object)x0$11, (Object)BoxesRunTime.boxToInteger((int)x1$6));
                if (tuple2 != null) {
                    ArrowAttributeReader result = (ArrowAttributeReader)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    ScalaImplicits.RichArray$.MODULE$.foreachIndex$extension(ScalaImplicits$.MODULE$.RichArray((Object)this.allMerges$1), (Function2)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$locationtech$geomesa$arrow$io$DeltaWriter$$mergeDictionaries$1 $outer;
                        private final int i$4;

                        public final Serializable apply(Tuple3<ArrowAttributeReader[], TransferPair[], HashBiMap<Integer, Integer>[]> x0$12, int x1$7) {
                            Tuple2 tuple2 = new Tuple2(x0$12, (Object)BoxesRunTime.boxToInteger((int)x1$7));
                            if (tuple2 != null) {
                                Tuple3 tuple3 = (Tuple3)tuple2._1();
                                int batch = tuple2._2$mcI$sp();
                                if (tuple3 != null) {
                                    ArrowAttributeReader[] vectors = (ArrowAttributeReader[])tuple3._1();
                                    Option option = vectors[this.i$4].getValueCount() > 0 ? this.$outer.queue$2.$plus$eq((Object)new Tuple3(vectors[this.i$4].apply(0), (Object)BoxesRunTime.boxToInteger((int)batch), (Object)BoxesRunTime.boxToInteger((int)0))) : CloseWithLogging$.MODULE$.apply((Object)vectors[this.i$4].vector());
                                    return option;
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.i$4 = i$4;
                        }
                    });
                    int count = 0;
                    while (this.queue$2.nonEmpty()) {
                        Tuple3 tuple3 = (Tuple3)this.queue$2.dequeue();
                        if (tuple3 != null) {
                            Tuple3 tuple32;
                            Object value = tuple3._1();
                            int batch = BoxesRunTime.unboxToInt((Object)tuple3._2());
                            int j = BoxesRunTime.unboxToInt((Object)tuple3._3());
                            Tuple3 tuple33 = tuple32 = new Tuple3(value, (Object)BoxesRunTime.boxToInteger((int)batch), (Object)BoxesRunTime.boxToInteger((int)j));
                            Object value2 = tuple33._1();
                            int batch2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
                            int j2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
                            Tuple3 tuple34 = this.allMerges$1[batch2];
                            if (tuple34 != null) {
                                BoxedUnit boxedUnit;
                                Tuple3 tuple35;
                                ArrowAttributeReader[] vectors = (ArrowAttributeReader[])tuple34._1();
                                TransferPair[] transfers = (TransferPair[])tuple34._2();
                                HashBiMap[] mapping = (HashBiMap[])tuple34._3();
                                Tuple3 tuple36 = tuple35 = new Tuple3((Object)vectors, (Object)transfers, (Object)mapping);
                                ArrowAttributeReader[] vectors2 = (ArrowAttributeReader[])tuple36._1();
                                TransferPair[] transfers2 = (TransferPair[])tuple36._2();
                                HashBiMap[] mapping2 = (HashBiMap[])tuple36._3();
                                if (count == 0 || !BoxesRunTime.equals((Object)result.apply(count - 1), (Object)vectors2[i].apply(j2))) {
                                    transfers2[i].copyValueSafe(j2, count);
                                    ++count;
                                }
                                if (DeltaWriter$.MODULE$.logger().underlying().isTraceEnabled()) {
                                    DeltaWriter$.MODULE$.logger().underlying().trace("remap {} {} {} {} -> {}", new Object[]{value2, BoxesRunTime.boxToInteger((int)batch2), mapping2[i], BoxesRunTime.boxToInteger((int)j2), BoxesRunTime.boxToInteger((int)(count - 1))});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                Integer remap = (Integer)mapping2[i].inverse().get((Object)BoxesRunTime.boxToInteger((int)j2));
                                Object object = remap == null ? BoxedUnit.UNIT : this.mappings$2[i][batch2].put((Object)remap, (Object)Predef$.MODULE$.int2Integer(count - 1));
                                int jpp = j2 + 1;
                                Object object2 = jpp < vectors2[i].getValueCount() ? this.queue$2.$plus$eq((Object)new Tuple3(vectors2[i].apply(jpp), (Object)BoxesRunTime.boxToInteger((int)batch2), (Object)BoxesRunTime.boxToInteger((int)jpp))) : CloseWithLogging$.MODULE$.apply((Object)vectors2[i].vector());
                                continue;
                            }
                            throw new MatchError((Object)tuple34);
                        }
                        throw new MatchError((Object)tuple3);
                    }
                    result.vector().setValueCount(count);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.queue$2 = queue$2;
                this.allMerges$1 = allMerges$1;
                this.mappings$2 = mappings$2;
            }
        });
        Builder dictionaryBuilder = Predef$.MODULE$.Map().newBuilder();
        dictionaryBuilder.sizeHint(dictionaryFields.length());
        Builder mappingsBuilder = Predef$.MODULE$.Map().newBuilder();
        mappingsBuilder.sizeHint(dictionaryFields.length());
        ScalaImplicits.RichTraversableOnce$.MODULE$.foreachIndex$extension(ScalaImplicits$.MODULE$.RichTraversableOnce(dictionaryFields), (Function2)new Serializable(sft, encoding, results, mappings, dictionaryBuilder, mappingsBuilder){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;
            private final SimpleFeatureVector.SimpleFeatureEncoding encoding$2;
            private final ArrowAttributeReader[] results$1;
            private final scala.collection.mutable.Map[][] mappings$2;
            private final Builder dictionaryBuilder$1;
            private final Builder mappingsBuilder$1;

            public final Builder<Tuple2<String, Map<Integer, Integer>[]>, scala.collection.immutable.Map<String, Map<Integer, Integer>[]>> apply(String x0$13, int x1$8) {
                Tuple2 tuple2 = new Tuple2((Object)x0$13, (Object)BoxesRunTime.boxToInteger((int)x1$8));
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String f = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (DeltaWriter$.MODULE$.logger().underlying().isTraceEnabled()) {
                        ArrowAttributeReader arrowAttributeReader = this.results$1[i];
                        DeltaWriter$.MODULE$.logger().underlying().trace(new StringBuilder().append((Object)"merged dictionary: ").append((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.results$1[i].getValueCount()).map((Function1)new Serializable(this, arrowAttributeReader){
                            public static final long serialVersionUID = 0L;
                            private final ArrowAttributeReader eta$0$1$1;

                            public final Object apply(int i) {
                                return this.eta$0$1$1.apply(i);
                            }
                            {
                                this.eta$0$1$1 = eta$0$1$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(",")).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    DictionaryEncoding enc = new DictionaryEncoding((long)i, true, new ArrowType.Int(32, true));
                    this.dictionaryBuilder$1.$plus$eq((Object)new Tuple2((Object)f, (Object)ArrowDictionary$.MODULE$.create(enc, this.results$1[i].vector(), this.sft$2.getDescriptor(f), this.encoding$2)));
                    Builder builder = this.mappingsBuilder$1.$plus$eq((Object)new Tuple2((Object)f, (Object)((Map[])this.mappings$2[i])));
                    return builder;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.sft$2 = sft$2;
                this.encoding$2 = encoding$2;
                this.results$1 = results$1;
                this.mappings$2 = mappings$2;
                this.dictionaryBuilder$1 = dictionaryBuilder$1;
                this.mappingsBuilder$1 = mappingsBuilder$1;
            }
        });
        scala.collection.immutable.Map dictionaryMap = (scala.collection.immutable.Map)dictionaryBuilder.result();
        scala.collection.immutable.Map mappingsMap = (scala.collection.immutable.Map)mappingsBuilder.result();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("batch dictionary mappings: {}", new Object[]{mappingsMap.mapValues((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Map<Integer, Integer>[] x$16) {
                    return Predef$.MODULE$.refArrayOps((Object[])x$16).mkString(",");
                }
            }).mkString(";")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new DeltaWriter.MergedDictionaries((scala.collection.immutable.Map<String, ArrowDictionary>)dictionaryMap, (scala.collection.immutable.Map<String, Map<Integer, Integer>[]>)mappingsMap, allocator2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final byte[] org$locationtech$geomesa$arrow$io$DeltaWriter$$nextBatch$1(int batchSize$2, Function3 getSortAttribute$1, SimpleFeatureVector result$2, RecordBatchUnloader unloader$1, Tuple4[] toMerge$1, PriorityQueue queue$1) {
        if (queue$1.isEmpty()) {
            return null;
        }
        result$2.clear();
        IntRef resultIndex = IntRef.create((int)0);
        do {
            BoxedUnit boxedUnit;
            Tuple4 tuple4;
            Tuple2.mcII.sp sp2;
            Tuple3 tuple3;
            if ((tuple3 = (Tuple3)queue$1.dequeue()) == null) throw new MatchError((Object)tuple3);
            int batch = BoxesRunTime.unboxToInt((Object)tuple3._2());
            int i = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(batch, i);
            int batch2 = sp3._1$mcI$sp();
            int i2 = sp3._2$mcI$sp();
            Tuple4 tuple42 = toMerge$1[batch2];
            if (tuple42 == null) throw new MatchError((Object)tuple42);
            StructVector vector = (StructVector)tuple42._1();
            ArrowAttributeReader sort = (ArrowAttributeReader)tuple42._2();
            Seq transfers = (Seq)tuple42._3();
            Map mappings = (Map)tuple42._4();
            Tuple4 tuple43 = tuple4 = new Tuple4((Object)vector, (Object)sort, (Object)transfers, (Object)mappings);
            StructVector vector2 = (StructVector)tuple43._1();
            ArrowAttributeReader sort2 = (ArrowAttributeReader)tuple43._2();
            Seq transfers2 = (Seq)tuple43._3();
            Map mappings2 = (Map)tuple43._4();
            transfers2.foreach((Function1)new Serializable(resultIndex, i2){
                public static final long serialVersionUID = 0L;
                private final IntRef resultIndex$1;
                private final int i$2;

                public final void apply(Function2<Object, Object, BoxedUnit> x$11) {
                    x$11.apply$mcVII$sp(this.i$2, this.resultIndex$1.elem);
                }
                {
                    this.resultIndex$1 = resultIndex$1;
                    this.i$2 = i$2;
                }
            });
            result$2.underlying().setIndexDefined(resultIndex.elem);
            ++resultIndex.elem;
            int nextBatchIndex = i2 + 1;
            if (vector2.getValueCount() > nextBatchIndex) {
                Object value = getSortAttribute$1.apply((Object)sort2, (Object)mappings2, (Object)BoxesRunTime.boxToInteger((int)nextBatchIndex));
                boxedUnit = queue$1.$plus$eq((Object)new Tuple3(value, (Object)BoxesRunTime.boxToInteger((int)batch2), (Object)BoxesRunTime.boxToInteger((int)nextBatchIndex)));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        } while (queue$1.nonEmpty() && resultIndex.elem < batchSize$2);
        byte[] byArray = unloader$1.unload(resultIndex.elem);
        return byArray;
    }

    public final ArrowAttributeReader[] org$locationtech$geomesa$arrow$io$DeltaWriter$$createNewVectors$1(SimpleFeatureType sft$2, Seq dictionaryFields$3, SimpleFeatureVector.SimpleFeatureEncoding encoding$2, BufferAllocator allocator$3) {
        ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(ArrowAttributeReader.class));
        builder.sizeHint(dictionaryFields$3.length());
        dictionaryFields$3.foreach((Function1)new Serializable(sft$2, encoding$2, allocator$3, builder){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;
            private final SimpleFeatureVector.SimpleFeatureEncoding encoding$2;
            private final BufferAllocator allocator$3;
            private final ArrayBuilder builder$1;

            public final ArrayBuilder<ArrowAttributeReader> apply(String f) {
                AttributeDescriptor descriptor = this.sft$2.getDescriptor(f);
                FieldVector vector = ArrowAttributeWriter$.MODULE$.apply(this.sft$2, descriptor, (Option<StructVector>)None$.MODULE$, (Option<ArrowDictionary>)None$.MODULE$, this.encoding$2, this.allocator$3).vector();
                return (ArrayBuilder)this.builder$1.$plus$eq((Object)ArrowAttributeReader$.MODULE$.apply(descriptor, vector, (Option<ArrowDictionary>)None$.MODULE$, this.encoding$2));
            }
            {
                this.sft$2 = sft$2;
                this.encoding$2 = encoding$2;
                this.allocator$3 = allocator$3;
                this.builder$1 = builder$1;
            }
        });
        return (ArrowAttributeReader[])builder.result();
    }

    private DeltaWriter$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.org$locationtech$geomesa$arrow$io$DeltaWriter$$provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        this.org$locationtech$geomesa$arrow$io$DeltaWriter$$dictionaryOrdering = new Ordering<Object>(){

            public Some<Object> tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Object> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Object> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(Object x, Object y) {
                return SimpleFeatureOrdering$.MODULE$.nullCompare((Comparable)x, y);
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
        this.queueOrdering = new Ordering<Tuple3<Object, Object, Object>>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Tuple3<Object, Object, Object>> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Tuple3<Object, Object, Object>> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(Tuple3<Object, Object, Object> x, Tuple3<Object, Object, Object> y) {
                return SimpleFeatureOrdering$.MODULE$.nullCompare((Comparable)y._1(), x._1());
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
    }
}

