/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.FeatureCollection;
import org.geotools.xsd.PropertyExtractor;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeaturePropertyExtractor
implements PropertyExtractor {
    SchemaIndex schemaIndex;

    public FeaturePropertyExtractor(SchemaIndex schemaIndex) {
        this.schemaIndex = schemaIndex;
    }

    public boolean canHandle(Object object) {
        return object instanceof SimpleFeature && !(object instanceof FeatureCollection);
    }

    public List properties(Object object, XSDElementDeclaration element) {
        XSDElementDeclaration e;
        String typeName;
        XSDTypeDefinition type;
        SimpleFeature feature = (SimpleFeature)object;
        if (feature.getUserData().get("xlink:id") != null) {
            return Collections.EMPTY_LIST;
        }
        SimpleFeatureType featureType = feature.getFeatureType();
        String namespace = featureType.getName().getNamespaceURI();
        if (namespace == null) {
            namespace = element.getTargetNamespace();
        }
        if ((type = this.schemaIndex.getTypeDefinition(new QName(namespace, typeName = featureType.getTypeName()))) == null && (e = this.schemaIndex.getElementDeclaration(new QName(namespace, typeName))) != null) {
            type = e.getTypeDefinition();
        }
        if (type == null) {
            String msg = "Could not find element declaration: (" + namespace + ", " + typeName + " )";
            throw new RuntimeException(msg);
        }
        List particles = Schemas.getChildElementParticles((XSDTypeDefinition)type, (boolean)true);
        ArrayList<Object[]> properties = new ArrayList<Object[]>();
        for (XSDParticle particle : particles) {
            XSDElementDeclaration attribute = (XSDElementDeclaration)particle.getContent();
            if (attribute.isElementDeclarationReference()) {
                attribute = attribute.getResolvedElementDeclaration();
            }
            if ("http://www.opengis.net/gml".equals(attribute.getTargetNamespace()) || featureType.getDescriptor(attribute.getName()) == null) continue;
            Object attributeValue = feature.getAttribute(attribute.getName());
            properties.add(new Object[]{particle, attributeValue});
        }
        return properties;
    }
}

