/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.vectorbin;

import it.geosolutions.jaiext.utilities.shape.LiteShape;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import org.locationtech.jts.awt.ShapeReader;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.geom.util.AffineTransformation;

public class ROIGeometry
extends ROI {
    private static final Logger LOGGER = Logger.getLogger(ROIGeometry.class.getName());
    public static final boolean DEFAULT_ROIGEOMETRY_ANTIALISING = true;
    public static final boolean DEFAULT_ROIGEOMETRY_USEFIXEDPRECISION = false;
    private boolean useAntialiasing = true;
    private boolean useFixedPrecision = false;
    private static final long serialVersionUID = 1L;
    private static final AffineTransformation Y_INVERSION = new AffineTransformation(1.0, 0.0, 0.0, 0.0, -1.0, 0.0);
    private static final String UNSUPPORTED_ROI_TYPE = "The argument be either an ROIGeometry or an ROIShape";
    private final PreparedGeometry theGeom;
    private volatile PlanarImage roiImage;
    private final GeometryFactory geomFactory;
    private static final double tolerance = 1.0;
    private static final PrecisionModel PRECISION = new PrecisionModel(1.0);
    private static final GeometryFactory PRECISE_FACTORY = new GeometryFactory(PRECISION);
    private static final PrecisionModel FLOAT_PRECISION = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
    private static final GeometryFactory FLOAT_PRECISION_FACTORY = new GeometryFactory(FLOAT_PRECISION);
    private final CoordinateSequence testPointCS;
    private final Point testPoint;
    private final CoordinateSequence testRectCS;
    private final Polygon testRect;
    private RenderingHints hints;

    public ROIGeometry(Geometry geom) {
        this(geom, true, false);
    }

    public ROIGeometry(Rectangle rect) {
        this((Geometry)ROIGeometry.toGeometry(rect));
    }

    private static Polygon toGeometry(Rectangle rect) {
        return FLOAT_PRECISION_FACTORY.createPolygon(FLOAT_PRECISION_FACTORY.createLinearRing(new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMinY())}), null);
    }

    public ROIGeometry(Geometry geom, boolean useFixedPrecision) {
        this(geom, true, useFixedPrecision);
    }

    public ROIGeometry(Geometry geom, boolean antiAliasing, boolean useFixedPrecision) {
        this(geom, true, useFixedPrecision, null);
    }

    public ROIGeometry(Geometry geom, RenderingHints hints) {
        this(geom, true, false, hints);
    }

    public ROIGeometry(Geometry geom, boolean antiAliasing, boolean useFixedPrecision, RenderingHints hints) {
        if (geom == null) {
            throw new IllegalArgumentException("geom must not be null");
        }
        if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon)) {
            throw new IllegalArgumentException("geom must be a Polygon, MultiPolygon");
        }
        this.useFixedPrecision = useFixedPrecision;
        this.hints = hints == null ? JAI.getDefaultInstance().getRenderingHints() : hints;
        Geometry cloned = null;
        if (useFixedPrecision) {
            Coordinate[] coords;
            this.geomFactory = PRECISE_FACTORY;
            cloned = this.geomFactory.createGeometry(geom);
            Coordinate[] coordinateArray = coords = cloned.getCoordinates();
            int n = coordinateArray.length;
            for (int i = 0; i < n; ++i) {
                Coordinate coord;
                Coordinate cc1 = coord = coordinateArray[i];
                PRECISION.makePrecise(cc1);
            }
            cloned.normalize();
        } else {
            Coordinate[] coords;
            this.geomFactory = FLOAT_PRECISION_FACTORY;
            cloned = this.geomFactory.createGeometry(geom);
            Coordinate[] coordinateArray = coords = cloned.getCoordinates();
            int n = coordinateArray.length;
            for (int i = 0; i < n; ++i) {
                Coordinate coord;
                Coordinate cc1 = coord = coordinateArray[i];
                FLOAT_PRECISION.makePrecise(cc1);
            }
            cloned.normalize();
        }
        this.theGeom = PreparedGeometryFactory.prepare((Geometry)cloned);
        this.testPointCS = new CoordinateArraySequence(1);
        this.testPoint = this.geomFactory.createPoint(this.testPointCS);
        this.testRectCS = new CoordinateArraySequence(5);
        this.testRect = this.geomFactory.createPolygon(this.geomFactory.createLinearRing(this.testRectCS), null);
    }

    public ROI add(ROI roi) {
        block3: {
            try {
                Geometry geom = this.getGeometry(roi);
                if (geom != null) {
                    Geometry union = geom.union(this.theGeom.getGeometry());
                    return this.buildROIGeometry(union);
                }
            }
            catch (TopologyException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to perform operation using geometries, falling back on raster path", e);
            }
        }
        return super.add(roi);
    }

    public boolean contains(java.awt.Point p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public boolean contains(double x, double y) {
        this.testPointCS.setOrdinate(0, 0, x);
        this.testPointCS.setOrdinate(0, 1, y);
        this.testPoint.geometryChanged();
        return this.theGeom.contains((Geometry)this.testPoint);
    }

    public boolean contains(Rectangle rect) {
        return this.contains(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(Rectangle2D rect) {
        return this.contains(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(int x, int y, int w, int h) {
        return this.contains((double)x, (double)y, (double)w, (double)h);
    }

    public boolean contains(double x, double y, double w, double h) {
        this.setTestRect(x, y, w, h);
        return this.theGeom.contains((Geometry)this.testRect);
    }

    public ROI exclusiveOr(ROI roi) {
        block3: {
            try {
                Geometry geom = this.getGeometry(roi);
                if (geom != null) {
                    return this.buildROIGeometry(this.theGeom.getGeometry().symDifference(geom));
                }
            }
            catch (TopologyException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to perform operation using geometries, falling back on raster path", e);
            }
        }
        return super.exclusiveOr(roi);
    }

    public int[][] getAsBitmask(int x, int y, int width, int height, int[][] mask) {
        ROI roiImage = new ROI((RenderedImage)this.getAsImage());
        return roiImage.getAsBitmask(x, y, width, height, mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanarImage getAsImage() {
        if (this.roiImage == null) {
            ROIGeometry rOIGeometry = this;
            synchronized (rOIGeometry) {
                if (this.roiImage == null) {
                    Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
                    int x = (int)Math.floor(env.getMinX());
                    int y = (int)Math.floor(env.getMinY());
                    int w = (int)Math.ceil(env.getMaxX()) - x;
                    int h = (int)Math.ceil(env.getMaxY()) - y;
                    boolean pixelPerfectRectangle = this.theGeom.getGeometry().isRectangle() && (double)x == env.getMinX() && (double)y == env.getMinY() && (double)(x + w) == env.getMaxX() && (double)(y + h) == env.getMaxY();
                    ParameterBlockJAI pb = new ParameterBlockJAI("VectorBinarize");
                    pb.setParameter("minx", x);
                    pb.setParameter("miny", y);
                    pb.setParameter("width", w);
                    pb.setParameter("height", h);
                    pb.setParameter("geometry", (Object)this.theGeom);
                    pb.setParameter("antiAliasing", this.useAntialiasing && !pixelPerfectRectangle);
                    this.roiImage = JAI.create((String)"VectorBinarize", (ParameterBlock)pb, (RenderingHints)this.hints);
                }
            }
        }
        return this.roiImage;
    }

    public LinkedList getAsRectangleList(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        if (!this.intersects(rect)) {
            return null;
        }
        if (this.theGeom.getGeometry().isRectangle()) {
            Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
            Envelope intersection = env.intersection(new Envelope((double)x, (double)(x + width), (double)y, (double)(y + width)));
            int rx = (int)Math.round(intersection.getMinX());
            int ry = (int)Math.round(intersection.getMinY());
            int rw = (int)Math.round(intersection.getMaxX() - (double)rx);
            int rh = (int)Math.round(intersection.getMaxY() - (double)ry);
            LinkedList<Rectangle> result = new LinkedList<Rectangle>();
            result.add(new Rectangle(rx, ry, rw, rh));
            return result;
        }
        ROI roiImage = new ROI((RenderedImage)this.getAsImage());
        return roiImage.getAsRectangleList(x, y, width, height);
    }

    public Shape getAsShape() {
        return new LiteShape(this.theGeom.getGeometry());
    }

    public Geometry getAsGeometry() {
        return this.theGeom.getGeometry();
    }

    public Rectangle getBounds() {
        Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
        return new Rectangle((int)env.getMinX(), (int)env.getMinY(), (int)env.getWidth(), (int)env.getHeight());
    }

    public Rectangle2D getBounds2D() {
        Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
        return new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight());
    }

    public int getThreshold() {
        return super.getThreshold();
    }

    public ROI intersect(ROI roi) {
        block3: {
            try {
                Geometry geom = this.getGeometry(roi);
                if (geom != null) {
                    Geometry intersect = geom.intersection(this.theGeom.getGeometry());
                    return this.buildROIGeometry(intersect);
                }
            }
            catch (TopologyException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to perform operation using geometries, falling back on raster path", e);
            }
        }
        return super.intersect(roi);
    }

    private Geometry getGeometry(ROI roi) {
        if (roi instanceof ROIGeometry) {
            return ((ROIGeometry)roi).getAsGeometry();
        }
        if (roi instanceof ROIShape) {
            Shape shape = ((ROIShape)roi).getAsShape();
            Geometry geom = ShapeReader.read((Shape)shape, (double)0.0, (GeometryFactory)this.geomFactory);
            geom.apply((CoordinateSequenceFilter)Y_INVERSION);
            return geom;
        }
        return null;
    }

    public boolean intersects(Rectangle rect) {
        this.setTestRect(rect.x, rect.y, rect.width, rect.height);
        return this.theGeom.intersects((Geometry)this.testRect);
    }

    public boolean intersects(Rectangle2D rect) {
        this.setTestRect(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
        return this.theGeom.intersects((Geometry)this.testRect);
    }

    public boolean intersects(int x, int y, int w, int h) {
        this.setTestRect(x, y, w, h);
        return this.theGeom.intersects((Geometry)this.testRect);
    }

    public boolean intersects(double x, double y, double w, double h) {
        this.setTestRect(x, y, w, h);
        return this.theGeom.intersects((Geometry)this.testRect);
    }

    public ROI performImageOp(RenderedImageFactory RIF, ParameterBlock paramBlock, int sourceIndex, RenderingHints renderHints) {
        return super.performImageOp(RIF, paramBlock, sourceIndex, renderHints);
    }

    public ROI performImageOp(String name, ParameterBlock paramBlock, int sourceIndex, RenderingHints renderHints) {
        return super.performImageOp(name, paramBlock, sourceIndex, renderHints);
    }

    public void setThreshold(int threshold) {
        super.setThreshold(threshold);
    }

    public ROI subtract(ROI roi) {
        block3: {
            try {
                Geometry geom = this.getGeometry(roi);
                if (geom != null) {
                    Geometry difference = this.theGeom.getGeometry().difference(geom);
                    return this.buildROIGeometry(difference);
                }
            }
            catch (TopologyException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to perform operation using geometries, falling back on raster path", e);
            }
        }
        return super.subtract(roi);
    }

    public ROI transform(AffineTransform at, Interpolation interp) {
        return this.transform(at);
    }

    public ROI transform(AffineTransform at) {
        Geometry cloned = (Geometry)this.theGeom.getGeometry().clone();
        cloned.apply((CoordinateSequenceFilter)new AffineTransformation(at.getScaleX(), at.getShearX(), at.getTranslateX(), at.getShearY(), at.getScaleY(), at.getTranslateY()));
        if (this.useFixedPrecision) {
            Coordinate[] coords;
            Geometry fixed = PRECISE_FACTORY.createGeometry(cloned);
            Coordinate[] coordinateArray = coords = fixed.getCoordinates();
            int n = coordinateArray.length;
            for (int i = 0; i < n; ++i) {
                Coordinate coord;
                Coordinate precise = coord = coordinateArray[i];
                PRECISION.makePrecise(precise);
            }
            cloned = fixed;
        }
        return this.buildROIGeometry(cloned);
    }

    private void setTestRect(double x, double y, double w, double h) {
        this.testRectCS.setOrdinate(0, 0, x);
        this.testRectCS.setOrdinate(0, 1, y);
        this.testRectCS.setOrdinate(1, 0, x);
        this.testRectCS.setOrdinate(1, 1, y + h);
        this.testRectCS.setOrdinate(2, 0, x + w);
        this.testRectCS.setOrdinate(2, 1, y + h);
        this.testRectCS.setOrdinate(3, 0, x + w);
        this.testRectCS.setOrdinate(3, 1, y);
        this.testRectCS.setOrdinate(4, 0, x);
        this.testRectCS.setOrdinate(4, 1, y);
        this.testRect.geometryChanged();
    }

    private ROI buildROIGeometry(Geometry geometry) {
        final ArrayList polygons = new ArrayList();
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry geom) {
                if (geom instanceof Polygon) {
                    polygons.add((Polygon)geom);
                }
            }
        });
        MultiPolygon geom = null;
        if (polygons.size() == 0) {
            geom = this.geomFactory.createMultiPolygon(new Polygon[0]);
        } else if (polygons.size() == 1) {
            geom = (Geometry)polygons.get(0);
        } else {
            Polygon[] polygonArray = polygons.toArray(new Polygon[polygons.size()]);
            geom = this.geomFactory.createMultiPolygon(polygonArray);
        }
        if (!geom.isEmpty()) {
            geom = this.removeCoaxialVertices((Geometry)geom);
        }
        return new ROIGeometry((Geometry)geom, this.useAntialiasing, this.useFixedPrecision, this.hints);
    }

    public String toString() {
        return "ROIGeometry[" + this.theGeom.getGeometry().toText() + "]";
    }

    private Geometry removeCoaxialVertices(Geometry g) {
        if (g == null) {
            throw new NullPointerException("The provided Geometry is null");
        }
        if (g instanceof LineString) {
            return this.removeCoaxialVertices((LineString)g);
        }
        if (g instanceof Polygon) {
            return this.removeCoaxialVertices((Polygon)g);
        }
        if (g instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)g;
            Polygon[] parts = new Polygon[mp.getNumGeometries()];
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                Polygon part = (Polygon)mp.getGeometryN(i);
                parts[i] = part = this.removeCoaxialVertices(part);
            }
            return g.getFactory().createMultiPolygon(parts);
        }
        throw new IllegalArgumentException("This method can work on LineString, Polygon and Multipolygon: " + g.getClass());
    }

    private LineString removeCoaxialVertices(LineString ls) {
        int size;
        Coordinate lastCoord;
        Coordinate midCoord;
        if (ls == null) {
            throw new NullPointerException("The provided linestring is null");
        }
        int N = ls.getNumPoints();
        boolean isLinearRing = ls instanceof LinearRing;
        ArrayList<Object> retain = new ArrayList<Object>();
        retain.add(ls.getCoordinateN(0));
        int i0 = 0;
        int i1 = 1;
        Coordinate firstCoord = ls.getCoordinateN(i0);
        for (int i2 = 2; i2 < N; ++i2) {
            midCoord = ls.getCoordinateN(i1);
            if (!this.isLaidOnSameAxis(firstCoord, midCoord, lastCoord = ls.getCoordinateN(i2))) {
                retain.add(midCoord);
                i0 = i1;
                firstCoord = ls.getCoordinateN(i0);
            }
            ++i1;
        }
        retain.add(ls.getCoordinateN(N - 1));
        if (isLinearRing && retain.size() > 5 && this.isLaidOnSameAxis(firstCoord = ls.getCoordinateN(N - 2), midCoord = ls.getCoordinateN(N - 1), lastCoord = ls.getCoordinateN(1))) {
            retain.remove(retain.size() - 1);
            retain.set(0, retain.get(retain.size() - 1));
        }
        if ((size = retain.size()) == N) {
            retain.clear();
            return ls;
        }
        return isLinearRing ? ls.getFactory().createLinearRing(retain.toArray(new Coordinate[size])) : ls.getFactory().createLineString(retain.toArray(new Coordinate[size]));
    }

    private boolean isLaidOnSameAxis(Coordinate firstCoord, Coordinate midCoord, Coordinate lastCoord) {
        boolean vertical = firstCoord.x == midCoord.x && midCoord.x == lastCoord.x;
        boolean horizontal = firstCoord.y == midCoord.y && midCoord.y == lastCoord.y;
        return vertical || horizontal;
    }

    private Polygon removeCoaxialVertices(Polygon polygon) {
        if (polygon == null) {
            throw new NullPointerException("The provided Polygon is null");
        }
        GeometryFactory gf = polygon.getFactory();
        LineString exterior = polygon.getExteriorRing();
        LineString shell = this.removeCoaxialVertices(exterior);
        if (shell == null || shell.isEmpty()) {
            return null;
        }
        ArrayList<LineString> holes = new ArrayList<LineString>();
        int size = polygon.getNumInteriorRing();
        for (int i = 0; i < size; ++i) {
            LineString hole = polygon.getInteriorRingN(i);
            if ((hole = this.removeCoaxialVertices(hole)) == null || hole.isEmpty()) continue;
            holes.add(hole);
        }
        return gf.createPolygon((LinearRing)shell, holes.toArray(new LinearRing[holes.size()]));
    }
}

