/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.nio.ByteBuffer;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.S3Filter;
import org.locationtech.geomesa.index.filters.S3Filter$;
import org.locationtech.geomesa.index.filters.S3Filter$$anonfun$7$;
import org.locationtech.geomesa.index.filters.S3Filter$$anonfun$serializeToBytes$2$;
import org.locationtech.geomesa.index.index.s3.package;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.ShortRef;

public final class S3Filter$
implements RowFilter.RowFilterFactory<S3Filter> {
    public static final S3Filter$ MODULE$;
    private final String org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator;
    private final String org$locationtech$geomesa$index$filters$S3Filter$$TermSeparator;
    private final String EpochSeparator;
    private final String XYKey;
    private final String TKey;
    private final String EpochKey;

    static {
        new S3Filter$();
    }

    public String org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator() {
        return this.org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator;
    }

    public String org$locationtech$geomesa$index$filters$S3Filter$$TermSeparator() {
        return this.org$locationtech$geomesa$index$filters$S3Filter$$TermSeparator;
    }

    private String EpochSeparator() {
        return this.EpochSeparator;
    }

    public String XYKey() {
        return this.XYKey;
    }

    public String TKey() {
        return this.TKey;
    }

    public String EpochKey() {
        return this.EpochKey;
    }

    public S3Filter apply(package.S3IndexValues values2) {
        package.S3IndexValues s3IndexValues = values2;
        if (s3IndexValues != null) {
            Tuple3 tuple3;
            int maxTime = s3IndexValues.maxTime();
            Seq<Tuple4<Object, Object, Object, Object>> spatialBounds = s3IndexValues.spatialBounds();
            scala.collection.immutable.Map<Object, Seq<Tuple2<Object, Object>>> temporalBounds = s3IndexValues.temporalBounds();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)maxTime), spatialBounds, temporalBounds);
            int maxTime2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            Seq spatialBounds2 = (Seq)tuple32._2();
            scala.collection.immutable.Map temporalBounds2 = (scala.collection.immutable.Map)tuple32._3();
            double[][] xy = (double[][])((TraversableOnce)spatialBounds2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double[] apply(Tuple4<Object, Object, Object, Object> x0$1) {
                    Tuple4<Object, Object, Object, Object> tuple4 = x0$1;
                    if (tuple4 != null) {
                        double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                        double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                        double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                        double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                        double[] dArray = new double[]{xmin, ymin, xmax, ymax};
                        return dArray;
                    }
                    throw new MatchError(tuple4);
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Seq wholePeriod = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJI.sp(0L, maxTime2)}));
            ShortRef minEpoch = ShortRef.create((short)Short.MAX_VALUE);
            ShortRef maxEpoch = ShortRef.create((short)Short.MIN_VALUE);
            Seq epochsAndTimes = (Seq)((TraversableLike)((SeqLike)temporalBounds2.toSeq().filter((Function1)new Serializable(wholePeriod){
                public static final long serialVersionUID = 0L;
                private final Seq wholePeriod$1;

                public final boolean apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x$3) {
                    Object object = x$3._2();
                    Seq seq = this.wholePeriod$1;
                    return object != null ? !object.equals(seq) : seq != null;
                }
                {
                    this.wholePeriod$1 = wholePeriod$1;
                }
            })).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final short apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x$4) {
                    return BoxesRunTime.unboxToShort((Object)x$4._1());
                }
            }, (Ordering)Ordering.Short$.MODULE$)).map((Function1)new Serializable(minEpoch, maxEpoch){
                public static final long serialVersionUID = 0L;
                private final ShortRef minEpoch$1;
                private final ShortRef maxEpoch$1;

                public final Tuple2<Object, int[][]> apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x0$2) {
                    Tuple2<Object, Seq<Tuple2<Object, Object>>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        short epoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Seq times = (Seq)tuple2._2();
                        if (epoch < this.minEpoch$1.elem) {
                            this.minEpoch$1.elem = epoch;
                        }
                        if (epoch > this.maxEpoch$1.elem) {
                            this.maxEpoch$1.elem = epoch;
                        }
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)epoch), ((TraversableOnce)times.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int[] apply(Tuple2<Object, Object> x0$3) {
                                Tuple2<Object, Object> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    int t1 = tuple2._1$mcI$sp();
                                    int t2 = tuple2._2$mcI$sp();
                                    int[] nArray = new int[]{t1, t2};
                                    return nArray;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.minEpoch$1 = minEpoch$1;
                    this.maxEpoch$1 = maxEpoch$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            int[][][] t = minEpoch.elem == Short.MAX_VALUE && maxEpoch.elem == Short.MIN_VALUE ? (int[][][])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))) : (int[][][])Array$.MODULE$.ofDim(maxEpoch.elem - minEpoch.elem + 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            epochsAndTimes.foreach((Function1)new Serializable(minEpoch, t){
                public static final long serialVersionUID = 0L;
                private final ShortRef minEpoch$1;
                private final int[][][] t$1;

                public final void apply(Tuple2<Object, int[][]> x0$4) {
                    Tuple2<Object, int[][]> tuple2 = x0$4;
                    if (tuple2 != null) {
                        short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        int[][] times = (int[][])tuple2._2();
                        this.t$1[w - this.minEpoch$1.elem] = times;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.minEpoch$1 = minEpoch$1;
                    this.t$1 = t$1;
                }
            });
            return new S3Filter(xy, t, minEpoch.elem, maxEpoch.elem);
        }
        throw new MatchError((Object)s3IndexValues);
    }

    @Override
    public byte[] serializeToBytes(S3Filter filter2) {
        int xyLength = 4 + filter2.xy().length * 32;
        int tLength = 4 + BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])filter2.t()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int[][] bounds) {
                return bounds == null ? 4 : 4 + bounds.length * 8;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ByteBuffer buffer = ByteBuffer.allocate(xyLength + tLength + 4);
        buffer.putInt(filter2.xy().length);
        Predef$.MODULE$.refArrayOps((Object[])filter2.xy()).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            public final ByteBuffer buffer$1;

            public final void apply(double[] bounds) {
                Predef$.MODULE$.doubleArrayOps(bounds).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.serializeToBytes.1 $outer;

                    public final ByteBuffer apply(double x$1) {
                        return this.$outer.buffer$1.putDouble(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
        buffer.putInt(filter2.t().length);
        Predef$.MODULE$.refArrayOps((Object[])filter2.t()).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            public final ByteBuffer buffer$1;

            public final Object apply(int[][] bounds) {
                ByteBuffer byteBuffer;
                if (bounds == null) {
                    byteBuffer = this.buffer$1.putInt(-1);
                } else {
                    this.buffer$1.putInt(bounds.length);
                    Predef$.MODULE$.refArrayOps((Object[])bounds).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.serializeToBytes.2 $outer;

                        public final void apply(int[] inner) {
                            Predef$.MODULE$.intArrayOps(inner).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$serializeToBytes$2$$anonfun$apply$6 $outer;

                                public final ByteBuffer apply(int x$1) {
                                    return this.$outer.org$locationtech$geomesa$index$filters$S3Filter$$anonfun$$anonfun$$$outer().buffer$1.putInt(x$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.serializeToBytes.2 org$locationtech$geomesa$index$filters$S3Filter$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    byteBuffer = BoxedUnit.UNIT;
                }
                return byteBuffer;
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
        buffer.putShort(filter2.minEpoch());
        buffer.putShort(filter2.maxEpoch());
        return buffer.array();
    }

    @Override
    public S3Filter deserializeFromBytes(byte[] serialized) {
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        double[][] xy = (double[][])Array$.MODULE$.fill(buffer.getInt(), (Function0)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            public final ByteBuffer buffer$2;

            public final double[] apply() {
                return (double[])Array$.MODULE$.fill(4, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.6 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.buffer$2.getDouble();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double());
            }
            {
                this.buffer$2 = buffer$2;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        int[][][] t = (int[][][])Array$.MODULE$.fill(buffer.getInt(), (Function0)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            public final ByteBuffer buffer$2;

            public final int[][] apply() {
                int length = this.buffer$2.getInt();
                return length == -1 ? null : (int[][])Array$.MODULE$.fill(length, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.7 $outer;

                    public final int[] apply() {
                        return (int[])Array$.MODULE$.fill(2, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$7$$anonfun$apply$8 $outer;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.$outer.org$locationtech$geomesa$index$filters$S3Filter$$anonfun$$anonfun$$$outer().buffer$2.getInt();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ClassTag$.MODULE$.Int());
                    }

                    public /* synthetic */ anonfun.7 org$locationtech$geomesa$index$filters$S3Filter$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
            }
            {
                this.buffer$2 = buffer$2;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        short minEpoch = buffer.getShort();
        short maxEpoch = buffer.getShort();
        return new S3Filter(xy, t, minEpoch, maxEpoch);
    }

    @Override
    public scala.collection.immutable.Map<String, String> serializeToStrings(S3Filter filter2) {
        String xy = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filter2.xy()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(double[] bounds) {
                return Predef$.MODULE$.doubleArrayOps(bounds).mkString(S3Filter$.MODULE$.org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(this.org$locationtech$geomesa$index$filters$S3Filter$$TermSeparator());
        String t = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filter2.t()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int[][] bounds) {
                return bounds == null ? "" : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])bounds).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int[] x$5) {
                        return Predef$.MODULE$.intArrayOps(x$5).mkString(S3Filter$.MODULE$.org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(S3Filter$.MODULE$.org$locationtech$geomesa$index$filters$S3Filter$$TermSeparator());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(this.EpochSeparator());
        String epoch = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)filter2.minEpoch()), this.org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator(), BoxesRunTime.boxToShort((short)filter2.maxEpoch())}));
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.XYKey()), (Object)xy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TKey()), (Object)t), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EpochKey()), (Object)epoch)}));
    }

    @Override
    public S3Filter deserializeFromStrings(Map<String, String> serialized) {
        double[][] xy = (double[][])Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.XYKey())).split(this.org$locationtech$geomesa$index$filters$S3Filter$$TermSeparator())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double[] apply(String x$6) {
                return (double[])Predef$.MODULE$.refArrayOps((Object[])x$6.split(S3Filter$.MODULE$.org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$7) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        int[][][] t = (int[][][])Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.TKey())).split(this.EpochSeparator())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int[][] apply(String bounds) {
                return bounds.isEmpty() ? null : (int[][])Predef$.MODULE$.refArrayOps((Object[])bounds.split(S3Filter$.MODULE$.org$locationtech$geomesa$index$filters$S3Filter$$TermSeparator())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int[] apply(String x$8) {
                        return (int[])Predef$.MODULE$.refArrayOps((Object[])x$8.split(S3Filter$.MODULE$.org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator())).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(String x$9) {
                                return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))));
        short[] sArray = (short[])Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.EpochKey())).split(this.org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final short apply(String x$10) {
                return new StringOps(Predef$.MODULE$.augmentString(x$10)).toShort();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
        Option option = Array$.MODULE$.unapplySeq((Object)sArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            short minEpoch = BoxesRunTime.unboxToShort((Object)((SeqLike)option.get()).apply(0));
            short maxEpoch = BoxesRunTime.unboxToShort((Object)((SeqLike)option.get()).apply(1));
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)minEpoch), (Object)BoxesRunTime.boxToShort((short)maxEpoch));
            short minEpoch2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
            short maxEpoch2 = BoxesRunTime.unboxToShort((Object)tuple22._2());
            return new S3Filter(xy, t, minEpoch2, maxEpoch2);
        }
        throw new MatchError((Object)sArray);
    }

    private S3Filter$() {
        MODULE$ = this;
        this.org$locationtech$geomesa$index$filters$S3Filter$$RangeSeparator = ":";
        this.org$locationtech$geomesa$index$filters$S3Filter$$TermSeparator = ";";
        this.EpochSeparator = ",";
        this.XYKey = "sxy";
        this.TKey = "st";
        this.EpochKey = "epoch";
    }
}

