/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import org.geotools.filter.FilterAbstract;
import org.geotools.filter.FilterType;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;

public abstract class AbstractFilter
extends FilterAbstract
implements FilterType,
Filter {
    protected static final Logger LOGGER = Logging.getLogger(AbstractFilter.class);

    protected AbstractFilter() {
    }

    public static boolean isLogicFilter(short filterType) {
        LOGGER.entering("AbstractFilter", "isLogicFilter", filterType);
        return filterType == 1 || filterType == 2 || filterType == 3;
    }

    protected static boolean isMathFilter(int filterType) {
        return filterType == 15 || filterType == 16 || filterType == 17 || filterType == 18;
    }

    protected static boolean isCompareFilter(int filterType) {
        return AbstractFilter.isMathFilter(filterType) || filterType == 14 || filterType == 19 || filterType == 23;
    }

    protected static boolean isGeometryFilter(short filterType) {
        return filterType == 4 || filterType == 5 || filterType == 6 || filterType == 8 || filterType == 7 || filterType == 9 || filterType == 10 || filterType == 11 || filterType == 12 || filterType == 24 || filterType == 13;
    }

    protected static boolean isGeometryDistanceFilter(short filterType) {
        return filterType == 24 || filterType == 13;
    }

    public static boolean isSimpleFilter(short filterType) {
        return AbstractFilter.isCompareFilter(filterType) || AbstractFilter.isGeometryFilter(filterType) || filterType == 21 || filterType == 22 || filterType == 20;
    }
}

