/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.orc;

import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemStorage$;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter$;
import org.locationtech.geomesa.fs.storage.orc.utils.OrcAttributeWriter;
import org.locationtech.geomesa.fs.storage.orc.utils.OrcAttributeWriter$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u0001=\u00111c\u0014:d\r&dWmU=ti\u0016lwK]5uKJT!a\u0001\u0003\u0002\u0007=\u00148M\u0003\u0002\u0006\r\u000591\u000f^8sC\u001e,'BA\u0004\t\u0003\t17O\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u00111A\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a[9\u0011!D\u000b\b\u00037!r!\u0001H\u0014\u000f\u0005u1cB\u0001\u0010&\u001d\tyBE\u0004\u0002!G5\t\u0011E\u0003\u0002#\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\tIC!A\u0002ba&L!a\u000b\u0017\u0002#\u0019KG.Z*zgR,Wn\u0015;pe\u0006<WM\u0003\u0002*\t%\u0011af\f\u0002\u0011\r&dWmU=ti\u0016lwK]5uKJT!a\u000b\u0017\t\u0011E\u0002!\u0011!Q\u0001\nI\n1a\u001d4u!\t\u0019$(D\u00015\u0015\t)d'\u0001\u0004tS6\u0004H.\u001a\u0006\u0003oa\nqAZ3biV\u0014XM\u0003\u0002:\u0019\u00059q\u000e]3oO&\u001c\u0018BA\u001e5\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\t{\u0001\u0011\t\u0011)A\u0005}\u000511m\u001c8gS\u001e\u0004\"a\u0010$\u000e\u0003\u0001S!!\u0011\"\u0002\t\r|gN\u001a\u0006\u0003\u0007\u0012\u000ba\u0001[1e_>\u0004(BA#\r\u0003\u0019\t\u0007/Y2iK&\u0011q\t\u0011\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011%\u0003!\u0011!Q\u0001\n)\u000bAAZ5mKB\u00111*T\u0007\u0002\u0019*\u0011qAQ\u0005\u0003\u001d2\u0013A\u0001U1uQ\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011+\u0001\u0005pEN,'O^3s!\t\u0011f+D\u0001T\u0015\t\u0001FK\u0003\u0002V\t\u000511m\\7n_:L!aV*\u0003%\u0019KG.Z*zgR,Wn\u00142tKJ4XM\u001d\u0005\u00063\u0002!\tAW\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bmkfl\u00181\u0011\u0005q\u0003Q\"\u0001\u0002\t\u000bEB\u0006\u0019\u0001\u001a\t\u000buB\u0006\u0019\u0001 \t\u000b%C\u0006\u0019\u0001&\t\u000fAC\u0006\u0013!a\u0001#\"9!\r\u0001b\u0001\n\u0013\u0019\u0017AB:dQ\u0016l\u0017-F\u0001e!\t)w-D\u0001g\u0015\t\u0019A)\u0003\u0002iM\nyA+\u001f9f\t\u0016\u001c8M]5qi&|g\u000e\u0003\u0004k\u0001\u0001\u0006I\u0001Z\u0001\bg\u000eDW-\\1!\u0011\u001da\u0007A1A\u0005\n5\fqa\u001c9uS>t7/F\u0001o!\ty'O\u0004\u0002fa&\u0011\u0011OZ\u0001\b\u001fJ\u001cg)\u001b7f\u0013\t\u0019HOA\u0007Xe&$XM](qi&|gn\u001d\u0006\u0003c\u001aDaA\u001e\u0001!\u0002\u0013q\u0017\u0001C8qi&|gn\u001d\u0011\t\u000fa\u0004!\u0019!C\u0005s\u00061qO]5uKJ,\u0012A\u001f\t\u0003KnL!\u0001 4\u0003\r]\u0013\u0018\u000e^3s\u0011\u0019q\b\u0001)A\u0005u\u00069qO]5uKJ\u0004\u0003\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0003\u0015\u0011\u0017\r^2i+\t\t)\u0001\u0005\u0003\u0002\b\u0005]QBAA\u0005\u0015\u0011\tY!!\u0004\u0002\rY,7\r^8s\u0015\u0011\ty!!\u0005\u0002\t\u0015DXm\u0019\u0006\u0005\u0003'\t)\"\u0001\u0002rY*\u0011QAZ\u0005\u0005\u00033\tIA\u0001\nWK\u000e$xN]5{K\u0012\u0014vn\u001e\"bi\u000eD\u0007\u0002CA\u000f\u0001\u0001\u0006I!!\u0002\u0002\r\t\fGo\u00195!\u0011%\t\t\u0003\u0001b\u0001\n\u0013\t\u0019#A\bbiR\u0014\u0018NY;uK^\u0013\u0018\u000e^3s+\t\t)\u0003\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tYCA\u0001\u0006kRLGn]\u0005\u0005\u0003_\tIC\u0001\nPe\u000e\fE\u000f\u001e:jEV$Xm\u0016:ji\u0016\u0014\b\u0002CA\u001a\u0001\u0001\u0006I!!\n\u0002!\u0005$HO]5ckR,wK]5uKJ\u0004\u0003bBA\u001c\u0001\u0011\u0005\u0013\u0011H\u0001\u0006oJLG/\u001a\u000b\u0005\u0003w\t9\u0005\u0005\u0003\u0002>\u0005\rSBAA \u0015\t\t\t%A\u0003tG\u0006d\u0017-\u0003\u0003\u0002F\u0005}\"\u0001B+oSRD\u0001\"!\u0013\u00026\u0001\u0007\u00111J\u0001\u0003g\u001a\u00042aMA'\u0013\r\ty\u0005\u000e\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V\u0005)a\r\\;tQR\u0011\u00111\b\u0005\b\u00033\u0002A\u0011IA+\u0003\u0015\u0019Gn\\:f\u0011\u001d\ti\u0006\u0001C\u0005\u0003+\n!B\u001a7vg\"\u0014\u0015\r^2i\u000f%\t\tGAA\u0001\u0012\u0003\t\u0019'A\nPe\u000e4\u0015\u000e\\3TsN$X-\\,sSR,'\u000fE\u0002]\u0003K2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qM\n\u0005\u0003K\nI\u0007\u0005\u0003\u0002>\u0005-\u0014\u0002BA7\u0003\u007f\u0011a!\u00118z%\u00164\u0007bB-\u0002f\u0011\u0005\u0011\u0011\u000f\u000b\u0003\u0003GB!\"!\u001e\u0002fE\u0005I\u0011AA<\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0010\u0016\u0004#\u0006m4FAA?!\u0011\ty(!#\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\u0005\u001d\u0015qH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAF\u0003\u0003\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class OrcFileSystemWriter
implements FileSystemStorage.FileSystemWriter {
    private final FileSystemObserver observer;
    private final TypeDescription schema;
    private final OrcFile.WriterOptions options;
    private final Writer writer;
    private final VectorizedRowBatch batch;
    private final OrcAttributeWriter attributeWriter;

    public static FileSystemObserver $lessinit$greater$default$4() {
        return OrcFileSystemWriter$.MODULE$.$lessinit$greater$default$4();
    }

    private TypeDescription schema() {
        return this.schema;
    }

    private OrcFile.WriterOptions options() {
        return this.options;
    }

    private Writer writer() {
        return this.writer;
    }

    private VectorizedRowBatch batch() {
        return this.batch;
    }

    private OrcAttributeWriter attributeWriter() {
        return this.attributeWriter;
    }

    public void write(SimpleFeature sf) {
        this.attributeWriter().apply(sf, this.batch().size);
        ++this.batch().size;
        if (this.batch().size == this.batch().getMaxSize()) {
            this.writer().addRowBatch(this.batch());
            this.batch().reset();
        }
        this.observer.write(sf);
    }

    public void flush() {
        this.flushBatch();
        this.observer.flush();
    }

    public void close() {
        try {
            this.flushBatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            CloseQuietly$.MODULE$.apply((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Closeable[]{this.writer(), this.observer}))).foreach((Function1)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final void apply(Throwable x$1) {
                    this.e$1.addSuppressed(x$1);
                }
                {
                    this.e$1 = e$1;
                }
            });
            throw e;
        }
        CloseQuietly$.MODULE$.apply((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Closeable[]{this.writer(), this.observer}))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Throwable e) {
                throw e;
            }
        });
    }

    private void flushBatch() {
        if (this.batch().size != 0) {
            this.writer().addRowBatch(this.batch());
            this.batch().reset();
        }
    }

    public OrcFileSystemWriter(SimpleFeatureType sft, Configuration config, Path file, FileSystemObserver observer) {
        this.observer = observer;
        this.schema = OrcFileSystemStorage$.MODULE$.createTypeDescription(sft, OrcFileSystemStorage$.MODULE$.createTypeDescription$default$2());
        this.options = OrcFile.writerOptions((Configuration)config).setSchema(this.schema());
        this.writer = OrcFile.createWriter((Path)file, (OrcFile.WriterOptions)this.options());
        this.batch = this.schema().createRowBatch();
        this.attributeWriter = OrcAttributeWriter$.MODULE$.apply(sft, this.batch(), OrcAttributeWriter$.MODULE$.apply$default$3());
    }
}

