/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.utils;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$RemoteIterator$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Stream;
import scala.concurrent.duration.Duration;

public final class PathCache$ {
    public static final PathCache$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty CacheDurationProperty;
    private final long duration;
    private final LoadingCache<Tuple2<FileContext, Path>, Boolean> pathCache;
    private final LoadingCache<Tuple2<FileContext, Path>, FileStatus> org$locationtech$geomesa$fs$storage$common$utils$PathCache$$statusCache;
    private final LoadingCache<Tuple2<FileContext, Path>, Stream<FileStatus>> org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache;

    static {
        new PathCache$();
    }

    public GeoMesaSystemProperties.SystemProperty CacheDurationProperty() {
        return this.CacheDurationProperty;
    }

    private long duration() {
        return this.duration;
    }

    private LoadingCache<Tuple2<FileContext, Path>, Boolean> pathCache() {
        return this.pathCache;
    }

    public LoadingCache<Tuple2<FileContext, Path>, FileStatus> org$locationtech$geomesa$fs$storage$common$utils$PathCache$$statusCache() {
        return this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$statusCache;
    }

    public LoadingCache<Tuple2<FileContext, Path>, Stream<FileStatus>> org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache() {
        return this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache;
    }

    public void register(FileContext fc, Path path, Option<FileStatus> status, Option<Stream<FileStatus>> list) {
        this.pathCache().put((Object)new Tuple2((Object)fc, (Object)path), (Object)Boolean.TRUE);
        status.foreach((Function1)new Serializable(fc, path){
            public static final long serialVersionUID = 0L;
            private final FileContext fc$1;
            private final Path path$1;

            public final void apply(FileStatus x$1) {
                PathCache$.MODULE$.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$statusCache().put((Object)new Tuple2((Object)this.fc$1, (Object)this.path$1), (Object)x$1);
            }
            {
                this.fc$1 = fc$1;
                this.path$1 = path$1;
            }
        });
        list.foreach((Function1)new Serializable(fc, path){
            public static final long serialVersionUID = 0L;
            private final FileContext fc$1;
            private final Path path$1;

            public final void apply(Stream<FileStatus> x$2) {
                PathCache$.MODULE$.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache().put((Object)new Tuple2((Object)this.fc$1, (Object)this.path$1), x$2);
            }
            {
                this.fc$1 = fc$1;
                this.path$1 = path$1;
            }
        });
    }

    public Option<FileStatus> register$default$3() {
        return None$.MODULE$;
    }

    public Option<Stream<FileStatus>> register$default$4() {
        return None$.MODULE$;
    }

    public boolean exists(FileContext fc, Path path, boolean reload2) {
        if (reload2) {
            this.invalidate(fc, path);
        }
        return (Boolean)this.pathCache().get((Object)new Tuple2((Object)fc, (Object)path));
    }

    public boolean exists$default$3() {
        return false;
    }

    public FileStatus status(FileContext fc, Path path) {
        return (FileStatus)this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$statusCache().get((Object)new Tuple2((Object)fc, (Object)path));
    }

    public Iterator<FileStatus> list(FileContext fc, Path dir) {
        return ((Stream)this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache().get((Object)new Tuple2((Object)fc, (Object)dir))).iterator();
    }

    public void invalidate(FileContext fc, Path path) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LoadingCache[]{this.pathCache(), this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$statusCache(), this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache()}))).foreach((Function1)new Serializable(fc, path){
            public static final long serialVersionUID = 0L;
            private final FileContext fc$2;
            private final Path path$2;

            public final void apply(LoadingCache<Tuple2<FileContext, Path>, ? super Stream<FileStatus>> x$3) {
                x$3.invalidate((Object)new Tuple2((Object)this.fc$2, (Object)this.path$2));
            }
            {
                this.fc$2 = fc$2;
                this.path$2 = path$2;
            }
        });
    }

    private PathCache$() {
        MODULE$ = this;
        this.CacheDurationProperty = new GeoMesaSystemProperties.SystemProperty("geomesa.fs.file.cache.duration", "10 minutes");
        this.duration = ((Duration)this.CacheDurationProperty().toDuration().get()).toMillis();
        this.pathCache = Caffeine.newBuilder().expireAfterWrite(this.duration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Tuple2<FileContext, Path>, Boolean>(){

            public Boolean load(Tuple2<FileContext, Path> key2) {
                return Predef$.MODULE$.boolean2Boolean(((FileContext)key2._1()).util().exists((Path)key2._2()));
            }
        });
        this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$statusCache = Caffeine.newBuilder().expireAfterWrite(this.duration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Tuple2<FileContext, Path>, FileStatus>(){

            public FileStatus load(Tuple2<FileContext, Path> key2) {
                return ((FileContext)key2._1()).getFileStatus((Path)key2._2());
            }
        });
        this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache = Caffeine.newBuilder().expireAfterWrite(this.duration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Tuple2<FileContext, Path>, Stream<FileStatus>>(){

            public Stream<FileStatus> load(Tuple2<FileContext, Path> key2) {
                return PathCache$RemoteIterator$.MODULE$.apply(((FileContext)key2._1()).listStatus((Path)key2._2())).toStream();
            }
        });
    }
}

