/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u00015\u0011\u0001b\u0012:jINs\u0017\r\u001d\u0006\u0003\u0007\u0011\t\u0001bZ3pi>|Gn\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!\u0011!Q\u0001\nY\t1!\u001a8w!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0003hK>l'BA\u000e\t\u0003\rQGo]\u0005\u0003;a\u0011\u0001\"\u00128wK2|\u0007/\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005)\u0001pU5{KB\u0011q\"I\u0005\u0003EA\u00111!\u00138u\u0011!!\u0003A!A!\u0002\u0013\u0001\u0013!B=TSj,\u0007\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\b\u0006\u0003)U-b\u0003CA\u0015\u0001\u001b\u0005\u0011\u0001\"B\u000b&\u0001\u00041\u0002\"B\u0010&\u0001\u0004\u0001\u0003\"\u0002\u0013&\u0001\u0004\u0001\u0003\u0002\u0003\u0018\u0001\u0011\u000b\u0007I\u0011A\u0018\u0002\u0011\u0015tg/\u001a7pa\u0016,\u0012\u0001\r\t\u0003/EJ!A\r\r\u0003\u0011\u001d+w.\\3uefD\u0001\u0002\u000e\u0001\t\u0002\u0003\u0006K\u0001M\u0001\nK:4X\r\\8qK\u0002BqA\u000e\u0001C\u0002\u0013%q'\u0001\u0003y\u001b&tW#\u0001\u001d\u0011\u0005=I\u0014B\u0001\u001e\u0011\u0005\u0019!u.\u001e2mK\"1A\b\u0001Q\u0001\na\nQ\u0001_'j]\u0002BqA\u0010\u0001C\u0002\u0013%q'\u0001\u0003y\u001b\u0006D\bB\u0002!\u0001A\u0003%\u0001(A\u0003y\u001b\u0006D\b\u0005C\u0004C\u0001\t\u0007I\u0011B\u001c\u0002\tel\u0015N\u001c\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001d\u0002\u000bel\u0015N\u001c\u0011\t\u000f\u0019\u0003!\u0019!C\u0005o\u0005!\u00110T1y\u0011\u0019A\u0005\u0001)A\u0005q\u0005)\u00110T1yA!9!\n\u0001b\u0001\n\u00139\u0014A\u00013y\u0011\u0019a\u0005\u0001)A\u0005q\u0005\u0019A\r\u001f\u0011\t\u000f9\u0003!\u0019!C\u0005o\u0005\u0011A-\u001f\u0005\u0007!\u0002\u0001\u000b\u0011\u0002\u001d\u0002\u0007\u0011L\b\u0005C\u0004S\u0001\t\u0007I\u0011B\u001c\u0002\u000fa|eMZ:fi\"1A\u000b\u0001Q\u0001\na\n\u0001\u0002_(gMN,G\u000f\t\u0005\b-\u0002\u0011\r\u0011\"\u00038\u0003\u001dIxJ\u001a4tKRDa\u0001\u0017\u0001!\u0002\u0013A\u0014\u0001C=PM\u001a\u001cX\r\u001e\u0011\t\u000bi\u0003A\u0011A.\u0002\u0003a$\"\u0001\u000f/\t\u000buK\u0006\u0019\u0001\u0011\u0002\u0003%DQa\u0018\u0001\u0005\u0002\u0001\f\u0011!\u001f\u000b\u0003q\u0005DQA\u00190A\u0002\u0001\n\u0011A\u001b\u0005\u0006;\u0002!\t\u0001\u001a\u000b\u0003A\u0015DQAW2A\u0002aBQA\u0019\u0001\u0005\u0002\u001d$\"\u0001\t5\t\u000b}3\u0007\u0019\u0001\u001d\t\u000b)\u0004A\u0011A6\u0002\tMt\u0017\r\u001d\u000b\u0004Y>\u0004\b\u0003B\bnqaJ!A\u001c\t\u0003\rQ+\b\u000f\\33\u0011\u0015Q\u0016\u000e1\u00019\u0011\u0015y\u0016\u000e1\u00019\u0011\u0015\u0011\b\u0001\"\u0001t\u00035\u0011'/Z:f]\"\fW\u000eT5oKRIA/a\u0001\u0002\b\u0005-\u0011q\u0002\t\u0005kv\f\tA\u0004\u0002ww:\u0011qO_\u0007\u0002q*\u0011\u0011\u0010D\u0001\u0007yI|w\u000e\u001e \n\u0003EI!\u0001 \t\u0002\u000fA\f7m[1hK&\u0011ap \u0002\t\u0013R,'/\u0019;pe*\u0011A\u0010\u0005\t\u0005\u001f5\u0004\u0003\u0005\u0003\u0004\u0002\u0006E\u0004\r\u0001I\u0001\u0003qBBa!!\u0003r\u0001\u0004\u0001\u0013AA=1\u0011\u0019\ti!\u001da\u0001A\u0005\u0011\u00010\r\u0005\u0007\u0003#\t\b\u0019\u0001\u0011\u0002\u0005e\f\u0004")
public class GridSnap {
    private final Envelope env;
    private final int xSize;
    private final int ySize;
    private Geometry envelope;
    private final double xMin;
    private final double xMax;
    private final double yMin;
    private final double yMax;
    private final double dx;
    private final double dy;
    private final double xOffset;
    private final double yOffset;
    private volatile boolean bitmap$0;

    private Geometry envelope$lzycompute() {
        GridSnap gridSnap = this;
        synchronized (gridSnap) {
            if (!this.bitmap$0) {
                this.envelope = GeometryUtils$.MODULE$.geoFactory().toGeometry(this.env);
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.env = null;
            return this.envelope;
        }
    }

    public Geometry envelope() {
        return this.bitmap$0 ? this.envelope : this.envelope$lzycompute();
    }

    private double xMin() {
        return this.xMin;
    }

    private double xMax() {
        return this.xMax;
    }

    private double yMin() {
        return this.yMin;
    }

    private double yMax() {
        return this.yMax;
    }

    private double dx() {
        return this.dx;
    }

    private double dy() {
        return this.dy;
    }

    private double xOffset() {
        return this.xOffset;
    }

    private double yOffset() {
        return this.yOffset;
    }

    public double x(int i) {
        return this.xOffset() + this.dx() * (double)i;
    }

    public double y(int j) {
        return this.yOffset() + this.dy() * (double)j;
    }

    public int i(double x) {
        int i;
        return x < this.xMin() || x > this.xMax() ? -1 : ((i = (int)package$.MODULE$.floor((x - this.xMin()) / this.dx())) >= this.xSize ? this.xSize - 1 : i);
    }

    public int j(double y) {
        int i;
        return y < this.yMin() || y > this.yMax() ? -1 : ((i = (int)package$.MODULE$.floor((y - this.yMin()) / this.dy())) >= this.ySize ? this.ySize - 1 : i);
    }

    public Tuple2<Object, Object> snap(double x, double y) {
        return new Tuple2.mcDD.sp(this.x(this.i(x)), this.y(this.j(y)));
    }

    public Iterator<Tuple2<Object, Object>> bresenhamLine(int x0, int y0, int x1, int y1) {
        Iterator iterator2;
        int deltaX = package$.MODULE$.abs(x1 - x0);
        int deltaY = package$.MODULE$.abs(y1 - y0);
        if (deltaX == 0 && deltaY == 0) {
            iterator2 = scala.package$.MODULE$.Iterator().single((Object)new Tuple2.mcII.sp(x0, y0));
        } else {
            int stepY;
            int stepX = x0 < x1 ? 1 : -1;
            int n = stepY = y0 < y1 ? 1 : -1;
            if (deltaX > deltaY) {
                double deltaError = (double)deltaY / (double)deltaX;
                DoubleRef error = DoubleRef.create((double)0.0);
                iterator2 = scala.package$.MODULE$.Iterator().iterate((Object)new Tuple2.mcII.sp(x0, y0), (Function1)new Serializable(this, stepX, stepY, deltaError, error){
                    public static final long serialVersionUID = 0L;
                    private final int stepX$1;
                    private final int stepY$1;
                    private final double deltaError$1;
                    private final DoubleRef error$1;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Tuple2.mcII.sp sp2;
                            int x = tuple2._1$mcI$sp();
                            int y = tuple2._2$mcI$sp();
                            this.error$1.elem += this.deltaError$1;
                            if (this.error$1.elem >= 0.5) {
                                this.error$1.elem -= 1.0;
                                sp2 = new Tuple2.mcII.sp(x + this.stepX$1, y + this.stepY$1);
                            } else {
                                sp2 = new Tuple2.mcII.sp(x + this.stepX$1, y);
                            }
                            Tuple2.mcII.sp sp3 = sp2;
                            return sp3;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.stepX$1 = stepX$1;
                        this.stepY$1 = stepY$1;
                        this.deltaError$1 = deltaError$1;
                        this.error$1 = error$1;
                    }
                }).take(deltaX);
            } else {
                double deltaError = (double)deltaX / (double)deltaY;
                DoubleRef error = DoubleRef.create((double)0.0);
                iterator2 = scala.package$.MODULE$.Iterator().iterate((Object)new Tuple2.mcII.sp(x0, y0), (Function1)new Serializable(this, stepX, stepY, deltaError, error){
                    public static final long serialVersionUID = 0L;
                    private final int stepX$1;
                    private final int stepY$1;
                    private final double deltaError$2;
                    private final DoubleRef error$2;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Tuple2.mcII.sp sp2;
                            int x = tuple2._1$mcI$sp();
                            int y = tuple2._2$mcI$sp();
                            this.error$2.elem += this.deltaError$2;
                            if (this.error$2.elem >= 0.5) {
                                this.error$2.elem -= 1.0;
                                sp2 = new Tuple2.mcII.sp(x + this.stepX$1, y + this.stepY$1);
                            } else {
                                sp2 = new Tuple2.mcII.sp(x, y + this.stepY$1);
                            }
                            Tuple2.mcII.sp sp3 = sp2;
                            return sp3;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.stepX$1 = stepX$1;
                        this.stepY$1 = stepY$1;
                        this.deltaError$2 = deltaError$2;
                        this.error$2 = error$2;
                    }
                }).take(deltaY);
            }
        }
        return iterator2;
    }

    public GridSnap(Envelope env, int xSize, int ySize) {
        this.env = env;
        this.xSize = xSize;
        this.ySize = ySize;
        this.xMin = env.getMinX();
        this.xMax = env.getMaxX();
        this.yMin = env.getMinY();
        this.yMax = env.getMaxY();
        this.dx = (this.xMax() - this.xMin()) / (double)xSize;
        this.dy = (this.yMax() - this.yMin()) / (double)ySize;
        this.xOffset = this.xMin() + this.dx() / (double)2;
        this.yOffset = this.yMin() + this.dy() / (double)2;
    }
}

