/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.avro;

import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.SerializationOption$;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils$;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureWriter$;
import org.locationtech.geomesa.features.avro.FieldNameEncoder;
import org.locationtech.geomesa.features.avro.FieldNameEncoder$;
import org.locationtech.geomesa.features.avro.serialization.AvroUserDataSerialization$;
import org.locationtech.jts.io.WKBWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.NotImplementedError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u00015\u0011q#\u0011<s_NKW\u000e\u001d7f\r\u0016\fG/\u001e:f/JLG/\u001a:\u000b\u0005\r!\u0011\u0001B1we>T!!\u0002\u0004\u0002\u0011\u0019,\u0017\r^;sKNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\f\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u00042aF\u000f \u001b\u0005A\"BA\r\u001b\u0003\tIwN\u0003\u0002\u00047)\u0011ADC\u0001\u0007CB\f7\r[3\n\u0005yA\"a\u0003#biVlwK]5uKJ\u0004\"\u0001I\u0014\u000e\u0003\u0005R!AI\u0012\u0002\rMLW\u000e\u001d7f\u0015\t!S%A\u0004gK\u0006$XO]3\u000b\u0005\u0019R\u0011aB8qK:<\u0017n]\u0005\u0003Q\u0005\u0012QbU5na2,g)Z1ukJ,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0007M4G\u000f\u0005\u0002!Y%\u0011Q&\t\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\t=\u0004Ho\u001d\t\u0004c]RdB\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a\u0014A\u0002)sK\u0012,g-\u0003\u00029s\t\u00191+\u001a;\u000b\u0005Y\u001a\u0004CA\u001eJ\u001d\tatI\u0004\u0002>\r:\u0011a(\u0012\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011\u0001\nB\u0001\u0014'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8PaRLwN\\\u0005\u0003\u0015.\u00131cU3sS\u0006d\u0017N_1uS>tw\n\u001d;j_:T!\u0001\u0013\u0003\t\u000b5\u0003A\u0011\u0001(\u0002\rqJg.\u001b;?)\ry\u0015K\u0015\t\u0003!\u0002i\u0011A\u0001\u0005\u0006U1\u0003\ra\u000b\u0005\b_1\u0003\n\u00111\u00011\u0011\u001d!\u0006A1A\u0005\nU\u000b!bY8om\u0016\u0014H/\u001a:t+\u00051\u0006c\u0001\u001aX3&\u0011\u0001l\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005eicv,\u0003\u0002\\g\tIa)\u001e8di&|g.\r\t\u0003euK!AX\u001a\u0003\r\u0005s\u0017PU3g!\t\u0011\u0004-\u0003\u0002bg\t\u0019\u0011I\\=\t\r\r\u0004\u0001\u0015!\u0003W\u0003-\u0019wN\u001c<feR,'o\u001d\u0011\t\u000f\u0015\u0004!\u0019!C\u0005M\u0006Q\u0011N\\2mk\u0012,g)\u001b3\u0016\u0003\u001d\u0004\"A\r5\n\u0005%\u001c$a\u0002\"p_2,\u0017M\u001c\u0005\u0007W\u0002\u0001\u000b\u0011B4\u0002\u0017%t7\r\\;eK\u001aKG\r\t\u0005\b[\u0002\u0011\r\u0011\"\u0003g\u0003=Ign\u00197vI\u0016,6/\u001a:ECR\f\u0007BB8\u0001A\u0003%q-\u0001\tj]\u000edW\u000fZ3Vg\u0016\u0014H)\u0019;bA!9\u0011\u000f\u0001b\u0001\n\u0013\u0011\u0018a\u00034jK2$wJ\u001a4tKR,\u0012a\u001d\t\u0003eQL!!^\u001a\u0003\u0007%sG\u000f\u0003\u0004x\u0001\u0001\u0006Ia]\u0001\rM&,G\u000eZ(gMN,G\u000f\t\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0003\u0019\u00198\r[3nCV\t1\u0010\u0005\u0002}{6\t!$\u0003\u0002\u007f5\t11k\u00195f[\u0006D\u0011\"!\u0001\u0001\u0001\u0004%I!a\u0001\u0002\u0015M\u001c\u0007.Z7b?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005-\u0001c\u0001\u001a\u0002\b%\u0019\u0011\u0011B\u001a\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u001by\u0018\u0011!a\u0001w\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005E\u0001\u0001)Q\u0005w\u000691o\u00195f[\u0006\u0004\u0003bBA\u000b\u0001\u0011\u0005\u0013qC\u0001\ng\u0016$8k\u00195f[\u0006$B!!\u0002\u0002\u001a!9\u00111DA\n\u0001\u0004Y\u0018!A:\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u0005)qO]5uKR1\u0011QAA\u0012\u0003OAq!!\n\u0002\u001e\u0001\u0007q$A\u0003eCR,X\u000e\u0003\u0005\u0002*\u0005u\u0001\u0019AA\u0016\u0003\ryW\u000f\u001e\t\u0004/\u00055\u0012bAA\u00181\t9QI\\2pI\u0016\u0014\bbBA\u0010\u0001\u0011%\u00111\u0007\u000b\t\u0003\u000b\t)$a\u000e\u0002<!A\u0011\u0011FA\u0019\u0001\u0004\tY\u0003C\u0004\u0002:\u0005E\u0002\u0019A>\u0002\u0017\u0019LW\r\u001c3TG\",W.\u0019\u0005\b\u0003{\t\t\u00041\u0001`\u0003\u00151\u0018\r\\;f\u000f%\t\tEAA\u0001\u0012\u0003\t\u0019%A\fBmJ|7+[7qY\u00164U-\u0019;ve\u0016<&/\u001b;feB\u0019\u0001+!\u0012\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u000f\u001a2!!\u0012]\u0011\u001di\u0015Q\tC\u0001\u0003\u0017\"\"!a\u0011\t\u0015\u0005=\u0013QII\u0001\n\u0003\t\t&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003'R3\u0001MA+W\t\t9\u0006\u0005\u0003\u0002Z\u0005\rTBAA.\u0015\u0011\ti&a\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAA1g\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00141\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class AvroSimpleFeatureWriter
implements DatumWriter<SimpleFeature> {
    private final Function1<Object, Object>[] converters;
    private final boolean includeFid;
    private final boolean includeUserData;
    private final int fieldOffset;
    private Schema schema;

    public static Set<Enumeration.Value> $lessinit$greater$default$2() {
        return AvroSimpleFeatureWriter$.MODULE$.$lessinit$greater$default$2();
    }

    private Function1<Object, Object>[] converters() {
        return this.converters;
    }

    private boolean includeFid() {
        return this.includeFid;
    }

    private boolean includeUserData() {
        return this.includeUserData;
    }

    private int fieldOffset() {
        return this.fieldOffset;
    }

    private Schema schema() {
        return this.schema;
    }

    private void schema_$eq(Schema x$1) {
        this.schema = x$1;
    }

    public void setSchema(Schema s) {
        this.schema_$eq(s);
    }

    public void write(SimpleFeature datum, Encoder out) {
        out.writeInt(AvroSimpleFeatureUtils$.MODULE$.VERSION());
        if (this.includeFid()) {
            out.writeString(datum.getID());
        }
        for (int i = 0; i < this.converters().length; ++i) {
            Object value = datum.getAttribute(i);
            Schema.Field field = (Schema.Field)this.schema().getFields().get(i + this.fieldOffset());
            this.write(out, field.schema(), value == null ? null : this.converters()[i].apply(value));
        }
        if (this.includeUserData()) {
            AvroUserDataSerialization$.MODULE$.serialize(out, datum.getUserData());
        }
    }

    private void write(Encoder out, Schema fieldSchema, Object value) {
        Schema.Type type;
        while (true) {
            block11: {
                block4: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block3: {
                                                if (!Schema.Type.STRING.equals(type = fieldSchema.getType())) break block3;
                                                out.writeString((CharSequence)value);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block4;
                                            }
                                            if (!Schema.Type.BYTES.equals(type)) break block5;
                                            out.writeBytes((ByteBuffer)value);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block4;
                                        }
                                        if (!Schema.Type.INT.equals(type)) break block6;
                                        out.writeInt(BoxesRunTime.unboxToInt((Object)value));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    if (!Schema.Type.LONG.equals(type)) break block7;
                                    out.writeLong(BoxesRunTime.unboxToLong((Object)value));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                if (!Schema.Type.DOUBLE.equals(type)) break block8;
                                out.writeDouble(BoxesRunTime.unboxToDouble((Object)value));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (!Schema.Type.FLOAT.equals(type)) break block9;
                            out.writeFloat(BoxesRunTime.unboxToFloat((Object)value));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (!Schema.Type.BOOLEAN.equals(type)) break block10;
                        out.writeBoolean(BoxesRunTime.unboxToBoolean((Object)value));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!Schema.Type.NULL.equals(type)) break block11;
                    out.writeNull();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            if (!Schema.Type.UNION.equals(type)) break;
            int unionIdx = value == null ? 1 : 0;
            out.writeIndex(unionIdx);
            fieldSchema = (Schema)fieldSchema.getTypes().get(unionIdx);
        }
        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Avro attribute type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{type})));
    }

    public AvroSimpleFeatureWriter(SimpleFeatureType sft, Set<Enumeration.Value> opts) {
        FieldNameEncoder nameEncoder = new FieldNameEncoder(AvroSimpleFeatureUtils$.MODULE$.VERSION(), FieldNameEncoder$.MODULE$.$lessinit$greater$default$2());
        Map<String, AvroSimpleFeatureUtils.Binding> typeMap = AvroSimpleFeatureUtils$.MODULE$.createTypeMap(sft, new WKBWriter(), nameEncoder);
        this.converters = (Function1[])Predef$.MODULE$.refArrayOps((Object[])DataUtilities.attributeNames((SimpleFeatureType)sft)).map((Function1)new Serializable(this, nameEncoder, typeMap){
            public static final long serialVersionUID = 0L;
            private final FieldNameEncoder nameEncoder$1;
            private final Map typeMap$1;

            public final Function1<Object, Object> apply(String n) {
                return ((AvroSimpleFeatureUtils.Binding)this.typeMap$1.apply((Object)this.nameEncoder$1.encode(n))).conv();
            }
            {
                this.nameEncoder$1 = nameEncoder$1;
                this.typeMap$1 = typeMap$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        this.includeFid = !SerializationOption.SerializationOptions$.MODULE$.withoutId$extension(SerializationOption$.MODULE$.SerializationOptions(opts));
        this.includeUserData = SerializationOption.SerializationOptions$.MODULE$.withUserData$extension(SerializationOption$.MODULE$.SerializationOptions(opts));
        this.fieldOffset = this.includeFid() ? 2 : 1;
        this.schema = AvroSimpleFeatureUtils$.MODULE$.generateSchema(sft, this.includeUserData(), this.includeFid(), sft.getName().getNamespaceURI());
    }
}

