/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class AbstractBufferedOutputStream
extends OutputStream {
    private byte[] buf;
    private int curr = 0;
    private boolean closed = false;

    public AbstractBufferedOutputStream(int bufferSize) {
        this.buf = new byte[bufferSize];
    }

    protected abstract void writeBuffer(byte[] var1) throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.available() < 1) {
            this.flush();
        }
        this.buf[this.curr++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
        if (this.curr > 0) {
            this.writeBuffer(Arrays.copyOf(this.buf, this.curr));
            this.curr = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.flush();
            super.close();
        }
    }

    protected int available() {
        return this.buf.length - this.curr;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot read from stream anymore.  It has been closed");
        }
    }
}

