/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.redis;

import com.typesafe.config.Config;
import java.net.URI;
import org.locationtech.geomesa.convert.EnrichmentCache;
import org.locationtech.geomesa.convert.EnrichmentCacheFactory;
import org.locationtech.geomesa.convert.redis.RedisConnectionBuilder;
import org.locationtech.geomesa.convert.redis.RedisEnrichmentCache;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.JedisURIHelper;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001\u001b\tY\"+\u001a3jg\u0016s'/[2i[\u0016tGoQ1dQ\u00164\u0015m\u0019;pefT!a\u0001\u0003\u0002\u000bI,G-[:\u000b\u0005\u00151\u0011aB2p]Z,'\u000f\u001e\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005!\u0011BA\f\u0005\u0005Y)eN]5dQ6,g\u000e^\"bG\",g)Y2u_JL\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0011 \u0003)\u0019\u0017M\u001c)s_\u000e,7o\u001d\u000b\u0003A\r\u0002\"aD\u0011\n\u0005\t\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006Iu\u0001\r!J\u0001\u0005G>tg\r\u0005\u0002'[5\tqE\u0003\u0002)S\u000511m\u001c8gS\u001eT!AK\u0016\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001L\u0001\u0004G>l\u0017B\u0001\u0018(\u0005\u0019\u0019uN\u001c4jO\")\u0001\u0007\u0001C!c\u0005)!-^5mIR\u0011!'\u000e\t\u0003+MJ!\u0001\u000e\u0003\u0003\u001f\u0015s'/[2i[\u0016tGoQ1dQ\u0016DQ\u0001J\u0018A\u0002\u0015\u0002")
public class RedisEnrichmentCacheFactory
implements EnrichmentCacheFactory {
    public boolean canProcess(Config conf) {
        return conf.hasPath("type") && conf.getString("type").equals("redis");
    }

    public EnrichmentCache build(Config conf) {
        String url = conf.getString("redis-url");
        String redisUrl = (String)new Some((Object)url).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String u) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, u){
                    public static final long serialVersionUID = 0L;
                    private final String u$1;

                    public final URI apply() {
                        return new URI(this.u$1);
                    }
                    {
                        this.u$1 = u$1;
                    }
                }).toOption().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(URI x$1) {
                        return JedisURIHelper.isValid((URI)x$1);
                    }
                });
            }
        }).getOrElse((Function0)new Serializable(this, url){
            public static final long serialVersionUID = 0L;
            private final String url$1;

            public final String apply() {
                return this.url$1.indexOf(":") == -1 ? this.url$1 : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"redis://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$1}));
            }
            {
                this.url$1 = url$1;
            }
        });
        long timeout = conf.hasPath("expiration") ? conf.getLong("expiration") : -1L;
        RedisConnectionBuilder connBuilder = new RedisConnectionBuilder(this, redisUrl){
            private final JedisPool pool;

            private JedisPool pool() {
                return this.pool;
            }

            public Jedis getConn() {
                return this.pool().getResource();
            }

            public void close() {
                this.pool().close();
            }
            {
                this.pool = new JedisPool(redisUrl$1);
            }
        };
        boolean localCache = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Config conf$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.conf$1.getBoolean("local-cache");
            }
            {
                this.conf$1 = conf$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
        return new RedisEnrichmentCache(connBuilder, timeout, localCache);
    }
}

