/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.tools.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import java.io.File;
import java.util.List;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.tools.CassandraConnectionParams$class;
import org.locationtech.geomesa.cassandra.tools.CassandraDataStoreCommand;
import org.locationtech.geomesa.cassandra.tools.CassandraDataStoreCommand$class;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.DistributedCombineParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.data.CreateSchemaCommand;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u001f\t12)Y:tC:$'/Y%oO\u0016\u001cHoQ8n[\u0006tGM\u0003\u0002\u0004\t\u0005A1m\\7nC:$7O\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\nG\u0006\u001c8/\u00198ee\u0006T!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\r&!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bcA\r\u001e?5\t!D\u0003\u0002\u001c9\u00051\u0011N\\4fgRT!!\u0002\u0005\n\u0005yQ\"!D%oO\u0016\u001cHoQ8n[\u0006tG\r\u0005\u0002!G5\t\u0011E\u0003\u0002#\r\u0005!A-\u0019;b\u0013\t!\u0013E\u0001\nDCN\u001c\u0018M\u001c3sC\u0012\u000bG/Y*u_J,\u0007C\u0001\u0014(\u001b\u0005!\u0011B\u0001\u0015\u0005\u0005e\u0019\u0015m]:b]\u0012\u0014\u0018\rR1uCN#xN]3D_6l\u0017M\u001c3\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\u0005a\u0003CA\u0017\u0001\u001b\u0005\u0011\u0001bB\u0018\u0001\u0005\u0004%\t\u0005M\u0001\u0007a\u0006\u0014\u0018-\\:\u0016\u0003E\u0002\"AM(\u000f\u0005M\u0012eB\u0001\u001bB\u001d\t)\u0004I\u0004\u00027\u007f9\u0011qG\u0010\b\u0003qur!!\u000f\u001f\u000e\u0003iR!a\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119Qa\u0011\u0002\t\u0002\u0011\u000bacQ1tg\u0006tGM]1J]\u001e,7\u000f^\"p[6\fg\u000e\u001a\t\u0003[\u00153Q!\u0001\u0002\t\u0002\u0019\u001b\"!R$\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g\u0011\u0015QS\t\"\u0001O)\u0005!e\u0001\u0002)F\u0001E\u0013QcQ1tg\u0006tGM]1J]\u001e,7\u000f\u001e)be\u0006l7o\u0005\u0003P\u000fJk\u0006CA*[\u001d\t!\u0006L\u0004\u0002V/:\u0011aGV\u0005\u0003\u000b!I!a\u0007\u000f\n\u0005eS\u0012!D%oO\u0016\u001cHoQ8n[\u0006tG-\u0003\u0002\\9\na\u0011J\\4fgR\u0004\u0016M]1ng*\u0011\u0011L\u0007\t\u0003=\u0006t!\u0001N0\n\u0005\u0001$\u0011!G\"bgN\fg\u000e\u001a:b\t\u0006$\u0018m\u0015;pe\u0016\u001cu.\\7b]\u0012L!AY2\u00031\r\u000b7o]1oIJ\fG)\u0019;b'R|'/\u001a)be\u0006l7O\u0003\u0002a\t!)!f\u0014C\u0001KR\ta\r\u0005\u0002h\u001f6\tQ\t\u000b\u0003PSN$\bC\u00016r\u001b\u0005Y'B\u00017n\u0003)Q7m\\7nC:$WM\u001d\u0006\u0003]>\fQAY3vgRT\u0011\u0001]\u0001\u0004G>l\u0017B\u0001:l\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.I\u0001v\u0003AJenZ3ti>\u001awN\u001c<feR\u0004c/\u0019:j_V\u001c\bEZ5mK\u00022wN]7biN\u0004\u0013N\u001c;pA\u001d+w.T3tC\"1q\u000f\u0001Q\u0001\nE\nq\u0001]1sC6\u001c\b\u0005C\u0003z\u0001\u0011\u0005#0A\u0004fq\u0016\u001cW\u000f^3\u0015\u0003m\u0004\"\u0001\u0013?\n\u0005uL%\u0001B+oSR\u0004")
public class CassandraIngestCommand
implements IngestCommand<CassandraDataStore>,
CassandraDataStoreCommand {
    private final CassandraIngestParams params;
    private final String name;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;

    @Override
    public Map<String, String> connection() {
        return CassandraDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public Seq<String> libjarsFiles() {
        return IngestCommand.class.libjarsFiles((IngestCommand)this);
    }

    public package.Awaitable startIngest(Enumeration.Value mode, DataStore ds, SimpleFeatureType sft, Config converter, IngestCommand.Inputs inputs) {
        return IngestCommand.class.startIngest((IngestCommand)this, (Enumeration.Value)mode, (DataStore)ds, (SimpleFeatureType)sft, (Config)converter, (IngestCommand.Inputs)inputs);
    }

    public void setBackendSpecificOptions(SimpleFeatureType sft) {
        CreateSchemaCommand.SchemaOptionsCommand.class.setBackendSpecificOptions((CreateSchemaCommand.SchemaOptionsCommand)this, (SimpleFeatureType)sft);
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return package.InteractiveCommand.class.console((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.class.setConsole((package.InteractiveCommand)this, (Object)c);
    }

    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return package.DistributedCommand.class.libjarsPaths((package.DistributedCommand)this);
    }

    public <T> T withDataStore(Function1<CassandraDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.class.withDataStore((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.class.loadDataStore((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.class.subCommands((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.class.validate((package.Command)this);
    }

    public void run() {
        package.Command.class.run((package.Command)this);
    }

    @Override
    public CassandraIngestParams params() {
        return this.params;
    }

    public void execute() {
        if (JavaConversions$.MODULE$.asScalaBuffer(this.params().files()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String path) {
                return PathUtils$.MODULE$.isRemote(path);
            }
        })) {
            throw new ParameterException("The Cassandra ingest tool does not support distributed ingest.");
        }
        IngestCommand.class.execute((IngestCommand)this);
    }

    public CassandraIngestCommand() {
        package.Command.class.$init$((package.Command)this);
        package.DataStoreCommand.class.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.class.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.class.$init$((package.InteractiveCommand)this);
        CreateSchemaCommand.SchemaOptionsCommand.class.$init$((CreateSchemaCommand.SchemaOptionsCommand)this);
        IngestCommand.class.$init$((IngestCommand)this);
        CassandraDataStoreCommand$class.$init$(this);
        this.params = new CassandraIngestParams();
    }

    @Parameters(commandDescription="Ingest/convert various file formats into GeoMesa")
    public static class CassandraIngestParams
    implements IngestCommand.IngestParams,
    CassandraDataStoreCommand.CassandraDataStoreParams {
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-P", "--contact-point"}, description="Cassandra contact point (address of a Cassandra node)", required=true)
        private String contactPoint;
        @Parameter(names={"-k", "--key-space"}, description="Cassandra key space (must already exist)", required=true)
        private String keySpace;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
        private Integer threads;
        @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
        private boolean srcList;
        @Parameter(names={"--no-tracking"}, description="Return immediately after submitting ingest job (distributed jobs)")
        private boolean noWaitForCompletion;
        @Parameter(names={"--combine-inputs"}, description="Combine multiple input files into a single input split (distributed jobs)")
        private boolean combineInputs;
        @Parameter(names={"--split-max-size"}, description="Maximum size of a split in bytes (distributed jobs)")
        private Integer maxSplitSize;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, auto-detection will be attempted")
        private String inputFormat;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter")
        private String config;
        @Parameter(names={"--converter-error-mode"}, description="Override the converter error mode - 'skip-bad-records' or 'raise-errors'", converter=ParameterConverters.ErrorModeConverter.class)
        private Enumeration.Value errorMode;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;
        private volatile boolean bitmap$0;

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String contactPoint() {
            return this.contactPoint;
        }

        @Override
        @TraitSetter
        public void contactPoint_$eq(String x$1) {
            this.contactPoint = x$1;
        }

        @Override
        public String keySpace() {
            return this.keySpace;
        }

        @Override
        @TraitSetter
        public void keySpace_$eq(String x$1) {
            this.keySpace = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public boolean srcList() {
            return this.srcList;
        }

        public void srcList_$eq(boolean x$1) {
            this.srcList = x$1;
        }

        public boolean noWaitForCompletion() {
            return this.noWaitForCompletion;
        }

        public void noWaitForCompletion_$eq(boolean x$1) {
            this.noWaitForCompletion = x$1;
        }

        public boolean waitForCompletion() {
            return IngestCommand.IngestParams.class.waitForCompletion((IngestCommand.IngestParams)this);
        }

        public boolean combineInputs() {
            return this.combineInputs;
        }

        public void combineInputs_$eq(boolean x$1) {
            this.combineInputs = x$1;
        }

        public Integer maxSplitSize() {
            return this.maxSplitSize;
        }

        public void maxSplitSize_$eq(Integer x$1) {
            this.maxSplitSize = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            CassandraIngestParams cassandraIngestParams = this;
            synchronized (cassandraIngestParams) {
                if (!this.bitmap$0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = true;
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return this.bitmap$0 ? this.mode : this.mode$lzycompute();
        }

        public String inputFormat() {
            return this.inputFormat;
        }

        public void inputFormat_$eq(String x$1) {
            this.inputFormat = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public String config() {
            return this.config;
        }

        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        public Enumeration.Value errorMode() {
            return this.errorMode;
        }

        public void errorMode_$eq(Enumeration.Value x$1) {
            this.errorMode = x$1;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public CassandraIngestParams() {
            OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
            OptionalFeatureSpecParam.class.$init$((OptionalFeatureSpecParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ConverterConfigParam.class.$init$((ConverterConfigParam)this);
            InputFilesParam.class.$init$((InputFilesParam)this);
            OptionalInputFormatParam.class.$init$((OptionalInputFormatParam)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            DistributedCombineParam.class.$init$((DistributedCombineParam)this);
            IngestCommand.IngestParams.class.$init$((IngestCommand.IngestParams)this);
            PasswordParams.class.$init$((PasswordParams)this);
            CredentialsParams.class.$init$((CredentialsParams)this);
            CassandraConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
        }
    }
}

