/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.avro;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.locationtech.geomesa.convert2.TypeInference;
import org.locationtech.geomesa.convert2.TypeInference$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;

public final class AvroConverterFactory$ {
    public static final AvroConverterFactory$ MODULE$ = new AvroConverterFactory$();

    public Seq<TypeInference.InferredType> schemaTypes(Schema schema) {
        TypeInference.Namer namer = new TypeInference.Namer(TypeInference.Namer$.MODULE$.$lessinit$greater$default$1());
        ArrayBuffer types = ArrayBuffer$.MODULE$.empty();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).foreach((Function1 & Serializable)x$6 -> {
            this.mapField$1(x$6, AvroConverterFactory$.mapField$default$2$1(), namer, types);
            return BoxedUnit.UNIT;
        });
        TypeInference$.MODULE$.deriveGeometry(types.toSeq(), (Function1)namer).foreach((Function1 & Serializable)g -> (ArrayBuffer)types.$plus$eq(g));
        return types.toSeq();
    }

    private boolean isSimple(Schema s) {
        Schema.Type type = s.getType();
        if (Schema.Type.STRING.equals(type)) {
            return true;
        }
        if (Schema.Type.INT.equals(type)) {
            return true;
        }
        if (Schema.Type.LONG.equals(type)) {
            return true;
        }
        if (Schema.Type.FLOAT.equals(type)) {
            return true;
        }
        if (Schema.Type.DOUBLE.equals(type)) {
            return true;
        }
        return Schema.Type.BOOLEAN.equals(type);
    }

    private final boolean isSimpleArray$1(Schema.Field field$1) {
        return this.isSimple(field$1.schema().getElementType());
    }

    private final boolean isSimpleMap$1(Schema.Field field$1) {
        return this.isSimple(field$1.schema().getValueType());
    }

    private final void mapField$1(Schema.Field field, String path, TypeInference.Namer namer$1, ArrayBuffer types$1) {
        String name = namer$1.apply(field.name());
        TypeInference.FunctionTransform transform = new TypeInference.FunctionTransform("avroPath(", new StringBuilder(5).append(",'").append(path).append("/").append(field.name()).append("')").toString());
        Schema.Type type = field.schema().getType();
        if (Schema.Type.STRING.equals(type)) {
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.STRING(), (TypeInference.InferredTransform)transform));
            return;
        }
        if (Schema.Type.BYTES.equals(type)) {
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.BYTES(), (TypeInference.InferredTransform)transform));
            return;
        }
        if (Schema.Type.INT.equals(type)) {
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.INT(), (TypeInference.InferredTransform)transform));
            return;
        }
        if (Schema.Type.LONG.equals(type)) {
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.LONG(), (TypeInference.InferredTransform)transform));
            return;
        }
        if (Schema.Type.FLOAT.equals(type)) {
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.FLOAT(), (TypeInference.InferredTransform)transform));
            return;
        }
        if (Schema.Type.DOUBLE.equals(type)) {
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.DOUBLE(), (TypeInference.InferredTransform)transform));
            return;
        }
        if (Schema.Type.BOOLEAN.equals(type)) {
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.BOOLEAN(), (TypeInference.InferredTransform)transform));
            return;
        }
        if (Schema.Type.ARRAY.equals(type)) {
            if (this.isSimpleArray$1(field)) {
                types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.LIST(), (TypeInference.InferredTransform)transform));
                return;
            }
            return;
        }
        if (Schema.Type.MAP.equals(type)) {
            if (this.isSimpleMap$1(field)) {
                types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.MAP(), (TypeInference.InferredTransform)transform));
                return;
            }
            return;
        }
        if (Schema.Type.FIXED.equals(type)) {
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.BYTES(), (TypeInference.InferredTransform)transform));
            return;
        }
        if (Schema.Type.ENUM.equals(type)) {
            String x$1 = new StringBuilder(8).append(transform.suffix()).append("::string").toString();
            String x$2 = transform.copy$default$1();
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.STRING(), (TypeInference.InferredTransform)transform.copy(x$2, x$1)));
            return;
        }
        if (Schema.Type.UNION.equals(type)) {
            String x$3 = new StringBuilder(8).append(transform.suffix()).append("::string").toString();
            String x$4 = transform.copy$default$1();
            types$1.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.STRING(), (TypeInference.InferredTransform)transform.copy(x$4, x$3)));
            return;
        }
        if (Schema.Type.RECORD.equals(type)) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(field.schema().getFields()).asScala()).foreach((Function1 & Serializable)x$5 -> {
                this.mapField$1(x$5, new StringBuilder(1).append(path).append("/").append(field.name()).toString(), namer$1, types$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private static final String mapField$default$2$1() {
        return "";
    }

    private AvroConverterFactory$() {
    }
}

