/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.util.ServiceLoader;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$$anonfun$infer$1$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverterFactory;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class SimpleFeatureConverter$
implements StrictLogging {
    public static final SimpleFeatureConverter$ MODULE$;
    private final List<SimpleFeatureConverterFactory> factories;
    private final List<org.locationtech.geomesa.convert.SimpleFeatureConverterFactory<?>> factoriesV1;
    private final Logger logger;

    static {
        new SimpleFeatureConverter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<SimpleFeatureConverterFactory> factories() {
        return this.factories;
    }

    private List<org.locationtech.geomesa.convert.SimpleFeatureConverterFactory<?>> factoriesV1() {
        return this.factoriesV1;
    }

    public SimpleFeatureConverter apply(SimpleFeatureType sft, Config config) {
        block7: {
            SimpleFeatureConverter simpleFeatureConverter;
            block6: {
                BoxedUnit boxedUnit;
                block5: {
                    Iterator converters = this.factories().iterator().flatMap((Function1)new Serializable(sft, config){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;
                        private final Config config$1;

                        public final Iterable<SimpleFeatureConverter> apply(SimpleFeatureConverterFactory x$2) {
                            return Option$.MODULE$.option2Iterable(x$2.apply(this.sft$1, this.config$1));
                        }
                        {
                            this.sft$1 = sft$1;
                            this.config$1 = config$1;
                        }
                    });
                    if (!converters.hasNext()) break block5;
                    simpleFeatureConverter = (SimpleFeatureConverter)converters.next();
                    break block6;
                }
                Iterator convertersV1 = this.factoriesV1().iterator().filter((Function1)new Serializable(config){
                    public static final long serialVersionUID = 0L;
                    private final Config config$1;

                    public final boolean apply(org.locationtech.geomesa.convert.SimpleFeatureConverterFactory<?> x$3) {
                        return x$3.canProcess(this.config$1);
                    }
                    {
                        this.config$1 = config$1;
                    }
                }).map((Function1)new Serializable(sft, config){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$1;
                    private final Config config$1;

                    public final org.locationtech.geomesa.convert.SimpleFeatureConverter<?> apply(org.locationtech.geomesa.convert.SimpleFeatureConverterFactory<?> x$4) {
                        return x$4.buildConverter(this.sft$1, this.config$1);
                    }
                    {
                        this.sft$1 = sft$1;
                        this.config$1 = config$1;
                    }
                });
                if (!convertersV1.hasNext()) break block7;
                org.locationtech.geomesa.convert.SimpleFeatureConverter v1 = (org.locationtech.geomesa.convert.SimpleFeatureConverter)convertersV1.next();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Wrapping deprecated converter of class {}, converter will not be closed", new Object[]{v1.getClass().getName()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                simpleFeatureConverter = new SimpleFeatureConverter.SimpleFeatureConverterWrapper(v1);
            }
            return simpleFeatureConverter;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find factory for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
    }

    public SimpleFeatureConverter apply(String typeName, String converterName) {
        SimpleFeatureType sft = (SimpleFeatureType)SimpleFeatureTypeLoader$.MODULE$.sftForName(typeName).getOrElse((Function0)new Serializable(typeName){
            public static final long serialVersionUID = 0L;
            private final String typeName$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load SimpleFeatureType for typeName '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.typeName$1})));
            }
            {
                this.typeName$1 = typeName$1;
            }
        });
        return this.apply(sft, converterName);
    }

    public SimpleFeatureConverter apply(SimpleFeatureType sft, String converterName) {
        Config converter = (Config)ConverterConfigLoader$.MODULE$.configForName(converterName).getOrElse((Function0)new Serializable(converterName){
            public static final long serialVersionUID = 0L;
            private final String converterName$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load converter config for converter named '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.converterName$1})));
            }
            {
                this.converterName$1 = converterName$1;
            }
        });
        return this.apply(sft, converter);
    }

    public Option<Tuple2<SimpleFeatureType, Config>> infer(Function0<InputStream> is, Option<SimpleFeatureType> sft) {
        return (Option)this.factories().foldLeft((Object)None$.MODULE$, (Function2)new Serializable(is, sft){
            public static final long serialVersionUID = 0L;
            public final Function0 is$1;
            public final Option sft$2;

            public final Option<Tuple2<SimpleFeatureType, Config>> apply(Option<Tuple2<SimpleFeatureType, Config>> res, SimpleFeatureConverterFactory f) {
                return res.orElse((Function0)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.infer.1 $outer;
                    public final SimpleFeatureConverterFactory f$1;

                    public final Option<Tuple2<SimpleFeatureType, Config>> apply() {
                        return (Option)WithClose$.MODULE$.apply(this.$outer.is$1.apply(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$infer$1$$anonfun$apply$1 $outer;

                            public final Option<Tuple2<SimpleFeatureType, Config>> apply(InputStream in) {
                                return this.$outer.f$1.infer(in, (Option<SimpleFeatureType>)this.$outer.org$locationtech$geomesa$convert2$SimpleFeatureConverter$$anonfun$$anonfun$$$outer().sft$2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.infer.1 org$locationtech$geomesa$convert2$SimpleFeatureConverter$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.f$1 = f$1;
                    }
                });
            }
            {
                this.is$1 = is$1;
                this.sft$2 = sft$2;
            }
        });
    }

    private SimpleFeatureConverter$() {
        BoxedUnit boxedUnit;
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.factories = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(SimpleFeatureConverterFactory.class)).asScala()).toList();
        this.factoriesV1 = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(org.locationtech.geomesa.convert.SimpleFeatureConverterFactory.class)).asScala()).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " factories: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.factories().size() + this.factoriesV1().size()))}))).append((Object)((TraversableOnce)((List)this.factories().$plus$plus(this.factoriesV1(), List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object x$1) {
                    return x$1.getClass().getName();
                }
            }, List$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

