/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.ServiceLoader;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert.SimpleFeatureConverters;
import org.locationtech.geomesa.convert2.AbstractConverter;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.convert2.SimpleFeatureConverterFactory;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class SimpleFeatureConverters$
implements LazyLogging {
    public static final SimpleFeatureConverters$ MODULE$;
    private final List<SimpleFeatureConverterFactory> factories;
    private final List<org.locationtech.geomesa.convert.SimpleFeatureConverterFactory<?>> factoriesV1;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SimpleFeatureConverters$();
    }

    private Logger logger$lzycompute() {
        SimpleFeatureConverters$ simpleFeatureConverters$ = this;
        synchronized (simpleFeatureConverters$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private List<SimpleFeatureConverterFactory> factories() {
        return this.factories;
    }

    private List<org.locationtech.geomesa.convert.SimpleFeatureConverterFactory<?>> factoriesV1() {
        return this.factoriesV1;
    }

    public <I> org.locationtech.geomesa.convert.SimpleFeatureConverter<I> build(String typeName, String converterName) {
        SimpleFeatureType sft = (SimpleFeatureType)SimpleFeatureTypeLoader$.MODULE$.sftForName(typeName).getOrElse((Function0)new Serializable(typeName){
            public static final long serialVersionUID = 0L;
            private final String typeName$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load SFT for typeName ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.typeName$1})));
            }
            {
                this.typeName$1 = typeName$1;
            }
        });
        return this.build(sft, converterName);
    }

    public <I> org.locationtech.geomesa.convert.SimpleFeatureConverter<I> build(SimpleFeatureType sft, String converterName) {
        return (org.locationtech.geomesa.convert.SimpleFeatureConverter)ConverterConfigLoader$.MODULE$.configForName(converterName).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final org.locationtech.geomesa.convert.SimpleFeatureConverter<I> apply(Config x$2) {
                return SimpleFeatureConverters$.MODULE$.build(this.sft$2, x$2);
            }
            {
                this.sft$2 = sft$2;
            }
        }).getOrElse((Function0)new Serializable(converterName){
            public static final long serialVersionUID = 0L;
            private final String converterName$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find converter config for converterName ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.converterName$1})));
            }
            {
                this.converterName$1 = converterName$1;
            }
        });
    }

    public <I> org.locationtech.geomesa.convert.SimpleFeatureConverter<I> build(SimpleFeatureType sft, Config converterConf) {
        Option option;
        block4: {
            block5: {
                SimpleFeatureConverters.SimpleFeatureConverterWrapper simpleFeatureConverterWrapper;
                block3: {
                    block2: {
                        SimpleFeatureConverters.SimpleFeatureConverterWrapper c;
                        option = this.factoriesV1().find((Function1)new Serializable(converterConf){
                            public static final long serialVersionUID = 0L;
                            private final Config converterConf$1;

                            public final boolean apply(org.locationtech.geomesa.convert.SimpleFeatureConverterFactory<?> x$3) {
                                return x$3.canProcess(this.converterConf$1);
                            }
                            {
                                this.converterConf$1 = converterConf$1;
                            }
                        }).map((Function1)new Serializable(sft, converterConf){
                            public static final long serialVersionUID = 0L;
                            private final SimpleFeatureType sft$1;
                            private final Config converterConf$1;

                            public final org.locationtech.geomesa.convert.SimpleFeatureConverter<?> apply(org.locationtech.geomesa.convert.SimpleFeatureConverterFactory<?> x$4) {
                                return x$4.buildConverter(this.sft$1, this.converterConf$1);
                            }
                            {
                                this.sft$1 = sft$1;
                                this.converterConf$1 = converterConf$1;
                            }
                        });
                        if (!(option instanceof Some)) break block2;
                        Some some = (Some)option;
                        simpleFeatureConverterWrapper = c = (SimpleFeatureConverters.SimpleFeatureConverterWrapper)some.x();
                        break block3;
                    }
                    if (!None$.MODULE$.equals(option)) break block4;
                    Iterator converters = this.factories().iterator().flatMap((Function1)new Serializable(sft, converterConf){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;
                        private final Config converterConf$1;

                        public final Iterable<SimpleFeatureConverter> apply(SimpleFeatureConverterFactory x$5) {
                            return Option$.MODULE$.option2Iterable(x$5.apply(this.sft$1, this.converterConf$1));
                        }
                        {
                            this.sft$1 = sft$1;
                            this.converterConf$1 = converterConf$1;
                        }
                    }).collect((PartialFunction)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends SimpleFeatureConverter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof AbstractConverter) {
                                AbstractConverter abstractConverter = (AbstractConverter)A1;
                                object = abstractConverter;
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(SimpleFeatureConverter x1) {
                            SimpleFeatureConverter simpleFeatureConverter = x1;
                            boolean bl = simpleFeatureConverter instanceof AbstractConverter;
                            return bl;
                        }
                    });
                    if (!converters.hasNext()) break block5;
                    simpleFeatureConverterWrapper = new SimpleFeatureConverters.SimpleFeatureConverterWrapper((AbstractConverter)converters.next());
                }
                return simpleFeatureConverterWrapper;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find converter factory for type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
        }
        throw new MatchError((Object)option);
    }

    private SimpleFeatureConverters$() {
        BoxedUnit boxedUnit;
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.factories = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(SimpleFeatureConverterFactory.class)).asScala()).toList();
        this.factoriesV1 = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(org.locationtech.geomesa.convert.SimpleFeatureConverterFactory.class)).asScala()).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " factories: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.factories().size() + this.factoriesV1().size()))}))).append((Object)((TraversableOnce)((List)this.factories().$plus$plus(this.factoriesV1(), List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object x$1) {
                    return x$1.getClass().getName();
                }
            }, List$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

